<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $host = filter_var(trim($_REQUEST['smtp-host']), FILTER_SANITIZE_SPECIAL_CHARS);

        $username = filter_var($_REQUEST['smtp-username'], FILTER_SANITIZE_SPECIAL_CHARS);

        $key = htmlspecialchars($_REQUEST['smtp-password']);

        $auth = filter_var($_REQUEST['smtp-auth'], FILTER_SANITIZE_SPECIAL_CHARS);

        $port = filter_var($_REQUEST['smtp-port'], FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var(trim($_REQUEST['mail-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $logo = !empty($_FILES['mail-logo']['name']) ? $_FILES['mail-logo'] : null;

        $contact = filter_var(trim($_REQUEST['mail-contact']), FILTER_SANITIZE_EMAIL);

        $support = !empty($_REQUEST['mail-support']) ? filter_var(trim($_REQUEST['mail-support']), FILTER_SANITIZE_EMAIL) : null;

        $complaint = !empty($_REQUEST['mail-complaint']) ? filter_var(trim($_REQUEST['mail-complaint']), FILTER_SANITIZE_EMAIL) : null;

        $logoPath = null;

        $directory = '../../../vault/web-data/';

        // Handle Logo Upload

        if ($logo) {

            $logoPath = fileUpload($logo, $directory, 'mail-logo-', 150);

            if ($logoPath['status']) {

                $logoPath = $logoPath['vault'];

            } else {

                echo json_encode(['uploadError' => true, 'message' => $logoPath['message']]); // Encode JSON Response

                exit; // End Run

            }

        }

        // Prepare Query

        $query = "UPDATE `mail_settings` SET `host_SMTP` = ? , `username_SMTP` = ?, `key_SMTP` = ?, `port_SMTP` = ?, `encryption_SMTP` = ?, `mail_name` = ?, `contact_mail` = ?";

        $type = "sssssss";

        $params = [$host, $username, $key, $port, $auth, $name, $contact];

        if ($logoPath) {

            $query .= ", `mail_logo` = ?";

            $type .= "s";

            $params[] = $logoPath;

        }

        if ($support) {

            $query .= ", `support_mail` = ?";

            $type .= "s";

            $params[] = $support;

        }

        if ($complaint) {

            $query .= ", `complaint_mail` = ?";

            $type .= "s";

            $params[] = $complaint;

        }

        $query .= " LIMIT 1";

        // Commence Data Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, $type, ...$params); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        // Handle Deletions

        if ($logoPath) {

            if ($updated) {

                $oldLogo = MAIL_LOGO_RAW;

                deleteFile($oldLogo, '../../../'); // Delete

            } else {

                deleteFile($logoPath); // Delete Uploaded File

            }    

        }

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>