<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['resource-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($action == 'DELETE') {

            // Get QR Code

            $codeQR = null;

            $stmt = mysqli_prepare($conn, "SELECT `resource_qrcode` FROM `pay_resources` WHERE `id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Result

            while ($row = mysqli_fetch_assoc($result)) {

                $codeQR = $row['resource_qrcode'];

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            // Determine Action

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `pay_resources` WHERE `id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

            } 

            mysqli_stmt_close($delete); // Close Statement

            if ($deleted && $codeQR) {

                deleteFile($codeQR, '../../../'); // Delete QR Code

            }

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }

    }

?>