<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['pay-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Flag

        // Fetch Payment Data

        $stmt = mysqli_prepare($conn, "SELECT * FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $paidOn = $row['pay_time'];

                $proof = $row['pay_proof'];

                $currency = $row['currency'];

                $user = $row['user_id'];

                $amount = $row['amount'];

                $details = $row['item'];

                $itemID = $row['item_desc'];

                $orderedOn = date('l, M d Y, (H:i)', strtotime($paidOn));

                // Get Item & Category

                $lastBracket = strrpos($details, '('); // Get Last '(' Position

                $preBracket = substr($details, 0, $lastBracket); // Elements Before (

                $postBracket = substr($details, $lastBracket + 1); // Elements After (

                $subDetails = [$preBracket, $postBracket];

                $type = rtrim($subDetails[1]); // Get Item Type

                $type = strtoupper(rtrim($type, ')')); // Remove Trailing )

                $item = rtrim($subDetails[0]); // Get Item Name

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo json_encode(['recordError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $thirdParty = false;

        $userData = userData($user, $conn); // Fetch User Info

        if (!$userData) {

            $userData = thirdPartyData($user, $conn); // Fetch User Info (Third Party)

            if ($userData) {

                $thirdParty = true;

            }

        }

        if (!$userData && $action !== 'DELETE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // $action = isset($_REQUEST['approve']) ? 'APPROVE' : 'DECLINE';

            // Get Current Datetime

            $datetime = timeGMT();

            $itemFound = false; // Item Flag

            // Handle Type (Determine Table)

            if ($type === 'BC') { // BILLING CODE / SERVICE FEE 

                $table = 'billing_codes';

                $column = 'code_id';

            } else if ($type === 'CARD') { // CARD REQUESTS 

                $itemFound = false;

                $table = 'accounts';

                $column = 'currency';

                $column2 = 'user_id';

                $subType = 'VIRTUAL CARD';

            } else if ($type === 'FUND') { // CARD FUNDING

                $table = 'virtual_cards';

                $column = 'card_id';

                $subType = 'VIRTUAL CARD DEPOSIT';

            } else if ($type === 'INVESTMENT') { // INVESTMENTS

                $table = 'investments';

                $column = 'inv_id';

                $subType = 'INVESTMENT';

            } else if ($type === 'LOAN') { // LOANS (Repayments)

                $table = 'loans';

                $column = 'loan_id';

            }

            // Locate Item

            if ($type !== 'CARD') {

                // Locate Item

                $query = "SELECT * FROM `$table` WHERE `$column` = ?";

                $locate = mysqli_prepare($conn, $query); // Prepare Statement

                mysqli_stmt_bind_param($locate, "s", $itemID); // Bind Parameter(s)

                mysqli_stmt_execute($locate); // Execute Statement

                $result = mysqli_stmt_get_result($locate); // Get Statement Result

                if (mysqli_num_rows($result) === 1) {

                    $itemFound = true; // Update Flag

                    $itemData = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Item Data

                }

                mysqli_free_result($result); // Free Result

                mysqli_stmt_close($locate); // Close Statement

            } else {

                // Locate Item

                $query = "SELECT * FROM `$table` WHERE `$column` = ? AND `$column2` = ?";

                $locate = mysqli_prepare($conn, $query); // Prepare Statement

                mysqli_stmt_bind_param($locate, "ss", $currency, $user); // Bind Parameter(s)

                mysqli_stmt_execute($locate); // Execute Statement

                $result = mysqli_stmt_get_result($locate); // Get Statement Result

                if (mysqli_num_rows($result) === 1) {

                    $itemFound = true; // Update Flag

                }

                mysqli_free_result($result); // Free Result

                mysqli_stmt_close($locate); // Close Statement

            }

            if (!$itemFound) { // Item Not Found

                echo json_encode(['itemError' => true]); // Encode JSON Response
    
                exit; // End Run
    
            }
    

            // Carry Out Approval / Decline

            if ($action === 'APPROVE') { // Approval

                $itemCreated = false; // Flag

                $subject = 'Order Confirmed #' . mt_rand(10000000, 99999999); // Mail Subject

                $notfTitle = 'Payment Confirmation Alert';

                if ($type === 'BC') { // Billing Code

                    // Update Code Status

                    $createItem = mysqli_prepare($conn, "UPDATE `billing_codes` SET `status` = ? WHERE `code_id` = ?");

                    $param = 'PAID';

                    mysqli_stmt_bind_param($createItem, "ss", $param, $itemID);

                    // Fetch Billing Code Data

                    foreach ($itemData as $row) {

                        $code = $row['code'];

                        $codeName = $row['name'];

                    }

                    // Email & Notification Draft (To Disperse Code)

                    $mail = dispenseBCode($userData['firstname'], $code, $codeName, $id, $orderedOn);

                    $notfTitle = $codeName . ' Authorization Code Alert';

                    $notf = 'Your order for ' . $codeName . ' has been confirmed, please use ' . $code . ' as your ' . $codeName . ' whenever you need to authenticate an action.';

                } else if ($type === 'INVESTMENT') { // Investment

                    // Fetch Investment Plan Data

                    foreach ($itemData as $row) {

                        $name = $row['name'];

                        $duration = $row['duration'];

                        $interest = $row['interest_rate'];

                        $unit = $row['timing_unit'];

                        $cycle = $row['timing'];

                        $return = $row['return_type'];

                    }

                    $seconds = ($duration * 24 * 60 * 60); // Convert Duration (In yDays) To Seconds

                    $starts = timeGMT('l, M d Y, (H:i) [T]');

                    $ends = time() + $seconds; // Calculate Lifespan

                    $expiryDate = date('Y-m-d H:i:s', $ends); // Format Date

                    $expiry = new DateTime("@$ends"); // Convert to DateTime Object

                    $expiry->setTimezone(new DateTimeZone('GMT')); // Convert to GMT

                    $expires = date_format($expiry, 'l, M d Y, (H:i) [T]'); // Format Date

                    // Create Subscription

                    $createItem = mysqli_prepare($conn, "INSERT INTO `subscriptions` (`sub_id`, `user_id`, `item`, `type`, `item_id`, `expires`) VALUES(?, ?, ?, ?, ?, ?)");

                    $subID = generateUniqueID($conn, 'subscriptions', 'SBR'); // Generate Id

                    mysqli_stmt_bind_param($createItem, "ssssss", $subID, $user, $item, $subType, $itemID, $expiryDate);

                    // Email Draft ~ Notify User

                    $subject = 'Portfolio Updated #' . mt_rand(10000000, 99999999); // Mail Subject

                    $mail = investmentConfirmation($userData['firstname'], $name, $orderedOn, $duration, $starts, $expires);

                    $notfTitle = 'Portfolio Updated!';

                    $notf = 'Your portfolio has been updated as your investment into ' . $name . ' has been confirmed. We trust your portfolio will deliver sustained value and strategic growth. Goodluck!';

                } else if ($type === 'FUND') { // Fund Virtual Card

                    $createItem = mysqli_prepare($conn, "UPDATE `virtual_cards` SET `balance` = `balance` + ? WHERE `card_id` = ?");

                    mysqli_stmt_bind_param($createItem, "ss", $amount, $itemID);

                    // Fetch Virtual Card Data

                    foreach ($itemData as $row) {

                        $cardNum = substr($row['card_number'], 0, 4) . '****' . substr($row['card_number'],  -3);

                        $provider = $row['provider'];

                        $currency = $row['currency'];

                        $balance = $row['balance'];

                    }

                    // Email Draft ~ Notify User

                    $symbol = $currSymbol[$currency] ?? null;

                    $newBal = $balance + $amount;

                    $subject = 'Virtual Card Funded #' . mt_rand(10000000, 99999999); // Mail Subject

                   // $mail = cardFundConfirmation($userData['firstname'], $provider, $amount, $paidOn, $currency, $symbol . number_format($balance, 2), $symbol . number_format($newBal, 2));

                   $mail = cardFundConfirmation( $userData['firstname'],$provider, $amount,  $paidOn, $currency, $symbol . number_format($balance ?? 0, 2), $symbol . number_format($newBal ?? 0, 2));

                  
                   $notfTitle = $currency . ' ' . $provider . ' Virtual card Funded!';

                    $notf = 'Your ' . $currency . ' ' . $provider . ' balance has been updated as your payment of ' . number_format($amount, 2) . ' ' . $currency . ' made on ' . $orderedOn .  ' has been confirmed.';

                } else if ($type === 'CARD') { // Virtual Card Request

                    $createItem = mysqli_prepare($conn, "INSERT INTO `virtual_cards` (`card_id`, `user_id`, `provider`, `currency`, `card_number`, `cvv`, `expires`, `color`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (Create Card)

                    // Parameter(s)
        
                    $cardID = generateUniqueID($conn, 'virtual_cards', 'VRT'); // Generate ID
        
                    $cardNum = generateCardNumber($item); // Generate Card Number
        
                    $cvv = generateCVV();
        
                    $duration = 1095; // 3 years (in days)
        
                    $expires = strtotime("+$duration days"); // 3 years from now
        
                    // Create a DateTime object
                    $date = new DateTime();
                    $date->setTimestamp($expires);
        
                    // Move to the last day of the month
                    $date->modify('last day of this month');
        
                    $expires = $date->format('Y-m-d');

                    $ends = $date->format('m/y');
        
                    $color = generateRGB();
        
                    mysqli_stmt_bind_param($createItem, "ssssssss", $cardID, $user, $item, $currency, $cardNum, $cvv, $expires, $color); // Bind Parameter(s)

                    // Email Draft ~ Notify User

                    $subject = 'New Virtual Card Alert #' . mt_rand(10000000, 99999999); // Mail Subject

                    $mail = newVirtualCardConfirmation($userData['firstname'], $item . ' ' . $currency, $paidOn, '3 years', $ends);

                    $notfTitle = 'New Virtual Card Alert!';

                    $notf = 'Your request for a/an ' . $item . ' ' . $currency . ' virtual card has been confirmed and released. Please note that this virtual card is valid till ' . $ends . '. Please enjoy your new ' . $item . ' ' . $currency . ' virtual card.';


                } else if ($type === 'LOAN') { // Loan Repayments

                    // Update Loan Paid Field

                    $createItem = mysqli_prepare($conn, "UPDATE `loans` SET `paid` = `paid` + ? WHERE `loan_id` = ?"); // Prepare Statement

                    mysqli_stmt_bind_param($createItem, "ds", $amount, $itemID); // Bind Parameter(s)

                }

                if (mysqli_stmt_execute($createItem)) { // Execute Statement

                    $itemCreated = true; // Update Flag

                    if ($type === 'INVESTMENT') { // Investment

                        $payouts = payoutSchedule($amount, $interest, $return, $duration, $cycle, $unit);// Generate Payout Schedule

                        $stmt = mysqli_prepare($conn, "INSERT INTO `payout_schedule` (`sub_id`, `user_id`, `amount`, `due`) VALUES(?, ?, ?, ?)");

                        foreach($payouts as $payout) {

                            mysqli_stmt_bind_param($stmt, "ssss", $subID, $user, $payout['amount'], $payout['date']);

                            mysqli_stmt_execute($stmt);

                        }

                        mysqli_stmt_close($stmt);

                    } else if ($type === 'LOAN') { // Loan Repayments

                        // Update Loan Payment Schedule & User's Credit Score

                        $stmt = mysqli_prepare($conn, "UPDATE `users` AS `A` JOIN (SELECT `user_id`, CASE WHEN `due` < ? THEN COUNT(*) * -20 ELSE 0 END AS `deductions`, CASE WHEN `due` = ? THEN COUNT(*) * 20 ELSE 0 END AS `additions` FROM `repayments_schedule` WHERE `status` != ? AND `due` <= ? AND `loan_id` = ?) AS `B` ON `A`.`user_id` = `B`.`user_id` SET `A`.`credit_score` = `A`.`credit_score` + `B`.`deductions` + `B`.`additions` WHERE `A`.`user_id` = ?"); // Prepare Statement (Update User's Credit Score)

                        // Parameter(s)

                        $param = 'PAID';

                        $due = sanitizeDate($paidOn);

                        mysqli_stmt_bind_param($stmt, "ssssss", $due, $due, $param, $due, $itemID, $user); // Bind Parameter(s)

                        mysqli_stmt_execute($stmt); // Execute Statement

                        mysqli_stmt_close($stmt); // Close Statement

                        $stmtB = mysqli_prepare($conn, "UPDATE `repayments_schedule` SET `status` = ? WHERE `status` != ? AND `due` <= ? AND `loan_id` = ?"); // Prepare Statement (Update Repayment Schedule)

                        mysqli_stmt_bind_param($stmtB, "ssss", $param, $param, $due, $itemID); // Bind Parameter(s)

                        mysqli_stmt_execute($stmtB); // Execute Statement

                        mysqli_stmt_close($stmtB); // Close Statement

                    }

                    mysqli_query($conn, "DELETE FROM `payments` WHERE `pay_id` = '$id'"); // Delete Payment Record

                    deleteFile($proof, '../../../'); // Delete Proof

                }

                mysqli_stmt_close($createItem); // Close Statement

                if ($itemCreated) {

                    createNotification($conn, $user, $notfTitle, $notf); // Create Notification

                    // Send Email

                    $deliverMail = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliverMail) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                }

                echo json_encode(['approved' => $itemCreated]); // Encode JSON Response
                
                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $decline = mysqli_prepare($conn, "DELETE FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
    
                mysqli_stmt_bind_param($decline, "s", $id); // Bind Parameter(s)

                if (mysqli_stmt_execute($decline)) { // Execute Statement

                    $declined = true; // Update Flag

                    deleteFile($proof, '../../../'); // Delete Proof

                    if ($type === 'BC') { 

                        $type = 'SERVICE CODE';
        
                    } else if ($type === 'CARD') {

                        $type = 'VIRTUAL CARD';

                    } else if ($type === 'FUND') {

                        $type = 'VIRTUAL CARD DEPOSIT';

                    } else if ($type === 'LOAN') {

                        $type = 'LOAN REPAYMENT / SERVICING';

                    } else {

                        $type = 'SUBSCRIPTION';

                    }

                } 

                mysqli_stmt_close($decline);

                if ($declined) {

                    // Create Notification

                    $notf = 'Your payment of ' . ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency . ' for ' . $details . ' has been declined. This may be due to but not limited to discrepancies in payment data, insufficient balance, amongst other factors.';

                    createNotification($conn, $user, 'Order Declined', $notf);

                    $subject = 'Order Declined #' . mt_rand(10000000, 99999999); // Mail Subject

                    $paid = ($currSymbol[$currency] ?? null) . $amount . ' '.  $currency;

                    $mail = payGatewayDeclined($orderedOn, $type, $details, 'DECLINED', $paid, $id); // Mail Draft

                    $deliverMail = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliverMail) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                }

                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete Payment Record

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

                deleteFile($proof, '../../../'); // Delete Proof

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>