<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['ticket-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $msg = filter_var($_REQUEST['reply'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Locate Support Ticket

        $ticket = ticketData($id, $conn);

        if (!$ticket) {

            echo json_encode(['noTicket' => true]); // Encode JSON Response

            exit; // End Run

        }

        $date = timeGMT(); // Get Time (GMT)

        $sender = 'Agent';

        // Send Message

        $sent = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `messages` (`message_text`, `sender`, `created_at`, `ticket_id`) VALUES(?, ?, ?, ?)"); // Prepare Statement 

        mysqli_stmt_bind_param($stmt, "ssss", $msg, $sender, $date, $id); // Bind Parameter(s) 

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $sent = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['sent' => $sent]); // Encode JSON Response

    }

?>