<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['ticket-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Determine Action

        if ($action == 'DELETE') { // Delete Support Ticket

            $deleted = false; // Flag

            $stmt = mysqli_prepare($conn, "DELETE FROM `messages` WHERE `ticket_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "DELETE FROM `support_tickets` WHERE `ticket_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            mysqli_stmt_bind_param($stmt2, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statement

                $deleted = true; // Update Flag

            } 

            mysqli_stmt_close($stmt);

            mysqli_stmt_close($stmt2);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        } else { // Status Update

            $updated = false; // Flag

            $status = ($action == 'PAUSE') ? 'ON HOLD' : 'OPEN';

            $stmt = mysqli_prepare($conn, "UPDATE `support_tickets` SET `status` = ? WHERE `ticket_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "ss", $status, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) {

                $updated = true; // Update Status

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['updated' => $updated]); // Encode JSON Response

        }

    }

?>