<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Check For Access List

        $countries = 0; // Flag

        $stmt = mysqli_prepare($conn, "SELECT COUNT(*) AS `total` FROM `countries_allowlist`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $countries = $row['total']; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($countries < 1) {

            echo json_encode(['noList' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine Message and Update State

        $param = (FILTER_LOCATION == 'ENABLED')  ? 'DISABLED' : 'ENABLED';

        $msg = (FILTER_LOCATION == 'ENABLED')  ? 'deactivation' : 'activation';

        // Commence Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `settings` SET `restrict_locations` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $param); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated, 'msg' => $msg]); // Encode JSON Response     

    }

?>