<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $registered = sanitizeDate($_REQUEST['reg-date']);

        $tag = !empty($_REQUEST['user-tag']) ? filter_var($_REQUEST['user-tag'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $status = filter_var($_REQUEST['acc-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $authFactor = filter_var($_REQUEST['auth-factor'], FILTER_SANITIZE_SPECIAL_CHARS);

        $loginAlerts = filter_var($_REQUEST['login-alerts'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bcode = filter_var($_REQUEST['bcode-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $transfers = filter_var($_REQUEST['transfer-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $tPin = filter_var($_REQUEST['transc-pin'], FILTER_SANITIZE_SPECIAL_CHARS);

        $invest = filter_var($_REQUEST['invest-by'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bypass = filter_var($_REQUEST['kyc-bypass'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn); // Get Userdata

        if (!$userData) {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run  

        }

        if (!is_null($tag)) {

            // Validate Tag

            if (preg_match_all('/[^a-zA-Z0-9_]/', $tag, $matches)) { // Look For Invalid Character(s)

                $invalidChars = array_unique($matches[0]); // remove duplicates if you want

                echo json_encode(['invalidTag' => true, 'invalidChars' => implode($invalidChars)]); // Encode JSON Response

                exit; // End Run

            } else if (strlen($tag) < 3) {

                echo json_encode(['lengthError' => true]); // Encode JSON Response

                exit; // End Run

            }

            $tagExists = tagExists($tag, $conn); // Check If Tag Exists

            if ($tagExists && $tag !== $userData['tag']) {

                echo json_encode(['tagExists' => true]); // Encode JSON Response

                exit; // End Run

            }

        }

        if (strlen($tPin) > 6 || strlen($tPin) < 6 || !ctype_digit($tPin)) { // Validate Transaction PIN 

            echo json_encode(['tPinError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Update

        $update = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `acc_status` = ?, `billing_code` = ?, `trans_pin` = ?, `transfers` = ?, `login_alerts` = ?, `factor_2FA` = ?, `invest_by` = ?, `username` = ?, `reg_date` = ?, `kyc_bypass` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssssss", $status, $bcode, $tPin, $transfers, $loginAlerts, $authFactor, $invest, $tag, $registered, $bypass, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
  
            $update = true; // Update Flag
        
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $update]); // Encode JSON Response

    }

?>