<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $user = filter_var($_REQUEST['user'], FILTER_SANITIZE_SPECIAL_CHARS);

        $current = !empty($_REQUEST['current-pfp']) ? filter_var($_REQUEST['current-pfp'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $file = $_FILES['new-pfp'];

        $directory = '../../../vault/avatars/';
        
        $filePath = fileUpload($file, $directory, 'avtr', null, true); // Attempt To  Upload File

        if ($filePath['status']) {

            $filePath = $filePath['vault'];

        } else {

            $error = $filePath['message'];

            echo json_encode(['uploadFail' => true, 'message' => $error]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Data Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `user_avatar` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $filePath, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if (!$updated) {

            deleteFile($filePath); // Delete Uploaded File

        } else {

            if ($current) {

                deleteFile($current, '../../../'); // Get Rid Of Current Avatar

            }

        }

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>