<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Function Definitions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $succeed = false; // Flag

        // Carry-out Specific Action

        if ($action == 'DELETE' || $action == 'DENY') {

            $succeed = deleteUser($conn, $user, '../../../');

        } else if ($action == 'APPROVE') {

            $stmt = mysqli_prepare($conn, "UPDATE `users` SET `reg_clearance` = ? WHERE `user_id` = ?"); // Prepare Statement (For 2FA Status)

            $param = 'CLEARED';

            mysqli_stmt_bind_param($stmt, "ss", $param, $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        } else { // 2FA

            $stmt = mysqli_prepare($conn, "UPDATE `users` SET `factor_2FA` = ? WHERE `user_id` = ?"); // Prepare Statement (For 2FA Status)

            $param = ($action == 'ENABLE') ? 'ENABLED' : 'DISABLED'; // Determine Field Value

            mysqli_stmt_bind_param($stmt, "ss", $param, $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        }

        echo json_encode(['succeeded' => $succeed]); // Encode JSON Response

    }

?>