<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['card'], FILTER_SANITIZE_SPECIAL_CHARS);

        $balance = filter_var($_REQUEST['balance'], FILTER_SANITIZE_SPECIAL_CHARS, FILTER_FLAG_ALLOW_FRACTION);

        // Data Drop

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `virtual_cards` SET `balance` = ? WHERE `card_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ds", $balance, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['balUpdated' => $updated]); // Encode JSON Response

    }

?>