<?php

    require('utility/partials/header.php');
    
?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Users Activity.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><button type="button" id="delete-access-logs" class="btn btn-danger"><span>Clear Activity Log</span> <em class="icon ni ni-trash"></em></button></li>

                        </ul>

                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Current Activity Log</h4>
                <div class="nk-block-des">
                    <p>Bar User / IP access</code>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col">#</th>
                            <th class="nk-tb-col"><span class="sub-text">Fullname</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">IP Address</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">IP Status</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Cookie</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Cookie Status</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Country</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // User Flag

                            // Fetch All Users
                        
                            $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname`, `B`.`email` FROM `users_activity` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` ORDER BY `A`.`id` DESC"); // Prepare Statement

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; // Declear Counter

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++; // Update Counter

                                    $id = $row['id'];

                                    $userId = $row['user_id'];

                                    $firstname = $row['fname'];

                                    $middlename = $row['mname'];

                                    $lastname = $row['lname'];

                                    $fullname = join(' ', [$firstname, $middlename, $lastname]);

                                    $email = $row['email'];

                                    $ipStatus = $row['ip_status'];

                                    $cookie = substr($row['cookie'], 0, 15) . '...';

                                    $cookieStatus = $row['cookie_status'];

                                    $ip = $row['ip_address'];

                                    $count = $row['activity_count'];

                                    $countryCode = $row['country_code'];

                                    $country = $countryCodeNames[$countryCode] ?? $countryCode;
    
                                ?>    

                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col"><?= $i ?></td>

                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-avatar bg-dim-primary d-none d-sm-flex">
                                                    <span>
                                                        <?= strtoupper(substr($fullname, 0, 2)) ?>
                                                    </span>
                                                </div>
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $fullname ?><span class="dot dot-success d-md-none ml-1"></span>
                                                    </span>
                                                    <span>
                                                        <?= $email ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span>
                                                <?= $ip ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <ul class="list-status">
                                            
                                                <?php
                                                
                                                    if ($ipStatus == 'DISALLOWED') {

                                                        echo '<li><em class="icon text-warning ni ni-alert-circle"></em> <span>DISALLOWED</span><li>';

                                                    } else if ($ipStatus == 'ALLOWED') {

                                                        echo '<li><em class="icon text-success ni ni-check-circle"></em> <span>ALLOWED</span></li>';

                                                    } else {

                                                        echo '<li><em class="icon text-danger ni ni-alert-circle"></em> <span>BLOCKED</span><li>';

                                                    }
                                                
                                                ?>

                                            </ul>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg" data-order="Email Verified - Kyc Unverified">
                                            <p><?= $cookie ?></p>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg">
                                            <span>
                                                <ul class="list-status">
                                            
                                                    <?php
                                                    
                                                        if ($cookieStatus == 'BLOCKED') {

                                                            echo '<li><em class="icon text-danger ni ni-alert-circle"></em> <span>BLOCKED</span><li>';

                                                        } else if ($cookieStatus == 'ALLOWED') {

                                                            echo '<li><em class="icon text-success ni ni-check-circle"></em> <span>ALLOWED</span></li>';

                                                        }
                                                    
                                                    ?>

                                                </ul>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <?= $country ?>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="access-mgmt-form" method="post">
                                                <input type="hidden" name="user-id" value="<?= $userId ?>">
                                                <ul class="nk-tb-actions gx-1">

                                                    <?php
                                                    
                                                        if ($ipStatus !== 'BLOCKED' || $cookieStatus !== 'BLOCKED') { ?>

                                                            <li class="nk-tb-action-hidden">
                                                                <button type="submit" name="toggle-status" value="BLOCK" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Block Access">
                                                                    <em class="icon ni ni-na text-danger"></em>
                                                                </a>
                                                            </li>

                                                        <?php } else { ?>

                                                            <li class="nk-tb-action-hidden">
                                                                <button type="submit" name="toggle-status" value="ALLOW" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Grant Access">
                                                                    <em class="icon ni ni-check text-success"></em>
                                                                </a>
                                                            </li>

                                                        <?php }
                                                    
                                                    ?>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="delete" value="DELETE" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete Activity">
                                                            <em class="icon ni ni-trash text-warning"></em>
                                                        </a>
                                                    </li>

                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li><a href="user-activity?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-eye"></em><span>View
                                                                                Details</span></a></li>
                                                                    <li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>    
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->
</div><!-- .components-preview -->


<?php

  require('utility/partials/footer.php');

?>