<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        $userAccounts = userAccounts($id, $conn); // Get User Accounts

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        } else if (!$userAccounts) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "No account not found!",

                    icon: "warning",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Withdrawal Settings</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="billing-codes?id=<?= $id ?>" class="btn btn-dark"><span>See Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Withdrawal Settings</h4>
                <div class="nk-block-des">
                    <p>Below is the list of accounts with active limits</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">                         
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Account</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Transactions / Limit</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Withdrawal Limit</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Flag

                            // Fetch All User's Joint Holders
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `accounts` WHERE `user_id` = ? AND (`wth_limit` IS NOT NULL OR `wth_max` IS NOT NULL) ORDER BY `id` DESC"); // Prepare Statement

                            $null = null;

                            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; 

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $accNum = $row['acc_num'];

                                    $accId = $row['acc_id'];

                                    $wLimit = $row['wth_limit'];

                                    $wCount = $row['wth_count'] ?? 0;

                                    $wMax = $row['wth_max'];

                                    $currency = $row['currency'];

                                ?>    

                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $currency ?></span>
                                            <span><?= $accNum ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $wCount . '/' . $wMax ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $currSymbol[$currency] . number_format($wLimit, 2) ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="wth-limit-mgmt-form" method="post">
                                                <input type="hidden" name="account-id" value="<?= $accId ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" value="RESET" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Reset Limits">
                                                            <em class="icon ni ni-reload text-success"></em>
                                                        </button>
                                                    </li>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" value="DELETE" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete Limit">
                                                            <em class="icon ni ni-trash text-danger"></em>
                                                        </button>
                                                    </li>

                                                </ul>
                                            </form>
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-lock-alt"></em> Set Withdrawal Limit</h5>
        </div>
        <form id="wth-limit-form" method="post">
            <div class="card-body">
                <b>Account Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="fname">Currency</label>
                            <select class="form-control" name="currency">
                                <?php
                                
                                    foreach($userAccounts as $account): ?>

                                        <option value="<?= $account['currency'] ?>"><?= $account['currency'] ?></option>

                                    <?php endforeach;

                                ?>
                            </select>
                            <input type="hidden" class="form-control" name="user-id" value="<?= $id ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="wth-max">Max Withdrawal (Amount)</label>
                            <input type="number" step="0.01" min="0.01" class="form-control" name="wth-max" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="wth-limit">Withdrawal Count Limit</label>
                            <input type="number" step="0.01" min="0.01" class="form-control" name="wth-limit" required>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="set-wth-limit" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>