if (window.location.pathname.includes('/pay')) {

    fetch('../controls/logic/pay-timeout.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Failed to fetch target date.');
            }
            return response.json();
        })
        .then(data => {
            if (!data.targetDate) {
                throw new Error('Target date not found in response.');
            }
            
            const targetDate = data.targetDate * 1000;  // Convert to milliseconds

            const timer = setInterval(function() {
                const now = new Date().getTime();
                const distance = targetDate - now;

                if (distance > 0) {
                    let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    let seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    minutes = String(minutes).padStart(2, '0');
                    seconds = String(seconds).padStart(2, '0');

                    const timerElement = document.querySelectorAll('.exp-time');
                    timerElement.forEach((timeDispl) => {
                        timeDispl.querySelector('span').innerHTML = minutes + ':' + seconds;
                    });
                } else {
                    clearInterval(timer);

                    // Clear timer display
                    document.querySelectorAll('.exp-time').forEach((timeDispl) => {
                        timeDispl.innerHTML = 'Expired!';
                    });

                    // Set session before redirecting
                    fetch('../controls/engines/pay-expired.php')
                        .then(response => response.json())
                        .then(data => {
                            // Check if the response indicates success
                            if (data.status === 'success') {
                                // Redirect after session is set
                                window.location.href = 'feedback';
                            }
                        })
                        .catch(error => console.error('Error setting session:', error));
                }
            }, 1000);
        })
        .catch(error => console.error('Error fetching target date:', error));

}        
