function formProcessZero(element) { // Button Loading Function
    if (!element) {
        console.error("Element not found");
        return;
    }

    const content = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>`;

    const identifier = 'inaccessible';

    element.innerHTML = content;
    element.classList.add(identifier);
    element.disabled = true;

    if (element.disabled) return; // Prevent Multiple Clicks

}

function formProcess(element, duration) { // Timed Button Loading Function
    if (!element) {
        console.error("Element not found");
        return;
    }

    const restore = element.innerHTML;

    const content = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>`;

    const identifier = 'inaccessible';

    element.innerHTML = content;
    element.classList.add(identifier);
    element.disabled = true;

    if (element.disabled) return; // Prevent Multiple Clicks

    setTimeout(() => {
        element.innerHTML = restore;
        element.disabled = false;
        element.classList.remove(identifier);
    }, duration);
}

function formProcessRestore(element, restore) { // Button Restore function
    if (!element) {
        console.error("Element not found");
        return;
    }

    const identifier = 'inaccessible';

    element.innerHTML = restore;
    element.classList.remove(identifier);
    element.disabled = false;

}

function processZero(element) { // Button Loading Function (Variant B)

    if (!element) {
        console.error("Element not found");
        return;
    }

    const feedback = 'Processing...';

    const content = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg> <span>${feedback}</span>`;

    const identifier = 'inaccessible';

    element.innerHTML = content;
    element.classList.add(identifier);
    element.disabled = true;

    if (element.disabled) return; // Prevent Multiple Clicks

}

function processRestore(element, restore) { // Button Restore function
    if (!element) {
        console.error("Element not found");
        return;
    }

    const identifier = 'inaccessible';

    element.innerHTML = restore;
    element.classList.remove(identifier);
    element.disabled = false;

}

function delayedRestore(element, restore, delayMinutes) { // Button Delayed Restore function
    if (!element) {
        console.error("Element not found");
        return;
    }

    const identifier = 'inaccessible';

    // Deny User Interaction
    element.classList.add(identifier);
    element.disabled = true;

    // Convert minutes to seconds
    let delay = delayMinutes * 60;

    // Set static text once
    element.innerHTML = `${restore} <span class="timer" translate="no"></span>`;
    const timerSpan = element.querySelector('.timer');

    let prevTime = '';

    const intervalId = setInterval(() => {
        delay--;

        if (delay < 0) {
            clearInterval(intervalId);

            // Restore original state
            element.innerHTML = restore;
            element.classList.remove(identifier);
            element.disabled = false;
            return;
        }

        // Calculate minutes and seconds
        const minutes = String(Math.floor(delay / 60)).padStart(2, '0');
        const seconds = String(delay % 60).padStart(2, '0');
        const currentTime = `(${minutes}:${seconds})`;

        // Update timer only if changed
        if (currentTime !== prevTime) {
            timerSpan.textContent = currentTime;
            prevTime = currentTime;
        }
    }, 1000);
}

function initLoadingPane(element) { // Initialize Loading Pane

    if (!element) {
        console.error("Element not found");
        return;
    }

    const content = `<div class="flx"><div><svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg></div></div>`;

    const identifier = 'inaccessible';

    element.innerHTML = content;
    element.classList.add(identifier);
    element.disabled = true;

    if (element.disabled) return; // Prevent Multiple Clicks

}

function closeLoadingPane(element) { // Close Loading Pane
    
    if (!element) {
        console.error("Element not found");
        return;
    }

    const identifier = 'inaccessible';

    element.innerHTML = null;
    element.classList.remove(identifier);
    element.disabled = false;

    if (element.disabled) return; // Prevent Multiple Clicks

}

// Login Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#loginForm');

    let button = document.querySelector('#login');

    if (form && button) {

        let idField = form.querySelector('input[name="identifier"]');

        let keyField = form.querySelector('input[name="key"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            if (button.disabled) return; // Prevent Multiple Clicks

            let content = button.innerHTML; // Store Button's Original Content

            formProcessZero(button); // Intiate Loading Animation

            try {

                // Process Form

                let formData = new FormData(form); // Holds Form Data

                let uaInfo = parseUA(); // Get User Agent Info

                for (const [key, value] of uaInfo) {

                    formData.append(key, value);

                }

                // console.log([...formData.entries()]);

                let processor = await fetch('../controls/logic/login-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Form Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.restricted) {

                    setTimeout(() => {

                        window.location = '../security/restricted';

                    }, 2000);

                } else if (response.jumpMFA) {

                    setTimeout(() => {

                        window.location = '../dashboard/';

                    }, 2000);

                } else if (response.mfa) {

                    setTimeout(() => {

                        window.location = '../mfa/';

                    }, 2000);

                } else if (response.regIncomplete) {

                    setTimeout(() => {

                        window.location = 'register';

                    }, 2000);

                } else if (response.regPending) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Account is yet to be approved!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore Button

                        form.reset(); // Reset Form

                    }, 2000);

                } else {

                    // Handle Errors

                    if (response.statusError) {

                        let status = response.statusError;

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Account: ' + status,

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                        }, 2000);

                    } else if (response.invalidKey) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Incorrect password!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            keyField.focus(); // Focus On Field

                            keyField.value = ''; // Clear Field

                        }, 2000);

                    } else if (response.invalidEmail) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Email address not found!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            idField.focus(); // Focus On Field

                        }, 2000);

                    } else if (response.invalidTag) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Username not found!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            idField.focus(); // Focus On Field

                        }, 2000);

                    } else if (response.invalidAcc) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Account number not found!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            idField.focus(); // Focus On Field

                        }, 2000);

                    }
                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// Login (By Cookie) Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#accessForm');

    let button = document.querySelector('#access');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Button's Original Content

            formProcessZero(button); // Initiate Loading Sequence

            let pwrd = form.querySelector('input[name="key"]');

            // Process Form

            try {

                const formData = new FormData(form); // Collect Form Data

                let uaInfo = parseUA(); // Get User Agent Info

                for (const [key, value] of uaInfo) {

                    formData.append(key, value);

                }

                // console.log([...formData.entries()]);

                const processor = await fetch('../controls/logic/cookie-login-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                const response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.cookieError) {

                    window.location.reload();

                } else if (response.pwrdError) {

                    setTimeout(() => {

                        toast({

                            text: 'Password incorrect!',

                            type: 'error',

                            duration: 2500

                        });

                        pwrd.value = null;

                        pwrd.focus(); // Focus On Field

                        formProcessRestore(button, content); // End Loading Sequence

                    }, 1200);

                } else if (response.mfa) {

                    setTimeout(() => {

                        window.location.href = '../mfa/';

                    }, 2500);

                } else if (response.jumpMFA) {

                    setTimeout(() => {

                        toast({

                            text: 'Welcome back!',

                            type: 'success',

                            duration: 2500

                        });

                    }, 1200);

                    setTimeout(() => {

                        window.location.href = '../dashboard/';

                    }, 3200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Password Reset Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#forgot-pwrd-form');

    let button = document.querySelector('#forgot-pwrd');

    if (form && button) {

        let idField = form.querySelector('input[name="identifier"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            if (button.disabled) return; // Prevent Multiple Clicks

            let content = button.innerHTML; // Store Button's Original Content

            formProcessZero(button); // Intiate Loading Animation

            try {

                // Process Form

                let formData = new FormData(form); // Holds Form Data

                    let processor = await fetch('../controls/logic/request-pwrd-reset.php', {

                    method: 'POST',

                    body: formData

                }); // Form Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.userError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Account not found!',

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore Button

                        idField.focus(); // Focus On Field

                        // idField.value = null; // Clear Field

                    }, 2000);

                } else if (response.mfa) {

                    setTimeout(() => {

                        window.location = '../mfa/';

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// Set New Password Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#new-pwrd-form');

    let button = document.querySelector('#set-new-pwrd');

    if (form && button) {

        let password = form.querySelector('input[name="pwrd"]');

        let confirmPwrd = form.querySelector('input[name="confirm-pwrd"]');

        let criteriaMap = form.querySelector('#pwrd-criteria');

        let criteria = false; // Password Criteria Flag

        let indicators; // Criteria Indicators

        // Password Criteria Indication

        password.addEventListener("focus", () => {

            criteriaMap.classList.remove('n_displ');

        });

        password.addEventListener("input", async () => {

            let data = password.value;

            indicators = document.querySelectorAll('.req_key');

            // 1. Escape function
            const escapeForRegex = (str) => str.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&');

            // 2. Prepare safe special chars
            const rawSpecialChars = "~`!@#$%^&*()_-+={}[]:\";'|?/\\";
            const safeSpecials = escapeForRegex(rawSpecialChars);


            // Consolidated validation logic (Object)

            const requirements = [

                { test: data.length >= 8 },

                { test: /[A-Z]/.test(data) },

                { test: /[a-z]/.test(data) },

                { test: new RegExp(`[${safeSpecials}]`).test(data) },

                { test: /\d/.test(data) }

            ];

            // Update UI and flags in one pass

            requirements.forEach((condition, index) => {

                indicators[index].classList.toggle('active', condition.test);

            });

            // Set final criteria flag (all must be true)

            criteria = requirements.every(r => r.test); // Update Flag

        });

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            // Validate Form Data

            if (!criteria) { // Check Criteria Flag

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Required criteria not met!',

                        type: 'warning',

                        duration: 2000

                    });

                    password.focus(); // Highlight Field

                    formProcessRestore(button, content); // Restore / Stop Animation

                }, 1200);

            } else if (String(password.value) !== String(confirmPwrd.value)) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Password mismatch!',

                        type: 'error',

                        duration: 2000

                    });

                    confirmPwrd.focus(); // Highlight Field

                    formProcessRestore(button, content); // Restore / Stop Animation

                }, 1200);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Gain FormData

                    let processor = await fetch('../controls/logic/set-new-pwrd.php', {

                        method: 'POST',

                        body: formData

                    }); // Request Handler, Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        window.location.reload();

                    } else if (response.updated) {

                        setTimeout(() => {

                            toast({

                                text: 'New password set!',

                                type: 'success',

                                duration: 3000

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.href = 'login';

                        }, 2500);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Please, try again!',

                                type: 'warning',

                                duration: 3000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    }


                } catch (error) {

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 2500

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            }

        });

    }

});


// UA Parser

function parseUA() {

    const parser = new UAParser(); // Initiate UA Parser

    const result = parser.getResult(); // Get Result

    const data = new Map([
        ['browser', result.browser.name || ''],
        ['browser-version', result.browser.version || ''],
        ['os', result.os.name || ''],
        ['os-version', result.os.version || ''],
        ['device', result.device.type || 'PC'],
    ]);

    return data;

}

// MFA Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#mfaForm');

    let button = document.querySelector('#verifyMfa');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Store Button Original Content

            if (button.disabled) return; // Prvent Multiple Clicks

            formProcessZero(button); // Intiate Button Loading Animation

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let uaInfo = parseUA(); // Get User Agent Info

                for (const [key, value] of uaInfo) {

                    formData.append(key, value);

                }

                let processor = await fetch('../controls/logic/mfa-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Form Processor Credentials 

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.codeValid) {

                    let loc = '../dashboard/';

                    if (response.pwrdReset) {

                        loc = '../auth/reset-password';

                    }

                    setTimeout(() => {

                        // Grant Dashboard Access 

                        window.location.href = loc;

                    }, 2000);

                } else {

                    if (response.invalidUser) {

                        setTimeout(() => {

                            window.location.href = '../auth/'; // Redirect to Login

                        }, 2000);


                    } else if (response.codeInvalid) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Code invalid!',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                            form.querySelector('input').focus(); // Focus On First Input

                        }, 2000);


                    } else if (response.codeExpired) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Expired multifactor code',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                            form.querySelector('input').focus(); // Focus On First Input

                        }, 2000);

                    }

                }


            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// OTP Request Handler

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#reMfa');

    let form = document.querySelector('#mfaForm');

    if (command && form) {

        command.addEventListener("click", async () => {

            let content = command.innerHTML; // Get Button Content

            if (command.disabled) return; // Prevent Multiple Clicks

            processZero(command); // Initiate Load

            form.reset(); // Reset Form

            form.querySelector('input').focus(); // Focus On First Input

            try {

                // Handle Request

                let processor = await fetch('../controls/logic/otp-generator.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh || response.userError) {

                    setTimeout(() => {

                        window.location.href = '../auth/'; // Redirect To Login

                    }, 2000);

                } else {

                    if (response.codeDelivered) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Multifactor code resent!',

                                type: 'success',

                                duration: 7000

                            });

                            delayedRestore(command, content, 2); // Restore Button

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Please, try again!',

                                type: 'error',

                                duration: 7000

                            });

                            processRestore(command, content); // Restore Button

                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    processRestore(command, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// Registration Forms Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#registerForm');

    let track = document.querySelector('#iQ_reg-track');

    let command = document.querySelector('#reg-conclude');

    let partA = document.querySelector('#reg-step-1');

    let partB = document.querySelector('#reg-step-2');

    let partC = document.querySelector('#reg-step-3');

    let partD = document.querySelector('#reg-step-4');

    let partE = document.querySelector('#reg-step-5');

    let partF = document.querySelector('#reg-step-6');

    let partG = document.querySelector('#reg-step-7');

    let back = document.querySelector('#iQ_reg-track .back_ctrl');

    let validPhone; // Stores Validated Phone Number

    //  Return Navigation Function

    function prev() {

        if (track.classList.contains('step-2')) {

            track.classList.replace('step-2', 'step-1');

            partB.classList.add('n_displ');

            partA.classList.remove('n_displ');

        } else if (track.classList.contains('step-3')) {

            track.classList.replace('step-3', 'step-2');

            partC.classList.add('n_displ');

            partB.classList.remove('n_displ');

        } else if (track.classList.contains('step-5')) {

            track.classList.replace('step-5', 'step-4');

            partD.classList.add('n_displ');

            partC.classList.remove('n_displ');

        }

    }

    if (back) {

        back.addEventListener("click", prev);

    }

    function goTop() {

        window.scrollTo({ top: 0, behavior: 'smooth' });

    }

    if (form && track) {

        // Handle Stage 1 ~ Part A

        if (partA && partB) {

            track.classList.add('step-1'); // Indicate Status

            let validator = partA.querySelector('button[name="r-step-1"]');

            let field = partA.querySelector('select[name="residence"]');

            validator.addEventListener("click", () => {

                let content = validator.innerHTML; // Store Original Text

                if (validator.disabled) return; // Prevent Multiple Clicks

                formProcessZero(validator); // Initial Load

                if (field.value == 0) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Please, select a country!',

                            type: 'error',

                            duration: 7000

                        });

                        partA.querySelector('.iQ_focus:not(select)').focus();

                        // partA.querySelector('.iQ_focus:not(select)').setAttribute('variant', 'error');

                        formProcessRestore(validator, content); // Restore Button

                    }, 2000);

                } else {

                    setTimeout(() => {

                        partA.classList.add('n_displ'); // Close Stage

                        partB.classList.remove('n_displ'); // Open Next Stage

                        track.classList.replace('step-1', 'step-2'); // Indicate Status

                        formProcessRestore(validator, content); // Restore Button

                        goTop();

                    }, 2000);

                }

            });

        }

        // Handle Stage 1 ~ Part B

        if (partB && partC) {

            let validator = partB.querySelector('button[name="r-step-2"]');

            let phone = partB.querySelector('input[name="user_tel"]');

            let email = partB.querySelector('input[name="user_email"]');

            let gender = partB.querySelector('select[name="user_gender"]');

            let fields = partB.querySelectorAll('input');

            const telVerify = window.intlTelInput(phone, {

                autoPlaceholder: "off",

                initialCountry: "us",

                separateDialCode: true,

                fixDropdownWidth: false,

                formatAsYouType: true,

                // nationalMode: true,

                strictMode: true,

            });

            window.iti = telVerify;

            validator.addEventListener("click", async () => {

                let content = validator.innerHTML; // Store Original Text

                if (validator.disabled) return; // Prevent Multiple Clicks

                formProcessZero(validator); // Initial Load

                let isEmpty = false; // Flag

                fields.forEach((field) => {

                    field.removeAttribute('variant');

                    if (field.value.trim().length === 0 && field.hasAttribute('required')) {

                        isEmpty = true; // Update Flag

                        field.setAttribute('variant', 'error');

                    }

                });

                if (isEmpty) {

                    toast({ // User Feedback

                        text: 'All fields are required.',

                        type: 'error',

                        duration: 7000

                    });

                    setTimeout(() => {

                        formProcessRestore(validator, content); // Restore Button

                    }, 1300);

                } else {

                    if (gender.value == 0) {

                        toast({ // User Feedback

                            text: 'Please, specify gender.',

                            type: 'error',

                            duration: 7000

                        });

                        setTimeout(() => {

                            formProcessRestore(validator, content); // Restore Button

                        }, 1300);

                    } else {

                        if (!email.checkValidity()) {

                            email.reportValidity();

                            formProcessRestore(validator, content); // Restore Button

                        } else {

                            // Check Email Address

                            let checker = await fetch('../controls/logic/registration-email-checker.php', {

                                method: 'POST',

                                body: new URLSearchParams({

                                    'address': email.value.trim()

                                }),

                                headers: {

                                    'Content-Type': 'application/x-www-form-urlencoded'

                                }

                            });

                            let response = await checker.json(); // Parse JSON Response

                            // Handle Response

                            if (response.emailTaken) {

                                email.setAttribute('variant', 'error'); // Highlight Field

                                toast({ // User Feedback

                                    text: 'Email already in use!',

                                    type: 'warning',

                                    duration: 7000

                                });

                                setTimeout(() => {

                                    formProcessRestore(validator, content); // Restore Button

                                }, 1300);

                            } else {

                                // Validate Phone Number

                                if (!telVerify.isValidNumber()) {

                                    phone.setAttribute('variant', 'error'); // Highlight Field

                                    toast({ // User Feedback

                                        text: 'Phone number invalid!',

                                        type: 'warning',

                                        duration: 7000

                                    });

                                    setTimeout(() => {

                                        formProcessRestore(validator, content); // Restore Button

                                    }, 1300);

                                } else {

                                    validPhone = telVerify.getNumber();

                                    // Check Valid Phone Number

                                    try {

                                        let checker = await fetch('../controls/logic/registration-tel-checker.php', {

                                            method: 'POST',

                                            body: new URLSearchParams({

                                                'phone': validPhone

                                            }),

                                            headers: {

                                                'Content-Type': 'application/x-www-form-urlencoded'

                                            }

                                        });

                                        let response = await checker.json(); // Parse JSON Response

                                        // Handle Response

                                        if (response.lineTaken) {

                                            phone.setAttribute('variant', 'error'); // Highlight Field

                                            toast({ // User Feedback

                                                text: 'Number already in use!',

                                                type: 'warning',

                                                duration: 7000

                                            });

                                            setTimeout(() => {

                                                formProcessRestore(validator, content); // Restore Button

                                            }, 1300);

                                        } else {

                                            setTimeout(() => {

                                                partB.classList.add('n_displ'); // Close Stage

                                                partC.classList.remove('n_displ'); // Open Next Stage

                                                track.classList.replace('step-2', 'step-3'); // Indicate Status

                                                formProcessRestore(validator, content); // Restore Button

                                                goTop();

                                            }, 2000);

                                        }

                                    } catch (error) {

                                        console.error('Error:', error);

                                        toast({ // User Feedback

                                            text: 'An error occurred!',

                                            type: 'error',

                                            duration: 7000

                                        });

                                        setTimeout(() => {

                                            formProcessRestore(validator, content); // Restore Button

                                        }, 1300);

                                    }    

                                }

                            }

                        }

                    }

                }

            });

        }

        // Handle Stage 1 ~ Part C

        let pwrdField = document.querySelector('#iQ_key');

        let criteriaMap = document.querySelector('#pwrd-criteria');

        let criteria = false; // Password Criteria Flag

        let indicators; // Criteria Indicators

        // Server-side Password Criteria Validation

        async function pwrdServerValidate(password) {

            try {

                let validator = await fetch('../controls/logic/validate-pwrd.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/json'

                    },

                    body: JSON.stringify({

                        'v-password': password

                    })

                });

                return await validator.json(); // Parse JSON Response

            } catch (error) {

                console.error('Password validation error:', error); // Log Error to Console

                return {

                    valid: false

                };

            }

        };

        if (pwrdField && criteriaMap) {

            pwrdField.addEventListener("focus", () => {

                criteriaMap.classList.remove('n_displ');

            });

            // Password Criteria Indication

            pwrdField.addEventListener("input", async () => {

                let data = pwrdField.value;

                indicators = document.querySelectorAll('.req_key');

                // 1. Escape function
                const escapeForRegex = (str) => str.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&');

                // 2. Prepare safe special chars
                const rawSpecialChars = "~`!@#$%^&*()_-+={}[]:\";'|?/\\";
                const safeSpecials = escapeForRegex(rawSpecialChars);


                // Consolidated validation logic (Object)

                const requirements = [

                    { test: data.length >= 8 },

                    { test: /[A-Z]/.test(data) },

                    { test: /[a-z]/.test(data) },

                    { test: new RegExp(`[${safeSpecials}]`).test(data) },

                    { test: /\d/.test(data) }

                ];

                // Update UI and flags in one pass

                requirements.forEach((condition, index) => {

                    indicators[index].classList.toggle('active', condition.test);

                });

                // Set final criteria flag (all must be true)

                criteria = requirements.every(r => r.test); // Update Flag

            });

        }

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            if (command.disabled) return; // Prevent Multiple Clicks

            let content = command.innerHTML; // Store Command Button Content

            formProcessZero(command); // Start Loading Animation

            let rePwrd = form.querySelector('input[name="r-key"]');

            let fields = partC.querySelectorAll('input');

            let questionA = partC.querySelector('select[name="sq1"]');

            let questionB = partC.querySelector('select[name="sq2"]');

            fields.forEach((field) => {

                field.removeAttribute('variant'); // Unset All Error

            });

            // Perform Checks

            if (questionA.value == 0 || questionB.value == 0) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Questions are required!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(command, content); // Restore / Stop Animation

                }, 2000);

            } else {

                if (!criteria) { // Check Criteria Flag

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Required criteria not met!',

                            type: 'warning',

                            duration: 7000

                        });

                        pwrdField.focus(); // Highlight Field

                        formProcessRestore(command, content); // Restore / Stop Animation

                    }, 2000);

                } else {

                    // Perform Server-side Criteria Validation (Security Fallback)

                    // let serverValidation = await pwrdServerValidate(pwrdField.value);

                    // console.log(serverValidation);

                    // if (!serverValidation.valid) {

                    //     setTimeout(() => {

                    //         toast({ // User Feedback

                    //             text: 'Password error!',

                    //             type: 'error',

                    //             duration: 7000

                    //         });

                    //         fields.forEach((field) => { // Reset Fields

                    //             field.value = '';

                    //         });

                    //         indicators.forEach((indicator) => {

                    //             indicator.classList.remove('active'); // Remove Active 

                    //         });

                    //         pwrdField.focus(); // Highlight Field

                    //         formProcessRestore(command, content); // Restore / Stop Animation

                    //     }, 2000);

                    // } else {

                    // Confirm Password

                    if (String(pwrdField.value) !== String(rePwrd.value)) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Password mismatch!',

                                type: 'error',

                                duration: 7000

                            });

                            rePwrd.focus(); // Highlight Field

                            formProcessRestore(command, content); // Restore / Stop Animation

                        }, 2000);

                    } else {

                        try {

                            // Process Form

                            let formData = new FormData(form); // Collect Form Data

                            formData.append('phone-number', validPhone); // Append 

                            let processor = await fetch('../controls/logic/registration-processor.php', {

                                method: 'POST',

                                body: formData

                            }); // Processor Credentials

                            let response = await processor.json(); // Parse JSON Response

                            // Handle Response

                            if (response.idError) {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'warning',

                                    duration: 7000

                                });

                                setTimeout(() => {

                                    formProcessRestore(command, content); // Restore Button

                                }, 2000);

                            } else {

                                if (response.regStatus) {

                                    setTimeout(() => {

                                        formProcessRestore(command, content); // Restore Button

                                        partC.classList.add('n_displ'); // Close Stage

                                        form.remove(); // Remove Form

                                        partD.classList.remove('n_displ'); // Open Next Stage

                                        track.classList.replace('step-3', 'step-4'); // Indicate Status

                                        goTop();

                                    }, 2000);

                                } else {

                                    toast({ // User Feedback

                                        text: 'Unable to process request!',

                                        type: 'warning',

                                        duration: 7000

                                    });

                                    setTimeout(() => {

                                        location.reload(); // Refresh Page

                                    }, 2000);

                                }

                            }

                        } catch (error) {

                            console.error('Error:', error); // Log Error to Console

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Unable to process request!',

                                    type: 'warning',

                                    duration: 7000

                                });

                                formProcessRestore(command, content); // Restore / Stop Animation

                            }, 2000);

                        }

                    }

                    // }

                }

            }

        });

    }

    // Stage 2

    let formB = document.querySelector('#registerFormB');

    let commandB = document.querySelector('#reg-concludeB');

    if (formB) {

        // Stage 2 ~ Part D

        if (partD) {

            let validator = partD.querySelector('button[name="r-step-4"]');

            validator.addEventListener("click", () => {

                let content = validator.innerHTML; // Store Original Text

                if (validator.disabled) return; // Prevent Multiple Clicks

                formProcessZero(validator); // Initial Load

                let fields = partD.querySelectorAll('input');

                let dFields = partD.querySelectorAll('select');

                let marital = partD.querySelector('input[name="marital"][required]');

                let isEmpty = false; // Flag

                fields.forEach((field) => {

                    field.removeAttribute('variant');

                    if (!field.checkValidity()) {

                        field.reportValidity();

                        formProcessRestore(validator, content); // Restore Button

                    }

                    if (field.value.trim().length === 0 && field.hasAttribute('required')) {

                        isEmpty = true; // Update Flag

                        field.setAttribute('variant', 'error'); // Error Border

                    }

                });

                dFields.forEach((dField) => {

                    if (dField.value == 0) {

                        isEmpty = true;

                        // dField.setAttribute('variant', 'error'); // Error Border

                    }

                });


                if (isEmpty) {

                    toast({ // User Feedback

                        text: 'Required field(s) empty',

                        type: 'error',

                        duration: 7000

                    });

                    setTimeout(() => {

                        formProcessRestore(validator, content); // Restore Button

                    }, 1300);

                } else {

                    if (!marital.checkValidity()) {

                        marital.reportValidity();

                        formProcessRestore(validator, content); // Restore Button

                    } else {

                        setTimeout(() => {

                            partD.classList.add('n_displ'); // Close Stage

                            partE.classList.remove('n_displ'); // Open Next Stage

                            track.classList.replace('step-4', 'step-5'); // Indicate Status

                            formProcessRestore(validator, content); // Restore Button

                            goTop();

                        }, 2000);

                    }

                }

            });

        }

        // Stage 2 ~ Part E

        if (partE) {

            let tag = partE.querySelector('input[name="username"]')

            // Tag Filtration

            tag.addEventListener("input", (event) => {

                var value = event.target.value;
                var invalidCharacter = value.match(/[^a-zA-Z0-9_]/); // Find invalid character

                // If there's an invalid character
                if (invalidCharacter) {

                    // alert('Invalid character: ' + invalidCharacter[0] + '. Only letters, numbers, and underscores are allowed.');

                    toast({

                        text: 'Invalid character: ' + invalidCharacter[0],

                        type: 'warning',

                        duration: 7000

                    });

                    // Remove the invalid character
                    event.target.value = value.replace(invalidCharacter[0], '');
                }

            });

            let validator = partE.querySelector('button[name="r-step-5"]');

            validator.addEventListener("click", async () => {

                let content = validator.innerHTML; // Store Original Text

                if (validator.disabled) return; // Prevent Multiple Clicks

                formProcessZero(validator); // Initial Load

                let fields = partE.querySelectorAll('input');

                let dFields = partE.querySelectorAll('select');

                var invalidCharacters = tag.value.match(/[^a-zA-Z0-9_]/g);  // Match all invalid characters

                let isEmpty = false; // Flag

                fields.forEach((field) => {

                    field.removeAttribute('variant');

                    if (field.value.trim().length === 0 && field.hasAttribute('required')) {

                        isEmpty = true; // Update Flag

                        field.setAttribute('variant', 'error'); // Error Border

                    } else if (field['type="radio"'] && field.hasAttribute('required')) {

                        isEmpty = true; // Update Flag

                        field.setAttribute('variant', 'error'); // Error Border

                    }

                });

                dFields.forEach((dField) => {

                    if (dField.value == 0) {

                        isEmpty = true;

                        // dField.setAttribute('variant', 'error'); // Error Border

                    }

                });

                if (isEmpty) {

                    toast({ // User Feedback

                        text: 'Required field(s) empty',

                        type: 'error',

                        duration: 7000

                    });

                    setTimeout(() => {

                        formProcessRestore(validator, content); // Restore Button

                    }, 1300);

                } else {

                    if (invalidCharacters) {

                        setTimeout(() => {

                            tag.setAttribute('variant', 'error');

                            toast({ // User Feedback

                                text: 'Valid: A-Z, 0-9, underscore(_)',

                                type: 'info',

                                duration: 7000

                            });

                            formProcessRestore(validator, content); // Restore Button

                        }, 2000);

                    } else {

                        try {

                            // Check Tag

                            let checker = await fetch('../controls/logic/tag-checker.php', {

                                method: 'POST',

                                body: new URLSearchParams({

                                    'tag': tag.value.trim()

                                }),

                                headers: {

                                    'Content-Type': 'application/x-www-form-urlencoded'

                                }

                            }); // Checker Credentials

                            let response = await checker.json(); // Parse JSON Response

                            // Handle Response

                            if (response.tagTaken) {

                                tag.setAttribute('variant', 'error'); // Highlight Field

                                toast({ // User Feedback

                                    text: 'Username unavailable!',

                                    type: 'warning',

                                    duration: 7000

                                });

                                setTimeout(() => {

                                    formProcessRestore(validator, content); // Restore Button

                                }, 1300);

                            } else {

                                setTimeout(() => {

                                    partE.classList.add('n_displ'); // Close Stage

                                    partF.classList.remove('n_displ'); // Open Next Stage

                                    track.classList.replace('step-5', 'step-6'); // Indicate Status

                                    formProcessRestore(validator, content); // Restore Button

                                    goTop();

                                }, 2000);

                            }

                        } catch (error) {

                            console.error('Error:', error);

                            toast({ // User Feedback

                                text: 'An error occurred!',

                                type: 'error',

                                duration: 7000

                            });

                            setTimeout(() => {

                                formProcessRestore(validator, content); // Restore Button

                            }, 1300);

                        }    

                    }

                }

            });

        }

        // Stage 3 ~ Part F

        formB.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            if (commandB.disabled) return; // Prevent Multiple Clicks

            let content = commandB.innerHTML; // Store Original Content

            formProcessZero(commandB); // Initaiate Loading

            try {

                // Process Form

                let formData = new FormData(formB); // Collect Form Data

                let processor = await fetch('../controls/logic/registration-processor-b.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.sessionError) {

                    setTimeout(() => {

                        window.location.href = 'login'; // Redirect

                    }, 2000);

                } else {

                    if (response.idError) {

                        toast({ // User Feedback

                            text: 'Please, try again!',

                            type: 'warning',

                            duration: 7000

                        });

                        setTimeout(() => {

                            formProcessRestore(commandB, content); // Restore Button

                        }, 2000);

                    } else {

                        if (response.regAugmented) {

                            const popup = document.querySelector('#iQ_term');

                            const btn = document.querySelector('#continue');

                            setTimeout(() => {

                                formProcessRestore(commandB, content);

                                // Open Popup

                                if (popup && btn) {

                                    popup.parentElement.classList.remove('n_displ');

                                    popup.classList.remove('n_displ');

                                    btn.addEventListener("click", () => {

                                        popup.parentElement.classList.add('n_displ');

                                        popup.classList.add('n_displ');

                                        partF.classList.add('n_displ') // Close Stage

                                        formB.remove(); // Remove Form

                                        partG.classList.remove('n_displ'); // Open Next Stage

                                        track.classList.replace('step-6', 'step-7'); // Indicate Status  

                                    });

                                } else {

                                    partF.classList.add('n_displ') // Close Stage

                                    formB.remove(); // Remove Form

                                    partG.classList.remove('n_displ'); // Open Next Stage

                                    track.classList.replace('step-6', 'step-7'); // Indicate Status  

                                    goTop();

                                }

                            }, 2000);

                        } else {

                            toast({ // User Feedback

                                text: 'Unable to process request!',

                                type: 'warning',

                                duration: 7000

                            });

                            setTimeout(() => {

                                formProcessRestore(commandB, content);

                            }, 1200);

                        }

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 7000

                    });

                    formProcessRestore(commandB, content); // Restore / Stop Animation

                }, 2000);

            }

        });

    }

    // Stage 3

    let formC = document.querySelector('#reg-mfaForm');

    let commandC = document.querySelector('#verifyMfa');

    let subCommand = document.querySelector('#reMfa')

    if (formC && commandC && subCommand) {

        formC.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = commandC.innerHTML; // Store Button Original Content

            formProcessZero(commandC); // Intiate Button Loading Animation

            try {

                // Process Form

                let formData = new FormData(formC); // Collect Form Data

                let uaInfo = parseUA(); // Get User Agent Info

                for (const [key, value] of uaInfo) {

                    formData.append(key, value);

                }

                let processor = await fetch('../controls/logic/registration-processor-c.php', {

                    method: 'POST',

                    body: formData

                }); // Form Processor Credentials 

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.codeValid) {

                    setTimeout(() => {

                        track.classList.replace('step-7', 'step-complete'); // Indicate Status

                        toast({

                            text: 'Welcome aboard!',

                            type: 'success',

                            duration: 7000

                        });

                    }, 2000);

                    if (response.cleared) { // Cleared

                        setTimeout(() => {

                            // Grant Dashboard Access 

                            window.location.href = '../security/';

                        }, 4500);

                    } else {

                        setTimeout(() => {

                            window.location.href = 'login'; // Redirect to Login

                        }, 4500);

                    }

                } else {

                    if (response.invalidUser) {

                        setTimeout(() => {

                            window.location.href = 'login'; // Redirect to Login

                        }, 2000);


                    } else if (response.codeInvalid) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Code invalid!',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(commandC, content); // Restore Button

                            formC.reset(); // Reset Form

                            formC.querySelector('input').focus(); // Focus On First Input

                        }, 2000);


                    } else if (response.codeExpired) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Expired multifactor code',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(commandC, content); // Restore Button

                            formC.reset(); // Reset Form

                            formC.querySelector('input').focus(); // Focus On First Input

                        }, 2000);

                    }

                }


            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(commandC, content); // Restore Button

                }, 2000);

            }

        });

        subCommand.addEventListener("click", async () => {

            let content = subCommand.innerHTML; // Get Button Content

            if (subCommand.disabled) return; // Prevent Multiple Clicks

            processZero(subCommand); // Initiate Load

            formC.reset(); // Reset Form

            formC.querySelector('input').focus(); // Focus On First Input

            try {

                // Handle Request

                let processor = await fetch('../controls/logic/reg-otp-generator.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.emailNull || response.userError) {

                    setTimeout(() => {

                        window.location.href = 'login'; // Redirect To Login

                    }, 2000);

                } else {

                    if (response.codeDelivered) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Multifactor code resent!',

                                type: 'success',

                                duration: 7000

                            });

                            delayedRestore(subCommand, content, 2); // Restore Button

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Please, try again!',

                                type: 'error',

                                duration: 7000

                            });

                            processRestore(subCommand, content); // Restore Button

                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    processRestore(subCommand, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// Local Transfer Form Handler (To Confirm)

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#transferForm');

    if (form) {

        let account = form.querySelector('select[name="source"]');

        let name = form.querySelector('input[name="name"]');

        let rAcc = form.querySelector('input[name="account"]');

        let bank = form.querySelector('input[name="account"]');

        let amount = form.querySelector('input[name="amount"]');

        let desc = form.querySelector('input[name="desc"]');

        let selected = account.options[account.selectedIndex];

        let symbol = selected.getAttribute('data-symbol');

        let currency = selected.getAttribute('data-currency');

        let source = selected.getAttribute('data-acc');

        account.addEventListener("change", () => {

            selected = account.options[account.selectedIndex];

            symbol = selected.getAttribute('data-symbol');

            currency = selected.getAttribute('data-currency');

            source = selected.getAttribute('data-acc');

        });

        let command = form.querySelector('button[type="submit"][name="transfer"]');

        form.addEventListener("submit", (event) => {

            event.preventDefault(); // Prevent Submission

            if (command.disabled) return; // Prevent Multiple Clicks

            let content = command.innerHTML; // Store Original Content

            formProcessZero(command);

            if (account.value == 0) {

                toast({ // User Feedback

                    text: 'Please, specify \'Source Account\'',

                    type: 'error',

                    duration: 5000

                });

                setTimeout(() => {

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            } else if (rAcc.value.length < 8 || rAcc.value.length > 17) {

                account.setAttribute('variant', 'error');

                toast({ // User Feedback

                    text: 'Invalid account number',

                    type: 'error',

                    duration: 5000

                });

                setTimeout(() => {

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            } else {

                if (parseFloat(amount.value) < 0) {

                    toast({ // User Feedback

                        text: 'Invalid amount!',

                        type: 'error',

                        duration: 5000

                    });

                    setTimeout(() => {

                        formProcessRestore(command, content); // Restore Button

                    }, 2000);

                } else {

                    let hold = document.querySelector('#transfHold');

                    let data = `<div class="dataHold">

                        <div>

                            <div class="dH_item">

                                <p>Amount</p>    

                                <p>${symbol}${amount.value} (${currency})</p>

                            </div>

                            <div class="dH_item">

                                <div>Source</div>

                                <p>${source}</p>

                            </div>

                        </div>

                        <div>

                            <div class="dH_item">

                                <p>Bank Name<p>

                                <p>${bank.value}</p>

                            </div>

                            <div class="dH_item">

                                <p>Account Holder</p>

                                <p>${name.value}</p>

                            </div>

                            <div class="dH_item">

                                <div>Account Number</div>

                                <p>${rAcc.value}</p>

                            </div>

                            <div class="dH_item">

                                <div>Descrption</div>

                                <p>${desc.value}</p>

                            </div>

                        </div>

                    </div>`;

                    let popup = document.querySelector('#confirmTransf');


                    setTimeout(() => {

                        popup.classList.remove('n_displ');

                        popup.parentElement.classList.remove('n_displ');

                        document.body.classList.add('deactivate');

                        hold.innerHTML = data.replace(/\\r\\n/g, '');

                        formProcessRestore(command, content); // Restore Button

                    }, 2000);

                }

            }

        });

    }

});

// Local Transfer Confirmation Handler

document.addEventListener("DOMContentLoaded", () => {

    let validator = document.querySelector('#validateTransf');

    let form = document.querySelector('#transferForm');

    if (form && validator) {

        validator.addEventListener("click", async () => {

            let saveBenefi = document.querySelector('#saveBeneficiary');

            let beneficiary = 'no';

            if (saveBenefi && saveBenefi.checked) {

                beneficiary = 'yes';

            }

            let content = validator.innerHTML;

            if (validator.disabled) return;

            formProcessZero(validator);

            // Process Form

            let formData = new FormData(form);

            formData.append('beneficiary', beneficiary);

            try {

                let processor = await fetch('../controls/logic/local-transfer-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.accError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Account not found!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 1200);

                    setTimeout(() => {

                        window.location.reload();

                    }, 2500);

                } else if (response.kycError) {

                    // User Feedback

                    setTimeout(() => {

                        toast({

                            text: 'User is yet to complete KYC!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(validator, content); // Restore Button

                    }, 1200);

                } else if (response.kycPending) {

                    // User Feedback

                    setTimeout(() => {

                        toast({

                            text: 'User\'s KYC is yet to be verified!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(validator, content); // Restore Button

                    }, 1200);

                } else if (response.maxTransc) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Transaction limit reached!',

                            type: 'warning'

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wthLimit || response.maxWth) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wLimit) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 1200);

                } else if (response.noAccess) {

                    setTimeout(() => {

                        let msg = response.currency + " access barred!";

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: msg,

                            type: 'failure'

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.fundError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Insufficient funds!',

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.tPIN) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter transaction PIN!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                        authTransferPIN(); // Ready T-PIN Retrieval

                    }, 2000);

                } else if (response.auth) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter MFA code!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                        authTransfer(); // Ready OTP Retrieval

                    }, 2000);

                } else {

                    if (response.bCode) {

                        setTimeout(() => {

                            window.location.href = 'code';

                            formProcessRestore(validator, content); // Restore / Stop Animation

                        }, 2000);


                    } else {

                        if (response.transfer) {

                            setTimeout(() => {

                                window.location.href = 'transaction-success';

                                formProcessRestore(validator, content); // Restore / Stop Animation

                            }, 2000);


                        } else {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'error',

                                    duration: 7000

                                });

                                formProcessRestore(validator, content); // Restore / Stop Animation

                            }, 2000);

                        }

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 7000

                    });

                    formProcessRestore(validator, content); // Restore / Stop Animation

                }, 2000);

            }

        });

    }

});

// Wire Transfer Form Handler (To Confirm)

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#wireForm');

    if (form) {

        let account = form.querySelector('select[name="source"]');

        let name = form.querySelector('input[name="name"]');

        let rAcc = form.querySelector('input[name="account"]');

        let bank = form.querySelector('input[name="account"]');

        let amount = form.querySelector('input[name="amount"]');

        let desc = form.querySelector('input[name="desc"]');

        let selected = account.options[account.selectedIndex];

        let symbol = selected.getAttribute('data-symbol');

        let currency = selected.getAttribute('data-currency');

        let source = selected.getAttribute('data-acc');

        let codeType = form.querySelector('select[name="codeType"]');

        let code = form.querySelector('input[name="code"]');

        account.addEventListener("change", () => {

            selected = account.options[account.selectedIndex];

            symbol = selected.getAttribute('data-symbol');

            currency = selected.getAttribute('data-currency');

            source = selected.getAttribute('data-acc');

        });

        let command = form.querySelector('button[type="submit"][name="transfer"]');

        form.addEventListener("submit", (event) => {

            event.preventDefault(); // Prevent Submission

            if (command.disabled) return; // Prevent Multiple Clicks

            let content = command.innerHTML; // Store Original Content

            formProcessZero(command);

            if (account.value == 0) {

                toast({ // User Feedback

                    text: 'Please, specify \'Source Account\'',

                    type: 'error',

                    duration: 5000

                });

                setTimeout(() => {

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            } else if (codeType.value == 0) {

                toast({ // User Feedback

                    text: 'Please, specify \'Bank code type\'',

                    type: 'error',

                    duration: 5000

                });

                setTimeout(() => {

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            } else if (rAcc.value.length < 8 || rAcc.value.length > 17 || rAcc.value < 0) {

                account.setAttribute('variant', 'error');

                toast({ // User Feedback

                    text: 'Invalid account number',

                    type: 'error',

                    duration: 5000

                });

                setTimeout(() => {

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            } else {

                if (parseFloat(amount.value) < 0) {

                    toast({ // User Feedback

                        text: 'Invalid amount!',

                        type: 'error',

                        duration: 5000

                    });

                    setTimeout(() => {

                        formProcessRestore(command, content); // Restore Button

                    }, 2000);

                } else {

                    let hold = document.querySelector('#wireHold');

                    let data = `<div class="dataHold">

                        <div>

                            <div class="dH_item">

                                <p>Amount</p>    

                                <p>${symbol}${amount.value} (${currency})</p>

                            </div>

                            <div class="dH_item">

                                <div>Source</div>

                                <p>${source}</p>

                            </div>

                        </div>

                        <div>

                            <div class="dH_item">

                                <p>Bank Name<p>

                                <p>${bank.value}</p>

                            </div>

                            <div class="dH_item">

                                <p>${codeType.value}</p>

                                <p>${code.value}</p>

                            </div>

                            <div class="dH_item">

                                <p>Account Holder</p>

                                <p>${name.value}</p>

                            </div>

                            <div class="dH_item">

                                <div>Account Number</div>

                                <p>${rAcc.value}</p>

                            </div>

                            <div class="dH_item">

                                <div>Descrption</div>

                                <p>${desc.value}</p>

                            </div>

                        </div>

                    </div>`;

                    let popup = document.querySelector('#confirmWire');


                    setTimeout(() => {

                        popup.classList.remove('n_displ');

                        popup.parentElement.classList.remove('n_displ');

                        document.body.classList.add('deactivate');

                        hold.innerHTML = data.replace(/\\r\\n/g, '');

                        formProcessRestore(command, content); // Restore Button

                    }, 2000);

                }

            }

        });

    }

});

// Wire Transfer Confirmation Handler

document.addEventListener("DOMContentLoaded", () => {

    let validator = document.querySelector('#validateWire');

    let form = document.querySelector('#wireForm');

    if (form && validator) {

        validator.addEventListener("click", async () => {

            let saveBenefi = document.querySelector('#saveBeneficiary');

            let beneficiary = 'no';

            if (saveBenefi && saveBenefi.checked) {

                beneficiary = 'yes';

            }

            let content = validator.innerHTML;

            if (validator.disabled) return;

            formProcessZero(validator);

            // Process Form

            let formData = new FormData(form);

            formData.append('beneficiary', beneficiary);

            try {

                let processor = await fetch('../controls/logic/wire-transfer-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.accError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Account not found!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 1200);

                    setTimeout(() => {

                        window.location.reload();

                    }, 2500);

                } else if (response.kycError) {

                    // User Feedback

                    setTimeout(() => {

                        toast({

                            text: 'User is yet to complete KYC!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(validator, content); // Restore Button

                    }, 1200);

                } else if (response.kycPending) {

                    // User Feedback

                    setTimeout(() => {

                        toast({

                            text: 'User\'s KYC is yet to be verified!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(validator, content); // Restore Button

                    }, 1200);

                } else if (response.maxTransc) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Transaction limit reached!',

                            type: 'warning'

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wthLimit || response.maxWth) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wLimit) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 1200);

                } else if (response.noAccess) {

                    setTimeout(() => {

                        let msg = response.currency + " access barred!";

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: msg,

                            type: 'failure'

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.fundError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Insufficient funds!',

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.tPIN) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter transaction PIN!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                        authTransferPIN(); // Ready T-PIN Retrieval

                    }, 2000);

                } else if (response.auth) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter MFA code!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(validator, content); // Restore / Stop Animation

                        authTransfer(); // Ready OTP Retrieval

                    }, 2000);

                } else {

                    if (response.bCode) {

                        setTimeout(() => {

                            window.location.href = 'code';

                            formProcessRestore(validator, content); // Restore / Stop Animation

                        }, 2000);


                    } else {

                        if (response.transfer) {

                            setTimeout(() => {

                                window.location.href = 'transaction-success';

                                formProcessRestore(validator, content); // Restore / Stop Animation

                            }, 2000);


                        } else {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'error',

                                    duration: 7000

                                });

                                formProcessRestore(validator, content); // Restore / Stop Animation

                            }, 2000);

                        }

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 7000

                    });

                    formProcessRestore(validator, content); // Restore / Stop Animation

                }, 2000);

            }

        });

    }

});

// Tag Transfer Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#tagForm');

    let button = document.querySelector('#tagBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML;

            formProcessZero(button); // Intiate Loading

            let fiat = form.querySelector('input[name="account"]:checked');

            if (!fiat) {

                setTimeout(() => {

                    toast({

                        text: 'Select currency!',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                }, 1200);

                return; // End Run

            }

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('../controls/logic/tag-transfer-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.invalidAmt) {

                    toast({ // User Feedback

                        text: 'Invalid amount!',

                        type: 'error',

                        duration: 5000

                    });

                    setTimeout(() => {

                        formProcessRestore(button, content); // Restore Button

                    }, 2000);

                } else if (response.maxTransc) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Transaction limit reached!',

                            type: 'warning'

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wthLimit || response.maxWth) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.wLimit) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Withdrawal limit reached! Would you like to contact support?',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then((confirmed) => {

                            if (confirmed) {

                                window.location.href = 'support-tickets';

                            } else {

                                return;

                            }

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 1200);

                } else if (response.noAccess) {

                    setTimeout(() => {

                        let msg = response.currency + " access barred!";

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: msg,

                            type: 'failure'

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.recipientError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Recipient not found!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 2000);

                    setTimeout(() => {

                        window.location.reload();

                        return;

                    }, 4500)

                } else if (response.sourceError) {

                    setTimeout(() => {

                        let msg = `You don't have a ${response.currency} account!`

                        toast({ // User Feedback

                            text: msg,

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(button, content);

                    }, 2000);

                } else {

                    if (response.fundError) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Insufficient funds!',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore / Stop Animation

                        }, 2000);

                    } else {

                        if (response.transfer) {

                            setTimeout(() => {

                                window.location.href = 'transaction-success';

                                formProcessRestore(button, content); // Restore / Stop Animation

                            }, 2000);


                        } else {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'error',

                                    duration: 7000

                                });

                                formProcessRestore(button, content); // Restore / Stop Animation

                            }, 2000);

                        }

                    }

                }

            } catch (error) {

                console.log('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                }, 2000);

            }

        });

    }

});

// Billing Code Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#codeForm');

    let button = document.querySelector('#codeValidate');

    let msgHold = document.querySelector('#msg');

    function validator(type = 'success') {

        let validator;

        if (type == 'success') {

            let msg = ['Validating', 'Processing', 'Authenticating'];

            validator = `<div class="validator">

                <p>${msg[Math.floor(Math.random() * msg.length)]}...</p>

                <div class="validator-progress">

                    <div class="track"></div>

                </div>

            </div>`;

        } else {

            let msg = ['Error!', 'Encoutered a problem!', 'Error detected!'];

            validator = `<div class="validator" variant="error">

                <p>${msg[Math.floor(Math.random() * msg.length)]}</p>

            </div>`;

        }

        return validator;

    }

    if (form && button && msgHold) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // End Submission

            let content = button.innerHTML;

            if (button.disabled) return;

            msgHold.classList.remove('n_displ');

            msgHold.innerHTML = validator();

            formProcessZero(button);

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('../controls/logic/bcode-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON

                if (response.refresh) {

                    window.location.reload();

                } else if (response.codeError) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Invalid PIN.',

                            type: 'error',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                        msgHold.innerHTML = validator('error');

                    }, 2000);

                } else if (response.codeNext) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'PIN valid.',

                            type: 'success',

                            duration: 5000

                        });

                        msgHold.classList.add('n_displ');

                    }, 2000);

                    setTimeout(() => {

                        location.reload();

                        return;

                    }, 4500);

                } else if (response.tPIN) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter transaction PIN!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                        authTransferPIN(); // Ready T-PIN Retrieval

                    }, 2000);

                } else if (response.auth) {

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Enter MFA code!',

                            type: 'info',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                        authTransfer(); // Ready OTP Retrieval

                    }, 2000);

                } else {

                    if (response.transfer) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'PIN valid.',

                                type: 'success',

                                duration: 5000

                            });

                            msgHold.classList.add('n_displ');

                        }, 2000);

                        setTimeout(() => {

                            window.location.href = 'transaction-success';

                            formProcessRestore(button, content); // Restore / Stop Animation

                        }, 4500);


                    } else {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Please, try again!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore / Stop Animation

                            msgHold.innerHTML = validator('error');

                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'An error occurred.',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                    msgHold.innerHTML = validator('error');

                }, 2000);


            }

        });

    }

});

// Billing Code Payment Handler

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#btnAutoPay');

    if (command) {

        command.addEventListener("click", async () => {

            let content = command.innerHTML; // Get Button Content

            if (command.disabled) return; // Prevent Multiple Clicks

            formProcessZero(command); // Initiate Load

            try {

                // Handle Request

                let processor = await fetch('../controls/logic/bcode-payment-processor.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.bcodePay) {

                    setTimeout(() => {

                        window.location.href = 'pay';

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 2000);

            }

        });

    }

});

// Deposit Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#depositForm');

    let button = document.querySelector('#depositBtn');

    if (form && button) {

        let account = form.querySelector('select[name="account"]');

        let amount = form.querySelector('input[name="amount"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Save Original Content

            formProcessZero(button); // Initiate Loading Animation

            if (account.value == 0) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Select currency / account!',

                        type: 'error',

                        duration: 3000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);

            } else if (amount.value.length < 0) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Invalid amount!',

                        type: 'error',

                        duration: 3000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('../controls/logic/deposit-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            location.reload();

                            return;

                        }, 1200);

                    } else if (response.amtError) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Invalid amount!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 2000);

                    } else if (response.accError) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Account not found!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 2000);

                    } else {

                        if (response.deposit) {

                            setTimeout(() => {

                                window.location.href = 'pay';

                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore Button

                    }, 2000);


                }

            }

        });

    }

});

// Card Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#viaCard');

    if (form) {

        form.addEventListener("submit", (event) => {

            event.preventDefault();

            let cardNum = document.querySelector('#cardNum');

            let cardCode = document.querySelector('#cardCode');

            let expiry = document.querySelector('#cardExpires');

            // Check Fields

            if (cardNum.value.length == 0 || cardCode.value.length == 0 || expiry.value.length == 0) {

                toast({
                    text: "Card details are needed!",
                    type: "warning",
                    duration: 7000
                });

            } else if (cardNum.value.length < 13 || isNaN(cardNum.value) || cardNum.value.length > 19) {

                toast({
                    text: "Invalid card number!",
                    type: "warning",
                    duration: 7000
                });

                cardNum.focus();

            } else if (isNaN(cardCode.value) || cardCode.value.length < 3 || cardCode.value.length > 4) {

                toast({
                    text: "Invalid CVC / CVV",
                    type: "warning",
                    duration: 7000
                });

                cardCode.focus();

            } else if (expiry.value.length < 4) {

                toast({
                    text: "Invalid date passed!",
                    type: "warning",
                    duration: 7000
                });

                expiry.focus();

            } else {

                function validateExpiry(expiry) {
                    let month, year;

                    // Handle both MM/YY and MMYY formats
                    if (expiry.includes('/')) {
                        [month, year] = expiry.split('/');
                    } else if (expiry.length === 4) {
                        month = expiry.slice(0, 2);
                        year = expiry.slice(2, 4);
                    } else {
                        return false; // Invalid format
                    }

                    // Ensure month is between 01 and 12
                    if (parseInt(month) < 1 || parseInt(month) > 12) {
                        return false; // Invalid month
                    }

                    // Add 2000 to two-digit year
                    year = '20' + year;

                    const currentDate = new Date();
                    const expiryDate = new Date(year, month - 1);

                    if (expiryDate > currentDate) {
                        return true; // Expiry date is valid
                    }
                    return false; // Expiry date is invalid or expired
                }

                if (validateExpiry(expiry.value)) {

                    toast({
                        text: "Processing...",
                        type: "info",
                        duration: 2500
                    });

                    function processAction(element, content, identifier, restore) {

                        element.innerHTML = content;

                        element.classList.add(identifier);

                        element.parseFloat

                        setTimeout(() => {

                            element.innerHTML = restore;

                            element.classList.remove(identifier);

                            // Process Form

                            // let msgs = ['Provider unavailable!', 'Service unavailable!', 'Try another payment method!', 'Not available!'];

                            let message = 'Unable to process card! Try another payment method!';

                            toast({
                                text: message,
                                type: "error",
                                duration: 7000
                            });

                        }, 3500);

                    }

                    let button = document.querySelector('#useCard');

                    let originalContent = button.innerHTML;

                    let newContent = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>`;

                    processAction(button, newContent, 'inaccessible', originalContent);

                    button.setAttribute

                } else {

                    toast({
                        text: "Invalid date passed!",
                        type: "warning",
                        duration: 7000
                    });

                    expiry.focus();

                }

            }

        })

    }

});

// Crypto Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#viaCrypto');

    let payMethod = 'CRYPTO';

    let button = document.querySelector('#payCrypto');

    if (form) {

        let options = form.querySelectorAll('input[type="radio"][name="channel"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML;

            formProcessZero(button); // Disable User Interaction

            isBlank = true;

            options.forEach((option) => {

                if (option.checked) {

                    isBlank = false;

                }

            });

            if (isBlank) {

                toast({

                    text: "Select asset!",

                    type: "warning",

                    duration: 7000,

                });

                setTimeout(() => {

                    formProcessRestore(button, content);

                }, 500)

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('payMethod', payMethod);

                    let processor = await fetch('../controls/logic/payment-processor.php', {

                        method: 'POST',

                        body: formData

                    });

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.getProof) {

                        let panels = document.querySelectorAll(".iQ_panel");
                        let preProcessor = document.querySelector("#payProcessor");
                        let proofCollector = document.querySelector("#payProof");

                        setTimeout(() => {

                            // Hide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {

                                let formBox = panel.querySelector("*");
                                if (formBox) { // Check if .payBox_con exists in the panel
                                    formBox.classList.add("n_displ");
                                }
                            });

                            // Show preProcessor panel
                            preProcessor.classList.remove("n_displ");

                        }, 1500);

                        // After 12 seconds, restore the original state
                        setTimeout(() => {

                            // Unhide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {
                                let formBox = panel.querySelector("*");
                                if (formBox) {
                                    formBox.classList.remove("n_displ");
                                }
                            });

                            // Hide the preProcessor and show the proofCollector
                            preProcessor.classList.add("n_displ");
                            proofCollector.classList.replace("n_displ", "fade_in");

                            // Animate the #iQ_proof element inside proofCollector
                            let proofElement = proofCollector.querySelector("#iQ_proof");
                            if (proofElement) { // Check if #iQ_proof exists
                                proofElement.classList.replace("n_displ", "float_up");
                            }

                            formProcessRestore(button, content); // Enable User Interaction

                        }, 30000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                    }, 1200);

                }

            }

        });

    }

});

// Other Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#viaMisc');

    let payMethod = 'OTHERS';

    let button = document.querySelector('#payMisc');

    if (form) {

        let options = form.querySelectorAll('input[type="radio"][name="method"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Store Button Original Content

            formProcessZero(button); // Disable User Interaction

            isBlank = true;

            options.forEach((option) => {

                if (option.checked) {

                    isBlank = false;

                }

            });

            if (isBlank) {

                toast({

                    text: "Select payment method!",

                    type: "warning",

                    duration: 7000,

                });

                setTimeout(() => {

                    formProcessRestore(button, content);

                }, 500)

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('payMethod', payMethod);

                    let processor = await fetch('../controls/logic/payment-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.getProof) {

                        let panels = document.querySelectorAll(".iQ_panel");
                        let preProcessor = document.querySelector("#payProcessor");
                        let proofCollector = document.querySelector("#payProof");

                        setTimeout(() => {

                            // Hide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {

                                let formBox = panel.querySelector("*");
                                if (formBox) { // Check if .payBox_con exists in the panel
                                    formBox.classList.add("n_displ");
                                }
                            });

                            // Show preProcessor panel
                            preProcessor.classList.remove("n_displ");

                        }, 3000);

                        // After 12 seconds, restore the original state
                        setTimeout(() => {

                            // Unhide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {
                                let formBox = panel.querySelector("*");
                                if (formBox) {
                                    formBox.classList.remove("n_displ");
                                }
                            });

                            // Hide the preProcessor and show the proofCollector
                            preProcessor.classList.add("n_displ");
                            proofCollector.classList.replace("n_displ", "fade_in");

                            // Animate the #iQ_proof element inside proofCollector
                            let proofElement = proofCollector.querySelector("#iQ_proof");
                            if (proofElement) { // Check if #iQ_proof exists
                                proofElement.classList.replace("n_displ", "float_up");
                            }

                            formProcessRestore(button, content); // Restore User Interaction

                        }, 30000);

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                        formProcessRestore(button, content); // Enable User Interaction

                    }, 1300);

                }

            }

        });

    }

});

// Bank Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#viaBank');

    let button = document.querySelector('#payBank');

    let payMethod = 'BANK TRANSFER';

    if (form) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Store Button Content

            formProcessZero(button); // Disable User Interaction

            try {

                // Process Form

                let formData = new FormData(form);

                formData.append('payMethod', payMethod);

                let processor = await fetch('../controls/logic/payment-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.getProof) {

                    formProcess(button, 3000);

                    let panels = document.querySelectorAll(".iQ_panel");
                    let preProcessor = document.querySelector("#payProcessor");
                    let proofCollector = document.querySelector("#payProof");

                    setTimeout(() => {

                        // Hide all .payBox_con elements inside each panel
                        panels.forEach((panel) => {

                            let formBox = panel.querySelector("*");
                            if (formBox) { // Check if .payBox_con exists in the panel
                                formBox.classList.add("n_displ");
                            }
                        });

                        // Show preProcessor panel
                        preProcessor.classList.remove("n_displ");

                    }, 1500);

                    // After 12 seconds, restore the original state
                    setTimeout(() => {

                        // Unhide all .payBox_con elements inside each panel
                        panels.forEach((panel) => {
                            let formBox = panel.querySelector("*");
                            if (formBox) {
                                formBox.classList.remove("n_displ");
                            }
                        });

                        // Hide the preProcessor and show the proofCollector
                        preProcessor.classList.add("n_displ");
                        proofCollector.classList.replace("n_displ", "fade_in");

                        // Animate the #iQ_proof element inside proofCollector
                        let proofElement = proofCollector.querySelector("#iQ_proof");
                        if (proofElement) { // Check if #iQ_proof exists
                            proofElement.classList.replace("n_displ", "float_up");
                        }

                    }, 30000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'An error occurred',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content); // Enable User Interaction

                }, 1300);

            }

        });

    }

});

// Payment Proof Upload Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#formPayProof');

    let button = document.querySelector('#uploadProof');

    if (form && button) {

        form.addEventListener("submit", (event) => {

            event.preventDefault();

            let content = button.innerHTML;

            let field = document.querySelector('#proof-file');

            if (field.files.length === 0) {

                toast({

                    text: "Please upload proof!",

                    type: "warning",

                    duration: 7000,

                });

                field.focus();


            } else {

                // Process Form

                formProcessZero(button); // Button Feedback

                let formData = new FormData(form);

                formData.append('proof', field);

                fetch('../controls/logic/pay-proof-processor.php', {

                    method: 'POST',

                    body: formData

                })
                    .then(response => response.json())
                    .then(data => {

                        if (data.refresh) {

                            window.location.reload();

                        } else if (data.extensionError) {

                            toast({

                                text: "Unsupported File Format!",

                                type: "warning",

                                duration: 7000,

                            });

                            formProcessRestore(button, content); // Restore Button

                        } else {

                            if (data.uploadError) {

                                toast({

                                    text: "Error, try again!",

                                    type: "warning",

                                    duration: 7000,

                                });

                                formProcessRestore(button, content); // Restore Button

                            } else {

                                if (data.insertProof) {

                                    toast({

                                        text: "Payment made!",

                                        type: "success",

                                        duration: 7000,

                                    });

                                    const identifier = data.id;

                                    // formProcessRestore(button, 'Proceed'); // Restore Button

                                    // formProcess(button, 3000);

                                    if (identifier != null) {

                                        setTimeout(() => {

                                            window.location.href = 'transaction-success';

                                        }, 3000);

                                    } else {

                                        setTimeout(() => {

                                            window.location.href = "feedback";

                                        }, 3000);

                                    }

                                } else {

                                    formProcessRestore(button, content); // Restore Button

                                    toast({

                                        text: "Error, try again!",

                                        type: "error",

                                        duration: 7000,

                                    });

                                }

                            }

                        }

                    })
                    .catch(error => {

                        formProcessRestore(button, content);

                        console.error('Error:', error);

                    });

            }

        });

    }

});

// Tag Checker Handler

document.addEventListener("DOMContentLoaded", () => {

    let tag = document.querySelector('#tag');

    let displ = document.querySelector('#tagResult');

    let button = document.querySelector('#tagBtn');

    if (tag && displ && button) {

        button.disabled = true;

        tag.addEventListener("input", async () => {

            const content = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="spin_icon" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>`;

            displ.innerHTML = '<div>' + content + '</div>';

            if (tag.value.trim().length < 1) {

                displ.innerHTML = '';

                button.disabled = true;

            } else {

                // Search For User

                try {

                    let checker = await fetch('../controls/logic/tag-locator.php', {

                        method: 'POST',

                        body: new URLSearchParams({

                            'tag': tag.value.trim()

                        }),

                        headers: {

                            'Content-Type': 'application/x-www-form-urlencoded'

                        }

                    }); // Processor Credentials

                    let response = await checker.json(); // Parse JSON Response

                    // Handle Response

                    if (response.located) {

                        setTimeout(() => {

                            button.disabled = false;

                            displ.innerHTML = response.results.replace(/\\r\\n/g, ''); // Remove extra characters

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            displ.innerHTML = '<small style="color: var(--pg-error)">User doesn\'t exist!</small>';

                        }, 2000);

                    }

                } catch (error) {

                    console.log('Error:', error); // Log Error to Console

                }

            }

        });

    }

});

// KYC Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#kycForm');

    let button = document.querySelector('#sendKyc');

    // let popup = document.querySelector('');

    if (form && button/* && popup*/) {

        let country = form.querySelector('select[name="issuing_country"]')

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Save Original Content

            formProcessZero(button); // Initiate Loading Animation

            if (country.value == 0) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Specify issuing country!',

                        type: 'error',

                        duration: 3000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 2000);


            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('../controls/logic/kyc-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            location.reload();

                            return;

                        }, 1200);

                    } else if (response.proofError) {

                        setTimeout(() => {

                            const error = response.error;

                            let msg = 'Upload error. ' + error;

                            msg = 'FRONT: ' + msg;

                            toast({ // User Feedback

                                text: msg,

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 2000);

                    } else if (response.backError) {

                        setTimeout(() => {

                            const error = response.error;

                            let msg = 'Upload error.';

                            msg = 'BACK: ' + msg;

                            toast({ // User Feedback

                                text: msg,

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 2000);

                    } else {

                        if (response.completed) {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'KYC completed',

                                    type: 'success',

                                    duration: 7000

                                });

                            }, 2000);

                            // Open Popup

                            setTimeout(() => {

                                window.location.href = 'home';

                                formProcessRestore(button, content); // Restore Button

                            }, 4500);

                        } else {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'warning',

                                    duration: 7000

                                });

                                formProcessRestore(button, content); // Restore Button

                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({ // User Feedback

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 7000

                        });

                        formProcessRestore(button, content); // Restore Button

                    }, 2000);


                }

            }

            // setTimeout(() => {

            //     popup.classList.remove('n_displ');

            //     popup.parentElement.classList.remove('n_displ');

            //     formProcessRestore(button, content); // Restore Button

            // }, 2000);

        });

    }

});

// Loan Form Handler (To Check Eligibility)

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#loanForm');

    let command = document.querySelector('#findLoan');

    let hold = document.querySelector('#loanHold');

    let popup = document.querySelector('#iQ_loanApply');

    if (form && command && popup && hold) {

        let term = form.querySelector('select[name="loan-term"]');

        let freq = form.querySelector('select[name="loan-freq"]');

        let currency = form.querySelector('select[name="loan-curr"]');

        let type = form.querySelector('select[name="loan-purpose"]');

        let job = form.querySelector('select[name="user-job"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = command.innerHTML; // Store Original Content

            formProcessZero(command); // Initiate Loading Function

            // Check Fields

            if (term.value == 0) {

                setTimeout(() => {

                    // User Feedback

                    toast({

                        text: 'Specify loan term.',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 1200);

            } else if (freq.value == 0) {

                setTimeout(() => {

                    // User Feedback

                    toast({

                        text: 'Specify payment frequency.',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 1200);

            } else if (currency.value == 0) {

                setTimeout(() => {

                    // User Feedback

                    toast({

                        text: 'Select currency',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 1200);

            } else if (type.value == 0) {

                setTimeout(() => {

                    // User Feedback

                    toast({

                        text: 'Specify, loan purpose',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 1200);

            } else if (job.value == 0) {

                setTimeout(() => {

                    // User Feedback

                    toast({

                        text: 'Specify income source',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(command, content); // Restore Button

                }, 1200);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form);

                    let processor = await fetch('../controls/logic/loan-eligibility-check.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 2000);

                    } else if (response.kycError) {

                        // User Feedback

                        setTimeout(() => {

                            toast({

                                text: 'User is yet to complete KYC!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(command, content); // Restore Button

                        }, 1200);

                    } else if (response.kycPending) {

                        // User Feedback

                        setTimeout(() => {

                            toast({

                                text: 'User\'s KYC is yet to be verified!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(command, content); // Restore Button

                        }, 1200);

                    } else {

                        if (response.eligiblity) {

                            let data = response.html.replace(/\\r\\n/g, '');

                            setTimeout(() => {

                                hold.innerHTML = data.replace(/\\r\\n/g, '');

                                popup.classList.remove('n_displ');

                                popup.parentElement.classList.remove('n_displ');

                                document.body.classList.add('deactivate');

                                formProcessRestore(command, content); // Restore Button

                            }, 2000);

                        }

                    }
                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    // User Feedback

                    setTimeout(() => {

                        // User Feedback

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(command, content); // Restore Button

                    }, 1200);
                }

            }

        });

    }

});

// Loan Request Handler

document.addEventListener('DOMContentLoaded', () => {
    // Set up the MutationObserver to listen for changes in the DOM
    const observer = new MutationObserver((mutationsList, observer) => {
        const validator = document.querySelector('#getLoan');

        if (validator) {
            // Once the #getLoan button is found, add the event listener
            validator.addEventListener('click', async () => {
                let rate = document.querySelector('#loan-rate');
                let amount = document.querySelector('#loan-amount');
                let content = validator.innerHTML;

                formProcessZero(validator);

                if (amount.value < 1) {
                    setTimeout(() => {
                        toast({
                            text: 'Specify loan amount!',
                            type: 'warning',
                            duration: 5000
                        });
                        formProcessRestore(validator, content); // Restore Button
                    }, 1200);
                } else {
                    try {
                        let formData = new FormData(document.querySelector('#loanForm')); // Collect Form Data
                        formData.append('rate', rate.value);
                        formData.append('loan', amount.value);

                        let processor = await fetch('../controls/logic/loan-request-processor.php', {
                            method: 'POST',
                            body: formData
                        });

                        let response = await processor.json();

                        if (response.refresh) {
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        } else {
                            if (response.request) {
                                setTimeout(() => {
                                    toast({
                                        text: 'Loan requested!',
                                        type: 'success',
                                        duration: 5000
                                    });
                                    setTimeout(() => {
                                        window.location.href = 'home';
                                    }, 4500);
                                }, 1200);
                            } else if (response.granted) {
                                setTimeout(() => {
                                    toast({
                                        text: 'Loan granted!',
                                        type: 'success',
                                        duration: 5000
                                    });
                                    setTimeout(() => {
                                        window.location.href = 'loans';
                                    }, 4500);
                                }, 1200);
                            } else {
                                setTimeout(() => {
                                    toast({
                                        text: 'Error, try again!',
                                        type: 'warning',
                                        duration: 5000
                                    });
                                    formProcessRestore(validator, content); // Restore Button
                                }, 1200);
                            }
                        }
                    } catch (error) {
                        console.error('Error:', error);
                        setTimeout(() => {
                            toast({
                                text: 'Unable to process request!',
                                type: 'warning',
                                duration: 5000
                            });
                            formProcessRestore(validator, content); // Restore Button
                        }, 1200);
                    }
                }
            });

            // Once the button is found and the event listener is attached, stop observing
            observer.disconnect();
        }
    });

    // Observe the document body for added nodes (including #getLoan)
    observer.observe(document.body, { childList: true, subtree: true });
});

// Virtual Card Request Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#cardForm');

    let button = document.querySelector('#getCard');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Form Submission

            let content = button.innerHTML;

            formProcessZero(button);

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('../controls/logic/virtual-card-request-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    setTimeout(() => {

                        window.location.reload();

                        return;

                    }, 1200);

                } else if (response.cardExists) {

                    const msg = `${response.card} Virtual card exists!`;

                    setTimeout(() => {

                        toast({

                            text: msg,

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(button, content);

                    }, 2000);

                } else if (response.kycError) {

                    // User Feedback

                    setTimeout(() => {

                        toast({

                            text: 'User is yet to complete KYC!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(button, content); // Restore Button

                    }, 1200);

                } else if (response.convError) {

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(button, content);

                    }, 2000);

                } else if (response.fundError) {

                    setTimeout(() => {

                        toast({

                            text: 'Insufficient funds!',

                            type: 'warning',

                            duration: 7000

                        });

                        formProcessRestore(button, content);

                    }, 200);

                } else {

                    if (response.pay) {

                        setTimeout(() => {

                            window.location.href = 'pay';

                        }, 2000);

                    } else if (response.cardCreated) {

                        setTimeout(() => {

                            toast({

                                text: 'Card created!',

                                type: 'success',

                                duration: 7000

                            });

                        }, 2000);

                        setTimeout(() => {

                            window.location.href = 'cards';

                        }, 4500);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Error, try again!',

                                type: 'error',

                                duration: 7000

                            });

                        }, 2000);

                    }

                }

            } catch (error) {

                console.log('Error:', error); // Log Error to Cpnsole

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                    formProcessRestore(button, content);

                }, 2000);

            }

        });

    }

});

// Virtual Card Data Transfer (For Funding)

document.addEventListener("DOMContentLoaded", () => {

    let instigators = document.querySelectorAll('button[iQ-target="#iQ_vFund"]');

    let receiver = document.querySelector('#fundMeans');

    if (instigators && receiver) {

        instigators.forEach(instigator => {

            instigator.addEventListener("click", () => {

                let type = instigator.getAttribute('data-fund');

                let card = instigator.getAttribute('data-id');

                let details = instigator.getAttribute('data-info');

                // Determine Data (Buttons)  Based On Type

                let buttons = `<div class="form_item db">

                    <div class="form_item formBtn_con">

                        <button name="transaction" value="DEPOSIT" class="form_btn" type="submit">Fund from Account</button>

                    </div>
                    
                    <div class="form_item formBtn_con">

                        <button name="pay" value="PAY" class="form_btn" type="submit">More Funding Options</button>

                    </div>

                </div>`;

                if (type == 'PAY') {

                    buttons = `<div class="form_item db">
                    
                        <div class="form_item formBtn_con">

                            <button name="pay" value="PAY" class="form_btn" type="submit">Proceed</button>

                        </div>

                    </div>`;

                } else if (type == 'BALANCE') {

                    buttons = `<div class="form_item db">

                        <div class="form_item formBtn_con">

                            <button name="transaction" value="DEPOSIT" class="form_btn" type="submit">Proceed</button>

                        </div>

                    </div>`;

                }

                // Receivers

                let detailsHold = document.querySelector('#card-details');

                let idHold = document.querySelector('#card-id');

                // Initiate Transfer

                receiver.innerHTML = buttons;

                detailsHold.value = details;

                idHold.value = card;


            });

        });

    }

});

// Virtual Card Funding Handler

document.addEventListener("DOMContentLoaded", () => {


    let form = document.querySelector('#vFundForm');

    if (form) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let button = event.submitter; // Get Button

            if (button) {

                let content = button.innerHTML;

                let buttons = form.querySelectorAll('button[type="submit"]');

                buttons.forEach(btn => {

                    if (btn != button) {

                        btn.classList.add('inaccessible');

                        btn.disabled = true;

                    }

                });

                formProcessZero(button);

                let method = button.value;

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('via', method);

                    let processor = await fetch('../controls/logic/card-funding-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 1200);

                    } else if (response.invalidAmt) {

                        setTimeout(() => {

                            toast({

                                text: 'Invalid amount!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    } else if (response.cardError) {

                        setTimeout(() => {

                            toast({

                                text: 'Card not found!',

                                type: 'warning',

                                duration: 5000

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 3500);

                    } else if (response.balError) {

                        setTimeout(() => {

                            toast({

                                text: 'Insufficient funds!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    } else {

                        if (response.cardFunded) {

                            setTimeout(() => {

                                toast({

                                    text: 'Card funded!',

                                    type: 'success',

                                    duration: 7000

                                });

                            }, 1200);

                            setTimeout(() => {

                                window.location.reload();

                            }, 4000);

                        } else {

                            if (response.pay) {

                                setTimeout(() => {

                                    window.location.href = 'pay';

                                }, 2000);

                            } else {

                                setTimeout(() => {

                                    formProcessRestore(button, content);

                                    toast({

                                        text: 'Please, try again!',

                                        type: 'warning',

                                        duration: 7000

                                    });

                                }, 2000);

                            }

                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                    }, 1300);

                } finally {

                    buttons.forEach(btn => {

                        if (btn != button) {

                            btn.classList.remove('inaccessible');

                            btn.disabled = false;

                        }

                    });

                }

            }

        });

    }

});

// Add New Account Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#accForm');

    let button = document.querySelector('#addAcct');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            let content = button.innerHTML;

            let accountType = form.querySelector('select[name="acc-type"]');

            let currency = form.querySelector('input[name="currency"]:checked');

            formProcessZero(button);

            if (accountType.value == 0) {

                formProcessRestore(button, content);

                toast({

                    text: 'Specify account type!',

                    type: 'warning',

                    duration: 7000

                });

            } else if (!currency) {

                formProcessRestore(button, content);

                toast({

                    text: 'Select currency!',

                    type: 'warning',

                    duration: 7000

                });

            } else {

                try {

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('../controls/logic/add-account-processor.php', {

                        method: 'POST',

                        body: formData

                    });

                    let response = await processor.json(); // Parse JSON Rwesponse

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 1200);

                    } else if (response.kycError) {

                        // User Feedback

                        setTimeout(() => {

                            toast({

                                text: 'User is yet to complete KYC!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 1200);

                    } else if (response.kycPending) {

                        // User Feedback

                        setTimeout(() => {

                            toast({

                                text: 'User\'s KYC is yet to be verified!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 1200);

                    } else {

                        if (response.created) {

                            if (response.request) {

                                setTimeout(() => {

                                    toast({

                                        text: 'Request submitted!',

                                        type: 'success',

                                        duration: 7000

                                    });

                                    setTimeout(() => {

                                        window.location.reload();

                                        return;

                                    }, 4000);

                                }, 2000);

                            } else {

                                setTimeout(() => {

                                    toast({

                                        text: 'Account created!',

                                        type: 'success',

                                        duration: 7000

                                    });

                                }, 2000);

                                setTimeout(() => {

                                    window.location.reload();

                                    return;

                                }, 4000);

                            }

                        } else {

                            setTimeout(() => {

                                toast({

                                    text: 'Please, try again!',

                                    type: 'warning',

                                    duration: 5000

                                });

                                formProcessRestore(button, content);

                            }, 1200);


                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            }

        });

    }

});

// Fund Swap Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#convForm');

    let button = document.querySelector('#swapFunds');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            let content = button.innerHTML;

            formProcessZero(button);

            // Process Forrm

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('../controls/logic/fund-conversion-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    setTimeout(() => {

                        window.location.reload();

                    }, 1200);

                } else if (response.invalidCurr) {

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Please specify currency!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1200);

                } else if (response.currError) {

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Can\'t swap same currency!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1200);

                } else if (response.amtError) {

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Invalid amount!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1200);

                } else if (response.fundError) {

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Insufficient funds!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1200);

                } else if (response.convError) {

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Unavailable at the moment!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1200);

                } else {

                    if (response.swapped) {

                        setTimeout(() => {

                            toast({

                                text: 'Swap sucessful!',

                                type: 'success',

                                duration: 7000

                            });

                        }, 2000);

                        setTimeout(() => {

                            window.location.href = 'transactions';

                        }, 4500);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Error! Please try again!',

                                type: 'error',

                                duration: 5000

                            });

                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    formProcessRestore(button, content);

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 5000

                    });

                }, 1200);

            }

        });

    }

});


// Bank Statement Request Handler

document.addEventListener('DOMContentLoaded', () => {

    let form = document.querySelector('#stmtForm');

    let button = document.querySelector('#getStmt');

    if (form && button) {

        form.addEventListener("submit", async (event) => { // Handle Submission

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Button's Original Content

            formProcessZero(button); // Enable Loading Sequence

            // Form Elements

            let currency = form.querySelector('select[name="account"]');

            let format = form.querySelector('input[name="format"]:checked');

            // Perform Validatory Checks

            if (currency.value == 0) {

                setTimeout(() => {

                    toast({

                        text: 'Please specify currency',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                }, 1000);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('../controls/logic/generate-statement.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 1500);

                    } else if (response.noTrans) {

                        setTimeout(() => {

                            toast({

                                text: 'No Transactions found!',

                                type: 'info',

                                duration: 5000

                            });

                            formProcessRestore(button, content);

                        }, 1500);

                    } else {

                        if (response.generated) {

                            let formatValue = format ? format.value : null;

                            if (formatValue == 'PDF') {

                                let data = response.data.replace(/\\r\\n/g, '');

                                let page = document.createElement('div');

                                page.id = 'statementContent';

                                // page.style.display = 'none';

                                document.body.appendChild(page);

                                page.innerHTML = data.replace(/\\r\\n/g, '');

                                // Apply the desired styles to ensure one-page fit for the PDF
                                page.style.setProperty('width', '800px', 'important');
                                page.style.setProperty('height', 'auto', 'important'); // Adjust height automatically based on content
                                page.style.setProperty('padding', '2.5em', 'important');
                                page.style.setProperty('border', 'none', 'important');
                                page.style.setProperty('overflow', 'visible', 'important');


                                html2pdf().from(page).set({
                                    margin: [0, 0, 0, 0],  // Set margin to 0 to avoid extra space around the content
                                    filename: `bank-statement.pdf`, // Use the dynamic filename with .pdf extension
                                    jsPDF: {
                                        unit: 'mm',
                                        format: 'a4',
                                        orientation: 'portrait'
                                    },
                                    html2canvas: {
                                        scale: 2,
                                        windowWidth: document.documentElement.scrollWidth,  // Ensure we capture full page width
                                        windowHeight: document.documentElement.scrollHeight  // Capture full page height
                                    }
                                })
                                    .toPdf()
                                    .get('pdf')
                                    .then(function (pdf) {
                                        // Check the PDF content size and scale it to fit within the page
                                        const pageHeight = pdf.internal.pageSize.height;
                                        const contentHeight = page.scrollHeight;

                                        // Scale the content to fit one page if needed
                                        if (contentHeight > pageHeight) {
                                            const scale = pageHeight / contentHeight;
                                            pdf.setScale(scale);
                                        }

                                        // Save the generated PDF with the dynamic filename
                                        pdf.save(`bank-statement.pdf`);

                                        // User Feedback

                                        toast({

                                            text: 'PDF saved!',

                                            type: 'success',

                                            duration: 7000

                                        }); // Feedback

                                        formProcessRestore(button, content); // Disable Loading Sequence

                                    })
                                    .catch(function (error) {

                                        // User Feedback

                                        toast({

                                            text: 'Unable to process request!',

                                            type: 'warning',

                                            duration: 7000

                                        }); // Feedback

                                        // Handle error or cleanup as needed
                                        console.error('PDF conversion error:', error);

                                    });

                                page.remove();

                            } else if (formatValue == 'CSV') {

                                let data = response.data;

                                toast({
                                    text: 'CSV download started!',
                                    type: 'info',
                                    duration: 5000
                                });

                                const blob = new Blob([data], {

                                    type: 'text/csv;charset=utf-8;'

                                });

                                const url = URL.createObjectURL(blob);

                                const link = document.createElement('a');

                                link.href = url;

                                link.download = 'bank-statement.csv';

                                document.body.appendChild(link);

                                link.click();

                                document.body.removeChild(link);

                                URL.revokeObjectURL(url);

                                formProcessRestore(button, content); // Disable Loading Sequence

                            }

                        } else {

                            setTimeout(() => {

                                toast({

                                    text: 'Failed to generate file!',

                                    type: 'error',

                                    duration: 5000

                                });

                                formProcessRestore(button, content);

                            }, 1500);

                        }

                    }

                } catch (error) {

                    console.log('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            }

        });

    }

});

// Support Ticket Creation Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#ticketForm');

    let button = document.querySelector('#create-ticket');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML;

            formProcessZero(button); // Deny Interaction

            // Process Form

            try {

                let formData = new FormData(form); // Colect Form Data

                let processor = await fetch('../controls/logic/create-support-ticket.php', {

                    method: 'POST',

                    body: formData

                }); // Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    setTimeout(() => {

                        window.location.reload();

                        return;

                    }, 1500);

                } else if (response.msgShort) {

                    setTimeout(() => {

                        toast({ // Feedback

                            text: 'Message too short!',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(button, content); // Restore Interaction

                    }, 1200);

                } else {

                    if (response.created) {

                        setTimeout(() => {

                            toast({ // Feedback

                                text: 'Message logged!',

                                type: 'success',

                                duration: 5000

                            });

                        }, 1500);

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 4500);

                    } else {

                        setTimeout(() => {

                            toast({ // Feedback

                                text: 'Error! Please try again!',

                                type: 'error',

                                duration: 5000

                            });

                            formProcessRestore(button, content); // Restore Interaction

                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({ // Feedback

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 5000

                    });

                    formProcessRestore(button, content); // Restore Button

                }, 1200);

            }

        });

    }

});

// Investment Subscription Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#investForm');

    // let button = document.querySelector('#invest');

    if (form) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let button = event.submitter; // Get Button

            if (button) {

                let content = button.innerHTML;

                let buttons = form.querySelectorAll('button[type="submit"]');

                buttons.forEach(btn => {

                    if (btn != button) {

                        btn.classList.add('inaccessible');

                        btn.disabled = true;

                    }

                });

                formProcessZero(button);

                let method = button.value;

                try {

                    // Process Form

                    let formData = new FormData(form);

                    formData.append('via', method);

                    let processor = await fetch('../controls/logic/plan-subscription.php', {

                        method: 'POST',

                        body: formData

                    });

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        setTimeout(() => {

                            window.location.reload();

                            return;

                        }, 1200);

                    } else if (response.balError) {

                        setTimeout(() => {

                            toast({

                                text: 'Insufficient funds!',

                                type: 'warning',

                                duration: 5000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    } else if (response.accError) {

                        setTimeout(() => {

                            popup({

                                header: 'Error!',

                                title: 'USD Account Not Found!',

                                text: 'A USD account is required for investments',

                                type: 'failure',

                            }).then(() => {

                                window.location.href = 'accounts'

                            });

                        }, 1200);

                    } else if (response.amtError) {

                        setTimeout(() => {

                            formProcessRestore(button, content);

                            toast({

                                text: 'Invalid amount!',

                                type: 'error',

                                duration: 5000

                            });

                        }, 1200);

                    } else {

                        if (response.invest) {

                            if (response.pay) {

                                setTimeout(() => {

                                    window.location.href = 'pay';

                                }, 1500);

                            } else {

                                setTimeout(() => {

                                    popup({

                                        header: 'Portfolio updated!',

                                        title: 'Investment successful',

                                        text: 'Investment added to your portfolio!',

                                        type: 'success',

                                    }).then(() => {

                                        window.location.href = 'profile?tab=investments'

                                    });

                                }, 1200);

                            }

                        } else {

                            setTimeout(() => {

                                formProcessRestore(button, content);

                                toast({

                                    text: 'Please, try again!',

                                    type: 'warning',

                                    duration: 7000

                                });

                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error

                    setTimeout(() => {

                        formProcessRestore(button, content);

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 5000

                        });

                    }, 1200);

                } finally {

                    buttons.forEach(btn => {

                        if (btn != button) {

                            btn.classList.remove('inaccessible');

                            btn.disabled = false;

                        }

                    });

                }

            }

        });

    }

});

// Support Ticket Conversation Fetch Handler

document.addEventListener("DOMContentLoaded", () => {

    let records = document.querySelectorAll('.chat-record');

    if (records.length > 0) {

        records.forEach(record => {

            let identifier = record.querySelector('input[name="chat-id"]');

            let chatWindow = document.querySelector('#chat-window');

            let message = document.querySelector('#chat-msg');

            let send = document.querySelector('#send-msg');

            let conv = document.querySelector('#conv-id');

            record.addEventListener("click", async () => {

                // Get Conversation

                if (identifier && chatWindow) {

                    chatWindow.innerHTML = '';

                    try {

                        let processor = await fetch('../controls/logic/chat-conversations.php', {

                            method: 'POST',

                            body: new URLSearchParams({

                                'id': identifier.value

                            }),

                            headers: {

                                'Content-Type': 'application/x-www-form-urlencoded'

                            }

                        }); // Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.refresh) {

                            setTimeout(() => {

                                window.location.reload();

                                return;

                            }, 1200);

                        } else if (response.conversations) {

                            chatWindow.innerHTML = response.conversations.replace(/\\r\\n/g, '');

                        }

                    } catch (error) {

                        console.error('Error:', error);

                        setTimeout(() => {

                            toast({

                                text: 'Unable to process request!',

                                type: 'warning',

                                duration: 5000

                            });

                        }, 1000);

                    }

                }

                scrollDwn();

                sendMsg();

            });


        });

        function sendMsg() {

            let message = document.querySelector('#chat-msg');

            let send = document.querySelector('#send-msg');

            let conv = document.querySelector('#conv-id');

            if (message && send && conv) {

                send.disabled = true; // Disable Button

                message.addEventListener("change", () => {

                    if (message.value.length > 0) {

                        send.disabled = false;

                    } else {

                        send.disabled = true; // Disable Button

                    }

                });

                send.addEventListener("click", async () => {

                    send.disabled = true;

                    message.disabled = true;

                    try {

                        let processor = await fetch('../controls/logic/send-message.php', {

                            method: 'POST',

                            headers: {

                                'Content-Type': 'application/x-www-form-urlencoded',

                            },

                            body: `msg=${encodeURIComponent(message.value)}&id=${encodeURIComponent(conv.value)}`,

                        });

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.refresh) {

                            setTimeout(() => {

                                window.location.reload();

                            }, 1200);

                        } else {

                            if (response.sent) {

                                // setTimeout(() => {

                                send.disabled = false;

                                message.disabled = false;

                                message.innerHTML = '';

                                msgSentUpdate();

                                // toast({

                                //     text: 'Message sent',

                                //     type: 'success',

                                //     duration: 5000

                                // });

                                // }, 1200);

                            } else {

                                send.disabled = false;

                                message.disabled = false;

                                toast({

                                    text: 'Message not sent',

                                    type: 'warning',

                                    duration: 5000

                                });

                            }

                        }

                    } catch (error) {

                        console.error('Error:', error);

                        setTimeout(() => {

                            send.disabled = false;

                            toast({

                                text: 'Unable to process request!',

                                type: 'error',

                                duration: 5000

                            });

                        }, 1200);

                    }

                });

            }

        }

        function msgSentUpdate() {

            let chatsWindow = document.querySelector('#chat-window .chat-con');

            let message = document.querySelector('#chat-msg');

            if (chatsWindow && message) {

                let msgBox = document.createElement('div');

                msgBox.className = 'chat-box sent';

                msgBox.innerHTML = `<div class="conversation-box">

                    <p>${message.value}</p>

                </div>
                
                <p class="temporal">Now</p>`;

                chatsWindow.appendChild(msgBox);

                message.value = '';

            }

            scrollDwn();

        }

        function scrollDwn() {

            let chatWindow = document.querySelector('#chat-window');

            if (chatWindow) {

                chatWindow.scrollTop = chatWindow.scrollHeight;

            }

        }

    }

});

// 2FA Toggle Handler

document.addEventListener("DOMContentLoaded", () => {

    let toggle = document.querySelector('#iQ_2fa');

    if (toggle) {

        toggle.addEventListener("click", async () => {

            toggle.disabled = true;

            try {

                let processor = await fetch('../controls/logic/2fa-activator.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                });

                let response = await processor.json();

                if (response.refresh) {

                    window.location.reload();

                } else {

                    if (response.updated) {

                        let msg = (response.action == 'ENABLED') ? '2FA enabled' : '2FA disabled';

                        let ariaVal = (response.action == 'ENABLED') ? 'true' : 'false';

                        let state = (response.action == 'ENABLED') ? 'on' : 'off';

                        toast({

                            text: msg,

                            type: 'success',

                            duration: 1500

                        });

                        toggle.value = state;

                        toggle.ariaChecked = ariaVal;

                    } else {

                        toast({

                            text: 'Error, try again!',

                            type: 'warning',

                            duration: 5000

                        });

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                toast({

                    text: 'Unable to process request!',

                    type: 'warning',

                    duration: 5000

                });

            } finally {

                toggle.disabled = false;

            }

        });

    }

});

// Login Alerts Toggle Handler

document.addEventListener("DOMContentLoaded", () => {

    let toggle = document.querySelector('#iQ_loginAlerts');

    if (toggle) {

        toggle.addEventListener("click", async () => {

            toggle.disabled = true;

            try {

                let processor = await fetch('../controls/logic/login-alerts-activator.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                });

                let response = await processor.json();

                if (response.refresh) {

                    window.location.reload();

                } else {

                    if (response.updated) {

                        let msg = (response.action == 'ENABLED') ? 'Login alerts enabled' : 'Login alerts disabled';

                        let ariaVal = (response.action == 'ENABLED') ? 'true' : 'false';

                        let state = (response.action == 'ENABLED') ? 'on' : 'off';

                        toast({

                            text: msg,

                            type: 'success',

                            duration: 1500

                        });

                        toggle.value = state;

                        toggle.ariaChecked = ariaVal;

                    } else {

                        toast({

                            text: 'Error, try again!',

                            type: 'warning',

                            duration: 5000

                        });

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                toast({

                    text: 'Unable to process request!',

                    type: 'warning',

                    duration: 5000

                });

            } finally {

                toggle.disabled = false;

            }

        });

    }

});

// Overview Graph

document.addEventListener("DOMContentLoaded", () => {

    let account = document.querySelector('#accountSelector');

    let range = document.querySelector('#range');

    let graph = document.querySelector('#overview-graph');

    if (account && graph && range) {

        updateGraph(); // Initial Load

        account.addEventListener("change", updateGraph);

        let ranges = range.querySelectorAll('.swatch-btn');

        ranges.forEach(range => {

            range.addEventListener("click", () => {

                ranges.forEach(btn => btn.classList.remove('active'));

                range.classList.add('active');

                updateGraph();

            });

        });

        function updateGraph() {

            const activeRange = range.querySelector('.swatch-btn.active');

            loadGraphData(account.value, activeRange?.value, graph);

        }

    }

    async function loadGraphData(account, range, graph, graphType = 'line') { // Get Data For Graph

        try {

            let processor = await fetch('../controls/logic/account-statistics.php', {

                method: 'POST',

                body: new URLSearchParams({

                    'account': account,

                    'range': range

                }),

                headers: {

                    'Content-Type': 'application/x-www-form-urlencoded'

                }

            });

            let response = await processor.json();

            if (response.refresh) {

                window.location.reload();

            } else if (response.accError) {

                toast({

                    text: 'Account not found!',

                    type: 'error',

                    duration: 2000

                });

            } else {

                // if (response.transc) {

                let symbol = response.symbol;

                let transactions = response.transc;

                renderGraph(transactions, symbol, graph, graphType); // Render Graph

                // }

            }


        } catch (error) {

            console.error('Error:', error.message);

        }

    }

    function colorScheme() { // Determine Graph Theme

        const isDark = window.matchMedia('(prefers-color-scheme: dark)').matches || page.classList.contains('darkmode');

        return {

            grid: isDark ? '#444' : '#ddd',

            text: isDark ? '#eee' : '#333',

            tooltipBg: isDark ? '#222' : '#fff',

            tooltipText: isDark ? '#fff' : '#000'

        };

    }

    function renderGraph(records, symbol, graph, graphType) { // Render Graph

        const ctx = graph.getContext("2d");

        if (!records) {

            if (window.chartInstance) {

                window.chartInstance.destroy();

            }

            return;

        }

        const labels = records.map(d => d.day);

        const inflowData = records.map(d => parseFloat(d.inflow));

        const outflowData = records.map(d => parseFloat(d.outflow));

        const theme = colorScheme();

        if (window.chartInstance) {

            window.chartInstance.destroy();

        }

        window.chartInstance = new Chart(ctx, {

            type: graphType,

            data: {
                labels,
                datasets: [
                    {
                        label: 'Inflow',
                        data: inflowData,
                        borderColor: 'rgb(23, 191, 99)',
                        backgroundColor: 'rgb(23, 191, 99, 0.15)',
                        fill: true,
                        tension: 0.3
                    },
                    {
                        label: 'Outflow',
                        data: outflowData,
                        borderColor: 'rgb(249, 58, 55)',
                        backgroundColor: 'rgb(249, 58, 55, 0.15)',
                        fill: true,
                        tension: 0.3
                    }
                ]
            },

            options: {
                responsive: true,
                animation: {
                    duration: 1000,
                    easing: 'easeOutQuart'
                },
                interaction: {
                    mode: 'index',
                    intersect: false
                },
                plugins: {
                    legend: {
                        labels: {
                            color: theme.text
                        }
                    },
                    tooltip: {
                        backgroundColor: theme.tooltipBg,
                        titleColor: theme.tooltipText,
                        bodyColor: theme.tooltipText,
                        callbacks: {
                            labels: function (context) {
                                const value = context.raw ?? 0;
                                const formatted = value.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                                return `${context.dataset.label}: ${symbol}${formatted}`;
                            }
                        }
                    },
                    // title: {
                    //     display: true,
                    //     text: (ctx) => 'Point Style: ' + ctx.window.chartInstance.data.datasets[0].pointStyle,
                    // },
                },
                scales: {
                    x: {
                        ticks: {
                            color: theme.text
                        },

                        grid: {
                            color: theme.grid
                        }
                    },
                    y: {
                        ticks: {
                            color: theme.text,
                            callback: function (value) {
                                return `${symbol}${value}`;
                            }
                        },

                        grid: {
                            color: theme.grid
                        }
                    },
                    grid: {
                        color: theme.grid
                    }
                }
            }

        });

    }

});

// Purchase Airtime Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#airtimeForm');

    let button = document.querySelector('#airtimeBtn');

    if (form && button) {

        let account = form.querySelector('select[name="account"]');

        let phone = form.querySelector('input[name="telephone"]');

        let amount = form.querySelector('input[name="amount"]');

        // Intl Tel Verify Setup

        const telVerify = window.intlTelInput(phone, {

            autoPlaceholder: "off",

            initialCountry: "us",

            fixDropdownWidth: true,

            separateDialCode: true,

            formatAsYouType: true,

            strictMode: true,

        });

        window.iti = telVerify;

        form.addEventListener("submit", (event) => { // Handle Form Submission

            event.preventDefault(); // Negate Submission

            let content = button.innerHTML; // Store Button's Original Content

            formProcessZero(button); // Enable Loading Sequence

            // Check Fields

            if (account.value == '0') {

                setTimeout(() => {

                    toast({

                        text: 'Please specify account!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else if (parseFloat(amount.value) <= 0) {

                setTimeout(() => {

                    toast({

                        text: 'Invalid amount!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else if (!telVerify.isValidNumber()) {

                setTimeout(() => {

                    toast({

                        text: 'Invalid phone number!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else {

                // Carry-out Processing

                let msgs = ['An error occurred!', 'Please, try again!', 'Provider error!', 'Unavailable!', 'Unable to process request!'];

                let msg = msgs[Math.floor(Math.random() * msgs.length)];

                setTimeout(() => {

                    toast({

                        text: msg,

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 2500);

            }

        });

    }

});

// Purchase Data Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#dataForm');

    let button = document.querySelector('#dataBtn');

    if (form && button) {

        let account = form.querySelector('select[name="account"]');

        let phone = form.querySelector('input[name="telephone"]');

        let amount = form.querySelector('input[name="amount"]');

        // Intl Tel Verify Setup

        const telVerify = window.intlTelInput(phone, {

            autoPlaceholder: "off",

            initialCountry: "us",

            fixDropdownWidth: true,

            separateDialCode: true,

            formatAsYouType: true,

            strictMode: true,

        });

        window.iti = telVerify;

        form.addEventListener("submit", (event) => { // Handle Form Submission

            event.preventDefault(); // Negate Submission

            let content = button.innerHTML; // Store Button's Original Content

            formProcessZero(button); // Enable Loading Sequence

            // Check Fields

            if (account.value == '0') {

                setTimeout(() => {

                    toast({

                        text: 'Please specify account!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else if (parseFloat(amount.value) <= 0) {

                setTimeout(() => {

                    toast({

                        text: 'Invalid amount!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else if (!telVerify.isValidNumber()) {

                setTimeout(() => {

                    toast({

                        text: 'Invalid phone number!',

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 1200);

            } else {

                // Carry-out Processing

                let msgs = ['An error occurred!', 'Please, try again!', 'Provider error!', 'Unavailable!', 'Unable to process request!'];

                let msg = msgs[Math.floor(Math.random() * msgs.length)];

                setTimeout(() => {

                    toast({

                        text: msg,

                        type: 'warning',

                        duration: 2500

                    }); // Feedback

                    formProcessRestore(button, content); // Disable Loading Sequence

                }, 2500);

            }

        });

    }

});

// Update Avatar Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#pfpForm');

    let button = document.querySelector('#setPfp');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Stop Submission

            let content = button.innerHTML; // Hold Button's Original Content

            formProcessZero(button); // Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                const processor = await fetch('../controls/logic/avatar-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                const response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.uploadError) {

                    let error = response.error;

                    let msg = 'Upload failure!'; // Default Message

                    switch (error) { // Determine Message 

                        case 'Extension Error': msg = 'Invalid file type!';

                            break;

                        case 'MIME Error': msg = 'Invalid MIME type!';

                            break;

                    }

                    setTimeout(() => {

                        toast({

                            text: msg,

                            type: 'error',

                            duration: 2500

                        });

                        formProcessRestore(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    if (response.saved) {

                        setTimeout(() => {

                            toast({

                                text: 'Avatar updated!',

                                type: 'success',

                                duration: 2500

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.reload();

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Error, please try again!',

                                type: 'error',

                                duration: 2500

                            });

                            formProcessRestore(button, content); // End Loading Sequence

                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Notification Management Handler

document.addEventListener("DOMContentLoaded", () => {

    manageNotifications();

    readNotification()

});

// Fetch / Update Read (Notification)

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#getRead');

    let view = document.querySelector('#displayRead');

    // let counter = document.querySelector('#');

    if (command && view) {

        command.addEventListener("click", async () => {

            view.innerHTML = '';

            view.style.minHeight = '45vh';

            view.classList.add('flx');

            view.classList.add('col');

            initLoadingPane(view);

            // Commence Data Retrieval

            try {

                let processor = await fetch('../controls/logic/read-notifications.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    }

                }); // Request Handler (Credentials)

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else {
                    
                    if (response.found) {

                        let data = response.data;

                        setTimeout(() => {

                            closeLoadingPane(view);

                            view.classList.remove('flx');

                            view.innerHTML = data.replace(/\\r\\n/g, '');

                            // Attach Function(s)

                            manageNotifications();

                            readNotification();

                            attachPopup();

                        }, 700);

                    } else {

                        setTimeout(() => {

                            closeLoadingPane(view);

                            view.innerHTML = `<div style="width: 3.5em">
                            
                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 32 32" version="1.1">
                                <path d="M30.65 27.75l-14.001-24.249c-0.142-0.211-0.379-0.349-0.649-0.349s-0.508 0.137-0.648 0.346l-0.002 0.003-14 24.249c-0.063 0.108-0.1 0.237-0.1 0.375 0 0.414 0.336 0.75 0.75 0.75h28c0 0 0.001 0 0.001 0 0.414 0 0.75-0.336 0.75-0.75 0-0.138-0.037-0.267-0.102-0.379l0.002 0.004zM3.299 27.375l12.701-21.999 12.701 21.999zM15.25 12v8.994c0 0.414 0.336 0.75 0.75 0.75s0.75-0.336 0.75-0.75v0-8.994c0-0.414-0.336-0.75-0.75-0.75s-0.75 0.336-0.75 0.75v0zM15.46 23.959c-0.123 0.145-0.198 0.334-0.2 0.541v0c-0.001 0.016-0.002 0.034-0.002 0.052 0 0.082 0.015 0.16 0.044 0.231l-0.002-0.004c0.039 0.094 0.093 0.173 0.16 0.24l0 0c0.071 0.076 0.158 0.137 0.255 0.178l0.005 0.002c0.084 0.026 0.18 0.041 0.28 0.041s0.196-0.015 0.287-0.043l-0.007 0.002c0.098-0.037 0.179-0.099 0.239-0.178l0.001-0.001c0.147-0.125 0.24-0.309 0.24-0.516 0-0.001 0-0.002 0-0.004v0c0-0 0-0 0-0 0-0.21-0.084-0.401-0.22-0.541l0 0c-0.142-0.13-0.332-0.209-0.54-0.209s-0.398 0.080-0.541 0.21l0.001-0.001z"/>
                                </svg>

                                </div>

                            <p>No read notifications!</p>`;

                        }, 700);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeLoadingPane(view);

                    view.innerHTML = `<div style="width: 3.5em">
                    
                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 32 32" version="1.1">
                        <path d="M30.65 27.75l-14.001-24.249c-0.142-0.211-0.379-0.349-0.649-0.349s-0.508 0.137-0.648 0.346l-0.002 0.003-14 24.249c-0.063 0.108-0.1 0.237-0.1 0.375 0 0.414 0.336 0.75 0.75 0.75h28c0 0 0.001 0 0.001 0 0.414 0 0.75-0.336 0.75-0.75 0-0.138-0.037-0.267-0.102-0.379l0.002 0.004zM3.299 27.375l12.701-21.999 12.701 21.999zM15.25 12v8.994c0 0.414 0.336 0.75 0.75 0.75s0.75-0.336 0.75-0.75v0-8.994c0-0.414-0.336-0.75-0.75-0.75s-0.75 0.336-0.75 0.75v0zM15.46 23.959c-0.123 0.145-0.198 0.334-0.2 0.541v0c-0.001 0.016-0.002 0.034-0.002 0.052 0 0.082 0.015 0.16 0.044 0.231l-0.002-0.004c0.039 0.094 0.093 0.173 0.16 0.24l0 0c0.071 0.076 0.158 0.137 0.255 0.178l0.005 0.002c0.084 0.026 0.18 0.041 0.28 0.041s0.196-0.015 0.287-0.043l-0.007 0.002c0.098-0.037 0.179-0.099 0.239-0.178l0.001-0.001c0.147-0.125 0.24-0.309 0.24-0.516 0-0.001 0-0.002 0-0.004v0c0-0 0-0 0-0 0-0.21-0.084-0.401-0.22-0.541l0 0c-0.142-0.13-0.332-0.209-0.54-0.209s-0.398 0.080-0.541 0.21l0.001-0.001z"/>
                        </svg>

                        </div>

                    <p>An error occurred!</p>`;

                }, 700);

            }

        });

    }

});

function manageNotifications() {

    let notifications = document.querySelectorAll('.notification-box');

    if (notifications.length > 0) {

        notifications.forEach(notification => {

            let field = notification.querySelector('.notf-data input[name="notf-id"]');

            let btn = notification.querySelector('.notf-data .notf-btn');

            if (field && btn) {

                btn.addEventListener("click", async (event) => {

                    event.stopPropagation();

                    const action = btn.value;

                    btn.disabled = true; // Disable Button

                    try {

                        let processor = await fetch('../controls/logic/notifications-manager.php', {

                            method: 'POST',

                            headers: {

                                'Content-Type': 'application/x-www-form-urlencoded'

                            },

                            body: new URLSearchParams({

                                'notf-id': field.value,

                                'action': action

                            })

                        });

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.updated) {

                            toast({

                                text: 'Marked as read!',

                                type: 'success',

                                duration: 1200

                            });

                            notification.remove();

                            return;

                        } else if (response.deleted) {

                            toast({

                                text: 'Notification deleted!',

                                type: 'success',

                                duration: 1200

                            });

                            notification.remove();

                        } else {

                            toast({

                                text: 'Error, try again!',

                                type: 'warning',

                                duration: 1500

                            });

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log Error To Console

                    } finally {

                        btn.disabled = false;

                    }

                });

            }

        });

    }

}

function readNotification() {

    let notifications = document.querySelectorAll('.notification-box');

    let display = document.querySelector('#notf-displ');

    if (notifications.length > 0 && display) {

        notifications.forEach(notification => {

            notification.addEventListener("click", async () => {

                display.innerHTML = '';

                initLoadingPane(display);

                const id = notification.querySelector('.notf-data input[name="notf-id"]');

                if (id) {

                    try {

                        let processor = await fetch('../controls/logic/fetch-notification-data.php', {

                            method: 'POST',

                            headers: {

                                'Content-Type': 'application/x-www-form-urlencoded'

                            },

                            body: new URLSearchParams({

                                'notf-id': id.value,

                            })

                        });

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.found) {

                            setTimeout(() => {
                                
                                closeLoadingPane(display);

                                const msg = response.data;

                                display.innerHTML = msg.replace(/\\r\\n/g, '');

                            }, 700);

                        }

                    } catch (error) {

                        closeLoadingPane(display);

                        console.error('Error:', error); // Log Error To Console

                    }

                }

            });

        });

    }

}

// Logout Handler

document.addEventListener("DOMContentLoaded", () => {

    let commands = document.querySelectorAll('.iQ-logout');

    if (commands.length > 0) {

        commands.forEach(command => {

            command.addEventListener("click", () => {

                const popup = document.createElement('div');

                popup.className = "popup_window";

                popup.innerHTML = `<div class="popup_con">

                    <div class="popup_box noScrollBar">

                        <div class="modal_box">

                            <div class="flx col" style="min-height: 15em; gap: 2em;">

                                <div class="preloader-spinner" style="position: unset; transform: unset;">
                                    <svg viewBox="0 0 44 44">
                                        <circle cx="22" cy="22" r="20" style="stroke: var(--pg-error)"></circle>
                                    </svg>
                                </div>

                                <p>Logging out...</p>

                            </div>

                        </div>

                    </div>

                </div>`;

                page.appendChild(popup); // Show Popup

                page.classList.add('deactivate');

                // Commence Logout Sequence

                fetch('../controls/engines/logout-engine.php', {

                    method: 'POST',

                    credentials: 'same-origin'

                }) // Request Handler, Credentials
                .then(response => {

                    if (!response.ok) {

                        window.location.href = 'logout';

                    }

                    return response.json();

                })
                .then(data => {
                    const direction = (data.direction == null) ? '../auth/login' : data.direction;

                    setTimeout(() => {
                        window.location.href = direction;
                    }, 7000);
                })
                .catch(error => {

                    console.error('Error:', error);

                    window.location.href = 'logout';

                });

            });

        });

    }

});

// Mobile Account Data Display

document.addEventListener("DOMContentLoaded", () => {
    fetchAccountDetails(); // Your custom function to fetch additional info

    const target = document.querySelector('#account-target');
    const display = document.querySelector('#account-display');

    if (target && display) {
        accountData(target, display); // Initial render

        target.addEventListener("change", () => {
            accountData(target, display); // On account select change
        });
    }
});

// 🔄 Handles AJAX fetch and DOM update
async function accountData(account, view) {
    view.innerHTML = ''; // Clear previous content

    initLoadingPane(view);

    try {
        const processor = await fetch('../controls/logic/mobile-account-data-fetch.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                'account-id': account.value
            })
        });

        const response = await processor.json();

        if (response.refresh) {
            window.location.reload(); // Reload page if backend says so
        } else if (response.accError) {
            closeLoadingPane(view);
            view.innerHTML = 'Data not found!';
        } else if (response.accData) {

            setTimeout(() => {

                closeLoadingPane(view);

                view.innerHTML = response.accData.replace(/\\r\\n/g, '');

                attachPopup();           // Your existing popup handler
                fetchAccountDetails();   // Refetch/update external data

                // 🔐 Re-initialize veil toggle for the new content
                initVeilForSensiq();

            }, 700);
        }

    } catch (error) {
        console.error('Error:', error);
        closeLoadingPane(view);
        view.innerHTML = 'An error occurred!';
    }
}

async function fetchAccountDetails() { // Account Detail Fetch Function

    let requesters = document.querySelectorAll('*[iQ-target="#iQ_accDetails"]');

    if (requesters) {

        requesters.forEach((requester) => {

            requester.addEventListener("click", async () => {

                let id = requester.querySelector('input[type="hidden"]');

                let container = document.querySelector('#accRqst');

                initLoadingPane(container);

                try {

                    let processor = await fetch('../controls/logic/fetch-account-details.php', {

                        method: 'POST',

                        body: new URLSearchParams({

                            'id': id.value

                        }),

                        headers: {

                            'Content-Type': 'application/x-www-form-urlencoded'

                        }

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    if (response.status) {

                        setTimeout(() => {

                            closeLoadingPane(container);

                            container.innerHTML = response.html.replace(/\\r\\n/g, ''); // Remove Extra Characters

                            copyFxn();

                        }, 700);

                    } else {

                        setTimeout(() => {

                            closeLoadingPane(container);

                            container.innerHTML = `<div style="width: 3.5em">
                            
                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 32 32" version="1.1">
                                <path d="M30.65 27.75l-14.001-24.249c-0.142-0.211-0.379-0.349-0.649-0.349s-0.508 0.137-0.648 0.346l-0.002 0.003-14 24.249c-0.063 0.108-0.1 0.237-0.1 0.375 0 0.414 0.336 0.75 0.75 0.75h28c0 0 0.001 0 0.001 0 0.414 0 0.75-0.336 0.75-0.75 0-0.138-0.037-0.267-0.102-0.379l0.002 0.004zM3.299 27.375l12.701-21.999 12.701 21.999zM15.25 12v8.994c0 0.414 0.336 0.75 0.75 0.75s0.75-0.336 0.75-0.75v0-8.994c0-0.414-0.336-0.75-0.75-0.75s-0.75 0.336-0.75 0.75v0zM15.46 23.959c-0.123 0.145-0.198 0.334-0.2 0.541v0c-0.001 0.016-0.002 0.034-0.002 0.052 0 0.082 0.015 0.16 0.044 0.231l-0.002-0.004c0.039 0.094 0.093 0.173 0.16 0.24l0 0c0.071 0.076 0.158 0.137 0.255 0.178l0.005 0.002c0.084 0.026 0.18 0.041 0.28 0.041s0.196-0.015 0.287-0.043l-0.007 0.002c0.098-0.037 0.179-0.099 0.239-0.178l0.001-0.001c0.147-0.125 0.24-0.309 0.24-0.516 0-0.001 0-0.002 0-0.004v0c0-0 0-0 0-0 0-0.21-0.084-0.401-0.22-0.541l0 0c-0.142-0.13-0.332-0.209-0.54-0.209s-0.398 0.080-0.541 0.21l0.001-0.001z"/>
                                </svg>

                                </div>

                            <p>Couldn't retrieve account data!</p>`;

                        }, 700);


                    }

                } catch (error) {

                    console.error('Error:', error);

                    closeLoadingPane(container);

                    container.innerHTML = `<div style="width: 3.5em">
                            
                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 32 32" version="1.1">
                        <path d="M30.65 27.75l-14.001-24.249c-0.142-0.211-0.379-0.349-0.649-0.349s-0.508 0.137-0.648 0.346l-0.002 0.003-14 24.249c-0.063 0.108-0.1 0.237-0.1 0.375 0 0.414 0.336 0.75 0.75 0.75h28c0 0 0.001 0 0.001 0 0.414 0 0.75-0.336 0.75-0.75 0-0.138-0.037-0.267-0.102-0.379l0.002 0.004zM3.299 27.375l12.701-21.999 12.701 21.999zM15.25 12v8.994c0 0.414 0.336 0.75 0.75 0.75s0.75-0.336 0.75-0.75v0-8.994c0-0.414-0.336-0.75-0.75-0.75s-0.75 0.336-0.75 0.75v0zM15.46 23.959c-0.123 0.145-0.198 0.334-0.2 0.541v0c-0.001 0.016-0.002 0.034-0.002 0.052 0 0.082 0.015 0.16 0.044 0.231l-0.002-0.004c0.039 0.094 0.093 0.173 0.16 0.24l0 0c0.071 0.076 0.158 0.137 0.255 0.178l0.005 0.002c0.084 0.026 0.18 0.041 0.28 0.041s0.196-0.015 0.287-0.043l-0.007 0.002c0.098-0.037 0.179-0.099 0.239-0.178l0.001-0.001c0.147-0.125 0.24-0.309 0.24-0.516 0-0.001 0-0.002 0-0.004v0c0-0 0-0 0-0 0-0.21-0.084-0.401-0.22-0.541l0 0c-0.142-0.13-0.332-0.209-0.54-0.209s-0.398 0.080-0.541 0.21l0.001-0.001z"/>
                        </svg>

                        </div>

                    <p>An error occurred!</p>`;

                }

            });

        });

    }

}

function initVeilForSensiq() {
    const veilActvtr = document.querySelector('#iQ_veil');
    const veilItem = document.querySelector('#sensiq');

    if (!veilActvtr || !veilItem) {
        console.warn('Veil elements not found.');
        return;
    }

    const originalText = veilItem.innerHTML;

    function toggleVeil() {
        if (!veilItem.classList.contains('veil')) {
            veilItem.innerHTML = `<b style="font-family: var(--subFont); font-size: 1.5rem; color: var(--pg-txt); text-align: center; letter-spacing: 0.2em">******</b>`;
            veilItem.classList.add('veil');
            veilActvtr.classList.add('active');
            localStorage.setItem('veilActvtrState', 'active');
        } else {
            veilItem.innerHTML = originalText;
            veilItem.classList.remove('veil');
            veilActvtr.classList.remove('active');
            localStorage.setItem('veilActvtrState', null);
        }
    }

    function recallVeil() {
        const state = localStorage.getItem('veilActvtrState');
        if (state === 'active') {
            veilItem.innerHTML = `<b style="font-family: var(--subFont); font-size: 1.5rem; color: var(--pg-txt); text-align: center; letter-spacing: 0.2em">******</b>`;
            veilItem.classList.add('veil');
            veilActvtr.classList.add('active');
        }
    }

    // Remove any previously attached handler
    veilActvtr.removeEventListener('click', veilActvtr._veilHandler);
    veilActvtr._veilHandler = toggleVeil;
    veilActvtr.addEventListener('click', toggleVeil);

    recallVeil();
}


// Add Joint User Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#jointUserForm');

    let button = document.querySelector('#add-jointUser');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading sequenceg

            let email = form.querySelector('input[name="email"]');

            try {

                let formData = new FormData(form); // Gain Form 

                let processor = await fetch('../controls/logic/add-joint-user.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.refresh();

                } else if (response.emailTaken) {

                    setTimeout(() => {

                        toast({

                            text: 'Email already in use!',

                            type: 'warning',

                            duration: 2500

                        });

                        email.focus(); // Highlight Field

                        formProcessRestore(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    if (response.added) {

                        let msg = (response.sent) ? 'Joint holder added, Email delivered!' : 'Joint holder added, Email not delivered!';

                        setTimeout(() => {

                            toast({

                                text: msg,

                                type: 'success',

                                duration: 2500

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.reload();

                        }, 2800);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Error, please try again!',

                                type: 'error',

                                duration: 2500

                            });

                            formProcessRestore(button, content); // End Loading Sequence

                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Update Joint Holder Personal Details Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#personal-form-holder');

    let button = document.querySelector('#update-holder-personal');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Initiate Loading Sequence

            try {

                // Process Form

                let formData = new FormData(form); // Gain FormData

                let processor = await fetch('../controls/logic/update-joint-holder-personal-data.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.updated) {

                    setTimeout(() => {

                        toast({

                            text: 'Personal details updated!',

                            type: 'success',

                            duration: 3000

                        });

                    }, 1200);

                    setTimeout(() => {

                        window.location.reload();

                    }, 2500);

                } else {

                    setTimeout(() => {

                        toast({

                            text: 'Please, try again!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'An error occurred',

                        type: 'warning',

                        duration: 1500

                    });

                    formProcessRestore(button, content);

                }, 1200);

            }

        });

    }

});

// Update Joint Holder Banking Details Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#banking-form-holder');

    let button = document.querySelector('#update-holder-banking');

    if (form && button) {

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            try {

                // Process Form

                let formData = new FormData(form); // Gain FormData

                let processor = await fetch('../controls/logic/update-joint-holder-banking-data.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.updated) {

                    setTimeout(() => {

                        toast({

                            text: 'Banking details updated!',

                            type: 'success',

                            duration: 3000

                        });

                    }, 1200);

                    setTimeout(() => {

                        window.location.reload();

                    }, 2500);

                } else {

                    setTimeout(() => {

                        toast({

                            text: 'Please, try again!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            } catch (error) {

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content);

                }, 1200);

            }

        });

    }

});

// Update Transaction Count Handler

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#reset-transc-count');

    let field = document.querySelector('#transc-count');

    let id = document.querySelector('#tpy-id');

    if (command && field && id) {

        command.addEventListener("click", async () => {

            let content = command.innerHTML;

            formProcessZero(command);

            try {

                let processor = await fetch('../controls/logic/update-transc-count-processor.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlencoded'

                    },

                    body: new URLSearchParams({

                        'tp-id': id.value

                    }),

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response 

                if (response.updated) {

                    setTimeout(() => {

                        toast({

                            text: 'Transaction count reset!',

                            type: 'success',

                            duration: 2500

                        });

                        field.value = '0'; // Update Field

                        formProcessRestore(command, content);

                    }, 1200);


                } else {

                    setTimeout(() => {

                        toast({

                            text: 'Reset failed!',

                            type: 'error',

                            duration: 2500

                        });

                        formProcessRestore(command, content);

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(command, content);

                }, 1200);

            }

        });

    }

});

// Reset Password Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#reset-pwrd-form');

    let button = document.querySelector('#reset-pwrd');

    if (form && button) {

        let current = form.querySelector('input[name="current-pwrd"]');

        let password = form.querySelector('input[name="new-pwrd"]');

        let confirmPwrd = form.querySelector('input[name="confirm-pwrd"]');

        let criteriaMap = form.querySelector('#pwrd-criteria');

        let criteria = false; // Password Criteria Flag

        let indicators; // Criteria Indicators

        // Password Criteria Indication

        password.addEventListener("focus", () => {

            criteriaMap.classList.remove('n_displ');

        });

        password.addEventListener("input", async () => {

            let data = password.value;

            indicators = document.querySelectorAll('.req_key');

            // 1. Escape function
            const escapeForRegex = (str) => str.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&');

            // 2. Prepare safe special chars
            const rawSpecialChars = "~`!@#$%^&*()_-+={}[]:\";'|?/\\";
            const safeSpecials = escapeForRegex(rawSpecialChars);


            // Consolidated validation logic (Object)

            const requirements = [

                { test: data.length >= 8 },

                { test: /[A-Z]/.test(data) },

                { test: /[a-z]/.test(data) },

                { test: new RegExp(`[${safeSpecials}]`).test(data) },

                { test: /\d/.test(data) }

            ];

            // Update UI and flags in one pass

            requirements.forEach((condition, index) => {

                indicators[index].classList.toggle('active', condition.test);

            });

            // Set final criteria flag (all must be true)

            criteria = requirements.every(r => r.test); // Update Flag

        });

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            // Validate Form Data

            if (!criteria) { // Check Criteria Flag

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Required criteria not met!',

                        type: 'warning',

                        duration: 2000

                    });

                    password.focus(); // Highlight Field

                    formProcessRestore(button, content); // Restore / Stop Animation

                }, 1200);

            } else if (String(password.value) !== String(confirmPwrd.value)) {

                setTimeout(() => {

                    toast({ // User Feedback

                        text: 'Password mismatch!',

                        type: 'error',

                        duration: 2000

                    });

                    confirmPwrd.focus(); // Highlight Field

                    formProcessRestore(button, content); // Restore / Stop Animation

                }, 1200);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Gain FormData

                    let processor = await fetch('../controls/logic/reset-pwrd-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Request Handler, Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        window.location.reload();

                    } else if (response.invalidPwrd) {

                        setTimeout(() => {

                            toast({

                                text: 'Password invalid!',

                                type: 'warning',

                                duration: 3000

                            });

                            formProcessRestore(button, content);

                            current.focus(); // Focus On Field

                        }, 1200);

                    } else {

                        if (response.updated) {

                            setTimeout(() => {

                                toast({

                                    text: 'Password reset!',

                                    type: 'success',

                                    duration: 3000

                                });

                            }, 1200);

                            setTimeout(() => {

                                window.location.reload();

                            }, 2500);

                        } else {

                            setTimeout(() => {

                                toast({

                                    text: 'Please, try again!',

                                    type: 'warning',

                                    duration: 3000

                                });

                                formProcessRestore(button, content);

                            }, 1200);

                        }

                    }

                } catch (error) {

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 2500

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            }

        });

    }

});

// Reset Password Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#update-tpin-form');

    let button = document.querySelector('#update-tpin');

    if (form && button) {

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            try {

                // Process Form

                let formData = new FormData(form); // Gain FormData

                let processor = await fetch('../controls/logic/update-tpin-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.ansError) {

                    setTimeout(() => {

                        toast({

                            text: 'Invalid answer(s) provided!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(button, content);

                        current.focus(); // Focus On Field

                    }, 1200);

                } else {

                    if (response.updated) {

                        setTimeout(() => {

                            toast({

                                text: 'Transaction PIN updated!',

                                type: 'success',

                                duration: 3000

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.reload();

                        }, 2500);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Please, try again!',

                                type: 'warning',

                                duration: 3000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    }

                }

            } catch (error) {

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content);

                }, 1200);

            }

        });

    }

});

// Create New Customer Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#addCustomerForm');

    let button = document.querySelector('#addCustomer');

    if (form && button) {

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            try {

                // Process Form

                let formData = new FormData(form); // Gain FormData

                let processor = await fetch('../controls/logic/create-customer-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.emailTaken) {

                    setTimeout(() => {

                        toast({

                            text: 'Email already in use!',

                            type: 'warning',

                            duration: 3000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                } else {

                    if (response.created) {

                        setTimeout(() => {

                            popup({
                                header: 'Attention!',
                                title: 'Creation Successful',
                                text: 'New customer added',
                                type: 'checked',
                            }).then(() => {

                                popup({
                                    header: 'Attention',
                                    title: 'Create Invoice',
                                    text: 'Would you like to create an invoice',
                                    type: 'confirm'
                                }).then(confirmed => {
                                    if (confirmed) {
                                        window.location.href = 'create-invoice';
                                    } else {
                                        window.location.reload();
                                    }
                                });

                            });

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Please, try again!',

                                type: 'warning',

                                duration: 3000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    }

                }

            } catch (error) {

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content);

                }, 1200);

            }

        });

    }

});

// Invoice Creation Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#create-invoice-form');

    let button = document.querySelector('#create-new-invoice');

    if (form && button) {

        form.addEventListener('submit', async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Store Original Content

            formProcessZero(button); // Loading Sequence

            try {

                // Process Form

                let formData = new FormData(form); // Gain FormData

                let processor = await fetch('../controls/logic/create-invoice-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                } else if (response.customerError) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Customer Error!',

                            text: 'Customer not found.',

                            type: 'warning'

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                } else if (response.dateError) {

                    setTimeout(() => {

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Due data error.',

                            type: 'warning'

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                } else {

                    if (response.created) {

                        let msg = (response.sent) ? 'New invoice added, Email delivered!' : 'New invoice added, Email not delivered!';

                        setTimeout(() => {

                            popup({
                                header: 'Attention!',
                                title: 'Creation Successful',
                                text: `${msg}`,
                                type: 'checked',
                            }).then(() => {

                                window.location.href = 'invoices';

                            });

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Please, try again!',

                                type: 'warning',

                                duration: 3000

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    }

                }

            } catch (error) {

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 2500

                    });

                    formProcessRestore(button, content);

                }, 1200);

            }

        });

    }

});


function authTransfer() { // OTP (Authenticate Transfer)

    attachAuthModal();

}

function attachAuthModal() { // Attach Authentication Modal

    const modal = document.createElement('div');

    modal.className = 'popup_window';

    modal.role = 'dialog';

    modal.innerHTML = `<div class="popup_con">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Enter Verification Code</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="otp-trans-form" method="post" autocomplete="off">

                    <p class="form_info">

                        To authenticate the transfer, kindly enter the verification code sent to your email address

                    </p>
                                        
                    <div class="form_item mltpl">

                        <input type="text" name="digit_1" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autofocus aria-autocomplete="none">

                        <input type="text" name="digit_2" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_3" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_4" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_5" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_6" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    </div>

                    <div class="form_item">

                        <button type="submit" name="verify" id="validate-trans-otp" class="form_btn">Proceed</button>

                    </div>

                    <div class="form_item" style="padding: 0;">

                        <button type="button" class="action_btn" id="trans-otp">

                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24" class="icon-md-heavy"><path fill="currentColor" d="M3.07 10.876C3.623 6.436 7.41 3 12 3a9.15 9.15 0 0 1 6.012 2.254V4a1 1 0 1 1 2 0v4a1 1 0 0 1-1 1H15a1 1 0 1 1 0-2h1.957A7.15 7.15 0 0 0 12 5a7 7 0 0 0-6.946 6.124 1 1 0 1 1-1.984-.248m16.992 1.132a1 1 0 0 1 .868 1.116C20.377 17.564 16.59 21 12 21a9.15 9.15 0 0 1-6-2.244V20a1 1 0 1 1-2 0v-4a1 1 0 0 1 1-1h4a1 1 0 1 1 0 2H7.043A7.15 7.15 0 0 0 12 19a7 7 0 0 0 6.946-6.124 1 1 0 0 1 1.116-.868"></path></svg>

                            <span>Resend code</span>

                        </button>

                    </div>

                </form>

            </div>

        </div>

    </div>`;

    document.body.appendChild(modal);

    processAuthForm(); // Auth Processor Logic

    numberOnlyFields();

    jumpFields();

    attachPopup();

}

function processAuthForm() { // Authentication Form Processor

    let form = document.querySelector('#otp-trans-form');

    let button = document.querySelector('#validate-trans-otp');

    let resend = document.querySelector('#trans-otp');

    if (form && button) {

        form.addEventListener("submit", (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Hold Original Content

            formProcessZero(button); // Loading Sequence

            // Process Form

            let formData = new FormData(form); // Gain Form Data

            fetch('../controls/logic/transfer-2fa-validator.php', {

                method: 'POST',

                body: formData,

            }) // Request Handler, Credentials
                .then(response => response.json()) // Parse JSON Response
                .then(data => {

                    // Handle Response

                    if (data.refresh) {

                        window.location.reload();

                    } else if (data.codeInvalid) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Code invalid!',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                            form.querySelector('input').focus(); // Focus On First Input

                        }, 1200);


                    } else if (data.codeExpired) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Expired multifactor code',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                            form.querySelector('input').focus(); // Focus On First Input

                        }, 1200);

                    } else if (data.tPIN) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Valid multifactor code',

                                type: 'success',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                        }, 500);

                        setTimeout(() => {

                            // form.closest().remove(); // Remove Popup

                            authTransferPIN(); // Attach Trans Pin Modal

                        }, 1200);

                    }

                })
                .catch(error => {

                    console.error('Error:', error); // Log Error

                    setTimeout(() => {

                        toast({

                            text: 'An error occurred',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                });

        });

    }

    if (resend && form) {

        resend.addEventListener("click", () => {

            let content = resend.innerHTML;

            if (resend.disabled) return;

            processZero(resend);

            form.reset();

            form.querySelector('input').focus();

            fetch('../controls/logic/transfer-otp-generator.php', {

                method: 'POST',

                headers: {

                    'Content-Type': 'application/x-www-form-urlencoded'

                }

            }) // Request Handler, Credentials
                .then(response => response.json()) // Parse JSON Response
                .then(data => {

                    // Handle Response

                    if (data.codeSent) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Multifactor code resent!',

                                type: 'success',

                                duration: 7000

                            });

                            delayedRestore(resend, content, 2); // Restore Button

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Please, try again!',

                                type: 'error',

                                duration: 7000

                            });

                            processRestore(resend, content); // Restore Button

                        }, 2000);

                    }

                })
                .catch(error => {

                    console.error('Error:', error); // Log Error

                    setTimeout(() => {

                        toast({

                            text: 'An error occurred',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                });

        });

    }

}

function authTransferPIN() { // Trans PIN (Authenticate Transfer)

    attachTransPINModal();

}

function attachTransPINModal() { // Attach Transc PIN Modal

    const modal = document.createElement('div');

    modal.className = 'popup_window';

    modal.role = 'dialog';

    modal.innerHTML = `<div class="popup_con">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Enter Transaction PIN</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="trans-pin-form" method="post" autocomplete="off">

                    <p class="form_info">

                        To authenticate the transfer, kindly enter your transaction PIN.

                    </p>
                                        
                    <div class="form_item mltpl">

                        <input type="text" name="digit_1" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autofocus aria-autocomplete="none">

                        <input type="text" name="digit_2" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_3" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_4" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_5" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="digit_6" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    </div>

                    <div class="form_item">

                        <button type="submit" name="verify" id="validate-trans-pin" class="form_btn">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>`;

    document.body.appendChild(modal);

    processAuthForm2(); // Auth Processor Logic

    numberOnlyFields();

    jumpFields();

    attachPopup();

}

function processAuthForm2() { // Trans PIN Form Processor

    let form = document.querySelector('#trans-pin-form');

    let button = document.querySelector('#validate-trans-pin');

    if (form && button) {

        form.addEventListener("submit", (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Hold Original Content

            formProcessZero(button); // Loading Sequence

            // Process Form

            let formData = new FormData(form); // Gain Form Data

            fetch('../controls/logic/transfer-pin-validator.php', {

                method: 'POST',

                body: formData,

            }) // Request Handler, Credentials
                .then(response => response.json()) // Parse JSON Response
                .then(data => {

                    // Handle Response

                    if (data.refresh) {

                        window.location.reload();

                    } else if (data.invalidPIN) {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'PIN invalid!',

                                type: 'warning',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore Button

                            form.reset(); // Reset Form

                            form.querySelector('input').focus(); // Focus On First Input

                        }, 1200);


                    } else {

                        if (data.transfer) {

                            setTimeout(() => {

                                window.location.href = 'transaction-success';

                                formProcessRestore(button, content); // Restore / Stop Animation

                            }, 2000);


                        } else {

                            setTimeout(() => {

                                toast({ // User Feedback

                                    text: 'Please, try again!',

                                    type: 'error',

                                    duration: 7000

                                });

                                formProcessRestore(button, content); // Restore / Stop Animation

                            }, 2000);

                        }

                    }

                })
                .catch(error => {

                    console.error('Error:', error); // Log Error

                    setTimeout(() => {

                        toast({

                            text: 'An error occurred',

                            type: 'warning',

                            duration: 5000

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                });

        });

    }

}

// Delete Support Ticket Handler

document.addEventListener("DOMContentLoaded", () => {

    let modules = document.querySelectorAll('.chat-record');

    modules.forEach(module => {

        let field = module.querySelector('input[type="hidden"]');

        let command = module.querySelector('button[name="delete-ticket"]');

        if (command && field) {

            command.addEventListener("click", (event) => {

                command.disabled = true;

                event.stopPropagation();

                popup({

                    header: 'Attention!',

                    title: 'Delete support ticket?',

                    text: 'Are you sure you want to delete this ticket?',

                    type: 'confirm'

                }).then(confirmed => {

                    if (!confirmed) {

                        command.disabled = false;

                        return;

                    }

                    fetch('../controls/logic/delete-support-ticket.php', {

                        method: 'POST',

                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },

                        body: `id=${encodeURIComponent(field.value)}`

                    })
                        .then(response => response.json())
                        .then(data => {

                            if (data.deleted) {

                                toast({

                                    text: 'Support ticket deleted!',

                                    type: 'success',

                                    duration: 7000

                                });

                                module.closest('.chat-record').remove();

                            } else {

                                toast({

                                    text: 'Support ticket deletion failed!',

                                    type: 'error',

                                    duration: 7000

                                });

                            }

                        })
                        .catch(error => {

                            console.error('Error:', error); // Log error

                            toast({

                                text: 'Unable to process request!',

                                type: 'warning',

                                duration: 7000

                            });

                        }).finally(() => {

                            command.disabled = false;

                        });


                });

            });

        }

    });

});

// Referral Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#referralForm');

    let button = document.querySelector('#iQ_refer');

    if (form) {

        form.addEventListener("submit", (event) => {

            event.preventDefault();

            let content = button.innerHTML;

            formProcessZero(button);

            // Process Form

            let formData = new FormData(form);

            fetch('../controls/logic/referral-processor.php', {

                method: 'POST',

                body: formData

            })
                .then(response => response.json())
                .then(data => {

                    if (data.refresh) {

                        setTimeout(() => {

                            location.reload();

                        }, 3500);

                    } else {

                        if (data.invalidGuest) {

                            setTimeout(() => {

                                toast({

                                    text: "User exists!",

                                    type: "error",

                                    duration: 7000,

                                });

                                form.reset();

                                formProcessRestore(button, content);

                            }, 2000);

                        } else {

                            if (data.inviteError) {

                                setTimeout(() => {

                                    toast({

                                        text: "An error occurred!",

                                        type: "error",

                                        duration: 7000,

                                    });

                                    formProcessRestore(button, content);

                                    form.reset();

                                }, 2000);

                            } else {

                                if (data.inviteSent) {

                                    setTimeout(() => {

                                        toast({

                                            text: "Invite sent!",

                                            type: "success",

                                            duration: 7000,

                                        });

                                        formProcessRestore(button, content);

                                        form.reset();

                                    }, 2000);

                                } else {

                                    setTimeout(() => {

                                        toast({

                                            text: "Invite not sent!",

                                            type: "error",

                                            duration: 7000,

                                        });

                                        formProcessRestore(button, content);

                                    }, 2000);

                                }

                            }

                        }

                    }

                })
                .catch(error => {

                    console.error('Error:', error);

                    setTimeout(() => {

                        toast({

                            text: "An error occurred!",

                            type: "error",

                            duration: 7000,

                        });

                        formProcessRestore(button, content);

                    }, 2000);

                });

        });

    }

});

// Edit Username Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#edit-tag-form');

    let button = document.querySelector('#edit-tag');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML;

            formProcessZero(button); // Intiate Loading

            let tag = form.querySelector('input[name="new-tag"]');

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('../controls/logic/edit-tag-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    windowe.location.reload();

                } else if (response.invalidTag) {

                    setTimeout(() => {

                        tag.focus(); // Focus On Input

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: `Invalid username. Invalid characters found: '${response.invalidChars}'!`,

                            type: 'warning'

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.lengthError) {

                    setTimeout(() => {

                        tag.focus(); // Focus On Input

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Username nust be at least 3 characters long!',

                            type: 'warning'

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else if (response.tagExists) {

                    setTimeout(() => {

                        tag.focus(); // Focus On Input

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'Username already exists!',

                            type: 'warning',

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                } else {

                    if (response.updated) {

                        setTimeout(() => {

                            popup({

                                header: 'Attention!',

                                title: 'Tag updated Successfully!',

                                text: 'Username updated!',

                                type: 'success',

                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            toast({ // User Feedback

                                text: 'Please, try again!',

                                type: 'error',

                                duration: 7000

                            });

                            formProcessRestore(button, content); // Restore / Stop Animation

                        }, 2000);

                    }

                }

            } catch (error) {

                console.log('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                }, 2000);

            }

        });

    }

});

// UETR Tracker Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#track-uetr-form');

    let button = document.querySelector('#track-uetr');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML;

            formProcessZero(button); // Intiate Loading

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('../controls/logic/uetr-tracker.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.track) {

                    setTimeout(() => {

                        window.open(
                            `${response.trackID}`,
                            'Track Payments',
                            'width=1200,height=1000,resizable=yes,scrollbars=yes,toolbar=no,menubar=no,location=no,status=no'
                        );

                        window.location.reload();

                    }, 2000);

                } else {

                    setTimeout(() => {

                        form.querySelector('input').focus(); // Focus On Input

                        popup({

                            header: 'Attention!',

                            title: 'Error!',

                            text: 'No cross-border transfer attached!',

                            type: 'warning'

                        });

                        formProcessRestore(button, content); // Restore / Stop Animation

                    }, 2000);

                }

            } catch (error) {

                console.log('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content);

                }, 2000);

            }

        });

    }

});

// Authorization Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#authorizeForm');

    let button = document.querySelector('#authorizer');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Form Submission

            let content = button.innerHTML; // Get Button's Text

            formProcessZero(button);

            let formData = new FormData(form); // Collect Form Data

            try {

                // Process Data

                let processor = await fetch('../controls/logic/access-authorization.php', {

                    method: 'POST',

                    body: formData,

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.access) {

                    // User Feedback

                    toast({

                        text: 'Welcome!',

                        type: 'success',

                        duration: 7000

                    });

                    setTimeout(() => { // Delay Redirect & Form Reset

                        window.location.href = `${response.dest}`; // Redirect

                        form.reset(); // Reset Form

                    }, 3000);

                } else {

                    setTimeout(() => { // Delay User Feedback

                        toast({

                            text: 'Access denied!',

                            type: 'warning',

                            duration: 7000

                        });

                    }, 1500);

                    setTimeout(() => { // Delay Page Refresh

                        location.reload(); // Refresh Page

                    }, 3000);

                    
                }

            } catch (error) {

                setTimeout(() => {

                    formProcessRestore(button, content);

                    // User Feedback

                    toast({

                        text: 'Unable to process request!',

                        type: 'error',

                        duration: 7000

                    });

                }, 1200)

                console.error('Error:', error); // Log Error To Console

            }

        });
        
    }

});