const page = document.body;

// Darkmode (Set Theme Based On System Preference)

const root = document.documentElement;

// Apply theme immediately (even before DOMContentLoaded)
function applyTheme() {
    const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
    
    // Check localStorage and system preference
    if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
        root.classList.add('darkmode');
    }
}

// Call `applyTheme` on load without waiting for `DOMContentLoaded`
applyTheme();

// Now, handle theme switching and other DOM manipulations after the page content is loaded
document.addEventListener("DOMContentLoaded", () => {

    const themeSwitches = document.querySelectorAll('.iQ_theme');

    themeSwitches.forEach((themeSwitch) => {

        themeSwitch.addEventListener("click", function() {
            theme();
            indicator(); // Update indicator after theme change
        });

    });

    // Call indicator on load to set initial state
    indicator();
});

function theme() {
    const themeSwitches = document.querySelectorAll('.iQ_theme');

    themeSwitches.forEach((themeSwitch) => {
        themeSwitch.classList.add('spin');
        
        if (themeSwitch.querySelector('.icon')) {
            themeSwitch.querySelector('.icon').classList.add('spin');

            setTimeout(() => {
                themeSwitch.querySelector('.icon').classList.remove('spin');
            }, 1000);
        }

        setTimeout(() => {
            themeSwitch.classList.remove('spin');
        }, 1000);
    });

    if (root.classList.contains('darkmode')) {
        root.classList.remove('darkmode');
        localStorage.setItem('pageClass', '');
    } else {
        root.classList.add('darkmode');
        localStorage.setItem('pageClass', 'darkmode');
    }
}

function indicator() {
    const themeIndLight = document.querySelector('.lmde');
    const themeIndDark = document.querySelector('.dmde');

    if (themeIndDark && themeIndLight) {
        if (root.classList.contains('darkmode')) {
            themeIndDark.classList.add('active');
            themeIndLight.classList.remove('active');
        } else {
            themeIndDark.classList.remove('active');
            themeIndLight.classList.add('active');
        }
    }
}

// Typing Effect

let isTyping = false;

function typeText(element, text, speed) {
    if (isTyping) return; // Prevent multiple simultaneous typing calls

    isTyping = true; // Mark as typing
    // let element = document.getElementById(id);
    element.innerHTML = '';
    let i = 0;

    function type() {
        if (i < text.length) {
            element.textContent += text.charAt(i);
            i++;
            setTimeout(type, speed);
        } else {
            isTyping = false; // Finished typing
        }
    }

    type(); // Start typing
}

// Support Popup Typer

document.addEventListener("DOMContentLoaded", () => {

    let commands = document.querySelectorAll('[iQ-target="#iQ-help"]');

    let space = document.querySelector('#pseudoTyper');

    if (commands.length > 0 && space) {

        commands.forEach(command => {

            command.addEventListener("click", () => {

                setTimeout(() => {

                    // let space = document.querySelector('#pseudoTyper');
                    // if (!space) {
                    // console.warn('#pseudoTyper element missing!');
                    // return;
                    // }

                    let texts = [
                        "Need assistance?", 
                        "How can we be of help?", 
                        "Have a question?", 
                        "Check out our help resources"
                    ];
                
                    // Select a random text from the array
                    let text = texts[Math.floor(Math.random() * texts.length)];
                
                    // Call the typeText function with the selected random text
                    typeText(space, text, 150);
                    
                }, 1500);

            });

        });

    }

});

// Aux Sidebar

document.addEventListener("DOMContentLoaded", () => {

    let trigger = document.querySelector('.aux_device');

    let pane = document.querySelector('.aux_sidebar');

    if (trigger && pane) {

        trigger.addEventListener("click", () => {

            pane.classList.toggle('n_displ');

            pane.classList.toggle('access');

            trigger.classList.toggle('access');

        });

    }

});

// Radio Input Helper

document.addEventListener("DOMContentLoaded", () => {

    let helpers = document.querySelectorAll('.iQ_radio');

    if (helpers) {

        helpers.forEach((helper) => {

            let radio = helper.querySelector('input[type="radio"]');

            helper.addEventListener("click", () => {

                radio.checked = true;

            });

        });

    }

});

// Checkbox Input Helper

document.addEventListener("DOMContentLoaded", () => {

    let helpers = document.querySelectorAll('.iQ_check');

    if (helpers) {

        helpers.forEach((helper) => {

            let checkbox = helper.querySelector('input[type="checkbox"]');

            helper.addEventListener("click", (e) => {

                if (e.target !== checkbox) {

                    checkbox.checked = !checkbox.checked;

                }

            });

        });

    }

});

// Number Only Fields

document.addEventListener("DOMContentLoaded", () => {

    numberOnlyFields();
    
});

function numberOnlyFields() {

    let fields = document.querySelectorAll('.iQ_fieldNum');

    if (fields.length > 0) {
        fields.forEach((field) => {

            field.setAttribute('type', 'tel');
            field.setAttribute('inputmode', 'numeric');
            field.setAttribute('pattern', '[0-9]*');

            field.addEventListener("input", (event) => {
                const cleanValue = event.target.value.replace(/\D/g, '');
                if (cleanValue !== event.target.value) {
                    // Invalid characters were removed
                    event.target.value = cleanValue;
                    // Optionally, show a warning or shake effect here
                }
            });

            field.addEventListener("keydown", (event) => {
                const allowedKeys = [
                    'Backspace',
                    'Delete',
                    'Tab',
                    'ArrowLeft',
                    'ArrowRight',
                    'Home',
                    'End',
                ];

                // Allow: control keys, digits, and Ctrl+V
                const isDigit = /^[0-9]$/.test(event.key);
                const isAllowedKey = allowedKeys.includes(event.key);
                const isCtrlV = event.ctrlKey && event.key.toLowerCase() === 'v';
                const isEnter = event.key === 'Enter';

                if (
                    !isDigit &&
                    !isAllowedKey &&
                    !isCtrlV &&
                    !isEnter
                ) {
                    event.preventDefault();
                }
            });
        });
    }

}


// OTP Fields

document.addEventListener("DOMContentLoaded", function() {

    jumpFields();

});

function jumpFields() {

    const inputs = document.querySelectorAll('.iQ_field');

    if (inputs) {

        inputs.forEach((input, index) => {
            input.addEventListener('input', (event) => {
                const value = event.target.value;

                // Handle pasting
                if (value.length > 1) {
                    const characters = value.split('');

                    characters.forEach((char, charIndex) => {
                        if (index + charIndex < inputs.length) {
                            inputs[index + charIndex].value = char;
                        }
                    });

                    // Move focus to the last filled input
                    const lastFilledInputIndex = Math.min(index + characters.length, inputs.length - 1);
                    inputs[lastFilledInputIndex].focus();
                } else {
                    // Jump to the next input if a single character is entered
                    if (value && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                }
            });

            input.addEventListener('keydown', (event) => {
                // Handle backspace
                if (event.key === 'Backspace' && !input.value && index > 0) {
                    inputs[index - 1].focus();
                }
            });
        });

        // Handle pasting multiple characters
        inputs.forEach((input) => {
            input.addEventListener('paste', (event) => {
                event.preventDefault();
                const pasteData = (event.clipboardData || window.clipboardData).getData('text');

                if (pasteData.length > 0 && !isNaN(pasteData)) {
                    const characters = pasteData.split('');
                    characters.forEach((char, index) => {
                        if (index < inputs.length) {
                            inputs[index].value = char;
                        }
                    });

                    // Focus the last filled input
                    inputs[Math.min(characters.length, inputs.length) - 1].focus();
                }
            });
        });
    
    }

}

// Pseudo Fields Active State

document.addEventListener("DOMContentLoaded", function() {

    let pseudoFields = document.querySelectorAll('.pseudoField');

    let fields = document.querySelectorAll('.pseudoField input');

    if (pseudoFields && fields) {

        for (let i = 0; i < fields.length; i++) {

            fields[i].addEventListener("focus", function() {

                pseudoFields[i].classList.add('active');

            });

            fields[i].addEventListener("focusout", function() {

                pseudoFields[i].classList.remove('active');

            });

        }    

    }    

});

// Password Veil

document.addEventListener("DOMContentLoaded", function() {

    let concealer = document.querySelectorAll('.iQ_veiler');

    let field = document.querySelectorAll('.iQ_veilField');

    if (concealer && field) {

        for (let i = 0; i < concealer.length; i++) {

            concealer[i].addEventListener("click", function() {

                if (field[i].type == 'password') {

                    field[i].type = 'text';

                    concealer[i].classList.add('active');

                } else {

                    field[i].type = 'password'

                    concealer[i].classList.remove('active');

                }

            });

        }

    }    

});

// Balance Veil

document.addEventListener("DOMContentLoaded", function() {

    let veilActvtr = document.querySelector('#iQ_veil');

    let itemVeil = document.getElementsByClassName('acct_desc');

    if (veilActvtr && itemVeil) {

        let originalTexts = []; // Save Original Content

        for (var i = 0; i < itemVeil.length; i++) {

            originalTexts[i] = itemVeil[i].innerHTML;

        }

        veilActvtr.addEventListener("click", veil);

        function veil() {

            for (var i = 0; i < itemVeil.length; i++) {

                let veilItems = itemVeil[i];

                if (!(veilItems.classList.contains('veil'))) {

                    veilItems.innerHTML = "<b style=\"font-family: var(--subFont); font-size: 1.5rem; color: var(--pg-txt); text-align: center; letter-spacing: 0.2em\">******</b>";

                    veilItems.classList.add('veil');

                    veilActvtr.classList.add('active');

                    localStorage.setItem('veilActvtrState', 'active')

                } else {

                    veilItems.innerHTML = originalTexts[i];

                    veilItems.classList.remove('veil');

                    veilActvtr.classList.remove('active');

                    localStorage.setItem('veilActvtrState', null)


                }

            }

        }

        function veilRecall() {

            if (localStorage.veilActvtrState != undefined) {

                veilActvtr.classList.add(localStorage.getItem('veilActvtrState'));

            }

            if (veilActvtr.classList.contains('active')) {

                for (var i = 0; i < itemVeil.length; i++) {

                    originalTexts[i] = itemVeil[i].innerHTML;
            
                }

                for (var i = 0; i < itemVeil.length; i++) {

                    let veilItems = itemVeil[i];

                    veilItems.classList.add('veil');

                    veilItems.innerHTML = "<b style=\"font-family: var(--subFont); font-size: 1.5rem; color: var(--pg-txt); text-align: center; letter-spacing: 0.2em\">******</b>";
            
                }
            
            }

        }

        window.addEventListener("load", veilRecall);

    }    

});

// Mobile Nav

document.addEventListener("DOMContentLoaded", function() {

    let navToggle = document.querySelector('.mobile_ctrl');

    let dashGrid  = document.querySelector('.dash_grid');

    let sidebar = document.querySelector('.dash_sidebar');

    let dashCon = document.querySelector('.dash_con');

    let appMenu = document.querySelector('#mobile-appMenu');

    if (navToggle && sidebar && dashGrid && dashCon && appMenu) {

        navToggle.addEventListener("click", () => {

            let elements = [page, navToggle, dashGrid, sidebar, dashCon];

            const isAccess = sidebar.classList.contains('access');

            elements.forEach(element => {

                if (isAccess) {
                    
                    element.classList.remove('access');
                    
                } else {
                    
                    element.classList.add('access');
                    
                }
                
            });

            if (isAccess) {
                
                appMenu.classList.remove('n_displ');
            
            } else {
                
                appMenu.classList.add('n_displ');
                
            }


        })

    }

});

// App Menu

document.addEventListener("DOMContentLoaded", () => {

    let menu = document.querySelector('#mobile-appMenu');

    if (menu) {

        menuMonitor();

        let maximizer = menu.querySelector('.maximizer_device');

        if (maximizer) {

            maximizer.addEventListener("click", () => {

                menu.classList.toggle('max');

                menuMonitor();

            });

        }

        function menuMonitor() {

            if (menu.classList.contains('max')) {

                page.classList.add('deactivate'); // Activate Scroll Lock

            } else {

                page.classList.remove('deactivate'); // Deactivate Scroll Lock

            }

            const observer = new MutationObserver(() => {

                if (menu.classList.contains('max')) {

                    page.classList.add('deactivate'); // Activate Scroll Lock
    
                } else {
    
                    page.classList.remove('deactivate'); // Deactivate Scroll Lock
    
                }

            });

            observer.observe(menu, {

                attributes: true, attributeFilter: ['class']

            });

        }

    }
    
});

// Sticky Nav Color Change

// Salutation / Logo Swap

document.addEventListener("DOMContentLoaded", () => {
    // Handle nav scroll effect
    const nav = document.querySelector('.dash_hbanner');

    const handleScroll = () => {
        const y = window.scrollY;
        if (nav) {
            nav.classList.toggle('scrolled', y > 0);
        }

        // Handle salutation/logo swap
        const targets = document.querySelectorAll('.jaQ'); // Use correct class selector
        targets.forEach(target => {
            target.classList.toggle('swap', y > 0);
        });
    };

    // Run once on load
    handleScroll();

    // Attach scroll listener
    window.addEventListener('scroll', handleScroll);
});


// User Profile Popup Menu

document.addEventListener("DOMContentLoaded", function() {

    let mNavButton = document.querySelector('.mobile_ctrl');

    let profilePopper = document.querySelector('.user_profile');

    let profilePopup = document.getElementById('profile_popup');

    if (mNavButton && profilePopper && profilePopup) {

        profilePopper.addEventListener("click", pop);
            
        mNavButton.addEventListener("click", terminate);

        document.getElementById('dashMain').addEventListener("click", terminate);

        document.getElementById('dashSidebar').addEventListener("click", terminate);

        function pop() {

            profilePopup.classList.toggle('n_displ');

        }

        function terminate() {

            if (!(profilePopup.classList.contains('n_displ'))) {

                profilePopup.classList.add('n_displ');

            }

        }

    }

});

// Nice Select Autofocus

document.addEventListener("DOMContentLoaded", function() {

    let autofocusField = document.querySelector('.form_field.nice-select.iQ_focus');

    function iQFocus() {

        autofocusField.focus();

    }

    if (autofocusField) {

        window.addEventListener("load", iQFocus);

    }

});

// Panel Nav System

document.addEventListener("DOMContentLoaded", () => {
    
    // Handle grouped panels inside .iQ_panels
    document.querySelectorAll('.iQ_panels').forEach(group => {
        setupPanelGroup(group.querySelectorAll('.iQ_panelSwitch'), group.querySelectorAll('.iQ_panel'));
    });

    // Handle ungrouped panels on the page (outside .iQ_panels)
    const ungroupedTriggers = Array.from(document.querySelectorAll('.iQ_panelSwitch')).filter(trigger => !trigger.closest('.iQ_panels'));
    const ungroupedPanels = Array.from(document.querySelectorAll('.iQ_panel')).filter(panel => !panel.closest('.iQ_panels'));

    if (ungroupedTriggers.length && ungroupedPanels.length) {
        setupPanelGroup(ungroupedTriggers, ungroupedPanels, true);
    }

    function setupPanelGroup(triggers, panels) {
        if (!triggers.length || !panels.length) return;

        // Convert NodeList to Array for indexOf
        const triggersArray = Array.from(triggers);

        // Hide all panels and remove all active triggers
        panels.forEach(p => p.classList.add('n_displ'));
        triggersArray.forEach(t => t.classList.remove('active'));

        // URL tab match (works for all groups)
        const urlTab = new URLSearchParams(window.location.search).get("tab");
        const matchTrigger = urlTab ? triggersArray.find(t => t.dataset.tab === urlTab) : null;
        const initialIndex = matchTrigger ? triggersArray.indexOf(matchTrigger) : 0;

        // Show the matched or first panel by default
        panels[initialIndex].classList.remove('n_displ');
        panels[initialIndex].classList.add('fade');
        triggersArray[initialIndex].classList.add('active');

        // Click listener for each trigger
        triggersArray.forEach((trigger, index) => {
            trigger.addEventListener('click', () => {
                if (trigger.classList.contains('active')) return;

                triggersArray.forEach(t => t.classList.remove('active'));
                trigger.classList.add('active');

                const tabId = trigger.dataset.tab;
                panels.forEach((panel, i) => {
                    const match = tabId ? (panel.id === tabId) : (i === index);
                    panel.classList.toggle('n_displ', !match);
                    panel.classList.toggle('fade', match);
                });

                // Always update URL if data-tab exists
                if (tabId) {
                    const url = new URL(window.location);
                    url.searchParams.set('tab', tabId);
                    window.history.pushState({}, '', url);
                }
            });
        });
    }


});

// PAY ~ Others Form Hidden Radio Selector

document.addEventListener("DOMContentLoaded", function() {
    let selectors = document.querySelectorAll('.opt_btn');

    selectors.forEach((selector) => {
        // Check if the radio button is checked initially
        if (selector.querySelector('input[type="radio"]').checked) {
            selector.classList.add('selected');
        }

        selector.addEventListener("click", function() {
            // Uncheck all radio buttons and remove 'selected' class from all
            selectors.forEach((s) => {
                s.querySelector('input[type="radio"]').checked = false;
                s.classList.remove('selected');
            });

            // Check the clicked radio button and add 'selected' class
            selector.querySelector('input[type="radio"]').checked = true;
            selector.classList.add('selected');
        });
    });
});

// PAY ~ Others Form Data Transfer System

document.addEventListener('DOMContentLoaded', function() {
    // Get all .deliver-data elements
    const deliverDataElements = document.querySelectorAll('.deliver-data');

    deliverDataElements.forEach(element => {
        element.addEventListener('click', function() {
            // Get the data from the clicked element
            const qrData = element.querySelector('.qr-data').value;
            const attrData = element.querySelector('.attr-data').value;
            const dataType = element.querySelector('.data-type').getAttribute('data-id');

            // Update the popup window
            document.getElementById('data-icon-receiver').src = '';
            document.querySelector('#qr-displ img').src = qrData;
            document.getElementById('data-addr-receiver').value = attrData;
            document.querySelectorAll('.asset-data-receiver').forEach((dataRec) => {

                if (dataType == 'GPAY') {

                    dataRec.textContent = 'GOOGLE PAY'

                } else {

                    dataRec.textContent = dataType;

                }

            });
            
        });
    });
});

// PAY ~ Radio Scroll Trigger

if (document.querySelector('form.payForm')) {

    function scrollToSubmitButton(event) {
        const form = event.target.closest('form.payForm'); // Get the closest form to the clicked radio
        const submitButton = form.querySelector('.form_btn'); // Find the submit button in that form
        submitButton.scrollIntoView({ behavior: 'smooth' }); // Smooth scroll to the button
    }
    
    // Add event listeners to all radio buttons
    document.querySelectorAll('input[type="radio"]').forEach(radio => {
        radio.addEventListener('click', scrollToSubmitButton);
    });
    

}

// Copy Fxn

document.querySelectorAll('.copy').forEach(copyButton => {
    copyButton.addEventListener('click', function() {
        // Find the corresponding .field element
        const field = this.previousElementSibling;
        if (field && field.classList.contains('field')) {
            // Copy the text content
            const textToCopy = field.textContent;
            navigator.clipboard.writeText(textToCopy).then(() => {
                console.log('Text copied to clipboard:', textToCopy);
            }).catch(err => {
                console.error('Failed to copy text:', err);
            });
        }
    });
});

document.addEventListener("DOMContentLoaded", function () {
    let copyBtn = document.getElementsByClassName('copier');
    let copyField = document.getElementsByClassName('copyField');

    for (let i = 0; i < copyBtn.length; i++) {
        copyBtn[i].addEventListener("click", function() {
            // Copy the content of the input field
            const textToCopy = copyField[i].value;
            navigator.clipboard.writeText(textToCopy).then(() => {
                console.log('Text copied to clipboard:', textToCopy);
                let initialContent = copyBtn[i].innerHTML;
                copyBtn[i].textContent = 'COPIED';
                copyBtn[i].classList.add('copied');
                setTimeout(() => {

                    copyBtn[i].innerHTML = initialContent;

                    copyBtn[i].classList.remove('copied');

                }, 3000);
            }).catch(err => {
                console.error('Failed to copy text:', err);
            });
        });
    }
});

// Pay Security Popup

document.addEventListener("DOMContentLoaded", () => {

    let popup = document.querySelector('#iQ_payTip');

    if (popup) {

        let popupCon = popup.querySelector('.popup_con')

        setTimeout(() => {

            popup.classList.replace("n_displ", "fade_in");

            popupCon.classList.replace("n_displ", "float_up");

            document.body.classList.add('deactivate');

        }, 1000);

    }
    
});

// Range ~ `.iQ_range`

document.addEventListener("change", async () => {

    let ranges = document.querySelectorAll('input.iQ_range[type="range"]');

    let displays = document.querySelectorAll('.iQ_rangeValue');

    if (ranges && displays) {

        ranges.forEach((range, index) => {
            
            range.addEventListener("input", () => {

                displays[index].textContent = range.value;

            });

            displays[index].textContent = range.value;

        });

    }

});


// Data Transfer System

document.addEventListener('DOMContentLoaded', function() {
    var transferButtons = document.querySelectorAll('.transferer');

    transferButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            // Get the parent container of the clicked button
            var parent = button.closest('.txbox');

            // Get the values from the hidden inputs within the same parent container
            var dataA = parent.querySelector('.transfer-data').value;
            var dataB = parent.querySelector('.transfer-dataB').value;
            var dataC = parent.querySelector('.transfer-dataC').value;

            // Set the values to the corresponding receivers
            document.getElementById('data-receiver').value = dataA;
            document.getElementById('data-receiverB').value = dataB;
            document.getElementById('data-receiverC').value = dataC;
        });
    });

    // File Reader

    if (document.getElementById('proof-file')) {
        document.getElementById('proof-file').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const displ = document.getElementById('proof-displ');
                displ.innerHTML = ''; // Clear the previous content
    
                const reader = new FileReader();
                reader.onload = function(e) {
                    const fileExtension = file.name.split('.').pop().toLowerCase();
    
                    if (fileExtension === 'pdf') {
                        // If it's a PDF, render it using PDF.js
                        const pdfData = e.target.result;
                        const loadingTask = pdfjsLib.getDocument(pdfData);
                        loadingTask.promise.then(function(pdf) {
                            pdf.getPage(1).then(function(page) {
                                const canvas = document.createElement('canvas');
                                const context = canvas.getContext('2d');
                                const scale = 1.5;
                                const viewport = page.getViewport({ scale: scale });
                                
                                canvas.height = viewport.height;
                                canvas.width = viewport.width;
    
                                page.render({
                                    canvasContext: context,
                                    viewport: viewport
                                }).promise.then(function() {
                                    displ.appendChild(canvas);
                                });
                            });
                        }).catch(function(error) {
                            console.error('Error loading PDF:', error);
                        });
                    } else {
                        // If it's an image, display it as before
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        displ.appendChild(img);
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }

});

// Data Transfer System V2

document.addEventListener("DOMContentLoaded", () => {
    // Function to handle the data transfer
    const handleDataTransfer = (event) => {
    //     // Find the closest .form_item element
        const formItem = event.target.closest('.data-con');

        // Retrieve the data from the form item
        const assetName = formItem.querySelector('.data-asset').value;
        const assetIcon = formItem.querySelector('.data-icon').src;
        const walletAddress = formItem.querySelector('.data-addr').value;
        const walletQrCode = formItem.querySelector('.data-qr').value;

        // Update the popup elements
        document.querySelectorAll('.asset-data-receiver').forEach(el => el.textContent = assetName);
        document.querySelector('#data-icon-receiver').src = assetIcon;
        document.querySelector('#data-addr-receiver').value = walletAddress;
        document.querySelector('#qr-displ img').src = walletQrCode;

    };

    // Attach event listeners to all .data-sender elements
    document.querySelectorAll('.data-sender').forEach(element => {
        element.addEventListener('click', handleDataTransfer);
    });
});

// Data Transfer System V3

document.addEventListener('DOMContentLoaded', function() {
    var senderButtons = document.querySelectorAll('.send-data');

    senderButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            // Get the parent container of the clicked button
            var parent = button.closest('.txbox');

            // Get the values from the hidden inputs within the same parent container
            var dataA = parent.querySelector('.data-A').value;
            var dataB = parent.querySelector('.data-B').value;
            var minValue = parent.querySelector('.dataC1').value;
            var maxValue = parent.querySelector('.data-C2').value;

            // Set the values to the corresponding receivers
            document.getElementById('get-A').value = dataA;
            document.getElementById('get-B').value = dataB;
            document.getElementById('get-C').value = ''; // Clear previous value
            document.getElementById('get-C').setAttribute('min', minValue);
            document.getElementById('get-C').setAttribute('max', maxValue);

            // Debugging log
            console.log("dataA: " + dataA + ", dataB: " + dataB + ", dataC1: " + minValue + ", dataC2: " + maxValue);
        });
    });
});    

// Data Transfer System V4
            
document.addEventListener('DOMContentLoaded', function() {
    // Get all the radio buttons
    const dataSenders = document.querySelectorAll('.data-sender');

    dataSenders.forEach(function(sender) {
        sender.addEventListener('change', function() {
            // Find the closest .form_item and then the .asset-qty input
            const assetQty = this.closest('.form_item').querySelector('.asset-qty').value;
            
            // Set the value to the #data-qty element
            document.getElementById('data-qty').value = assetQty;
        });
    });
});

// Progress Fluid

document.addEventListener("DOMContentLoaded", function() {

    let tracks = document.querySelectorAll('.iQ_track');

    const preloader = document.getElementById('preloader');

    tracks.forEach(track => {

        let targetWidth = track.style.width;

        track.style.width = '0';

        if (preloader) {

            setTimeout(() => {

                track.classList.add('progress');

                track.style.width = targetWidth;

            }, 5500);

        } else {

            setTimeout(() => {

                track.classList.add('progress');

                track.style.width = targetWidth;

            }, 500);

        }

    });

});

// PORTFOLIO ~ Format Currency Display

document.addEventListener("DOMContentLoaded", () => {

    let amts = document.querySelectorAll('.iQ_amt');

    if (amts) {
        
        amts.forEach(function(amt) {
            const span = amt.querySelector('.txSmall');
            const text = span.innerText.trim();
        
            // Match any non-digit characters at the start, digits, and optional decimal part
            const match = text.match(/^([^0-9]*)([0-9,]+)(.*)$/);
            if (match) {
                const prefix = match[1]; // e.g., $, #, or any non-digit characters
                const number = match[2]; // e.g., 100,000,000
                const suffix = match[3]; // e.g., .00 or any remaining characters
        
                // Modify the inner HTML
                span.innerHTML = `${prefix}<span class='txLarge'>${number}</span>${suffix}`;
            }
        });

    }

});

// Popup Engine Initialization

document.addEventListener("DOMContentLoaded", () => {

    popupScrollLock();

    attachPopup();

});

function attachPopup() {

    const triggers = document.querySelectorAll('[iQ-target]');

    const terminators = document.querySelectorAll('.iQ_terminator');

    if (triggers.length > 0) {

        triggers.forEach(trigger => {

            const identifier = trigger.getAttribute('iQ-target');

            if (identifier != '') {

                const popup = document.querySelector(`${identifier}`); 

                if (popup) {

                    let popupWindow = popup.closest('.popup_window');

                    const writer = popup.querySelector('#pseudoTyper');

                    trigger.addEventListener("click", () => {

                        popupWindow.classList.replace('n_displ', 'fade_in');

                        setTimeout(() => {

                            popup.classList.replace('n_displ', 'float_up');

                        }, 700);

                        if (writer) {

                            setTimeout(() => {

                                let texts = [
                                    "Need assistance?", 
                                    "How can we be of help?", 
                                    "Have a question?", 
                                    "Check out our help resources"
                                ];

                                let text = texts[Math.floor(Math.random() * texts.length)];

                                typeText('pseudoTyper', text, 150);

                            }, 1500);

                            popupScrollLock();

                        }

                    });

                }

            }    

        });

    }

    if (terminators.length > 0) {

        terminators.forEach(terminator => {

            const popupWindow = terminator.closest('.popup_window');

            if (popupWindow) {

                const forms = popupWindow.querySelectorAll('form');

                const proofView = popupWindow.querySelector('#proof-displ');

                terminator.addEventListener("click", () => {

                    setTimeout(() => {

                        // popupWindow.classList.replace('fade_in', 'n_displ');

                        popupWindow.classList.remove('fade_in');

                        popupWindow.classList.add('n_displ');
    
                        if (forms.length > 0) {
    
                            forms.forEach(form => {
    
                                form.reset();
    
                            });
    
                        }
    
                        if (proofView) {
    
                            proofView.innerHTML = '';
    
                        }
    
                        popupScrollLock();

                        // menuScrollLock();
    
                    }, 500);

                });

            }    

        });

    }

}

function popupScrollLock() {
    // const page = document.querySelector('.page'); // Update with correct selector

    // if (!page) return; // Fail-safe

    const popupWindows = document.querySelectorAll('.popup_window');
    const appMenu = document.querySelector('#mobile-appMenu');
    const notfWindow = document.querySelector('#notification-window');

    const checkLockState = () => {
        const anyPopupVisible = Array.from(popupWindows).some(p => !p.classList.contains('n_displ'));

        if (
            anyPopupVisible ||
            (appMenu && appMenu.classList.contains('max')) ||
            (notfWindow && !notfWindow.classList.contains('n_displ'))
        ) {
            page.classList.add('deactivate');
        } else {
            page.classList.remove('deactivate');
        }
    };

    // Initial check
    checkLockState();

    // Set up observers for each popup window
    popupWindows.forEach(popup => {
        const observer = new MutationObserver(checkLockState);

        observer.observe(popup, {
            attributes: true,
            attributeFilter: ['class']
        });
    });

    // Optional: observe appMenu and notfWindow as well if their visibility affects scroll lock
    if (appMenu) {
        new MutationObserver(checkLockState).observe(appMenu, {
            attributes: true,
            attributeFilter: ['class']
        });
    }

    if (notfWindow) {
        new MutationObserver(checkLockState).observe(notfWindow, {
            attributes: true,
            attributeFilter: ['class']
        });
    }
}

// Table Functions

document.addEventListener("DOMContentLoaded", function() {
    let tableCon = document.getElementsByClassName('table_con');
    let tableContent = [];

    // Store the original content of each table_con element
    for (let i = 0; i < tableCon.length; i++) {
        tableContent[i] = tableCon[i].innerHTML;
    }

    function Skeleton(index) {
        // Replace content with skeleton loader for the specific tableCon element
        tableCon[index].innerHTML = `
            <table class="skeleton">
                <thead>
                    <tr>
                        <th><span class="skeleton_cell"></span></th>
                        <th><span class="skeleton_cell"></span></th>
                        <th><span class="skeleton_cell"></span></th>
                        <th><span class="skeleton_cell"></span></th>
                        <th><span class="skeleton_cell"></span></th>
                        <th><span class="skeleton_cell"></span></th>
                    </tr>
                </thead>
                <tbody>
                    ${Array(5).fill('<tr>' + Array(6).fill('<td><span class="skeleton_cell"></span></td>').join('') + '</tr>').join('')}
                </tbody>
            </table>`;

        // Restore original content and reinitialize after a delay
        setTimeout(() => {
            tableCon[index].innerHTML = tableContent[index];
            jointHolderPopup();
            deleteJointUser();
            transactionReceipt();
            loanDetails();
            loanRepayments();
            transactionDetails();
            manageBeneficiary();
            deleteInvoice();
            mailInvoice();
            deleteCustomer();
            attachPopup(); // Reinitialize popups
            applyTableBreak(`#table-${index + 1}`, index); // Reapply pagination
        }, 3500);
    }

    // Intersection Observer to trigger Skeleton() when the element is in view
    const observerOptions = {
        root: null, // Use the viewport as the root
        rootMargin: '0px',
        threshold: 0.1 // Trigger when 10% of the element is visible
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                // Trigger the Skeleton function for the visible element
                const index = Array.from(tableCon).indexOf(entry.target);
                if (index !== -1) {
                    Skeleton(index); // Call Skeleton for the visible element
                }
                observer.unobserve(entry.target); // Stop observing after first trigger
            }
        });
    }, observerOptions);

    // Observe each tableCon element
    for (let i = 0; i < tableCon.length; i++) {
        observer.observe(tableCon[i]);
    }

    function applyTableBreak(tableSelector, index) {
        const rows = document.querySelectorAll(`${tableSelector} .iQ_tRow`);
        const rowsPerPage = 7;
        let currentPage = 1;
    
        function showPage(page) {
            const start = (page - 1) * rowsPerPage;
            const end = start + rowsPerPage;
    
            // Hide all rows and only show the selected page's rows
            rows.forEach((row, idx) => {
                if (idx >= start && idx < end) {
                    row.classList.remove('n_displ');
                } else {
                    row.classList.add('n_displ');
                }
            });
    
            // Disable/enable pagination buttons
            const prevButton = document.querySelector(`${tableSelector} .prevPage`);
            const nextButton = document.querySelector(`${tableSelector} .nextPage`);
    
            if (prevButton) prevButton.disabled = page === 1;
            if (nextButton) nextButton.disabled = end >= rows.length;
        }
    
        function changePage(newPage) {
            currentPage = newPage; // Update current page
            // Skeleton(index); // Show the skeleton loader
    
            setTimeout(() => {
                showPage(currentPage); // Show the new page after the skeleton
            }, 500); // Adjust timeout duration if needed
        }
    
        // Set up event listeners for pagination buttons
        const prevButton = document.querySelector(`${tableSelector} .prevPage`);
        const nextButton = document.querySelector(`${tableSelector} .nextPage`);
    
        if (prevButton) {
            prevButton.addEventListener('click', function() {
                if (currentPage > 1) {
                    changePage(currentPage - 1); // Go to the previous page
                }
            });
        }
    
        if (nextButton) {
            nextButton.addEventListener('click', function() {
                if (currentPage * rowsPerPage < rows.length) {
                    changePage(currentPage + 1); // Go to the next page
                }
            });
        }
    
        showPage(currentPage); // Initial display
    }    

    // Call this function for each table on your page
    for (let i = 0; i < tableCon.length; i++) {
        applyTableBreak(`#table-${i + 1}`, i); // Ensure to set the appropriate selector and index
    }

    // Function to handle AJAX requests For Joint Holder Management
    function jointHolderPopup() {
        let requesterCons = document.querySelectorAll('.iQ_rqustCon');

        requesterCons.forEach((requesterCon) => {
            let requesterField = requesterCon.querySelector('input[type="hidden"]');
            let requester = requesterCon.querySelector('.iQ_rqust');
            const formA = document.querySelector('#personal-form-holder');
            const formB = document.querySelector('#banking-form-holder');

            requester.addEventListener("click", function() {
                if (requesterField && requester) {

                    let requestData = requesterField.value;

                    // Make the AJAX request to fetch.php
                    fetch('../controls/logic/build-joint-holder-popup.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `id=${encodeURIComponent(requestData)}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.refresh || data.holderError) {
    
                            window.location.reload();
                    
                        } else if (data.accError) {
                            
                            toast({

                                text: 'Account(s) error!',

                                type: 'warning',

                                duration: 1500

                            });

                            setTimeout(() => {

                                window.location.reload();

                            }, 2500);

                        } else if (data.strt) {

                            const personal = data.strt.personal;
                            const banking = data.strt.banking;

                            if (personal && formA) {
                                formA.querySelector('input[name="tpy-id"]').value = personal.id;
                                formA.querySelector('input[name="fname"]').value = personal.firstname;
                                formA.querySelector('input[name="mname"]').value = personal.middlename;
                                formA.querySelector('input[name="lname"]').value = personal.lastname;
                                formA.querySelector('input[name="email"]').value = personal.email;

                                if (personal.gender) {
                                    const genderInput = formA.querySelector(`input[name="gender"][value="${personal.gender}"]`);
                                    if (genderInput) genderInput.checked = true;
                                }

                                if (personal.title) {
                                    const titleInput = formA.querySelector(`input[name="title"][value="${personal.title}"]`);
                                    if (titleInput) titleInput.checked = true;
                                }
                            }

                            if (banking && formB) {
                                formB.querySelector('input[name="tpy-id"]').value = personal.id;
                                formB.querySelector('select[name="account-status"]').value = banking.status;

                                // NiceSelect.update(formB.querySelector('select[name="account-status"]'));
   
                                formB.querySelector('input[name="wth-limit"]').value = banking.wthLimit;
                                formB.querySelector('input[name="trans-limit"]').value = banking.transLimit;
                                formB.querySelector('input[name="trans-count"]').value = banking.transCount;

                                // Uncheck all checkboxes first
                                const barredCheckboxes = formB.querySelectorAll('input[name="barred[]"]');
                                barredCheckboxes.forEach(cb => cb.checked = false);

                                // Check barred checkboxes
                                if (Array.isArray(banking.barred)) {
                                    banking.barred.forEach(currency => {
                                        const checkbox = formB.querySelector(`input[name="barred[]"][value="${currency}"]`);
                                        if (checkbox) checkbox.checked = true;
                                    });
                                }
                            }

                        } else {
                            console.log('No recognizable data property found.');
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching data:', error);
                    });
                }
            });
        });
    }

    // Initial call to set up the listeners for transaction details
    jointHolderPopup();

    // Function to handle AJAX requests For Joint Holder Deletion

    function deleteJointUser() {

        let modules = document.querySelectorAll('.delete-joint-user');

        modules.forEach((module) => {

            let command = module.querySelector('.iQ_rqust');

            let field = module.querySelector('input[type="hidden"]');

            // let row = module.closest('tr');

            if (command && field) {

                command.addEventListener("click", () => {

                    popup({

                        header: 'Attention!',

                        title: 'Confirm Action!',

                        text: 'Are you sure you want to delete this joint user?',

                        type: 'warning',

                        showConfirmBtn: true

                    }).then(confirmed => {

                        if (confirmed) {

                            // Initiate AJAX Request

                            fetch('../controls/logic/delete-joint-user.php', {

                                method: 'POST',

                                headers: {

                                    'Content-Type': 'application/x-www-form-urlencoded'

                                },

                                body: `id=${encodeURIComponent(field.value)}`

                            }) // Request Handler, Credentials (Processor)
                            .then(response => response.json()) // Parse JSON Response
                            .then(data => {

                                // Handle Response

                                if (data.deleted) {

                                    // row.remove();

                                    popup({

                                        header: 'Attention!',

                                        title: 'Joint holder deleted.',

                                        text: '',

                                        type: 'checked',

                                    }).then(() => {

                                        window.location.reload();

                                    });

                                } else {

                                    popup({

                                        header: 'Error!',

                                        title: 'An error occurred.',

                                        text: 'Joint holder not deleted, try again',

                                        type: 'failure',

                                    });

                                }

                            })
                            .catch(error => {

                                // Handle Error

                                console.error('Error:', error); // Log Error

                                toast({

                                    text: 'An error occurred',

                                    type: 'error',

                                    duration: 2500

                                });

                            });

                        }

                    });

                });

            }    

        });

    }

    deleteJointUser(); // Initial Call

    // Function to handle AJAX requests for transaction Receipt

    function transactionReceipt() {
        let requesterCons = document.querySelectorAll('.iQ_rqustCon2');

        requesterCons.forEach((requesterCon) => {
            let requesterField = requesterCon.querySelector('input[type="hidden"]');
            let requester = requesterCon.querySelector('.iQ_rqust');
            const resultContainer = document.querySelector('#receiptRqst');

            requester.addEventListener("click", function() {
                if (requesterField && requester && resultContainer) {
                    resultContainer.innerHTML = '';
                    initLoadingPane(resultContainer);
                    let requestData = requesterField.value;

                    // Make the AJAX request to fetch.php
                    fetch('../controls/logic/generate-transaction-receipt.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `id=${encodeURIComponent(requestData)}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status) {

                            setTimeout(() => {

                                closeLoadingPane(resultContainer);

                                resultContainer.innerHTML = data.html.replace(/\\r\\n/g, ''); // Remove extra characters

                            }, 700);
                            
                        } else {
                            closeLoadingPane(resultContainer);
                            console.error(data.message);
                        }
                    })
                    .catch(error => {
                        closeLoadingPane(resultContainer);
                        console.error('Error fetching data:', error);
                    });
                }
            });
        });
    }

    // Initial call to set up the listeners for transaction receipt
    transactionReceipt();

    // Function to handle AJAX requests for loan details
    function loanDetails() {
        let requesterCons = document.querySelectorAll('.iQ_rqustCon3');

        requesterCons.forEach((requesterCon) => {
            let requesterField = requesterCon.querySelector('input[type="hidden"]');
            let requester = requesterCon.querySelector('.iQ_rqust');
            const resultContainer = document.querySelector('#loanRqst');

            requester.addEventListener("click", function() {
                if (requesterField && requester && resultContainer) {
                    resultContainer.innerHTML = '';
                    initLoadingPane(resultContainer)
                    let requestData = requesterField.value;

                    // Make the AJAX request to fetch.php
                    fetch('../controls/logic/fetch-loan-details.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `id=${encodeURIComponent(requestData)}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status) {

                            setTimeout(() => {

                                closeLoadingPane(resultContainer);

                                resultContainer.innerHTML = data.html.replace(/\\r\\n/g, ''); // Remove extra characters

                            }, 700)
                            
                        } else {
                            closeLoadingPane(resultContainer);
                            console.error(data.message);
                        }
                    })
                    .catch(error => {
                        closeLoadingPane(resultContainer);
                        console.error('Error fetching data:', error);
                    });
                }
            });
        });
    }

    // Initial call to set up the listeners for loan details
    loanDetails();

    // Function to handle AJAX requests for Loan Repayments details
    function loanRepayments() {
        let requesterCons = document.querySelectorAll('.iQ_rqustCon4');

        requesterCons.forEach((requesterCon) => {
            let requesterField = requesterCon.querySelector('input[type="hidden"]');
            let requester = requesterCon.querySelector('.iQ_rqust');
            const resultContainer = document.querySelector('#repayVal');

            requester.addEventListener("click", function() {
                if (requesterField && requester && resultContainer) {
                    resultContainer.innerHTML = '';
                    initLoadingPane(resultContainer);
                    let requestData = requesterField.value;

                    // Make the AJAX request to fetch.php
                    fetch('../controls/logic/loan-repayments.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `id=${encodeURIComponent(requestData)}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.refresh) {

                            window.location.reload();

                        } else if (data.nonExistent) {

                            closeLoadingPane(resultContainer);

                            resultContainer.innerHTML = `<div class="flx col">
                                
                                <div class="dH_icon">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none"><path id="vector (Stroke)" fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12Z" fill="#c72626"/><path id="vector (Stroke)_2" fill-rule="evenodd" clip-rule="evenodd" d="M8.46967 8.46967C8.76257 8.17678 9.23744 8.17678 9.53033 8.46967L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7625 15.8232 14.4696 15.5303L8.46967 9.53033C8.17678 9.23743 8.17678 8.76256 8.46967 8.46967Z" fill="#c72626"/><path id="vector (Stroke)_3" fill-rule="evenodd" clip-rule="evenodd" d="M15.5303 8.46967C15.8232 8.76257 15.8232 9.23744 15.5303 9.53033L9.53033 15.5303C9.23743 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7625 8.46967 14.4696L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z" fill="#c72626"/></svg>

                                </div>

                                <p class="font-sm">Error! Record not found!</p>
                            
                            </div>`;

                        } else {

                            if (data.records) {

                                setTimeout(() => {

                                    closeLoadingPane(resultContainer);

                                    resultContainer.innerHTML = data.html.replace(/\\r\\n/g, ''); // Remove extra characters

                                    payLoan();

                                }, 700);
                                
                            } else {

                                closeLoadingPane(resultContainer);

                                resultContainer.innerHTML = `<div class="flx col">
                                
                                    <div class="dH_icon">

                                        <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none"><path id="vector (Stroke)" fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12Z" fill="#c72626"/><path id="vector (Stroke)_2" fill-rule="evenodd" clip-rule="evenodd" d="M8.46967 8.46967C8.76257 8.17678 9.23744 8.17678 9.53033 8.46967L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7625 15.8232 14.4696 15.5303L8.46967 9.53033C8.17678 9.23743 8.17678 8.76256 8.46967 8.46967Z" fill="#c72626"/><path id="vector (Stroke)_3" fill-rule="evenodd" clip-rule="evenodd" d="M15.5303 8.46967C15.8232 8.76257 15.8232 9.23744 15.5303 9.53033L9.53033 15.5303C9.23743 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7625 8.46967 14.4696L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z" fill="#c72626"/></svg>

                                    </div>

                                    <p class="font-sm">Error! No Record(s) found!</p>
                                
                                </div>`;

                            }

                        }
                    })
                    .catch(error => {
                        closeLoadingPane(resultContainer);
                        console.error('Error fetching data:', error);

                        resultContainer.innerHTML = `<div class="flx col">
                                
                            <div class="dH_icon">

                                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none"><path id="vector (Stroke)" fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12Z" fill="#c72626"/><path id="vector (Stroke)_2" fill-rule="evenodd" clip-rule="evenodd" d="M8.46967 8.46967C8.76257 8.17678 9.23744 8.17678 9.53033 8.46967L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7625 15.8232 14.4696 15.5303L8.46967 9.53033C8.17678 9.23743 8.17678 8.76256 8.46967 8.46967Z" fill="#c72626"/><path id="vector (Stroke)_3" fill-rule="evenodd" clip-rule="evenodd" d="M15.5303 8.46967C15.8232 8.76257 15.8232 9.23744 15.5303 9.53033L9.53033 15.5303C9.23743 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7625 8.46967 14.4696L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z" fill="#c72626"/></svg>

                            </div>

                            <p class="font-sm">Error! Couldn't retrive data!</p>
                        
                        </div>`;

                    });
                }
            });
        });
    }

    // Initial call to set up the listeners for live demo trade details
    loanRepayments();

    function payLoan() { // Initiates & Handles Loan Payment

        let payBtn = document.querySelector('#loan-data button[name="pay-loan"]');

        let field = document.querySelector('#loan-data input[name="loan-id"]');

        if (payBtn && field) {

            payBtn.addEventListener("click", async () => {

                let content = payBtn.innerHTML;

                payBtn.innerHTML = '...';

                payBtn.disabled = true;

                try {

                    let processor = await fetch('../controls/logic/loan-payment-processor.php', {

                        method: 'POST',

                        body: new URLSearchParams({

                            'loan-id': field.value.trim()

                        }),

                        headers: {

                            'Content-Type': 'application/x-www-form-urlencoded'

                        }

                    });

                    let response = await processor.json();

                    if (response.proceed) {

                        setTimeout(() => {

                            window.location.href = 'pay';

                        }, 1500);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'No record found!',

                                type: 'warning',

                                duration: 5000

                            });

                            payBtn.innerHTML = content;

                            payBtn.disabled = false;
                            
                        }, 1200);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 5000

                        });

                        payBtn.innerHTML = content;

                        payBtn.disabled = false;
                        
                    }, 1200);

                }    

            })

        }

    }

    // Function to handle AJAX requests for Transcation Details
    function transactionDetails() {
        let requesterCons = document.querySelectorAll('.fetch-trans-details');

        requesterCons.forEach((requesterCon) => {
            let requesterField = requesterCon.querySelector('input[type="hidden"]');
            let requester = requesterCon.querySelector('.iQ_rqust');
            const resultContainer = document.querySelector('#transc-detail-view');

            requester.addEventListener("click", function() {
                if (requesterField && requester && resultContainer) {
                    let requestData = requesterField.value;
                    resultContainer.innerHTML = '';
                    initLoadingPane(resultContainer);

                    // Make the AJAX request to fetch.php
                    fetch('../controls/logic/fetch-transaction-details.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `id=${encodeURIComponent(requestData)}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status) {

                            setTimeout(() => {

                                closeLoadingPane(resultContainer);
                            
                                resultContainer.innerHTML = data.structure.replace(/\\r\\n/g, ''); // Remove extra characters

                                copyFxn();

                            }, 700);

                        } else {

                            closeLoadingPane(resultContainer);

                            resultContainer.innerHTML = 'Error!'

                        }
                    })
                    .catch(error => {
                        closeLoadingPane(resultContainer);
                        console.error('Error fetching data:', error);
                    });
                }
            });
        });
    }

    // Initial call to set up the listeners for demo trade details
    transactionDetails();

    function manageBeneficiary() { // Function To Manage Beneficiary

        let forms = document.querySelectorAll('.beneficiary-form');

        if (forms.length > 0) {

            forms.forEach(form => {

                form.addEventListener("submit", async (event) => {

                    event.preventDefault(); // Deny Submission

                    const button = event.submitter; // Get Button

                    if (button) {

                        if (button.value == 'DELETE') {

                            const confirmed = await popup({

                                header: 'Attention!',

                                title: 'Delete beneficiary',

                                text: 'Are you sure you want to delete this beneficiary?',

                                type: 'confirm'

                            });

                            if (!confirmed) {

                                return; // Stop processing if not confirmed
                            
                            }

                        }

                        // Process Form

                        try {

                            let formData = new FormData(form); // Collect Form Data

                            formData.append('action', button.value);

                            let processor = await fetch('../controls/logic/beneficiary-manager.php', {

                                method: 'POST',

                                body: formData

                            }); // Request Handler, Credentials

                            let response = await processor.json(); // Parse JSON Response

                            // Handle Response 

                            if (response.found) {

                                let view = document.querySelector('#beneficiaryView');

                                let data = response.body;

                                initializeNiceSelect();

                                if (view) {

                                    view.innerHTML = data.replace(/\\r\\n/g, '');

                                    editBeneficiary(); // Edit Beneficiary

                                }

                            } else if (response.deleted) {

                                toast({

                                    text: 'Beneficiary deleted',

                                    type: 'success',

                                    duration: 2300

                                });

                                form.closest('tr').remove(); // Remove Parent Table row

                            } else {

                                toast({

                                    text: 'Unable to process request!',

                                    type: 'warning',

                                    duration: 2300

                                });

                            }

                        } catch (error) {

                            console.error('Error:', error);

                        }

                    }

                });

            });

        }

    }

    manageBeneficiary(); // Initial Call

    function editBeneficiary() { // Edit Beneficiary

        let form = document.querySelector('#edit-beneficiaryForm');

        let button = document.querySelector('#edit-beneficiary');

        if (form && button) {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                let content = button.innerHTML; // Hold Original Content

                formProcessZero(button); // Initiate Loading Sequence

                // Process Form 

                try {

                    let formData = new FormData(form); // Gain Form Data

                    let processor = await fetch('../controls/logic/edit-beneficiary.php', {

                        method: 'POST',

                        body: formData

                    }); // Request Handler, Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.updated) {

                        setTimeout(() => {

                            toast({

                                text: 'Beneficiary updated!',

                                type: 'success',

                                duration: 2500

                            });

                        }, 1200);

                        setTimeout(() => {

                            window.location.reload();

                        }, 3200);

                    } else {

                        setTimeout(() => {

                            toast({

                                text: 'Couldn\'t update, try again!',

                                type: 'warning',

                                duration: 2500

                            });

                            formProcessRestore(button, content);

                        }, 1200);

                    } 

                } catch (error) {

                    console.error('Error:', error); // Log Error To Console

                    setTimeout(() => {

                        toast({

                            text: 'Error, try again!',

                            type: 'warning',

                            duration: 2500

                        });

                        formProcessRestore(button, content);

                    }, 1200);

                }

            });

        }

    }

    // Function to handle AJAX requests for Invoice Delivery

    function mailInvoice() {

        let deliveryModules = document.querySelectorAll('.invoice-send');

        if (deliveryModules.length > 0) {

            deliveryModules.forEach(module => {

                module.addEventListener("click", () => {

                    const command = module.querySelector('.iQ_rqust'); // Get Button

                    const field = module.querySelector('input[type="hidden"]');

                    if (command && field) {

                        let proceed = false; // Flag

                        popup({

                            header: 'Attention!',
                            
                            title: 'Confirm Action!',

                            text: 'Are you sure you want to mail this invoice to the customer?',

                            type: 'confirm',

                        }).then(confirmed => {

                            if (confirmed) {

                                // Process Request

                                fetch('../controls/logic/invoice-mail-handler.php', {

                                    method: 'POST',

                                    headers: {

                                        'Content-Type': 'application/x-www-form-urlencoded'

                                    },

                                    body: `inv-id=${encodeURIComponent(field.value)}`

                                }) // Request Handler, Credentials (Processor)
                                .then(response => response.json()) // Parse JSON Response
                                .then(data => {

                                    // Handle Response

                                    if (data.sent) {

                                        toast({

                                            text: 'Invoice delivered',

                                            type: 'success',

                                            duration: 2300

                                        });

                                    } else {

                                        toast({

                                            text: 'Mail delivery failed!',

                                            type: 'warning',

                                            duration: 2300

                                        });

                                    }

                                })
                                .catch(error => {

                                    // Handle Error

                                    console.error('Error:', error); // Log Error

                                    toast({

                                        text: 'Unable to process request!',

                                        type: 'error',

                                        duration: 2500

                                    });

                                });

                            }

                        });

                    }

                });

            });

        }    
       
    }

    // Initial call to set up the listeners for Invoice Delivery
    mailInvoice();

    // Function to handle AJAX requests for Invoice Deletion

    function deleteInvoice() {

        let deleteModules = document.querySelectorAll('.invoice-delete');

        if (deleteModules.length > 0) {

            deleteModules.forEach(module => {

                module.addEventListener("click", () => {

                    const command = module.querySelector('.iQ_rqust'); // Get Button

                    const field = module.querySelector('input[type="hidden"]');

                    if (command && field) {

                        let proceed = false; // Flag

                        popup({

                            header: 'Attention!',
                            
                            title: 'Confirm Action!',

                            text: 'Are you sure you want to delete this invoice? You won\'t be able to receive payment, if you do',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then(confirmed => {

                            if (confirmed) {

                                // Process Request

                                fetch('../controls/logic/invoice-deletion-handler.php', {

                                    method: 'POST',

                                    headers: {

                                        'Content-Type': 'application/x-www-form-urlencoded'

                                    },

                                    body: `inv-id=${encodeURIComponent(field.value)}`

                                }) // Request Handler, Credentials (Processor)
                                .then(response => response.json()) // Parse JSON Response
                                .then(data => {

                                    // Handle Response

                                    if (data.deleted) {

                                        toast({

                                            text: 'Invoice deleted',

                                            type: 'success',

                                            duration: 2300

                                        });

                                        module.closest('tr').remove(); // Remove Parent Table row

                                    } else {

                                        toast({

                                            text: 'Unable to process request!',

                                            type: 'warning',

                                            duration: 2300

                                        });

                                    }

                                })
                                .catch(error => {

                                    // Handle Error

                                    console.error('Error:', error); // Log Error

                                    toast({

                                        text: 'An error occurred',

                                        type: 'error',

                                        duration: 2500

                                    });

                                });

                            }

                        });

                    }

                });

            });

        }    
       
    }

    // Initial call to set up the listeners for Invoice Deletion
    deleteInvoice();

    // Function to handle AJAX requests for Customer Deletion

    function deleteCustomer() {

        let deleteModules = document.querySelectorAll('.customer-delete');

        if (deleteModules.length > 0) {

            deleteModules.forEach(module => {

                module.addEventListener("click", () => {

                    const command = module.querySelector('.iQ_rqust'); // Get Button

                    const field = module.querySelector('input[type="hidden"]');

                    if (command && field) {

                        let proceed = false; // Flag

                        popup({

                            header: 'Attention!',
                            
                            title: 'Confirm Action!',

                            text: 'Are you sure you want to delete this customer? All invoice(s) pertaining to this customer will be deleted as well.',

                            type: 'warning',

                            showConfirmBtn: true

                        }).then(confirmed => {

                            if (confirmed) {

                                // Process Request

                                fetch('../controls/logic/customer-deletion-handler.php', {

                                    method: 'POST',

                                    headers: {

                                        'Content-Type': 'application/x-www-form-urlencoded'

                                    },

                                    body: `cus-id=${encodeURIComponent(field.value)}`

                                }) // Request Handler, Credentials (Processor)
                                .then(response => response.json()) // Parse JSON Response
                                .then(data => {

                                    // Handle Response

                                    if (data.deleted) {

                                        toast({

                                            text: 'Invoice deleted',

                                            type: 'success',

                                            duration: 2300

                                        });

                                        module.closest('tr').remove(); // Remove Parent Table row

                                    } else {

                                        toast({

                                            text: 'Unable to process request!',

                                            type: 'warning',

                                            duration: 2300

                                        });

                                    }

                                })
                                .catch(error => {

                                    // Handle Error

                                    console.error('Error:', error); // Log Error

                                    toast({

                                        text: 'An error occurred',

                                        type: 'error',

                                        duration: 2500

                                    });

                                });

                            }

                        });

                    }

                });

            });

        }    
       
    }

    // Initial call to set up the listeners for Customer Deletion
    deleteCustomer();

});

// Preloader

document.addEventListener("DOMContentLoaded", () => {

    preloaderObserver();

    const preloader = document.querySelector('#preloader');

    if (preloader) {

        window.addEventListener("load", () => {

            setTimeout(() => {
    
                preloader.remove();

                preloaderObserver();
    
            }, 2500);

        });

    }

    function preloaderObserver() {

        const preloader = document.querySelector('#preloader');

        if (preloader) {

            page.classList.add('deactivate');

        } else {

            page.classList.remove('deactivate');

        }

        const observer = new MutationObserver(() => {

            if (preloader) {

                page.classList.add('deactivate');

            } else {

                page.classList.remove('deactivate');

            }

        });

        observer.observe(document.documentElement, {

            childList: true

        });

    }

});

// Code Help ~ Payment Countdown

document.addEventListener("DOMContentLoaded", () => {

    let button = document.querySelector('#btnAutoPay');

    let countdown = 45; // 45 Seconds 

    if (button) {

        let timer = button.querySelector('.timer');

        let interval = setInterval(() => {

            countdown--; // Decrement Countdown

            timer.innerHTML = ` (00:${String(countdown).padStart(2, '0')})`; // Update Button Content
            
            if (countdown <= 0) {

                button.click(); // Submit Form

                clearInterval(interval);

            }

        }, 1000); // Run Every 1s


    }

});

// Print Receipt (Popup)

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#iQ_print');

    let page = document.querySelector('#receiptRqst');

    if (command && page) {

        // command.addEventListener("click", printPage(page));

        command.addEventListener("click", () => {

            var printWindow = document.createElement('iframe'); // Iframe to hold content
            printWindow.style.position = 'absolute';
            printWindow.style.width = '0px';
            printWindow.style.height = '0px';
            printWindow.style.border = 'none';
            document.body.appendChild(printWindow);
        
            // Append Content
        
            var doc = printWindow.contentWindow.document;
            doc.open();
            doc.write('<!DOCTYPE html><html><head></head><body>');
        
            var styles = document.querySelectorAll('link[rel="stylesheet"], style'); // Get Parent CSS
            styles.forEach((style) => {
                doc.head.appendChild(style.cloneNode(true)); // Clone & Append
            });
                
            doc.write(page.innerHTML);  // Insert Page
            doc.write('</body></html>');
            doc.close();
        
            // Load then trigger Print Dialog
        
            printWindow.onload = () => {
                    
                printWindow.contentWindow.focus();  // Focus On Iframe
                printWindow.contentWindow.print();  //  Trigger Print Dialog
                document.body.removeChild(printWindow); // Remove Iframe
        
            };

        });

    }

});

// Download Receipt As PDF (Popup)

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#iQ_pdf');

    let page = document.querySelector('#receiptRqst');

    if (command && page) {

        command.addEventListener("click", () => {

            // Find and hide all elements with the class .print-0 before generating the PDF
            let printZeroElements = page.querySelectorAll('.print-0');
            let removedElements = [];
            printZeroElements.forEach(el => {
                // Store the original display value and hide the element
                removedElements.push({ element: el, display: el.style.display });
                el.style.display = 'none'; // Hide the element
            });

            // Store original styles
            const originalStyles = {
                width: page.style.width,
                height: page.style.height,
                padding: page.style.padding,
                border: page.style.border,
                overflow: page.style.overflow
            };

            // Apply the desired styles to ensure one-page fit for the PDF
            page.style.setProperty('width', '800px', 'important');
            page.style.setProperty('height', 'auto', 'important'); // Adjust height automatically based on content
            page.style.setProperty('padding', '2.5em', 'important');
            page.style.setProperty('border', 'none', 'important');
            page.style.setProperty('overflow', 'visible', 'important');

            // Generate PDF directly using html2pdf
            html2pdf()
                .from(page)
                .set({
                    margin: [0, 0, 0, 0],  // Set margin to 0 to avoid extra space around the content
                    filename: `transaction-receipt.pdf`, // Use the dynamic filename with .pdf extension
                    jsPDF: {
                        unit: 'mm',
                        format: 'a4',
                        orientation: 'portrait'
                    },
                    html2canvas: { 
                        scale: 2,
                        windowWidth: document.documentElement.scrollWidth,  // Ensure we capture full page width
                        windowHeight: document.documentElement.scrollHeight  // Capture full page height
                    }
                })
                .toPdf()
                .get('pdf')
                .then(function(pdf) {
                    // Check the PDF content size and scale it to fit within the page
                    const pageHeight = pdf.internal.pageSize.height;
                    const contentHeight = page.scrollHeight;

                    // Scale the content to fit one page if needed
                    if (contentHeight > pageHeight) {
                        const scale = pageHeight / contentHeight;
                        pdf.setScale(scale);
                    }

                    // Save the generated PDF with the dynamic filename
                    pdf.save(`transaction-receipt.pdf`);

                    // User Feedback

                    toast({

                        text: 'PDF saved!',

                        type: 'success',

                        duration: 7000

                    });

                    // Restore the .print-0 elements after the PDF is downloaded
                    removedElements.forEach(({ element, display }) => {
                        element.style.display = display; // Restore the original display value
                    });

                    // Restore original styles
                    page.style.setProperty('width', originalStyles.width);
                    page.style.setProperty('height', originalStyles.height);
                    page.style.setProperty('padding', originalStyles.padding);
                    page.style.setProperty('border', originalStyles.border);
                    page.style.setProperty('overflow', originalStyles.overflow);
                })
                .catch(function(error) {
                    
                    // User Feedback

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 7000

                    });

                    // Handle error or cleanup as needed
                    console.error('PDF conversion error:', error);

                    // Restore the .print-0 elements in case of an error
                    removedElements.forEach(({ element, display }) => {
                        element.style.display = display; // Restore the original display value
                    });

                    // Restore original styles if the conversion fails
                    page.style.setProperty('width', originalStyles.width);
                    page.style.setProperty('height', originalStyles.height);
                    page.style.setProperty('padding', originalStyles.padding);
                    page.style.setProperty('border', originalStyles.border);
                    page.style.setProperty('overflow', originalStyles.overflow);
                });

        });

    }

});

// Print Receipt

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#iQ_print');

    let page = document.querySelector('#page');

    if (command && page) {

        command.addEventListener("click", () => {

            var printWindow = document.createElement('iframe'); // Iframe to hold content
            printWindow.style.position = 'absolute';
            printWindow.style.width = '0px';
            printWindow.style.height = '0px';
            printWindow.style.border = 'none';
            document.body.appendChild(printWindow);
        
            // Append Content
        
            var doc = printWindow.contentWindow.document;
            doc.open();
            doc.write('<!DOCTYPE html><html><head></head><body>');
        
            var styles = document.querySelectorAll('link[rel="stylesheet"], style'); // Get Parent CSS
            styles.forEach((style) => {
                doc.head.appendChild(style.cloneNode(true)); // Clone & Append
            });
                
            doc.write(page.innerHTML);  // Insert Page
            doc.write('</body></html>');
            doc.close();
        
            // Load then trigger Print Dialog
        
            printWindow.onload = () => {
                    
                printWindow.contentWindow.focus();  // Focus On Iframe
                printWindow.contentWindow.print();  //  Trigger Print Dialog
                document.body.removeChild(printWindow); // Remove Iframe
        
            };

        });

    }

});

// Download Receipt As PDF

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#iQ_pdf');

    let page = document.querySelector('#page');

    if (command && page) {

        command.addEventListener("click", () => {

            // Find and hide all elements with the class .print-0 before generating the PDF
            let printZeroElements = page.querySelectorAll('.print-0');
            let removedElements = [];
            printZeroElements.forEach(el => {
                // Store the original display value and hide the element
                removedElements.push({ element: el, display: el.style.display });
                el.style.display = 'none'; // Hide the element
            });

            // Store original styles
            const originalStyles = {
                width: page.style.width,
                height: page.style.height,
                padding: page.style.padding,
                border: page.style.border,
                overflow: page.style.overflow
            };

            // Apply the desired styles to ensure one-page fit for the PDF
            page.style.setProperty('width', '800px', 'important');
            page.style.setProperty('height', 'auto', 'important'); // Adjust height automatically based on content
            page.style.setProperty('padding', '2.5em', 'important');
            page.style.setProperty('border', 'none', 'important');
            page.style.setProperty('overflow', 'visible', 'important');

            // Generate the filename using the filename() function
            // const generatedFilename = filename(); // Get the dynamic filename

            // Generate PDF directly using html2pdf
            html2pdf()
                .from(page)
                .set({
                    margin: [0, 0, 0, 0],  // Set margin to 0 to avoid extra space around the content
                    filename: `transaction-receipt.pdf`, // Use the dynamic filename with .pdf extension
                    jsPDF: {
                        unit: 'mm',
                        format: 'a4',
                        orientation: 'portrait'
                    },
                    html2canvas: { 
                        scale: 2,
                        windowWidth: document.documentElement.scrollWidth,  // Ensure we capture full page width
                        windowHeight: document.documentElement.scrollHeight  // Capture full page height
                    }
                })
                .toPdf()
                .get('pdf')
                .then(function(pdf) {
                    // Check the PDF content size and scale it to fit within the page
                    const pageHeight = pdf.internal.pageSize.height;
                    const contentHeight = page.scrollHeight;

                    // Scale the content to fit one page if needed
                    if (contentHeight > pageHeight) {
                        const scale = pageHeight / contentHeight;
                        pdf.setScale(scale);
                    }

                    // Save the generated PDF with the dynamic filename
                    pdf.save(`transaction-receipt.pdf`);

                    // User Feedback

                    toast({

                        text: 'PDF saved!',

                        type: 'success',

                        duration: 7000

                    });

                    // Restore the .print-0 elements after the PDF is downloaded
                    removedElements.forEach(({ element, display }) => {
                        element.style.display = display; // Restore the original display value
                    });

                    // Restore original styles
                    page.style.setProperty('width', originalStyles.width);
                    page.style.setProperty('height', originalStyles.height);
                    page.style.setProperty('padding', originalStyles.padding);
                    page.style.setProperty('border', originalStyles.border);
                    page.style.setProperty('overflow', originalStyles.overflow);
                })
                .catch(function(error) {
                    
                    // User Feedback

                    toast({

                        text: 'Unable to process request!',

                        type: 'warning',

                        duration: 7000

                    });

                    // Handle error or cleanup as needed
                    console.error('PDF conversion error:', error);

                    // Restore the .print-0 elements in case of an error
                    removedElements.forEach(({ element, display }) => {
                        element.style.display = display; // Restore the original display value
                    });

                    // Restore original styles if the conversion fails
                    page.style.setProperty('width', originalStyles.width);
                    page.style.setProperty('height', originalStyles.height);
                    page.style.setProperty('padding', originalStyles.padding);
                    page.style.setProperty('border', originalStyles.border);
                    page.style.setProperty('overflow', originalStyles.overflow);
                });

        });

    }

});

// Beneficiary Navigation

document.addEventListener("DOMContentLoaded", () => {

    let navigator = document.querySelector('#transNav');

    let dstProp = document.querySelector('#transDest');

    if (navigator && dstProp) {

        let destination = 'transfer';

        if (window.location.search.includes('?type=wire')) {

            destination = 'wire';

        } 
        
        navigator.addEventListener("click", () => {

            let locationURL = `${destination}?beneficiary=${dstProp.value}`;

            if (dstProp.value == 0) {

                toast({

                    text: 'Please, select a beneficiary!',

                    type: 'error',

                    duration: 5000

                });

            } else {

                formProcessZero(navigator);

                setTimeout(() => {

                    window.location.href = locationURL;

                }, 1500);              

            }  

        });

    }

});

// Pseudo Radio

document.addEventListener("change", async () => {

    let selectors = document.querySelectorAll('.pseudoRadio');

    if (selectors) {

        function clearSelection() {

            selectors.forEach((selector) => {

                selector.classList.remove('selected');

                selector.querySelector('input[type="radio"]').checked = false;

            });

        }

        // Recall State

        window.addEventListener("load", function() {

            selectors.forEach((selector) => {

                if (selector.querySelector('input[type="radio"]').checked == true) {
        
                    selector.classList.add('selected');
        
                }
        
            });

        })

        selectors.forEach((selector) => {

            selector.addEventListener("click", function() {

                clearSelection();

                selector.classList.add('selected');

                selector.querySelector('input[type="radio"]').checked = true;

            });

        });

    }    

});

// Profile / Avatar Image Transfer

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('[iQ-target="#iQ_Avatar"]');

    let display = document.querySelector('#proof-displ');

    if (command && display) {

        command.addEventListener("click", () => {

            let image = command.querySelector('img');

            if (image && image.src != null) {

                let newImage = document.createElement('img');

                newImage.src = `${image.src}`;

                newImage.alt = null;

                display.innerHTML = null;

                display.appendChild(newImage);

            }

        });

    }

});

// Subscription (Investments) Data Transfer

document.addEventListener("DOMContentLoaded", () => {

    let boxes = document.querySelectorAll('.plan-data');
    
    if (boxes.length > 0) {

        boxes.forEach(box => {

            let trigger = box.querySelector('.plan-apply'); // Initiatior

            // Data Sources

            let identifier = box.querySelector('input[name="inv-id"]');

            let name = box.querySelector('input[name="inv-name"]');

            let minimum = box.querySelector('input[name="inv-min"]');

            let maximum = box.querySelector('input[name="inv-max"]');

            // Receivers

            let idHold = document.querySelector('#plan-id');

            let nameHold = document.querySelector('#plan-name');

            let priceHold = document.querySelector('#plan-price');

            // Transfer Data

            if (trigger) {

                trigger.addEventListener("click", () => {

                    if (identifier && name && idHold && nameHold && priceHold) {

                        idHold.value = '';

                        idHold.value = identifier.value;

                        nameHold.value = '';

                        nameHold.value = name.value;

                        priceHold.value = '';

                        if (minimum) {

                            priceHold.setAttribute('min', minimum.value);

                        }

                        if (maximum) {

                            priceHold.setAttribute('max', maximum.value);

                            if (!minimum) {

                                priceHold.setAttribute('readonly', true);

                                priceHold.value = maximum.value;

                            }

                        }

                    }

                });

            }

        });

    }

});


// Carousel / Slider Function

function slides(slider, slides, indicators, timing) {

    slides = document.querySelectorAll(`${slider} ${slides}`);

    slider = document.querySelector(`${slider}`);

    indicators = document.querySelectorAll(`${indicators}`);

    if (slider && slides.length > 0) { //(slides.length > 0 && indicators.length > 0) && slides.length == indicators.length) {
    
        var journey = 0;

        var currentSlide = 1;

        var maxTravel = (slides.length * 100);

        for (var i = 0; i <= slides.length; i++) {

            setInterval(() => {

                slider.style.transform = (journey > 0) ? `translateX(-${journey}%)` : `translateX(${journey}%)`;

                // let current = indicators[currentSlide];

                // let next = indicators[currentSlide + 1];

                // let prev = indicators[i < currentSlide];

                // if (current) {

                //     current.classList.add('active');

                // }

                // if (prev)

                //     prev.classList.add('prev');

                // if (next) {

                //     next.classList.add('next');

                // }

                // indicators[currentSlide].classList.add('active');

                // indicators[currentSlide - 1].classList.remove('active');

                // indicators[currentSlide - 1].classList.add('prev');

                // if (!indicators[currentSlide] && !indicators[currentSlide + 1]) {

                    

                // }

                // indicators[i < currentSlide].classList.remove('active');

                // indicators[i < currentSlide].classList.add('prev');

                // indicators[currentSlide + 1].classList.add('next');

                currentSlide++;

                journey += 100;

                if (journey >= maxTravel && journey != 0) {

                    currentSlide = 1;

                    journey = 0;

                }

                // console.log('Journey:', journey);

                // console.log('Max Travel:', maxTravel);

                // console.log('Current Slide:', currentSlide);

            }, timing);

        }

    }    

}

document.addEventListener("DOMContentLoaded", () => {

    slides('#iQ_slider', '.transbox', '.sb_controls .sb_control', 3500);

    slides('#iQ_slider', '.dashCarousel_item', null, 3500);

});

// Virtual Card Flip

document.addEventListener("DOMContentLoaded", () => {

    let flippers = document.querySelectorAll('.card-flipper');

    let cards = document.querySelectorAll('.vCard_box');

    if (flippers && cards) {

        flippers.forEach((flipper, index) => {

            flipper.addEventListener("click", () => {

                cards[index].classList.toggle('flip');

            });

        });

    }

});

// Notifications Reveal Toggle Action

document.addEventListener("DOMContentLoaded", () => {

    let pane = document.querySelector('#notification-window');

    let toggles = document.querySelectorAll('.notification-toggle');

    if (pane && (toggles.length > 0)) {

        pageLock();

        toggles.forEach(toggle => {

            toggle.addEventListener("click", () => {

                pane.classList.toggle('n_displ');

                pageLock();

            });

        });

        function pageLock() {

            if (!pane.classList.contains('n_displ')) {

                page.classList.add('deactivate');

            } else {

                page.classList.remove('deactivate');

            }

            const observer = new MutationObserver(() => {

                if (!pane.classList.contains('n_displ')) {

                    page.classList.add('deactivate');

                } else {

                    page.classList.remove('deactivate');

                }                

            });

            observer.observe(pane, {

                attributes: true, attributeFilter: ['class']

            });

        }

    }

});

function initializeNiceSelect() { // Initialize Nice Select

    let selectFields = document.querySelectorAll('select');

    if (selectFields) {

        var prop = {searchable: true};

        selectFields.forEach((field) => {

            if (field.classList.contains('search')) { // Searchable Fields

                NiceSelect.bind(field, prop);

            } else {  // Non-Searchable Fields

                NiceSelect.bind(field);

            }    

        });

    }

}

// Invoice Item Addition

document.addEventListener("DOMContentLoaded", () => {

    invoiceCalculator();

    const command = document.querySelector('#add-invoice-item');

    const display = document.querySelector('#invoice-items');

    if (command && display) {

        command.addEventListener("click", () => {

            let newItem = document.createElement('div');

            newItem.className = 'form_item inv-row';

            newItem.innerHTML = `<div class="form_item fi-1">

                <label for="item-desc">Item Description</label>

                <input type="text" name="item-desc[]" placeholder="Enter item description" class="form_field" required>

            </div>

            <div class="form_item fi-2">

                <label for="item-qty">Qty</label>

                <input type="number" name="item-qty[]" placeholder="0" class="form_field calc-field" min="1">

            </div>

            <div class="form_item fi-3">

                <label for="item-price">Price</label>

                <input type="number" name="item-price[]" placeholder="0.00" step="0.01" min="0.01" class="form_field calc-field" required>

            </div>

            <div class="form_item fi-4">

                <label for="item-amt">Amount</label>

                <input type="number" name="item-amt[]" placeholder="0.00" class="form_field" readonly>

            </div>

            <div class="inv-delete">

                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5555 4C10.099 4 9.70052 4.30906 9.58693 4.75114L9.29382 5.8919H14.715L14.4219 4.75114C14.3083 4.30906 13.9098 4 13.4533 4H10.5555ZM16.7799 5.8919L16.3589 4.25342C16.0182 2.92719 14.8226 2 13.4533 2H10.5555C9.18616 2 7.99062 2.92719 7.64985 4.25342L7.22886 5.8919H4C3.44772 5.8919 3 6.33961 3 6.8919C3 7.44418 3.44772 7.8919 4 7.8919H4.10069L5.31544 19.3172C5.47763 20.8427 6.76455 22 8.29863 22H15.7014C17.2354 22 18.5224 20.8427 18.6846 19.3172L19.8993 7.8919H20C20.5523 7.8919 21 7.44418 21 6.8919C21 6.33961 20.5523 5.8919 20 5.8919H16.7799ZM17.888 7.8919H6.11196L7.30423 19.1057C7.3583 19.6142 7.78727 20 8.29863 20H15.7014C16.2127 20 16.6417 19.6142 16.6958 19.1057L17.888 7.8919ZM10 10C10.5523 10 11 10.4477 11 11V16C11 16.5523 10.5523 17 10 17C9.44772 17 9 16.5523 9 16V11C9 10.4477 9.44772 10 10 10ZM14 10C14.5523 10 15 10.4477 15 11V16C15 16.5523 14.5523 17 14 17C13.4477 17 13 16.5523 13 16V11C13 10.4477 13.4477 10 14 10Z" fill="currentColor"></path></svg>

            </div>`;

            display.append(newItem);

            deleteItem();

            invoiceCalculator();

        });

        function deleteItem() {

            let items = document.querySelectorAll('.inv-row');

            if (items.length > 0) {

                items.forEach(item => {

                    let deleteBtn = item.querySelector('.inv-delete');

                    deleteBtn.addEventListener("click", () => {

                        item.remove();

                        invoiceCalculator();

                    });

                });

            }

        }

    }

    function invoiceCalculator() {

        const fields = document.querySelectorAll('.calc-field');

        if (fields.length > 0) {

            fields.forEach(field => {

                field.addEventListener("input", () => {

                    if (!field.checkValidity()) {

                        field.reportValidity();

                    } else {

                        invoiceCalc();

                    }    

                });

            });

        }

        const deleteBtns = document.querySelectorAll('.inv-delete');

        if (deleteBtns.length > 0) {

            deleteBtns.forEach(btn => {

                btn.addEventListener("click", () => {

                    invoiceCalc();

                });

            });

        }

    }

    async function invoiceCalc() {

        let quantities = document.querySelectorAll('input[name="item-qty[]"]');
        let prices = document.querySelectorAll('input[name="item-price[]"]');
        let amounts = document.querySelectorAll('input[name="item-amt[]"]');

        let taxProtocol = document.querySelector('input[name="tax-first"]');
        let taxType = document.querySelector('select[name="tax-type"]');
        let taxField = document.querySelector('input[name="tax"]');
        let taxDisplay = document.querySelector('input[name="tax-calc"]');

        let discountType = document.querySelector('select[name="discount-type"]');
        let discountField = document.querySelector('input[name="discount"]');
        let discountDisplay = document.querySelector('input[name="discount-calc"]');

        let creditField = document.querySelector('input[name="credit"]');

        let subtotalDisplay = document.querySelector('#sub-total');
        let totalDisplay = document.querySelector('#total');

        let subtotal = [];
        let amount = 0;

        quantities.forEach((qtyEl, index) => {
            let qty = parseFloat(qtyEl.value) || 1;
            let price = parseFloat(prices[index].value) || 0;
            amount = parseFloat((price * qty).toFixed(2));
            amounts[index].value = amount;
            subtotal.push(amount);
        });

        let subtotalSum = subtotal.reduce((a, b) => a + b, 0);
        subtotalDisplay.innerHTML = subtotalSum.toFixed(2);

        let taxAfterDiscount = !taxProtocol.checked;

        // Handle Discount
        let discountAmount = 0;
        if (discountField.value) {
            if (discountType.value === 'PERCENTAGE') {
                discountAmount = (parseFloat(discountField.value) / 100) * subtotalSum;
            } else {
                discountAmount = parseFloat(discountField.value);
            }
        }
        discountDisplay.value = discountAmount.toFixed(2);

        // Handle Tax
        let taxAmount = 0;
        if (taxField.value) {
            if (taxType.value === 'PERCENTAGE') {
                taxAmount = (parseFloat(taxField.value) / 100) * (taxAfterDiscount ? (subtotalSum - discountAmount) : subtotalSum);
            } else {
                taxAmount = parseFloat(taxField.value);
            }
        }
        taxDisplay.value = taxAmount.toFixed(2);

        let owed = (creditField.value) ? parseFloat(creditField.value) : 0;

        // Calculate Final Total
        let total = (subtotalSum - discountAmount) + taxAmount + owed;
        totalDisplay.innerHTML = total.toFixed(2);
    }

});

function copyFxn() { // Copy Fxn 2
    let buttons = document.querySelectorAll('.copier-trigger');
    let fields = document.querySelectorAll('.copy-field');

    if (buttons.length > 0 && fields.length > 0 && buttons.length === fields.length) {

        buttons.forEach((button, index) => {
            button.addEventListener("click", () => {

                button.disabled = true;

                let originalHTML = button.innerHTML;
                let textToCopy = fields[index].textContent || fields[index].value || '';

                if (navigator.clipboard) {
                    navigator.clipboard.writeText(textToCopy).then(() => {
                        button.innerHTML = `<svg class="svg-fill-current-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.625 11.25L8.125 17.5L19.375 2.5" fill="none" vector-effect="non-scaling-stroke" stroke="green" stroke-width="1.5"></path>
                        </svg>`;
                        setTimeout(() => {
                            button.innerHTML = originalHTML;
                            button.enabled = true;
                        }, 2000);
                    }).catch(err => {
                        console.error('Failed to copy:', err);
                    });
                } else {
                    const textarea = document.createElement('textarea');
                    textarea.value = textToCopy;
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand('copy');
                        button.innerHTML = `<svg class="svg-fill-current-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.625 11.25L8.125 17.5L19.375 2.5" fill="none" vector-effect="non-scaling-stroke" stroke="green" stroke-width="1.5"></path>
                        </svg>`;
                        setTimeout(() => {
                            button.innerHTML = originalHTML;
                            button.enabled = true;
                        }, 2000);
                    } catch (err) {
                        console.error('Fallback: Copy command failed', err);
                    }
                    document.body.removeChild(textarea);
                }
            });
        });
    }
}

// Run after DOM is ready:
document.addEventListener('DOMContentLoaded', copyFxn);


// IOS Scroll Lock 

function toggleDeactivateClass() {
    const body = document.body;

    if (body.classList.contains('deactivate')) {
        body.style.overflow = 'hidden';
        body.style.position = 'fixed';
        body.style.width = '100%';
        body.style.height = '100%';
    } else {
        body.style.overflow = '';
        body.style.position = '';
        body.style.width = '';
        body.style.height = '';
    }
}

function isIOS() {
    return /iP(hone|od|ad)/.test(navigator.userAgent);
}

function isAppleDevice() {
  const ua = navigator.userAgent;
  const isIOS = /iP(hone|od|ad)/.test(ua);
  const isMac = /Macintosh/.test(ua);
  return isIOS || isMac;
}


if (isIOS()) {
    // Listen for changes in the 'deactivate' class on the body element
    const observer = new MutationObserver(toggleDeactivateClass);

    // Start observing the 'class' attribute on the body element
    observer.observe(document.body, { attributes: true });

    // Initial check in case 'deactivate' class is already present
    toggleDeactivateClass();
}
