// Toast System

function toast(options) {

    let toastBox = document.querySelector('#toast');

    if (!toastBox) {

        toastBox = document.createElement('div');

        toastBox.id = 'toast';

        document.body.appendChild(toastBox);

    }

    const {text, type, duration} = options;

    const toast = document.createElement('div');

    toast.classList.add('toast_box');

    toast.setAttribute('variant', type.toLowerCase());

    const icon = document.createElement('div');

    icon.classList.add('toastIcon');

    if (type == "success") {

        icon.innerHTML = `
        
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 28" width="25" height="28" class="info-icon">
            <title>Sparkles-svg</title>
            <defs>
                <image width="20" height="20" id="img1" href="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHZpZXdCb3g9IjAgMCAyMCAyMCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTEwIDEuNjY2NjZDNS40MDgzNSAxLjY2NjY2IDEuNjY2NjkgNS40MDgzMiAxLjY2NjY5IDkuOTk5OTlDMS42NjY2OSAxNC41OTE3IDUuNDA4MzUgMTguMzMzMyAxMCAxOC4zMzMzQzE0LjU5MTcgMTguMzMzMyAxOC4zMzM0IDE0LjU5MTcgMTguMzMzNCA5Ljk5OTk5QzE4LjMzMzQgNS40MDgzMiAxNC41OTE3IDEuNjY2NjYgMTAgMS42NjY2NlpNMTMuOTgzNCA4LjA4MzMyTDkuMjU4MzUgMTIuODA4M0M5LjE0MTY5IDEyLjkyNSA4Ljk4MzM1IDEyLjk5MTcgOC44MTY2OSAxMi45OTE3QzguNjUwMDIgMTIuOTkxNyA4LjQ5MTY5IDEyLjkyNSA4LjM3NTAyIDEyLjgwODNMNi4wMTY2OSAxMC40NUM1Ljc3NTAyIDEwLjIwODMgNS43NzUwMiA5LjgwODMyIDYuMDE2NjkgOS41NjY2NkM2LjI1ODM1IDkuMzI0OTkgNi42NTgzNSA5LjMyNDk5IDYuOTAwMDIgOS41NjY2Nkw4LjgxNjY5IDExLjQ4MzNMMTMuMSA3LjE5OTk5QzEzLjM0MTcgNi45NTgzMiAxMy43NDE3IDYuOTU4MzIgMTMuOTgzNCA3LjE5OTk5QzE0LjIyNSA3LjQ0MTY2IDE0LjIyNSA3LjgzMzMyIDEzLjk4MzQgOC4wODMzMloiIGZpbGw9IiMxOUIyNTkiLz4KPC9zdmc+Cg=="></image>
            </defs>
            <style>.s0 { fill: #19b259 }</style>
            <path class="s0" d="m23.1 0.3c0-0.4 0.5-0.4 0.6 0l0.1 0.6c0 0.2 0.1 0.3 0.2 0.3l0.7 0.1c0.4 0 0.4 0.5 0 0.6l-0.7 0.1c-0.1 0-0.2 0.1-0.2 0.2l-0.1 0.7c-0.1 0.4-0.6 0.4-0.6 0l-0.1-0.7c0-0.1-0.1-0.2-0.3-0.2l-0.7-0.1c-0.3-0.1-0.3-0.6 0-0.6l0.7-0.1c0.2 0 0.3-0.1 0.3-0.3z"></path>
            <path class="s0" d="m6.8 25.1c0.1-0.4 0.6-0.4 0.6 0l0.1 0.7c0 0.1 0.1 0.2 0.3 0.2l0.7 0.1c0.3 0.1 0.3 0.6 0 0.6l-0.7 0.1c-0.2 0-0.3 0.1-0.3 0.3l-0.1 0.6c0 0.4-0.5 0.4-0.6 0l-0.1-0.6c0-0.2-0.1-0.3-0.2-0.3l-0.7-0.1c-0.4 0-0.4-0.5 0-0.6l0.7-0.1c0.1 0 0.2-0.1 0.2-0.2z"></path>
            <path class="s0" d="m0.8 6.7c0.1-0.2 0.4-0.2 0.4 0l0.1 0.4q0 0.2 0.1 0.2l0.5 0.1c0.2 0 0.2 0.3 0 0.3l-0.5 0.1q-0.1 0-0.1 0.1l-0.1 0.5c0 0.2-0.3 0.2-0.4 0v-0.5q0-0.1-0.2-0.1l-0.4-0.1c-0.3 0-0.3-0.3 0-0.3l0.4-0.1q0.2 0 0.2-0.2z"></path>
            <use id="20" href="#img1" transform="matrix(1,0,0,1,3,4)"></use>
        </svg>`;

    } else if (type == "error") {

        icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="info-icon"><path d="M10 1.66666C5.40835 1.66666 1.66669 5.40832 1.66669 9.99999C1.66669 14.5917 5.40835 18.3333 10 18.3333C14.5917 18.3333 18.3334 14.5917 18.3334 9.99999C18.3334 5.40832 14.5917 1.66666 10 1.66666ZM9.37502 6.66666C9.37502 6.32499 9.65835 6.04166 10 6.04166C10.3417 6.04166 10.625 6.32499 10.625 6.66666V10.8333C10.625 11.175 10.3417 11.4583 10 11.4583C9.65835 11.4583 9.37502 11.175 9.37502 10.8333V6.66666ZM10.7667 13.65C10.725 13.7583 10.6667 13.8417 10.5917 13.925C10.5084 14 10.4167 14.0583 10.3167 14.1C10.2167 14.1417 10.1084 14.1667 10 14.1667C9.89169 14.1667 9.78335 14.1417 9.68335 14.1C9.58335 14.0583 9.49169 14 9.40835 13.925C9.33335 13.8417 9.27502 13.7583 9.23335 13.65C9.19169 13.55 9.16669 13.4417 9.16669 13.3333C9.16669 13.225 9.19169 13.1167 9.23335 13.0167C9.27502 12.9167 9.33335 12.825 9.40835 12.7417C9.49169 12.6667 9.58335 12.6083 9.68335 12.5667C9.88335 12.4833 10.1167 12.4833 10.3167 12.5667C10.4167 12.6083 10.5084 12.6667 10.5917 12.7417C10.6667 12.825 10.725 12.9167 10.7667 13.0167C10.8084 13.1167 10.8334 13.225 10.8334 13.3333C10.8334 13.4417 10.8084 13.55 10.7667 13.65Z" fill="#2467E3"></path></svg>`;

    } else if (type == "warning") {

        icon.innerHTML = `<svg stroke="currentColor" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="icon-sm" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><polygon points="7.86 2 16.14 2 22 7.86 22 16.14 16.14 22 7.86 22 2 16.14 2 7.86 7.86 2"></polygon><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>`;

    } else {

        icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none" class="info-icon"><path d="M10 1.66666C5.40835 1.66666 1.66669 5.40832 1.66669 9.99999C1.66669 14.5917 5.40835 18.3333 10 18.3333C14.5917 18.3333 18.3334 14.5917 18.3334 9.99999C18.3334 5.40832 14.5917 1.66666 10 1.66666ZM9.37502 6.66666C9.37502 6.32499 9.65835 6.04166 10 6.04166C10.3417 6.04166 10.625 6.32499 10.625 6.66666V10.8333C10.625 11.175 10.3417 11.4583 10 11.4583C9.65835 11.4583 9.37502 11.175 9.37502 10.8333V6.66666ZM10.7667 13.65C10.725 13.7583 10.6667 13.8417 10.5917 13.925C10.5084 14 10.4167 14.0583 10.3167 14.1C10.2167 14.1417 10.1084 14.1667 10 14.1667C9.89169 14.1667 9.78335 14.1417 9.68335 14.1C9.58335 14.0583 9.49169 14 9.40835 13.925C9.33335 13.8417 9.27502 13.7583 9.23335 13.65C9.19169 13.55 9.16669 13.4417 9.16669 13.3333C9.16669 13.225 9.19169 13.1167 9.23335 13.0167C9.27502 12.9167 9.33335 12.825 9.40835 12.7417C9.49169 12.6667 9.58335 12.6083 9.68335 12.5667C9.88335 12.4833 10.1167 12.4833 10.3167 12.5667C10.4167 12.6083 10.5084 12.6667 10.5917 12.7417C10.6667 12.825 10.725 12.9167 10.7667 13.0167C10.8084 13.1167 10.8334 13.225 10.8334 13.3333C10.8334 13.4417 10.8084 13.55 10.7667 13.65Z" fill="#2467E3"></path></svg>`;

    }

    const message = document.createElement('p');

    message.textContent = text;

    const closeButton = document.createElement('div');

    closeButton.classList.add('iconClose');

    closeButton.innerHTML = `<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" class="close"><path d="M5.91748 5.91666L14.0836 14.0828" stroke="#2D3443" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.91677 14.0828L14.0829 5.91666" stroke="#2D3443" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>`;

    closeButton.addEventListener("click", ()=> {

        toast.remove();

        const toasts = document.querySelectorAll('.toast_box');

        if (toasts.length < 1) {

            toastBox.remove();

        }

    });

    toast.appendChild(icon);

    toast.appendChild(message);

    toast.appendChild(closeButton);
    
    toastBox.appendChild(toast);

    toastBox.appendChild(toast);

    setTimeout(() => {

        toast.remove();

        const toasts = document.querySelectorAll('.toast_box');

        if (toasts.length == 0) {

            toastBox.remove()

        }

    }, duration);

}