<?php

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../partials/auth-header.php');

    $partialReg = false;

    if (isset($_SESSION['REG-ID'])) {

        $user = $_SESSION['REG-ID'];

        $userData = userData($user, $conn);

        if ($userData) {

            $partialReg = true;

        }

    }

    $extraScripts = <<<HTML

        <!-- UA Parser -->

        <script src="../resources/ua-parser/ua-parser.pack.js"></script>
        
    HTML; // Add UA-Parser

?>

<div class="reg_con">

    <!-- Sidebar -->

    <div class="sidebar">

        <div class="sb_controls">

            <div class="sb_control"></div>

            <div class="sb_control"></div>

            <div class="sb_control"></div>

        </div>

        <div class="logo">

            <a<?= !is_null(HOME_PAGE) ? ' href="' . HOME_PAGE . '"' : null ?>> 

                <img class="light" src="<?= SITE_LOGO ?>" alt="">

                <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

            </a>

        </div>

        <div class="sb_tbox">

            <div class="sb_tbox_con" id="iQ_slider">

                <div class="transbox active">

                    <img src="../assets/media/images/globe.svg" alt="">

                    <div class="tbox_tx">

                        <div class="title b">Receive your payments faster</div>

                        <p class="desc">
                            Open a global bank account to send and receive payments in minutes
                        </p>

                    </div>

                </div>

                <div class="transbox">

                    <img src="../assets/media/images/convert.svg" alt="">

                    <div class="tbox_tx">

                        <div class="title b">Instantly convert between currencies</div>

                        <p class="desc">
                            Swap currencies with no hidden fees at the best market rates.
                        </p>

                    </div>

                </div>

                <div class="transbox">

                    <img src="../assets/media/images/globe.svg" alt="">

                    <div class="tbox_tx">

                        <div class="title b">Spend globally with your Dollar card</div>

                        <p class="desc">

                            Spend freely with a debit card that makes your international payments easier

                        </p>

                    </div>

                </div>

            </div>

        </div>


        <div class="sb_footer">

            <div class="sb_ft_con">

                <p>&copy;<?= date('Y') . ' ' .  SITE_NAME; ?></p>

                <a href="../help-center">Help Center</a>

                <a href="../terms-conditions">Terms of Service</a>

            </div>

        </div>

    </div>

    <div class="viewBox">

        <div class="vbox_item header">

            <div class="logo">

                <a href="../home"> 

                    <img class="light" src="<?= SITE_LOGO ?>" alt="">

                    <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

                </a>

            </div>

            <!-- Registration Progress -->

            <div id="iQ_reg-track" class="reg_map<?= !$partialReg ? '' : ' step-4' ?>">

                <a class="back_ctrl">

                    <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.79822 2.78332L4.27745 6.26295L14.7838 6.31095C15.1085 6.31216 15.4193 6.44245 15.6479 6.67311C15.8764 6.90377 16.0038 7.21585 16.0019 7.54053C16.0004 7.86502 15.87 8.1756 15.6394 8.40387C15.4087 8.63214 15.0968 8.75937 14.7723 8.75755L4.2683 8.7107L7.74223 12.2258C7.9709 12.456 8.09867 12.7677 8.09738 13.0922C8.0961 13.4167 7.96586 13.7274 7.73537 13.9559C7.2549 14.4313 6.48017 14.4277 6.00412 13.9479L0.290433 8.17818C-0.098626 7.78278 -0.0935099 7.14685 0.301861 6.75776L6.07611 1.04407C6.55619 0.568793 7.33056 0.572374 7.80622 1.05207C8.03481 1.28267 8.1624 1.59465 8.1609 1.91935C8.1594 2.24405 8.02894 2.55484 7.79822 2.78332Z" fill="#808080"></path>
                    </svg>

                </a>

                <div class="reg_timeline">

                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 1</p>

                            <p class="b">Country of Residence</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>

                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 2</p>

                            <p class="b">Basic Information</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>

                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 3</p>

                            <p class="b">Security Setup</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>
                    
                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 4</p>

                            <p class="b">Personal Info</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>

                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 5</p>

                            <p class="b">Account Personalization</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>

                    <div class="reg_status">

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 6</p>

                            <p class="b">NOK Details</p>

                        </div>

                        <svg class="line" width="59" height="2" viewBox="0 0 59 2" fill="none" xmlns="http://www.w3.org/2000/svg" class="line-success">
                            <path d="M1 1H57.3333" stroke="#36B37E" stroke-width="2" stroke-linecap="round"></path>
                        </svg>

                    </div>

                    <div class="reg_status"> 

                        <div class="inactive_circle"></div>

                        <svg class="circle" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="9" cy="9" r="9" fill="#36B37E"></circle>
                            <path d="M6.19922 8.74242L7.2296 10.9652C7.25112 11.0116 7.286 11.0116 7.30753 10.9652L12.1992 7" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>

                        <div class="status_desc">

                            <p>Step 7</p>

                            <p class="b">Verify Email</p>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <div class="vbox_item main">

            <?php
            
                // Check For Previous Steps

                if (!$partialReg) { ?>

                    <form id="registerForm" method="post">

                        <div class="form_sect" id="reg-step-1">

                            <div class="form_con">

                                <p class="form_title">What country do you live in?</p>

                                <div class="form_item">

                                    <label for="residence" class="pos-rel">Country

                                        <div class="tooltip">

                                            <div class="tooltip-content">Your current country of residence</div>

                                            <div class="tooltip-icon">

                                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 56 56"><path d="M 27.9999 51.9063 C 41.0546 51.9063 51.9063 41.0781 51.9063 28 C 51.9063 14.9453 41.0312 4.0937 27.9765 4.0937 C 14.8983 4.0937 4.0937 14.9453 4.0937 28 C 4.0937 41.0781 14.9218 51.9063 27.9999 51.9063 Z M 27.7890 19.6563 C 26.0780 19.6563 24.7421 18.2968 24.7421 16.6094 C 24.7421 14.8984 26.0780 13.5390 27.7890 13.5390 C 29.4999 13.5390 30.8358 14.8984 30.8358 16.6094 C 30.8358 18.2968 29.4999 19.6563 27.7890 19.6563 Z M 23.8749 40.8906 C 22.9374 40.8906 22.1874 40.2109 22.1874 39.25 C 22.1874 38.3359 22.9374 37.6094 23.8749 37.6094 L 26.8046 37.6094 L 26.8046 26.8516 L 24.2733 26.8516 C 23.3358 26.8516 22.5858 26.1719 22.5858 25.2109 C 22.5858 24.2968 23.3358 23.5703 24.2733 23.5703 L 28.7030 23.5703 C 29.8749 23.5703 30.5312 24.4141 30.5312 25.6797 L 30.5312 37.6094 L 33.4374 37.6094 C 34.3983 37.6094 35.1483 38.3359 35.1483 39.25 C 35.1483 40.2109 34.3983 40.8906 33.4374 40.8906 Z"/></svg>

                                            </div>

                                        </div>

                                    </label>

                                    <select class="form_field iQ_focus search" name="residence" required autofocus>

                                        <option value="0">Select country</option>

                                        <option value="Afghanistan" title="Afghanistan">Afghanistan</option>
                                        <option value="Åland Islands" title="Åland Islands">Åland Islands</option>
                                        <option value="Albania" title="Albania">Albania</option>
                                        <option value="Algeria" title="Algeria">Algeria</option>
                                        <option value="American Samoa" title="American Samoa">American Samoa</option>
                                        <option value="Andorra" title="Andorra">Andorra</option>
                                        <option value="Angola" title="Angola">Angola</option>
                                        <option value="Anguilla" title="Anguilla">Anguilla</option>
                                        <option value="Antarctica" title="Antarctica">Antarctica</option>
                                        <option value="Antigua and Barbuda" title="Antigua and Barbuda">Antigua and Barbuda</option>
                                        <option value="Argentina" title="Argentina">Argentina</option>
                                        <option value="Armenia" title="Armenia">Armenia</option>
                                        <option value="Aruba" title="Aruba">Aruba</option>
                                        <option value="Australia" title="Australia">Australia</option>
                                        <option value="Austria" title="Austria">Austria</option>
                                        <option value="Azerbaijan" title="Azerbaijan">Azerbaijan</option>
                                        <option value="Bahamas" title="Bahamas">Bahamas</option>
                                        <option value="Bahrain" title="Bahrain">Bahrain</option>
                                        <option value="Bangladesh" title="Bangladesh">Bangladesh</option>
                                        <option value="Barbados" title="Barbados">Barbados</option>
                                        <option value="Belarus" title="Belarus">Belarus</option>
                                        <option value="Belgium" title="Belgium">Belgium</option>
                                        <option value="Belize" title="Belize">Belize</option>
                                        <option value="Benin" title="Benin">Benin</option>
                                        <option value="Bermuda" title="Bermuda">Bermuda</option>
                                        <option value="Bhutan" title="Bhutan">Bhutan</option>
                                        <option value="Bolivia, Plurinational State of" title="Bolivia, Plurinational State of">Bolivia, Plurinational State of</option>
                                        <option value="Bonaire, Sint Eustatius and Saba" title="Bonaire, Sint Eustatius and Saba">Bonaire, Sint Eustatius and Saba</option>
                                        <option value="Bosnia and Herzegovina" title="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                        <option value="Botswana" title="Botswana">Botswana</option>
                                        <option value="Bouvet Island" title="Bouvet Island">Bouvet Island</option>
                                        <option value="Brazil" title="Brazil">Brazil</option>
                                        <option value="British Indian Ocean Territory" title="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                        <option value="Brunei Darussalam" title="Brunei Darussalam">Brunei Darussalam</option>
                                        <option value="Bulgaria" title="Bulgaria">Bulgaria</option>
                                        <option value="Burkina Faso" title="Burkina Faso">Burkina Faso</option>
                                        <option value="Burundi" title="Burundi">Burundi</option>
                                        <option value="Cambodia" title="Cambodia">Cambodia</option>
                                        <option value="Cameroon" title="Cameroon">Cameroon</option>
                                        <option value="Canada" title="Canada">Canada</option>
                                        <option value="Cape Verde" title="Cape Verde">Cape Verde</option>
                                        <option value="Cayman Islands" title="Cayman Islands">Cayman Islands</option>
                                        <option value="Central African Republic" title="Central African Republic">Central African Republic</option>
                                        <option value="Chad" title="Chad">Chad</option>
                                        <option value="Chile" title="Chile">Chile</option>
                                        <option value="China" title="China">China</option>
                                        <option value="Christmas Island" title="Christmas Island">Christmas Island</option>
                                        <option value="Cocos (Keeling) Islands" title="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                                        <option value="Colombia" title="Colombia">Colombia</option>
                                        <option value="Comoros" title="Comoros">Comoros</option>
                                        <option value="Congo" title="Congo">Congo</option>
                                        <option value="Congo, the Democratic Republic of the" title="Congo, the Democratic Republic of the">Congo, the Democratic Republic of the</option>
                                        <option value="Cook Islands" title="Cook Islands">Cook Islands</option>
                                        <option value="Costa Rica" title="Costa Rica">Costa Rica</option>
                                        <option value="Côte d'Ivoire" title="Côte d'Ivoire">Côte d'Ivoire</option>
                                        <option value="Croatia" title="Croatia">Croatia</option>
                                        <option value="Cuba" title="Cuba">Cuba</option>
                                        <option value="Curaçao" title="Curaçao">Curaçao</option>
                                        <option value="Cyprus" title="Cyprus">Cyprus</option>
                                        <option value="Czech Republic" title="Czech Republic">Czech Republic</option>
                                        <option value="Denmark" title="Denmark">Denmark</option>
                                        <option value="Djibouti" title="Djibouti">Djibouti</option>
                                        <option value="Dominica" title="Dominica">Dominica</option>
                                        <option value="Dominican Republic" title="Dominican Republic">Dominican Republic</option>
                                        <option value="Ecuador" title="Ecuador">Ecuador</option>
                                        <option value="Egypt" title="Egypt">Egypt</option>
                                        <option value="El Salvador" title="El Salvador">El Salvador</option>
                                        <option value="Equatorial Guinea" title="Equatorial Guinea">Equatorial Guinea</option>
                                        <option value="Eritrea" title="Eritrea">Eritrea</option>
                                        <option value="Estonia" title="Estonia">Estonia</option>
                                        <option value="Ethiopia" title="Ethiopia">Ethiopia</option>
                                        <option value="Falkland Islands (Malvinas)" title="Falkland Islands (Malvinas)">Falkland Islands (Malvinas)</option>
                                        <option value="Faroe Islands" title="Faroe Islands">Faroe Islands</option>
                                        <option value="Fiji" title="Fiji">Fiji</option>
                                        <option value="Finland" title="Finland">Finland</option>
                                        <option value="France" title="France">France</option>
                                        <option value="French Guiana" title="French Guiana">French Guiana</option>
                                        <option value="French Polynesia" title="French Polynesia">French Polynesia</option>
                                        <option value="French Southern Territories" title="French Southern Territories">French Southern Territories</option>
                                        <option value="Gabon" title="Gabon">Gabon</option>
                                        <option value="Gambia" title="Gambia">Gambia</option>
                                        <option value="Georgia" title="Georgia">Georgia</option>
                                        <option value="Germany" title="Germany">Germany</option>
                                        <option value="Ghana" title="Ghana">Ghana</option>
                                        <option value="Gibraltar" title="Gibraltar">Gibraltar</option>
                                        <option value="Greece" title="Greece">Greece</option>
                                        <option value="Greenland" title="Greenland">Greenland</option>
                                        <option value="Grenada" title="Grenada">Grenada</option>
                                        <option value="Guadeloupe" title="Guadeloupe">Guadeloupe</option>
                                        <option value="Guam" title="Guam">Guam</option>
                                        <option value="Guatemala" title="Guatemala">Guatemala</option>
                                        <option value="Guernsey" title="Guernsey">Guernsey</option>
                                        <option value="Guinea" title="Guinea">Guinea</option>
                                        <option value="Guinea-Bissau" title="Guinea-Bissau">Guinea-Bissau</option>
                                        <option value="Guyana" title="Guyana">Guyana</option>
                                        <option value="Haiti" title="Haiti">Haiti</option>
                                        <option value="Heard Island and McDonald Islands" title="Heard Island and McDonald Islands">Heard Island and McDonald Islands</option>
                                        <option value="Holy See (Vatican City State)" title="Holy See (Vatican City State)">Holy See (Vatican City State)</option>
                                        <option value="Honduras" title="Honduras">Honduras</option>
                                        <option value="Hong Kong" title="Hong Kong">Hong Kong</option>
                                        <option value="Hungary" title="Hungary">Hungary</option>
                                        <option value="Iceland" title="Iceland">Iceland</option>
                                        <option value="India" title="India">India</option>
                                        <option value="Indonesia" title="Indonesia">Indonesia</option>
                                        <option value="Iran, Islamic Republic of" title="Iran, Islamic Republic of">Iran, Islamic Republic of</option>
                                        <option value="Iraq" title="Iraq">Iraq</option>
                                        <option value="Ireland" title="Ireland">Ireland</option>
                                        <option value="Isle of Man" title="Isle of Man">Isle of Man</option>
                                        <option value="Israel" title="Israel">Israel</option>
                                        <option value="Italy" title="Italy">Italy</option>
                                        <option value="Jamaica" title="Jamaica">Jamaica</option>
                                        <option value="Japan" title="Japan">Japan</option>
                                        <option value="Jersey" title="Jersey">Jersey</option>
                                        <option value="Jordan" title="Jordan">Jordan</option>
                                        <option value="Kazakhstan" title="Kazakhstan">Kazakhstan</option>
                                        <option value="Kenya" title="Kenya">Kenya</option>
                                        <option value="Kiribati" title="Kiribati">Kiribati</option>
                                        <option value="Korea, Democratic People's Republic of" title="Korea, Democratic People's Republic of">Korea, Democratic People's Republic of</option>
                                        <option value="Korea, Republic of" title="Korea, Republic of">Korea, Republic of</option>
                                        <option value="Kuwait" title="Kuwait">Kuwait</option>
                                        <option value="Kyrgyzstan" title="Kyrgyzstan">Kyrgyzstan</option>
                                        <option value="Lao People's Democratic Republic" title="Lao People's Democratic Republic">Lao People's Democratic Republic</option>
                                        <option value="Latvia" title="Latvia">Latvia</option>
                                        <option value="Lebanon" title="Lebanon">Lebanon</option>
                                        <option value="Lesotho" title="Lesotho">Lesotho</option>
                                        <option value="Liberia" title="Liberia">Liberia</option>
                                        <option value="Libya" title="Libya">Libya</option>
                                        <option value="Liechtenstein" title="Liechtenstein">Liechtenstein</option>
                                        <option value="Lithuania" title="Lithuania">Lithuania</option>
                                        <option value="Luxembourg" title="Luxembourg">Luxembourg</option>
                                        <option value="Macao" title="Macao">Macao</option>
                                        <option value="Macedonia, the former Yugoslav Republic of" title="Macedonia, the former Yugoslav Republic of">Macedonia, the former Yugoslav Republic of</option>
                                        <option value="Madagascar" title="Madagascar">Madagascar</option>
                                        <option value="Malawi" title="Malawi">Malawi</option>
                                        <option value="Malaysia" title="Malaysia">Malaysia</option>
                                        <option value="Maldives" title="Maldives">Maldives</option>
                                        <option value="Mali" title="Mali">Mali</option>
                                        <option value="Malta" title="Malta">Malta</option>
                                        <option value="Marshall Islands" title="Marshall Islands">Marshall Islands</option>
                                        <option value="Martinique" title="Martinique">Martinique</option>
                                        <option value="Mauritania" title="Mauritania">Mauritania</option>
                                        <option value="Mauritius" title="Mauritius">Mauritius</option>
                                        <option value="Mayotte" title="Mayotte">Mayotte</option>
                                        <option value="Mexico" title="Mexico">Mexico</option>
                                        <option value="Micronesia, Federated States of" title="Micronesia, Federated States of">Micronesia, Federated States of</option>
                                        <option value="Moldova, Republic of" title="Moldova, Republic of">Moldova, Republic of</option>
                                        <option value="Monaco" title="Monaco">Monaco</option>
                                        <option value="Mongolia" title="Mongolia">Mongolia</option>
                                        <option value="Montenegro" title="Montenegro">Montenegro</option>
                                        <option value="Montserrat" title="Montserrat">Montserrat</option>
                                        <option value="Morocco" title="Morocco">Morocco</option>
                                        <option value="Mozambique" title="Mozambique">Mozambique</option>
                                        <option value="Myanmar" title="Myanmar">Myanmar</option>
                                        <option value="Namibia" title="Namibia">Namibia</option>
                                        <option value="Nauru" title="Nauru">Nauru</option>
                                        <option value="Nepal" title="Nepal">Nepal</option>
                                        <option value="Netherlands" title="Netherlands">Netherlands</option>
                                        <option value="New Caledonia" title="New Caledonia">New Caledonia</option>
                                        <option value="New Zealand" title="New Zealand">New Zealand</option>
                                        <option value="Nicaragua" title="Nicaragua">Nicaragua</option>
                                        <option value="Niger" title="Niger">Niger</option>
                                        <option value="Nigeria" title="Nigeria">Nigeria</option>
                                        <option value="Niue" title="Niue">Niue</option>
                                        <option value="Norfolk Island" title="Norfolk Island">Norfolk Island</option>
                                        <option value="Northern Mariana Islands" title="Northern Mariana Islands">Northern Mariana Islands</option>
                                        <option value="Norway" title="Norway">Norway</option>
                                        <option value="Oman" title="Oman">Oman</option>
                                        <option value="Pakistan" title="Pakistan">Pakistan</option>
                                        <option value="Palau" title="Palau">Palau</option>
                                        <option value="Palestinian Territory, Occupied" title="Palestinian Territory, Occupied">Palestinian Territory, Occupied</option>
                                        <option value="Panama" title="Panama">Panama</option>
                                        <option value="Papua New Guinea" title="Papua New Guinea">Papua New Guinea</option>
                                        <option value="Paraguay" title="Paraguay">Paraguay</option>
                                        <option value="Peru" title="Peru">Peru</option>
                                        <option value="Philippines" title="Philippines">Philippines</option>
                                        <option value="Pitcairn" title="Pitcairn">Pitcairn</option>
                                        <option value="Poland" title="Poland">Poland</option>
                                        <option value="Portugal" title="Portugal">Portugal</option>
                                        <option value="Puerto Rico" title="Puerto Rico">Puerto Rico</option>
                                        <option value="Qatar" title="Qatar">Qatar</option>
                                        <option value="Réunion" title="Réunion">Réunion</option>
                                        <option value="Romania" title="Romania">Romania</option>
                                        <option value="Russian Federation" title="Russian Federation">Russian Federation</option>
                                        <option value="Rwanda" title="Rwanda">Rwanda</option>
                                        <option value="Saint Barthélemy" title="Saint Barthélemy">Saint Barthélemy</option>
                                        <option value="Saint Helena, Ascension and Tristan da Cunha" title="Saint Helena, Ascension and Tristan da Cunha">Saint Helena, Ascension and Tristan da Cunha</option>
                                        <option value="Saint Kitts and Nevis" title="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                        <option value="Saint Lucia" title="Saint Lucia">Saint Lucia</option>
                                        <option value="Saint Martin (French part)" title="Saint Martin (French part)">Saint Martin (French part)</option>
                                        <option value="Saint Pierre and Miquelon" title="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
                                        <option value="Saint Vincent and the Grenadines" title="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                                        <option value="Samoa" title="Samoa">Samoa</option>
                                        <option value="San Marino" title="San Marino">San Marino</option>
                                        <option value="Sao Tome and Principe" title="Sao Tome and Principe">Sao Tome and Principe</option>
                                        <option value="Saudi Arabia" title="Saudi Arabia">Saudi Arabia</option>
                                        <option value="Senegal" title="Senegal">Senegal</option>
                                        <option value="Serbia" title="Serbia">Serbia</option>
                                        <option value="Seychelles" title="Seychelles">Seychelles</option>
                                        <option value="Sierra Leone" title="Sierra Leone">Sierra Leone</option>
                                        <option value="Singapore" title="Singapore">Singapore</option>
                                        <option value="Sint Maarten (Dutch part)" title="Sint Maarten (Dutch part)">Sint Maarten (Dutch part)</option>
                                        <option value="Slovakia" title="Slovakia">Slovakia</option>
                                        <option value="Slovenia" title="Slovenia">Slovenia</option>
                                        <option value="Solomon Islands" title="Solomon Islands">Solomon Islands</option>
                                        <option value="Somalia" title="Somalia">Somalia</option>
                                        <option value="South Africa" title="South Africa">South Africa</option>
                                        <option value="South Georgia and the South Sandwich Islands" title="South Georgia and the South Sandwich Islands">South Georgia and the South Sandwich Islands</option>
                                        <option value="South Sudan" title="South Sudan">South Sudan</option>
                                        <option value="Spain" title="Spain">Spain</option>
                                        <option value="Sri Lanka" title="Sri Lanka">Sri Lanka</option>
                                        <option value="Sudan" title="Sudan">Sudan</option>
                                        <option value="Suriname" title="Suriname">Suriname</option>
                                        <option value="Svalbard and Jan Mayen" title="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
                                        <option value="Swaziland" title="Swaziland">Swaziland</option>
                                        <option value="Sweden" title="Sweden">Sweden</option>
                                        <option value="Switzerland" title="Switzerland">Switzerland</option>
                                        <option value="Syrian Arab Republic" title="Syrian Arab Republic">Syrian Arab Republic</option>
                                        <option value="Taiwan, Province of China" title="Taiwan, Province of China">Taiwan, Province of China</option>
                                        <option value="Tajikistan" title="Tajikistan">Tajikistan</option>
                                        <option value="Tanzania, United Republic of" title="Tanzania, United Republic of">Tanzania, United Republic of</option>
                                        <option value="Thailand" title="Thailand">Thailand</option>
                                        <option value="Timor-Leste" title="Timor-Leste">Timor-Leste</option>
                                        <option value="Togo" title="Togo">Togo</option>
                                        <option value="Tokelau" title="Tokelau">Tokelau</option>
                                        <option value="Tonga" title="Tonga">Tonga</option>
                                        <option value="Trinidad and Tobago" title="Trinidad and Tobago">Trinidad and Tobago</option>
                                        <option value="Tunisia" title="Tunisia">Tunisia</option>
                                        <option value="Turkey" title="Turkey">Turkey</option>
                                        <option value="Turkmenistan" title="Turkmenistan">Turkmenistan</option>
                                        <option value="Turks and Caicos Islands" title="Turks and Caicos Islands">Turks and Caicos Islands</option>
                                        <option value="Tuvalu" title="Tuvalu">Tuvalu</option>
                                        <option value="Uganda" title="Uganda">Uganda</option>
                                        <option value="Ukraine" title="Ukraine">Ukraine</option>
                                        <option value="United Arab Emirates" title="United Arab Emirates">United Arab Emirates</option>
                                        <option value="United Kingdom" title="United Kingdom">United Kingdom</option>
                                        <option value="United States" title="United States">United States</option>
                                        <option value="United States Minor Outlying Islands" title="United States Minor Outlying Islands">United States Minor Outlying Islands</option>
                                        <option value="Uruguay" title="Uruguay">Uruguay</option>
                                        <option value="Uzbekistan" title="Uzbekistan">Uzbekistan</option>
                                        <option value="Vanuatu" title="Vanuatu">Vanuatu</option>
                                        <option value="Venezuela, Bolivarian Republic of" title="Venezuela, Bolivarian Republic of">Venezuela, Bolivarian Republic of</option>
                                        <option value="Viet Nam" title="Viet Nam">Viet Nam</option>
                                        <option value="Virgin Islands, British" title="Virgin Islands, British">Virgin Islands, British</option>
                                        <option value="Virgin Islands, U.S." title="Virgin Islands, U.S.">Virgin Islands, U.S.</option>
                                        <option value="Wallis and Futuna" title="Wallis and Futuna">Wallis and Futuna</option>
                                        <option value="Western Sahara" title="Western Sahara">Western Sahara</option>
                                        <option value="Yemen" title="Yemen">Yemen</option>
                                        <option value="Zambia" title="Zambia">Zambia</option>
                                        <option value="Zimbabwe" title="Zimbabwe">Zimbabwe</option>

                                    </select>

                                </div>

                                <div class="form_item">

                                    <button type="button" name="r-step-1" class="form_btn">Continue &rarr;</button>

                                </div>

                            </div>

                            <div class="fd_tx b">Got an account? <a href="login" class="dft_link">Sign in</a></div>

                        </div>

                        <div class="form_sect n_displ" id="reg-step-2">

                            <div class="form_con">

                                <p class="form_title">Setup your account</p>

                                <div class="form_item db">

                                    <div class="form_item">

                                        <label for="user_fname">Legal Firstname</label>

                                        <input type="text" name="user_fname" class="form_field" placeholder="Firstname" value="<?= (isset($_POST['user_fname'])) ? $_POST['user_fname'] : ""; ?>" required autofocus>

                                    </div>

                                    <div class="form_item">

                                        <label for="user_lname">Legal Surname</label>

                                        <input type="text" name="user_lname" class="form_field" placeholder="Surname" value="<?= (isset($_POST['user_lname'])) ? $_POST['user_lname'] : ""; ?>" required>

                                    </div>

                                </div>

                                <div class="form_item">

                                    <label for="user_mname">Legal Middlename</label>

                                    <input type="text" name="user_mname" class="form_field" placeholder="Middlename" value="<?= (isset($_POST['user_mname'])) ? $_POST['user_mname'] : ""; ?>">

                                </div>

                                <div class="form_item">

                                    <label for="user_gender">Select your gender</label>

                                    <select class="form_field" name="user_gender">

                                        <option data-display="Select your Gender" value="0">Select your Gender</option>

                                        <option value="Female">Female</option>

                                        <option value="Male">Male</option>

                                        <option value="Others">Others</option>

                                    </select>

                                </div>

                                <div class="form_item">

                                    <label for="user_email">Email Address</label>

                                    <input type="email" name="user_email" class="form_field" placeholder="Enter your email address" value="<?= (isset($_POST['user_email'])) ? $_POST['user_email'] : ""; ?>" required>

                                </div>

                                <div class="form_item">

                                    <label for="user_tel">Phone Number</label>

                                    <input type="tel" name="user_tel" class="form_field" placeholder="Enter phone number" value="<?= (isset($_POST['user_tel'])) ? $_POST['user_tel'] : ""; ?>" required>

                                </div>

                                <div class="form_item">

                                    <button name="r-step-2" type="button" class="form_btn">Continue &rarr;</button>

                                </div>

                            </div>

                        </div>

                        <div class="form_sect n_displ" id="reg-step-3">

                            <div class="form_con">

                                <p class="form_title">Security Settings</p>

                                <div class="form_item">

                                    <label for="user_key">Password</label>

                                    <div class="form_field pseudoField">

                                        <input id="iQ_key" class="iQ_veilField" type="password" name="user_key" required autocomplete="off">

                                        <div class="iQ_veiler">

                                            <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0)">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0">
                                                        <rect width="16" height="16" fill="currentColor"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>

                                            <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0)">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0">
                                                        <rect width="16" height="16" fill="currentColor"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>

                                        </div>

                                    </div>

                                </div>

                                <div id="pwrd-criteria" class="n_displ">

                                    <div class="form_item req">

                                        <span class="bl">At Least:</span>

                                        <div class="req_map">

                                            <div class="req_key">

                                                <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>

                                                <span>8 characters</span>

                                            </div>

                                            <div class="req_key">

                                                <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>

                                                <span>An uppercase letter</span>

                                            </div>

                                            <div class="req_key">

                                                <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>

                                                <span>A lowercase letter</span>

                                            </div>

                                            <div class="req_key">

                                                <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>

                                                <span>A special character</span>

                                            </div>

                                            <div class="req_key">

                                                <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>

                                                <span>A number</span>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                <div class="form_item">

                                    <label for="r-key">Confirm Password</label>

                                    <div class="form_field pseudoField">

                                        <input class="iQ_veilField" type="password" name="r-key" required autocomplete="off">

                                        <div class="iQ_veiler">

                                            <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0)">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0">
                                                        <rect width="16" height="16" fill="currentColor"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>

                                            <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0)">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0">
                                                        <rect width="16" height="16" fill="currentColor"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>

                                        </div>

                                    </div>

                                </div>

                                <div class="form_item mltpl integrate">
                                
                                    <label for="t-digit">Transaction PIN</label>

                                    <div class="mltpl_fields">

                                        <input type="text" name="t-digit_1" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                        <input type="text" name="t-digit_2" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                        <input type="text" name="t-digit_3" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                        <input type="text" name="t-digit_4" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                        <input type="text" name="t-digit_5" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                        <input type="text" name="t-digit_6" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autocomplete="off">

                                    </div>    

                                </div>

                                <div class="form_item db">

                                    <div class="form_item">

                                        <label for="sq1">Secret Question 1</label>

                                        <select class="form_field" name="sq1" required>

                                            <option data-display="Select a question" value="0">Select a question</option>

                                            <option value="What is the name of your first pet?">What is the name of your first pet?</option>

                                            <option value="In what city were you born?">In what city were you born?</option>

                                            <option value="What is your mother's maiden name?">What is your mother's maiden name?</option>

                                            <option value="What was the name of your elementary school?">What was the name of your elementary school?</option>

                                            <option value="What was your childhood nickname?">What was your childhood nickname?</option>

                                            <option value="What was the street name you grew up on?">What was the street name you grew up on?</option>

                                            <option value="What was the make and model of your first car?">What was the make and model of your first car?</option>

                                            <option value="What is your father's middle name?">What is your father's middle name?</option>

                                            <option value="What is your oldest sibling’s middle name?">What is your oldest sibling’s middle name?</option>

                                            <option value="What is the name of the hospital where you were born?">What is the name of the hospital where you were born?</option>

                                            <option value="What was the name of your first teacher?">What was the name of your first teacher?</option>

                                            <option value="What was the name of your first school friend?">What was the name of your first school friend?</option>

                                            <option value="What was your first job title?">What was your first job title?</option>

                                            <option value="What company gave you your first paycheck?">What company gave you your first paycheck?</option>

                                            <option value="What was your dream job as a child?">What was your dream job as a child?</option>

                                            <option value="What was the first concert you attended?">What was the first concert you attended?</option>

                                            <option value="What was the first movie you saw in a theater?">What was the first movie you saw in a theater?</option>

                                            <option value="What was your first mobile phone brand?">What was your first mobile phone brand?</option>

                                            <option value="What was your first email address (without the domain)?">What was your first email address (without the domain)?</option>

                                            <option value="What was the name of your first boss?">What was the name of your first boss?</option>


                                        </select>

                                    </div>

                                    <div class="form_item">

                                        <label for="a_sq1">Answer to Secret Question 1</label>

                                        <input type="text" name="a_sq1" class="form_field" placeholder="Secret Answer 1" value="<?= (isset($_POST['a_sq1'])) ? $_POST['a_sq1'] : ""; ?>" required>

                                    </div>

                                </div>

                                <div class="form_item db">

                                    <div class="form_item">

                                        <label for="sq2">Secret Question 2</label>

                                        <select class="form_field" name="sq2" required>

                                            <option data-display="Select a question" value="0">Select a question</option>

                                            <option value="What is your favorite movie of all time?">What is your favorite movie of all time?</option>

                                            <option value="What was your favorite subject in school?">What was your favorite subject in school?</option>

                                            <option value="What is your favorite sports team?">What is your favorite sports team?</option>

                                            <option value="What is your favorite book?">What is your favorite book?</option>

                                            <option value="What is your favorite childhood TV show?">What is your favorite childhood TV show?</option>

                                            <option value="Where did you go on your first flight?">Where did you go on your first flight?</option>

                                            <option value="What is the name of the first beach you visited?">What is the name of the first beach you visited?</option>

                                            <option value="What city did you visit on your first vacation?">What city did you visit on your first vacation?</option>

                                            <option value="What is the name of your favorite restaurant in your hometown?">What is the name of your favorite restaurant in your hometown?</option>

                                            <option value="Where did you celebrate your last birthday?">Where did you celebrate your last birthday?</option>

                                            <option value="What was the name of your childhood best friend?">What was the name of your childhood best friend?</option>

                                            <option value="What was your favorite toy as a child?">What was your favorite toy as a child?</option>

                                            <option value="What game did you play most as a child?">What game did you play most as a child?</option>

                                            <option value="What did you want to be when you grew up?">What did you want to be when you grew up?</option>

                                            <option value="What was the color of your childhood bedroom?">What was the color of your childhood bedroom?</option>

                                            <option value="What was the name of the town your grandparents lived in?">What was the name of the town your grandparents lived in?</option>

                                            <option value="What was the name of your first roommate?">What was the name of your first roommate?</option>

                                            <option value="What is the name of a place you’ve always wanted to visit?">What is the name of a place you’ve always wanted to visit?</option>

                                            <option value="What was the first foreign country you visited?">What was the first foreign country you visited?</option>

                                            <option value="What is the name of your favorite vacation spot?">What is the name of your favorite vacation spot?</option>

                                            <option value="What is the name of your first boyfriend/girlfriend?">What is the name of your first boyfriend/girlfriend?</option>

                                            <option value="What was the name of your first crush?">What was the name of your first crush?</option>

                                            <option value="What is your best friend’s nickname?">What is your best friend’s nickname?</option>

                                            <option value="Where did you meet your significant other?">Where did you meet your significant other?</option>

                                            <option value="What is the anniversary month of your parents?">What is the anniversary month of your parents?</option>

                                            <option value="What is your favorite meal your mom/dad used to cook?">What is your favorite meal your mom/dad used to cook?</option>

                                            <option value="What is your favorite dessert?">What is your favorite dessert?</option>

                                            <option value="What is your least favorite food?">What is your least favorite food?</option>

                                            <option value="What was your favorite food as a child?">What was your favorite food as a child?</option>

                                            <option value="What’s the name of your favorite hometown café or eatery?">What’s the name of your favorite hometown café or eatery?</option>

                                            <option value="In what city did you attend your first wedding?">In what city did you attend your first wedding?</option>

                                            <option value="Who was your childhood hero?">Who was your childhood hero?</option>

                                            <option value="What was your high school mascot?">What was your high school mascot?</option>

                                            <option value="What was the theme of your prom?">What was the theme of your prom?</option>

                                            <option value="What was your graduation year?">What was your graduation year?</option>

                                            <option value="What was the name of your imaginary friend?">What was the name of your imaginary friend?</option>

                                            <option value="What is the name of your favorite video game character?">What is the name of your favorite video game character?</option>

                                            <option value="What color was your first bicycle?">What color was your first bicycle?</option>

                                            <option value="What is your favorite board game?">What is your favorite board game?</option>

                                            <option value="What is a unique talent or hobby you had growing up?">What is a unique talent or hobby you had growing up?</option>


                                        </select>

                                    </div>

                                    <div class="form_item">

                                        <label for="a_sq2">Answer to Secret Question 2</label>

                                        <input type="text" name="a_sq2" class="form_field" placeholder="Secret 2 Answer" value="<?= (isset($_POST['a_sq2'])) ? $_POST['a_sq2'] : ""; ?>" required>

                                    </div>

                                </div>

                                <div class="form_item">

                                    <button type="submit" id="reg-conclude" name="step3_submit" class="form_btn">Continue &rarr;</button>

                                </div>

                                <p class="form_info">

                                    By clicking continue, you accept our <a href="../terms-conditions" target="_blank" class="form_link">Terms of use</a> and <a href="../privacy-policy" target="_blank" class="form_link">Privacy Policy</a>.

                                </p>

                            </div>

                        </div>

                    </form>

                <?php  

                }

            ?>

            

            <form id="registerFormB" method="post">

                <div class="form_sect<?= !$partialReg ? ' n_displ' : '' ?>" id="reg-step-4">

                    <div class="form_con">

                        <p class="form_title">Personal Info</p>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="origin">Nationality</label>

                                <input type="text" name="origin" class="form_field" placeholder="Citizenship" value="<?= (isset($_POST['origin'])) ? $_POST['origin'] : ""; ?>" required>

                            </div>

                            <div class="form_item">

                                <label for="dob">Date Of Birth</label>

                                <input type="date" name="dob" class="form_field" value="<?= (isset($_POST['dob'])) ? $_POST['dob'] : ""; ?>" required>

                            </div>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="religion">Religion</label>

                                <input type="text" name="religion" class="form_field" placeholder="Christianity / (None)" value="<?= (isset($_POST['religion'])) ? $_POST['religion'] : ""; ?>" required>

                            </div>

                            <div class="form_item">

                                <label for="occupation">Occupation</label>

                                <input type="text" name="occupation" class="form_field" placeholder="Job / Unemployed" value="<?= (isset($_POST['occupation'])) ? $_POST['occupation'] : ""; ?>" required>

                            </div>

                        </div>

                        <div class="form_item">

                            <label for="income">Annual Earnings</label>

                            <select name="income" class="form_field">
                                <option value="0">Select Income Range</option>
                                <option value="$100.00 - $500.00">$100.00 - $500.00</option> 
                                <option value="$700.00 - $1,000.00">$700.00 - $1,000.00</option> 
                                <option value="$1,000.00 - $2,000.00">$1,000.00 - $2,000.00</option> 
                                <option value="$2,000.00 - $5,000.00">$2,000.00 - $5,000.00</option> 
                                <option value="$5,000.00 - $10,000.00">$5,000.00 - $10,000.00</option> 
                                <option value="$15,000.00 - $20,000.00">$15,000.00 - $20,000.00</option> 
                                <option value="$25,000.00 - $30,000.00">$25,000.00 - $30,000.00</option> 
                                <option value="$30,000.00 - $70,000.00">$30,000.00 - $70,000.00</option> 
                                <option value="$80,000.00 - $140,000.00">$80,000.00 - $140,000.00</option> 
                                <option value="$150,000.00 - $300,000.00">$150,000.00 - $300,000.00</option> 
                                <option value="$300,000.00 - $1,000,000.00">$300,000.00 - $1,000,000.00</option>
                                <option value="$1,000,000.00+">$1,000,000.00+</option> 
                            </select>

                        </div>

                        <div class="form_item radio">

                            <label for="maritial">Maritial Status</label>

                            <div class="iQ_radio" title="Married"><input type="radio" name="marital" value="MARRIED" required> <span>Married</span></div>

                            <div class="iQ_radio" title="Single"><input type="radio" name="marital" value="SINGLE"> <span>Single</span></div>

                        </div>

                        <div class="form_item">

                            <label for="addr">Street address</label>
                        
                            <input name="addr" type="text" class="form_field" placeholder="Enter street address" required value="<?= isset($_REQUEST['addr']) ? $_REQUEST['addr'] : '' ?>">

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="city">City</label>
                            
                                <input name="city" type="text" class="form_field" placeholder="Enter your city" required value="<?= isset($_REQUEST['city']) ? $_REQUEST['city'] : '' ?>">

                            </div>
                            
                            <div class="form_item">

                                <label for="state">State</label>
                            
                                <input name="state" type="text" class="form_field" placeholder="Enter state" required value="<?= isset($_REQUEST['state']) ? $_REQUEST['state'] : '' ?>">

                            </div>
                            
                        </div>

                        <div class="form_item">

                            <label for="zip_code">ZIP code</label>
                            
                            <input name="zip_code" type="text" class="form_field" placeholder="Enter Zip code" required value="<?= isset($_REQUEST['zip_code']) ? $_REQUEST['zip_code'] : '' ?>">

                        </div>

                        <div class="form_item">

                            <button name="r-step-4" type="button" class="form_btn">Continue &rarr;</button>

                        </div>

                    </div>

                </div>

                <div class="form_sect n_displ" id="reg-step-5">

                    <div class="form_con">

                        <p class="form_title">Account Personalization</p>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="username">Username</label>

                                <input type="text" name="username" class="form_field" placeholder="Unique Identifier" value="<?= (isset($_POST['username'])) ? $_POST['username'] : ""; ?>" required>

                            </div>

                            <div class="form_item">

                                <label for="acc_type">Account Type</label>

                                <select name="acc_type" class="form_field">
                                                
                                    <option value="0">Select an Account Type</option> 
                                    <option value="CHECKING">Checking Account</option>
                                    <option value="SAVINGS">Saving Account</option>
                                    <option value="FIXED DEPOSIT">Fixed Deposit Account</option>
                                    <option value="CURRENT">Current Account</option>
                                    <option value="JOINT">Joint Account</option>
                                    <option value="BUSINESS">Business Account</option>
                                    <option value="NON RESIDENT">Non Resident Account</option>
                                    <option value="CORPERATE BUSINESS">Corperate Business Account</option>
                                    <option value="INVESTMENT">Investment Account</option>
                                            
                                </select>

                            </div>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="currency">Account Currency</label>

                                <select class="form_field search" name="currency">

                                    <option value="0">Select Currency</option>

                                    <option value="AFN">Afghan afghani (AFN)</option>
                                    <option value="ALL">Albanian lek (ALL)</option>
                                    <option value="DZD">Algerian dinar (DZD)</option>
                                    <option value="AOA">Angolan kwanza (AOA)</option>
                                    <option value="ARS">Argentine peso (ARS)</option>
                                    <option value="AMD">Armenian dram (AMD)</option>
                                    <option value="AWG">Aruban florin (AWG)</option>
                                    <option value="AUD">Australian dollar (AUD)</option>
                                    <option value="AZN">Azerbaijani manat (AZN)</option>
                                    <option value="BHD">Bahraini dinar (BHD)</option>
                                    <option value="BSD">Bahamian dollar (BSD)</option>
                                    <option value="BDT">Bangladeshi taka (BDT)</option>
                                    <option value="BBD">Barbadian dollar (BBD)</option>
                                    <option value="BYN">Belarusian ruble (BYN)</option>
                                    <option value="BZD">Belize dollar (BZD)</option>
                                    <option value="BMD">Bermudian dollar (BMD)</option>
                                    <option value="BTN">Bhutanese ngultrum (BTN)</option>
                                    <option value="BOB">Bolivian boliviano (BOB)</option>
                                    <option value="BAM">Bosnia and Herzegovina convertible mark (BAM)</option>
                                    <option value="BWP">Botswana pula (BWP)</option>
                                    <option value="BRL">Brazilian real (BRL)</option>
                                    <option value="GBP">British pound (GBP)</option>
                                    <option value="BND">Brunei dollar (BND)</option>
                                    <option value="MMK">Burmese kyat (MMK)</option>
                                    <option value="BIF">Burundian franc (BIF)</option>
                                    <option value="KHR">Cambodian riel (KHR)</option>
                                    <option value="CAD">Canadian dollar (CAD)</option>
                                    <option value="CVE">Cape Verdean escudo (CVE)</option>
                                    <option value="KYD">Cayman Islands dollar (KYD)</option>
                                    <option value="XAF">Central African CFA franc (XAF)</option>
                                    <option value="XPF">CFP franc (XPF)</option>
                                    <option value="CLP">Chilean peso (CLP)</option>
                                    <option value="CNY">Chinese yuan (CNY)</option>
                                    <option value="COP">Colombian peso (COP)</option>
                                    <option value="KMF">Comorian franc (KMF)</option>
                                    <option value="CDF">Congolese franc (CDF)</option>
                                    <option value="CRC">Costa Rican colón (CRC)</option>
                                    <option value="HRK">Croatian kuna (HRK)</option>
                                    <option value="CUC">Cuban convertible peso (CUC)</option>
                                    <option value="CUP">Cuban peso (CUP)</option>
                                    <option value="CZK">Czech koruna (CZK)</option>
                                    <option value="DKK">Danish krone (DKK)</option>
                                    <option value="DOP">Dominican peso (DOP)</option>
                                    <option value="DJF">Djiboutian franc (DJF)</option>
                                    <option value="XCD">Eastern Caribbean dollar (XCD)</option>
                                    <option value="EGP">Egyptian pound (EGP)</option>
                                    <option value="ERN">Eritrean nakfa (ERN)</option>
                                    <option value="ETB">Ethiopian birr (ETB)</option>
                                    <option value="EUR">Euro (EUR)</option>
                                    <option value="FKP">Falkland Islands pound (FKP)</option>
                                    <option value="FJD">Fijian dollar (FJD)</option>
                                    <option value="GMD">Gambian dalasi (GMD)</option>
                                    <option value="GEL">Georgian lari (GEL)</option>
                                    <option value="GHS">Ghanaian cedi (GHS)</option>
                                    <option value="GIP">Gibraltar pound (GIP)</option>
                                    <option value="GTQ">Guatemalan quetzal (GTQ)</option>
                                    <option value="GGP">Guernsey pound (GGP)</option>
                                    <option value="GNF">Guinean franc (GNF)</option>
                                    <option value="GYD">Guyanese dollar (GYD)</option>
                                    <option value="HTG">Haitian gourde (HTG)</option>
                                    <option value="HNL">Honduran lempira (HNL)</option>
                                    <option value="HKD">Hong Kong dollar (HKD)</option>
                                    <option value="HUF">Hungarian forint (HUF)</option>
                                    <option value="ISK">Icelandic króna (ISK)</option>
                                    <option value="INR">Indian rupee (INR)</option>
                                    <option value="IDR">Indonesian rupiah (IDR)</option>
                                    <option value="IRR">Iranian rial (IRR)</option>
                                    <option value="IQD">Iraqi dinar (IQD)</option>
                                    <option value="ILS">Israeli new shekel (ILS)</option>
                                    <option value="JMD">Jamaican dollar (JMD)</option>
                                    <option value="JPY">Japanese yen (JPY)</option>
                                    <option value="JEP">Jersey pound (JEP)</option>
                                    <option value="JOD">Jordanian dinar (JOD)</option>
                                    <option value="KZT">Kazakhstani tenge (KZT)</option>
                                    <option value="KES">Kenyan shilling (KES)</option>
                                    <option value="KID">Kiribati dollar (KID)</option>
                                    <option value="KGS">Kyrgyzstani som (KGS)</option>
                                    <option value="KWD">Kuwaiti dinar (KWD)</option>
                                    <option value="LAK">Lao kip (LAK)</option>
                                    <option value="LBP">Lebanese pound (LBP)</option>
                                    <option value="LSL">Lesotho loti (LSL)</option>
                                    <option value="LRD">Liberian dollar (LRD)</option>
                                    <option value="LYD">Libyan dinar (LYD)</option>
                                    <option value="MOP">Macanese pataca (MOP)</option>
                                    <option value="MKD">Macedonian denar (MKD)</option>
                                    <option value="MGA">Malagasy ariary (MGA)</option>
                                    <option value="MWK">Malawian kwacha (MWK)</option>
                                    <option value="MYR">Malaysian ringgit (MYR)</option>
                                    <option value="MVR">Maldivian rufiyaa (MVR)</option>
                                    <option value="IMP">Manx pound (IMP)</option>
                                    <option value="MRU">Mauritanian ouguiya (MRU)</option>
                                    <option value="MUR">Mauritian rupee (MUR)</option>
                                    <option value="MXN">Mexican peso (MXN)</option>
                                    <option value="MDL">Moldovan leu (MDL)</option>
                                    <option value="MNT">Mongolian tögrög (MNT)</option>
                                    <option value="MAD">Moroccan dirham (MAD)</option>
                                    <option value="MZN">Mozambican metical (MZN)</option>
                                    <option value="NAD">Namibian dollar (NAD)</option>
                                    <option value="NPR">Nepalese rupee (NPR)</option>
                                    <option value="ANG">Netherlands Antillean guilder (ANG)</option>
                                    <option value="TWD">New Taiwan dollar (TWD)</option>
                                    <option value="NZD">New Zealand dollar (NZD)</option>
                                    <option value="NIO">Nicaraguan córdoba (NIO)</option>
                                    <option value="NGN">Nigerian naira (NGN)</option>
                                    <option value="KPW">North Korean won (KPW)</option>
                                    <option value="NOK">Norwegian krone (NOK)</option>
                                    <option value="OMR">Omani rial (OMR)</option>
                                    <option value="PKR">Pakistani rupee (PKR)</option>
                                    <option value="PAB">Panamanian balboa (PAB)</option>
                                    <option value="PGK">Papua New Guinean kina (PGK)</option>
                                    <option value="PYG">Paraguayan guaraní" (YG<)/option>
                                    <option value="PEN">Peruvian sol (PEN)</option>
                                    <option value="PHP">Philippine peso (PHP)</option>
                                    <option value="PLN">Polish złoty (PLN)</option>
                                    <option value="QAR">Qatari riyal (QAR)</option>
                                    <option value="RON">Romanian leu (RON)</option>
                                    <option value="RUB">Russian ruble (RUB)</option>
                                    <option value="RWF">Rwandan franc (RWF)</option>
                                    <option value="SHP">Saint Helena pound (SHP)</option>
                                    <option value="WST">Samoan tālā (WST)</option>
                                    <option value="STN">São Tomé and Príncipe dobra (STN)</option>
                                    <option value="SAR">Saudi riyal (SAR)</option>
                                    <option value="RSD">Serbian dinar (RSD)</option>
                                    <option value="SLL">Sierra Leonean leone (SLL)</option>
                                    <option value="SGD">Singapore dollar (SGD)</option>
                                    <option value="SOS">Somali shilling (SOS)</option>
                                    <option value="SLS">Somaliland shilling (SLS)</option>
                                    <option value="ZAR">South African rand (ZAR)</option>
                                    <option value="KRW">South Korean won (KRW)</option>
                                    <option value="SSP">South Sudanese pound (SSP)</option>
                                    <option value="SRD">Surinamese dollar (SRD)</option>
                                    <option value="SEK">Swedish krona (SEK)</option>
                                    <option value="CHF">Swiss franc (CHF)</option>
                                    <option value="LKR">Sri Lankan rupee (LKR)</option>
                                    <option value="SZL">Swazi lilangeni (SZL)</option>
                                    <option value="SYP">Syrian pound (SYP)</option>
                                    <option value="TJS">Tajikistani somoni (TJS)</option>
                                    <option value="TZS">Tanzanian shilling (TZS)</option>
                                    <option value="THB">Thai baht (THB)</option>
                                    <option value="TOP">Tongan pa&#703;anga (TOP)</option>
                                    <option value="PRB">Transnistrian ruble (PRB)</option>
                                    <option value="TTD">Trinidad and Tobago dollar (TTD)</option>
                                    <option value="TND">Tunisian dinar (TND)</option>
                                    <option value="TRY">Turkish lira (TRY)</option>
                                    <option value="TMT">Turkmenistan manat (TMT)</option>
                                    <option value="TVD">Tuvaluan dollar (TVD)</option>
                                    <option value="UGX">Ugandan shilling (UGX)</option>
                                    <option value="UAH">Ukrainian hryvnia (UAH)</option>
                                    <option value="AED">United Arab Emirates dirham (AED)</option>
                                    <option value="USD">United States dollar (USD)</option>
                                    <option value="UYU">Uruguayan peso (UYU)</option>
                                    <option value="UZS">Uzbekistani so&#703;m (UZS)</option>
                                    <option value="VUV">Vanuatu vatu (VUV)</option>
                                    <option value="VES">Venezuelan bolívar soberano (VES)</option>
                                    <option value="VND">Vietnamese đồng (VND)</option>
                                    <option value="XOF">West African CFA franc (XOF)</option>
                                    <option value="ZMW">Zambian kwacha (ZMW)</option>
                                    <option value="ZWB">Zimbabwean bonds (ZWB)</option>

                                </select>

                            </div>

                            <div class="form_item checkbox">

                                <div class="iQ_checkbox" title="Apply for virtual card"><input type="checkbox" name="v-cards"> <label for="v-cards">Get a virtual card</label></div>

                            </div>

                        </div>

                        <div class="form_item radio">

                            <label for="maritial">Preferred Card Type</label>

                            <div class="iQ_radio" title="AMEX"><input type="radio" name="v-card-type" value="AMEX"> <span>AMEX</span></div>

                            <div class="iQ_radio" title="Mastercard"><input type="radio" name="v-card-type" value="MASTERCARD"> <span>Mastercard</span></div>

                            <div class="iQ_radio" title="Visa"><input type="radio" name="v-card-type" value="VISA"> <span>VISA</span></div>

                        </div>

                        <div class="form_item db">

                            <div class="form_item checkbox">

                                <div class="iQ_checkbox" title="Login alerts"><input type="checkbox" name="login-alerts"> <label for="login-alerts">Receive login alerts</label></div>

                            </div>

                            <div class="form_item checkbox">

                                <div class="iQ_checkbox" title="Account number login"><input type="checkbox" name="accnum-login"> <label for="accnum-login">Log in using account number</label></div>

                            </div>

                            <div class="form_item checkbox">

                                <div class="iQ_checkbox" title="Loan application"><input name="loan" type="checkbox"> <label for="loan">Enable loan application</label></div>

                            </div>

                        </div>

                        <div class="form_item">

                            <button name="r-step-5" type="button" class="form_btn">Continue &rarr;</button>

                        </div>

                    </div>

                </div>

                <div class="form_sect n_displ" id="reg-step-6">

                    <div class="form_con">

                        <p class="form_title">Next of Kin Details</p>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="nok_fname">NOK Firstname</label>
                            
                                <input name="nok_fname" type="text" class="form_field" placeholder="Firstname" required value="<?= isset($_REQUEST['nok_fname']) ? $_REQUEST['nok_fname'] : '' ?>">

                            </div>

                            <div class="form_item">

                                <label for="nok_lname">NOK Firstname</label>
                            
                                <input name="nok_lname" type="text" class="form_field" placeholder="Lastname" required value="<?= isset($_REQUEST['nok_lname']) ? $_REQUEST['nok_lname'] : '' ?>">

                            </div>
                            
                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="nok_mname">NOK Middlename</label>
                            
                                <input name="nok_mname" type="text" class="form_field" placeholder="Middlename" value="<?= isset($_REQUEST['nok_mname']) ? $_REQUEST['nok_mname'] : '' ?>">

                            </div>

                            <div class="form_item">

                                <label for="nok_dob">NOK DOB</label>
                            
                                <input name="nok_dob" type="date" class="form_field" required value="<?= isset($_REQUEST['nok_dob']) ? $_REQUEST['nok_dob'] : '' ?>">

                            </div>
                            
                        </div>

                        <div class="form_item">

                            <label for="nok_rel">Relationship</label>
                        
                            <input name="nok_rel" type="text" class="form_field" placeholder="Relationship with NOK" required value="<?= isset($_REQUEST['nok_rel']) ? $_REQUEST['nok_rel'] : '' ?>">

                        </div>

                        <div class="form_item">

                            <label for="nok_addr">NOK Address</label>

                            <textarea class="form_field" placeholder="NOK Residence" name="nok_addr" rows="7" required></textarea>

                        </div>

                        <div class="form_item">

                            <button id="reg-concludeB" name="r-step-6" type="submit" class="form_btn">Continue &rarr;</button>

                        </div>

                    </div>

                </div>

            </form>

            <div class="form_sect n_displ" id="reg-step-7">

                <div class="form_con">

                    <p class="form_title">Verify your email address</p>

                    <form id="reg-mfaForm" method="post" autocomplete="off">

                        <p class="form_info">

                            Please enter the OTP sent to the email address you provided to verify your email address

                        </p>

                        <div class="form_item mltpl">

                            <input type="text" name="digit_1" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autofocus aria-autocomplete="none">

                            <input type="text" name="digit_2" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                            <input type="text" name="digit_3" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                            <input type="text" name="digit_4" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                            <input type="text" name="digit_5" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                            <input type="text" name="digit_6" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        </div>

                        <div class="form_item">

                            <button type="submit" name="verify" id="verifyMfa" class="form_btn">Verify your account</button>

                        </div>

                        <div class="form_item">

                            <button type="button" class="action_btn" id="reMfa">

                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24" class="icon-md-heavy">
                                    <path fill="currentColor" d="M3.07 10.876C3.623 6.436 7.41 3 12 3a9.15 9.15 0 0 1 6.012 2.254V4a1 1 0 1 1 2 0v4a1 1 0 0 1-1 1H15a1 1 0 1 1 0-2h1.957A7.15 7.15 0 0 0 12 5a7 7 0 0 0-6.946 6.124 1 1 0 1 1-1.984-.248m16.992 1.132a1 1 0 0 1 .868 1.116C20.377 17.564 16.59 21 12 21a9.15 9.15 0 0 1-6-2.244V20a1 1 0 1 1-2 0v-4a1 1 0 0 1 1-1h4a1 1 0 1 1 0 2H7.043A7.15 7.15 0 0 0 12 19a7 7 0 0 0 6.946-6.124 1 1 0 0 1 1.116-.868"></path>
                                </svg>

                                <span>Resend code</span>

                            </button>

                        </div>

                    </form>

                </div>

            </div>

        </div>

<?php

    require('../partials/reg-footer.php');

?>