<?php

    // Checks Items Longitevity

    // EXPIRATION HANDLERS / LOGIC

    function loansLongetivity($connection, $useriD, $time) { // Loans

        $stmt = mysqli_prepare($connection, "UPDATE `loans` SET `status` = ? WHERE `user_id` = ? AND `due` < ? AND `status` = ?"); // Prepare Statement

        $param = 'OVERDUE';

        $param2 = 'ALIVE';

        mysqli_stmt_bind_param($stmt, "ssss", $param, $useriD, $time, $param2); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement


    }

    function loanPayout($connection, $useriD, $time) { // Payout
    
        $stmt = mysqli_prepare($connection, "UPDATE `repayments_schedule` SET `status` = ? WHERE `user_id` = ? AND `due` < ? AND `status` = ?"); // Prepare Statement

        $param = 'OVERDUE';

        $param2 = 'PENDING';

        mysqli_stmt_bind_param($stmt, "ssss", $param, $useriD, $time, $param2); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

        
    }

    function subscriptionsLongetivity($connection, $useriD, $time) { // Investment
        
        $stmt = mysqli_prepare($connection, "UPDATE `subscriptions` SET `status` = ? WHERE `user_id` = ? AND `expires` < ? AND `status` != ?"); // Prepare Statement

        $param = 'EXPIRED';

        mysqli_stmt_bind_param($stmt, "ssss", $param, $useriD, $time, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

    }

    function payoutDispersal($connection, $useriD, $time, $accData) { // Payout Dispensal

        // Commence Returns Fetch

        $payoutGroups = []; // Holds Retuns
        
        $payoutIDs = []; // Holds Row IDs
        
        // $stmt = mysqli_prepare($connection, "SELECT `A`.`id`,`A`.`sub_id`, SUM(`A`.`amount`) AS `payout_amount`, `B`.`item` AS `commodity` FROM `payout_schedule` AS `A` JOIN `subscriptions` AS B ON `A`.`sub_id` = `B`.`sub_id` WHERE `A`.`status` = ? AND `A`.`user_id` = ? AND `A`.`due` <= ? GROUP BY `A`.`sub_id`");// Prepare Statement

        $stmt = mysqli_prepare($connection, "SELECT A.id, A.sub_id, A.amount, B.item 
        FROM payout_schedule AS A 
        JOIN subscriptions AS B ON A.sub_id = B.sub_id 
        WHERE A.status = ? AND A.user_id = ? AND A.due <= ?");// Prepare Statement

        $param = 'PENDING';

        mysqli_stmt_bind_param($stmt, "sss", $param, $useriD, $time); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            // $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            while ($row = mysqli_fetch_assoc($result)) {
                // $sub_id = $row['sub_id'];
                // $amount = (float)$row['payout_amount'];
                // $item = $row['commodity'];
                // $id = $row['id'];

                $id = $row['id'];
                $sub_id = $row['sub_id'];
                $amount = (float)$row['amount'];
                $item = $row['item'];

                $payoutIDs[] = $id;

                if (!isset($payoutGroups[$sub_id])) {
                    $payoutGroups[$sub_id] = [
                        'total' => 0,
                        'item' => $item
                    ];
                }
                $payoutGroups[$sub_id]['total'] += $amount;

            }    

        }

        mysqli_stmt_close($stmt); // Close Statement

        foreach ($payoutGroups as $subID => $details) {

            // Make sure payout and item keys exist
            if (!isset($details['total'], $details['item'])) {
                //error_log("Missing keys in payoutGroups for subID: $subID");
                continue;
            }

            $acciD = $accData['acc-id'] ?? null;
            $accNumber = $accData['acc-number'] ?? null;
            $balance = $accData['balance'] ?? null;
            $currency = $accData['currency'] ?? null;

            if (!$acciD || !$accNumber || $balance === null || !$currency) {
                //error_log("Account data incomplete for user: $useriD, subID: $subID");
                continue;
            }

            $payout = (float)$details['total'];
            $item = $details['item'];

            $newBalance = $balance + $payout;

            // INSERT transaction
            $stmt = mysqli_prepare($connection, "INSERT INTO `transactions` (`trans_id`, `user_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if ($stmt === false) {
                //error_log("Prepare failed (transactions): " . mysqli_error($connection));
                continue;
            }

            $id = generateUniqueID($connection, 'transactions', 'TRN');
            $type = 'CREDIT';
            $action = 'ROI';
            $descr = $item . ' (ROI)';
            $status = 'COMPLETED';

            mysqli_stmt_bind_param($stmt, "sssssssssss", $id, $useriD, $type, $action, $descr, $currency, $acciD, $accNumber, $newBalance, $payout, $status);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

            // UPDATE account balance
            $stmt2 = mysqli_prepare($connection, "UPDATE `accounts` SET `balance` = `balance` + ? WHERE `acc_id` = ?");
            if ($stmt2 === false) {
                // error_log("Prepare failed (accounts): " . mysqli_error($connection));
                continue;
            }

            mysqli_stmt_bind_param($stmt2, "ds", $payout, $acciD);
            mysqli_stmt_execute($stmt2);
            mysqli_stmt_close($stmt2);

            // error_log("ROI Payout of $payout credited to Account ID: $acciD (User: $useriD)");
        }

        // Delete Processed Payouts

        if (!empty($payoutIDs)) {
            // Prepare deletion query with IN clause
            $in = implode(',', array_fill(0, count($payoutIDs), '?'));
            $query = "DELETE FROM payout_schedule WHERE id IN ($in)";
            $stmt = mysqli_prepare($connection, $query);

            // Dynamically bind params
            $types = str_repeat('i', count($payoutIDs)); // All integers
            mysqli_stmt_bind_param($stmt, $types, ...$payoutIDs);

            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);

        }

        // Dynamic IN clause binding workaround:
        // if (!empty($payoutIDs)) {
        //     // Prepare placeholders
        //     $placeholders = implode(',', array_fill(0, count($payoutIDs), '?'));
        //     $query = "DELETE FROM payout_schedule WHERE id IN ($placeholders)";
        //     $stmt = mysqli_prepare($connection, $query);

        //     if ($stmt) {
        //         // Dynamically bind parameters using call_user_func_array
        //         $types = str_repeat('i', count($payoutIDs));
        //         $bind_names[] = $types;
        //         foreach ($payoutIDs as $key => $id) {
        //             $bind_name = 'bind' . $key;
        //             $$bind_name = $id;
        //             $bind_names[] = &$$bind_name; // Note: use reference
        //         }
        //         call_user_func_array(array($stmt, 'bind_param'), $bind_names);
        //         mysqli_stmt_execute($stmt);
        //         mysqli_stmt_close($stmt);
        //     } else {
        //         error_log("Prepare failed (delete payouts): " . mysqli_error($connection));
        //     }
        // }


    }

?>