<?php

    // Get User's IP Address

    function getUserIP() {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }
        return $_SERVER['REMOTE_ADDR'];
    }

    // API Setup To Get User's IP Data

    function fetchUserInfoFromApi($ip, $api_url) {
        $response = @file_get_contents($api_url); // Suppress Errors
        if ($response === FALSE) {
            error_log("Error retrieving data from API for IP: $ip");
            return null;
        }

        $data = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            error_log("JSON decoding failed: " . json_last_error_msg());
            return null;
        }

        return $data;
    }

    // Get User's IP Data

    function getUserInfo($ip) {

        $dataFetch = true; // Flag To Check If API Returns Data 
        
        $data = fetchUserInfoFromApi($ip, "https://freeipapi.com/api/json/$ip"); // Primary API

        if (is_null($data) || (isset($data['status']) && $data['status'] === 'fail')) {

            $response = @file_get_contents("http://www.geoplugin.net/php.gp?ip=$ip"); // Fallback API
            
            if ($response === FALSE) {

                $dataFetch = false; // Update Flag

                return ['error' => 'Failed to retrieve data from both APIs.'];

            }

            $data = unserialize($response);

            if (!is_array($data) || (isset($data['geoplugin_status']) && !$data['geoplugin_status'])) {

                $dataFetch = false; // Update Flag

                return ['error' => 'Failed to retrieve valid data from fallback API.'];

            }

        }

        if ($dataFetch) { // Consider Flag

            $country_code = strtolower($data['countryCode'] ?? ($data['geoplugin_countryCode']) ?? 'N/A');

            $flag_url = "https://flagcdn.com/w320/{$country_code}.png";
        
            // Return user information

            return [
                'countryCode' => $country_code,
                'flag' => $flag_url,
            ];

        } else {

            return false;

        }

    }

?>