<?php

    // require('../config/config.php'); // Temporary

    /* This file and the functions within make use of constants, declared in `/controls/config/config.php`.
    
    Which isn't included here. Ensure the `config.php` is required before this file for desired performance.

    */

    // All Mail Draft Structures Appear Here:

    function mailStructure($content, $logo = MAIL_LOGO, $platform = SITE_NAME, $baseURL = SITE_BASE_URL) { // Default HTML Structure

        $year = date('Y');

        $mail = <<<HTML
        
            <!DOCTYPE html>

            <html lang="en">

                <head>

                    <meta charset="UTF-8">

                    <meta http-equiv="X-UA-compatible" content="ie=edge">

                    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

                    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat">

                </head>

                <body style="font-family: 'Montserrat', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; color: #000000;">

                    <div>
                    
                        <div style="width:100%;background:#f4f5f7">

                            <div style="padding-top:50px;padding-bottom:20px">

                                <div style="max-width:800px;margin:0 auto;border:0.336601px solid rgba(19,18,18,0.1);border-radius:2.69281px; background-color: white;">
                                
                                    <table>
                                        <tbody style="font-size:10px;color:#1a1a1a;font-weight:500">
                                            <tr style="float:left;width:100%;padding:40px 44px">
                                                <td>
                                                    <img src="$logo" alt="$platform" style="width:120px;height:35px; padding: 0.5em; border-radius: 0.25em;">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    $content
                                
                                </div>

                            </div>

                        </div>

                        <div style="width:100%;background:#f4f5f7">
                            <div style="max-width:800px;margin:0 auto">
                                <div style="padding:0 30px">
                                    <div style="display: flex; align-items: center; justify-content: center; gap: 0.5em;">

                                        <p style="font-weight:500;font-size:1rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin: 0 auto;">&copy; $year $platform</p>

                                    </div>
                                
                                </div>
                            </div>
                        </div>


                    </div>

                </body>

            </html>

        HTML;

        return $mail;

    }

    function loginAlert($firstname, $loginDateTime, $loginLog, $closure = true, $platform = SITE_NAME, $contact = COMPLAINT_MAIL, $party = MAIL_PARTY) { // Login Alerts

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $ip = $loginLog['ip-address'] ?? 'UNKNOWN';

        $device = $loginLog['device'] ?? 'UNKNOWN';

        $location = $loginLog['location'] ?? 'UNKNOWN';

        $browser = $loginLog['browser'] ?? 'UNIDENTIFIED';


        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Login Detected</h3>
                        </td>
                    </tr>
                
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We've detected a new login to your $platform account, dashboard was accessed on <i>$loginDateTime</i>. Just to be sure your security wasn't compromised, We want to double-check that it was you.
                                
                                <br><br>At the time of the login
                                we were able to gain the following information, below;

                            </p> <br>

                            <table style="outline:currentcolor;border-collapse:collapse;border:1px solid rgb(235, 237, 240); margin: 0 44px;">

                                <colgroup><col width="107" span="1"><col width="682" span="1"></colgroup>

                                <tbody>
                                
                                    <tr style="height:33px">
                                    
                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>IP</strong>
                                            </p>
                                        
                                        </td>

                                        <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                            
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$ip</p>
                                            
                                        </td>

                                    </tr>    

                                    <tr style="height:33px">

                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>Device</strong>
                                            </p>
                                        
                                        </td>

                                        <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                            
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$device</p>
                                            
                                        </td>

                                    </tr> 
                                    
                                    <tr style="height:33px">
                                    
                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>Location</strong>
                                            </p>
                                        
                                        </td>

                                        <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                            
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$location</p>
                                            
                                        </td>

                                    </tr>    

                                    <tr style="height:33px">

                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>Browser</strong>
                                            </p>
                                        
                                        </td>

                                        <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                            
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$browser</p>
                                            
                                        </td>

                                    </tr>      
                                        
                                </tbody>    
                                    
                            </table>
                            
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                If you didn't initiate this login attempt, please change your password & contact <br>
                                support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>
                            
                                <br><br>
                                $closure
                            <p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function thirdPartyloginAlert($firstname, $loginDateTime, $thirdParty, $closure = true, $platform = SITE_NAME, $contact = COMPLAINT_MAIL, $party = MAIL_PARTY) { // Third Party Login Alerts

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Third Party Login Detected</h3>
                        </td>
                    </tr>
                
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We've detected a new login to your $platform account, dashboard was accessed on <i>$loginDateTime</i> by <i>$thirdParty</i>, an individual you seem to have granted access & control privileges. 
                                
                                <br><br>Please be aware that this third party (joint user) may carrry out transactions with any of your account(s). You can always login and manage joint holders like <i>$thirdParty</i>.

                            </p> <br>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                If you didn't grant access privileges to <i>$thirdParty</i>, please change your password, login and remove <i>$thirdParty</i> from your joint users & contact <br>
                                support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>
                                <br><br>
                                $closure
                            <p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function loginOTP($firstname, $code, $contact = SUPPORT_MAIL, $platform = SITE_NAME) { // OTP For Logins

        $content = <<<HTML

            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Login to $platform</h3>
                        </td>
                    </tr>
                
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                It looks like you're trying to log into your $platform account. To access your account<br>
                                and dashboard, please use the one-time password (OTP) below;

                            </p> <br>

                            <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">
                            This code expires in 5 minutes.<br>
                            If you didn't initiate this login attempt, please change your password or contact <br>
                            support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a></p>                                                <br>
                            <br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>
        
        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function registrationOTP($firstname, $code, $contact = SUPPORT_MAIL, $platform = SITE_NAME) { // OTP For Registration Verification 

        $content = <<<HTML

            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Confirm Your Identity</h3>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Thank you for signing up to $platform,<br>
                                here's your One Time Password (OTP) to verify your account.

                            </p> <br>

                            <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">If you have any complaints, please contact our support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a></p>
                            <br>
                            <br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function pwrdResetOTP($firstname, $code, $contact = SUPPORT_MAIL, $platform = SITE_NAME) { // OTP For Password Reset

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Reset your password</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We received a request to reset the password to your $platform account. Please use the one-time password (OTP) below to authenticate this action:

                            </p> <br>

                            <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">
                            This code expires in 5 minutes.<br>
                            If you didn't initiate this request, please change your password & contact the 
                            support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a></p>                                                <br>
                            <br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function reOTP($firstname, $code, $contact = SUPPORT_MAIL, $platform = SITE_NAME) { // OTP Re-request

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Verification Code</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                It looks like you requested for a verification code for your $platform account. To complete the given process<br>
                                please use the one-time password (OTP) below;

                            </p> <br>

                            <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">
                            This code expires in 5 minutes.<br>
                            If you didn't initiate this action, please change your password or contact <br>
                            support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a></p>                                                <br>
                            <br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function transferOTP($firstname, $code, $contact = SUPPORT_MAIL, $platform = SITE_NAME) { // OTP Reset Password

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Authenticate Transfer</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                A transfer is being carried out with your $platform account. Please use this one-time password (OTP) below to authenticate the transaction;

                            </p> <br>

                            <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">
                            This code expires in 5 minutes.<br>
                            If you didn't initiate any transfer, please change your password or contact <br>
                            support team immediately via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a></p>                                                <br>
                            <br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);

        return $msg;

    }

    function dispenseBCode($firstname, $code, $codeName, $orderID, $ordered, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Billing Code Dispensal

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Order Confirmed</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your order <i>$orderID</i> for <b>$codeName</b> on <i>$ordered</i>, has been confirmed. Here's your code:

                            </p>        

                            <br>

                                <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            
                            <br>
                            
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">    

                                If you carried this out, please use this as your <b>$codeName</b> whenever you need to authenticate an action. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function resendBCode($firstname, $code, $codeName, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Resend Billing Code

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Authentication Code</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your authentication code <b>$codeName</b>, has been processed and released. Here's your code:

                            </p>        

                            <br>

                                <p style="font-weight:500;line-height:24px;font-size:1.6rem;color:#27303d;text-align:center;background:#f0f6fe;border-radius:4px;padding:1.35rem; margin: 0 44px;">$code</p>
                            
                            <br>
                            
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">    

                                Please use this as your <b>$codeName</b> whenever you need to authenticate an action on your <i>$platform account</i>. Need more information, contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function regUncleared($firstname, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Registration Under Review

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Registration Under Review</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Thank you for choosing $platform. We’ve received your registration and are currently reviewing your application.
                                
                                <br>

                                At $platform, we take security and compliance seriously. To ensure a safe and personalized banking experience, every new account application undergoes a quick verification and approval process.

                                <br><br>

                                <b>What happens next?</b><br><br>

                                Our team is reviewing the information you provided.<br>

                                You’ll receive an update via email within [1-2 business days] regarding the status of your application.<br>

                                If we need any additional information, we’ll reach out to you directly.

                                <br><br>

                                If you have any questions or need assistance, our dedicated customer support team is just a click away. Contact us via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                We appreciate your interest in joining $platform and look forward to welcoming you aboard soon!

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function welcomeAboard($firstname, $siteURL = SITE_BASE_URL, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Welcome Aboard

        $loginLink = $siteURL . '/auth/login';

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Welcome Aboard $platform</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Welcome to $platform! We are thrilled to have you join our family of valued customers.
                                
                                <br>

                                Your registration is now complete, and your $platform account is ready to use. Whether you’re saving for the future, managing daily expenses, or investing for your dreams, we’re here to support you every step of the way.

                                <br><br>

                                Here’s what you can do next:<br><br>

                                <b>Access Your Account:</b> Log in anytime at <a href="$loginLink" style="color: rgb(58, 117, 176);">$loginLink</a> using your username and password.<br><br>

                                <b>Download Our Mobile App:</b> Manage your money on the go with our secure and user-friendly app — available on iOS and Android.<br><br>

                                <b>Explore Our Services:</b> From savings accounts and credit cards to personal loans and investment options, discover how Horizon Bank can help you achieve your goals.

                                <br><br>

                                If you have any questions or need assistance, our dedicated customer support team is just a click away. Contact us via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                Thank you for choosing $platform. We look forward to a successful financial journey together!

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function completeReg($firstname, $email, $password, $trasPin, $siteURL = SITE_BASE_URL, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Complete Registration

        $loginLink = $siteURL . '/auth/login';

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Welcome Aboard $platform</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Welcome to $platform! We are thrilled to have you join our family of valued customers.
                                
                                <br>

                                Your registration is now complete, and your $platform account is ready to use. Whether you’re saving for the future, managing daily expenses, or investing for your dreams, we’re here to support you every step of the way. Below are your login credentials:<br>

                                <b>E-mail Address:</b> $email<br>

                                <b>Password:</b> $password<br>

                                <b>Transaction:</b> $trasPin

                                <br><br>

                                Here’s what you can do next:<br><br>

                                <b>Access Your Account:</b> Log in anytime at <a href="$loginLink" style="color: rgb(58, 117, 176);">$loginLink</a> using your username and password. And Go to the settings to reset password. Please keep your login credentials a secret.<br><br>

                                <b>Download Our Mobile App:</b> Manage your money on the go with our secure and user-friendly app — available on iOS and Android.<br><br>

                                <b>Explore Our Services:</b> From savings accounts and credit cards to personal loans and investment options, discover how Horizon Bank can help you achieve your goals.

                                <br><br>

                                If you have any questions or need assistance, our dedicated customer support team is just a click away. Contact us via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                Thank you for choosing $platform. We look forward to a successful financial journey together!

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function partialReg($firstname, $email, $password, $siteURL = SITE_BASE_URL, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Complete Registration

        $loginLink = $siteURL . '/auth/login';

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Welcome Aboard $platform</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Welcome to $platform! We are thrilled to have you join our family of valued customers.
                                
                                <br>

                                Your registration is partially complete, and your $platform account is ready to use. Whether you’re saving for the future, managing daily expenses, or investing for your dreams, we’re here to support you every step of the way. Below are your login credentials:<br>

                                <b>E-mail Address:</b> $email<br>

                                <b>Password:</b> $password

                                <br><br>

                                Here’s what you can do next:<br><br>

                                <b>Access Your Account:</b> Log in anytime at <a href="$loginLink" style="color: rgb(58, 117, 176);">$loginLink</a> using your username and password. And Go to the settings to reset password. Please keep your login credentials a secret.<br><br>

                                <b>Download Our Mobile App:</b> Manage your money on the go with our secure and user-friendly app — available on iOS and Android.<br><br>

                                <b>Explore Our Services:</b> From savings accounts and credit cards to personal loans and investment options, discover how Horizon Bank can help you achieve your goals.

                                <br><br>

                                If you have any questions or need assistance, our dedicated customer support team is just a click away. Contact us via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                Thank you for choosing $platform. We look forward to a successful financial journey together!

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function accountRequestAlert($firstname, $account, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Investment Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">New Account Alert</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                A request for a/an <b>$account</b> account was just made through your $platform account, and is awaiting approval.<br> Just to be sure your security wasn't compromised, we want to double-check that it was you.

                                <br><br>

                                If you didn't initiate this, immediately change your password and contact us via <br>
                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function newAccountAlert($firstname, $account, $dateTime, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Investment Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">New Account Alert</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your request for a/an <b>$account</b> account made on <i>$dateTime</i> through your $platform account has been approved.

                                <br><br>

                                You now have a secured <i>$account<i> at your disposal, do enjoy. For more imformation please contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function investmentNotification($firstname, $commodity, $dateTime, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Investment Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Investment Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We just detected an attempt to invest into <b>$commodity</b> was made through your $platform account on <i>$dateTime</i><br> Just to be sure your security wasn't compromised, we want to double-check that it was you.

                                <br><br>

                                If you initiated this, please proceed to payment to finalize you investment. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function investmentConfirmation($firstname, $commodity, $dateTime, $duration, $start, $expires, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Investment Confirmation

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Investment Confirmed</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your request to invest into <b>$commodity</b> on <i>$dateTime</i> made through your $platform account on has been confirmed<br> and the aforementioned commodity has been added to your portfolio.

                                <br><br>

                                Please Note that:<br>

                                This investment will last for <b>$duration day(s)</b>

                                <br>

                                From the <b>$start</b> to <b>$expires</b>

                                If you initiated this, we trust your portfolio will deliver sustained value and strategic growth. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function newVirtualCardConfirmation($firstname, $card, $dateTime, $duration, $expires, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // New Virtual Card Confirmation

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Virtual Card Released</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your request for a/an <b>$card</b> virtual card on <i>$dateTime</i> made through your $platform account on has been confirmed and released. This $card will last for <b>$duration</b> valid till <i>$expires</i>.

                                <br><br>

                                Please Note that:<br>
                                
                                <small>Misuse of this card is a criminal offense. Though this card is a property of the issuer and is subject to the issuer's terms of service, any harm from its usage isn't liable to the issuer.</small>

                                <br><br>

                                If you initiated this card request, enjoy your new $card virtual card. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function loanConfirmation($firstname, $currency, $amount, $loanType, $requested, $lifetime, $frequency, $records, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Loan Approval Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Loan Application Approved</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your request for a loan of <i>$amount</i> for <b>$loanType</b> on <i>$requested</i>, has been approved and dispered into your $currency account.<br> Please note that:<br>

                                This loan will last for <b>$lifetime day(s)</b>, with repayments occuring <i>$frequency</i> during this $lifetime day period.<br><br> Below are the the expected repayments and due dates:

                            </p>        

                            <table style="outline:currentcolor;border-collapse:collapse;border:1px solid rgb(235, 237, 240); margin: 0 44px;">

                                <colgroup><col width="107" span="1"><col width="682" span="1"></colgroup>

                                <tbody>
                                
                                    <tr style="height:33px">
                                    
                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>Due Date</strong>
                                            </p>
                                        
                                        </td>

                                        <td style="background-color:rgb(217, 234, 252);min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                        
                                            <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">
                                                <strong>Amount</strong>
                                            </p>
                                        
                                        </td>
                                    </tr>
                                    
                                    $records   

                                </tbody>    
                                    
                            </table>
                            
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">    

                                Please note that failure to repay / overdue payments will be penalised. For more info please contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function loanDeclined($firstname, $currency, $amount, $loanType, $requested, $lifetime, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Loan Declined Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Loan Application Declined</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your request for a loan of <i>$amount</i> for <b>$loanType</b> for <b>$lifetime day(s)</b> request on <i>$requested</i>, has been through consideration and reviewed and has been declined.<br><br>

                                For more info please contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function depositNotification($firstname, $currency, $dateTime, $amount, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Deposit Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Deposit Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We just detected an attempt to deposit  <i>$amount</i> into your $platform $currency account, on $dateTime.
                                <br> Just to be sure your security wasn't compromised, we want to double-check that it was you.

                                <br><br>

                                If you initiated this, please disregard this notification and proceed to payment to finalize your deposit. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function thirdPartyDepositNotification($firstname, $thirdParty, $currency, $dateTime, $amount, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Deposit Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Deposit Notification (Third Party)</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We just detected an attempt to deposit  <i>$amount</i> into your $platform $currency account by <i>$thirdParty</i>, on $dateTime.
                                <br> Just to be sure your security wasn't compromised, we want you to be aware of this.

                                <br><br>

                                If you don't remember granting access privileges to a <i>$thirdParty</i> who initiated this action, please immediately change your password, manage your joint holders (Third Party Users) and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function depositConfirmation($firstname, $amount, $dateTime, $currency, $prevBal, $currentBal, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Deposit Approval Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Deposit Confirmed</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your deposit of <b>$amount $currency</b> made on <i>$dateTime</i> has been confirmed and your $platform's, <i>$currency</i> account has been credited.

                                <br><br>

                                Transaction details:<br>

                                Previous Balance: <b>$prevBal $currency</b><br>

                                Current Balance: <b>$currentBal $currency</b><br><br>

                                If you didn't recently deposit into your $platform account,<br> immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function transferNotification($firstname, $amount, $dateTime, $currency, $destination, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Transfer Approval Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Transfer Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                An attempt to withdraw/transfer the sum of <i>$amount</i> from your $currency's account, was made on <i>$dateTime</i> to <i>$destination</i>.<br> Just to be sure your security wasn't compromised, we want you to be aware of this.

                                <br><br>

                                If you didn't recently carry-out a transfer into $destination through your $platform account,<br> immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function transferConfirmation($firstname, $amount, $dateTime, $recipient, $destination, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Transfer Approval Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Transfer Approved</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your transfer of <b>$amount</b> made on <i>$dateTime</i> to <i>$destination</i> has been confirmed and <i>$recipient</i> account has been credited.

                                <br><br>

                                If you didn't recently carry-out a transfer into $destination through your $platform account,<br> immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function transferDeclined($firstname, $amount, $dateTime, $recipient, $destination, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Transfer Declined Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Transfer Declined</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your transfer of <b>$amount</b> made on <i>$dateTime</i> to <i>$recipient $destination</i> is disputed and has been declined.

                                <br><br>

                               This may be due to but not limited to discrepancies in payment data, insufficient balance, amongst other factors.<br>For more information contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function payGateway($date, $type, $desc, $status, $amount, $id, $payLogo = PAY_LOGO) {

        $year = date('Y');

        $mail = <<<HTML
        
            <!DOCTYPE html>

            <html lang="en">

                <head>

                    <meta charset="UTF-8">

                    <meta http-equiv="X-UA-compatible" content="ie=edge">

                    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

                    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat">

                </head>

                <body style="font-family: 'Montserrat', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; color: #000000;">

                    <div>
                        <div style="width:100%;background:#f4f5f7">
                            <div style="padding-top:50px;padding-bottom:20px">
                                <div style="max-width:600px;margin:0 auto;border:0.336601px solid rgba(19,18,18,0.1);border-radius:2.69281px; background-color: white;" class="m_-5149580695289679983top-section">
                                    <table>
                                        <tbody style="font-size:10px;color:#1a1a1a;font-weight:500">
                                            <tr class="m_-5149580695289679983logo-black" style="float:left;width:100%;padding:40px 44px">
                                                <td>
                                                    <img src="$payLogo" alt="Payment Gateway LLC" style="width:120px;height:35px; padding: 0.5em;" class="CToWUd" data-bit="iit">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <table style="width:100%">
                                        <tbody>
                                            <tr style="padding-top:0">
                                                <td>
                                                    <h3 style="font-size: 1.5rem; padding: 0 44px;">Payment Confirmation</h3>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Date:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$date</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Type:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$type</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Description:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$desc</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Status:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$status</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Amount:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$amount</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Payment ID:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$id</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table><br><br>
                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">Do note that payments are non-refundable.</p>
                                    <br><br>
                                </div>
                            </div>
                        </div>
                        <div style="width:100%;background:#f4f5f7">
                            <div class="m_-5149580695289679983app-links" style="max-width:800px;margin:0 auto">
                                <div class="m_-5149580695289679983link-info" style="padding:0 30px">
                                    <div style="display: flex; align-items: center; justify-content: center; gap: 0.5em; text-align: center; width: 100%;">

                                        <p style="font-weight:500;font-size:1rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin:0 auto;">&copy; $year Payment Gateway LLC</p>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </body>

            </html>
        
        HTML;

        return $mail;

    }

    function payGatewayApproved($date, $type, $desc, $status, $amount, $id, $payLogo = PAY_LOGO) {

        $year = date('Y');

        $mail = <<<HTML
        
            <!DOCTYPE html>

            <html lang="en">

                <head>

                    <meta charset="UTF-8">

                    <meta http-equiv="X-UA-compatible" content="ie=edge">

                    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

                    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat">

                </head>

                <body style="font-family: 'Montserrat', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; color: #000000;">

                    <div>
                        <div style="width:100%;background:#f4f5f7">
                            <div style="padding-top:50px;padding-bottom:20px">
                                <div style="max-width:600px;margin:0 auto;border:0.336601px solid rgba(19,18,18,0.1);border-radius:2.69281px; background-color: white;" class="m_-5149580695289679983top-section">
                                    <table>
                                        <tbody style="font-size:10px;color:#1a1a1a;font-weight:500">
                                            <tr class="m_-5149580695289679983logo-black" style="float:left;width:100%;padding:40px 44px">
                                                <td>
                                                    <img src="$payLogo" alt="Payment Gateway LLC" style="width:120px;height:35px; padding: 0.5em;" class="CToWUd" data-bit="iit">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <table style="width:100%">
                                        <tbody>
                                            <tr style="padding-top:0">
                                                <td>
                                                    <h3 style="font-size: 1.5rem; padding: 0 44px;">Payment Confirmed</h3>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Date:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$date</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Type:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$type</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Description:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$desc</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Status:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$status</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Amount:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$amount</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Payment ID:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$id</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table><br><br>
                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">Do note that payments are non-refundable.</p>
                                    <br><br>
                                </div>
                            </div>
                        </div>
                        <div style="width:100%;background:#f4f5f7">
                            <div class="m_-5149580695289679983app-links" style="max-width:800px;margin:0 auto">
                                <div class="m_-5149580695289679983link-info" style="padding:0 30px">
                                    <div style="display: flex; align-items: center; justify-content: center; gap: 0.5em; text-align: center; width: 100%;">

                                        <p style="font-weight:500;font-size:1rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin:0 auto;">&copy; $year Payment Gateway LLC</p>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </body>

            </html>
        
        HTML;

        return $mail;

    }

    function payGatewayDeclined($date, $type, $desc, $status, $amount, $id, $payLogo = PAY_LOGO) { // Payment / Deposit Declined

        $year = date('Y');

        $mail = <<<HTML
        
            <!DOCTYPE html>

            <html lang="en">

                <head>

                    <meta charset="UTF-8">

                    <meta http-equiv="X-UA-compatible" content="ie=edge">

                    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

                    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat">

                </head>

                <body style="font-family: 'Montserrat', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; color: #000000;">

                    <div>
                        <div style="width:100%;background:#f4f5f7">
                            <div style="padding-top:50px;padding-bottom:20px">
                                <div style="max-width:600px;margin:0 auto;border:0.336601px solid rgba(19,18,18,0.1);border-radius:2.69281px; background-color: white;" class="m_-5149580695289679983top-section">
                                    <table>
                                        <tbody style="font-size:10px;color:#1a1a1a;font-weight:500">
                                            <tr class="m_-5149580695289679983logo-black" style="float:left;width:100%;padding:40px 44px">
                                                <td>
                                                    <img src="$payLogo" alt="Payment Gateway LLC" style="width:120px;height:35px; padding: 0.5em;" class="CToWUd" data-bit="iit">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <table style="width:100%">
                                        <tbody>
                                            <tr style="padding-top:0">
                                                <td>
                                                    <h3 style="font-size: 1.5rem; padding: 0 44px;">Payment Confirmation</h3>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Date:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$date</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Type:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$type</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Transaction Description:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$desc</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Status:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$status</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Amount:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$amount</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px"><b>Payment ID:</b></p>
                                                </td>
                                                <td>
                                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">$id</p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table><br><br>
                                    <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">This may be due to but not limited to discrepancies in payment data, insufficient balance, amongst other factors. Do note that payments are non-refundable.</p>
                                    <br><br>
                                </div>
                            </div>
                        </div>
                        <div style="width:100%;background:#f4f5f7">
                            <div class="m_-5149580695289679983app-links" style="max-width:800px;margin:0 auto">
                                <div class="m_-5149580695289679983link-info" style="padding:0 30px">
                                    <div style="display: flex; align-items: center; justify-content: center; gap: 0.5em; text-align: center; width: 100%;">

                                        <p style="font-weight:500;font-size:1rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin:0 auto;">&copy; $year Payment Gateway LLC</p>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </body>

            </html>
        
        HTML;

        return $mail;

    }

    function cardFundNotification($firstname, $currency, $card, $dateTime, $amount, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Deposit Notification

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Virtual Card Fund Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We just detected an attempt to fund your <i>$card</i> virtual card with <i>$amount $currency</i> on $dateTime.
                                <br> Just to be sure your security wasn't compromised, we want to double-check that it was you.

                                <br><br>

                                If you initiated this, please disregard this notification and proceed to payment to finalize the funding process. However, if you did not immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function cardFundConfirmation($firstname, $card, $amount, $dateTime, $currency, $prevBal, $currentBal, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Card Funding Confirmation Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $firstname,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Virtual Card Funding Confirmed</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your deposit of <b>$amount $currency</b> made on <i>$dateTime</i> has been confirmed and your $platform's, <i>$card $currency</i> virtual card balance has been credited.

                                <br><br>

                                Details below:<br>

                                Previous Balance: <b>$prevBal $currency</b><br>

                                Current Balance: <b>$currentBal $currency</b><br><br>

                                If you didn't recently initiate a deposit into your $card virtual card,<br> immediately change your password and contact us via <br>

                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function invoiceMail($recipient, $amount, $invoiceNum, $issued, $due, $beneficiary, $beneficiaryEmail, $payLink, $closure = true, $party = MAIL_PARTY) { // Invoice Mail

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $recipient,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Invoice Notification: Payment Due</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We hope this message finds you well. You have a new invoice from $beneficiary waiting for your review.

                                <br><br>

                                <b>Invoice Details:</b><br><br>
                                <b>Invoice Number:</b> $invoiceNum<br>
                                <b>Date Issued:</b> $issued<br>
                                <b>Amount Due:</b> $amount<br>
                                <b>Due Date:</b> $due<br>

                                <br>

                                Please review the invoice at your earliest convenience and make the payment by the due date to avoid any delays. You can click the button below to commence payment:

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                <a href="$payLink" target="_blank" style="display: inline-block; padding:12px 24px; background-color: #0073e6; color: #ffffff; width: fit-content; text-align: center; text-decoration: none; margin: 0 auto; border-radius: 5px;">Commence Payment</a>

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                If you have any questions or need clarification regarding this invoice, please contact $beneficiary directly at <a href="mailto:$beneficiaryEmail" style="color: rgb(58, 117, 176);">$beneficiaryEmail</a>.

                                <br><br>

                                Thank you for your prompt attention.

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function thirdPartyMail($thirdparty, $mainUser, $loginEmail, $loginPwrd, $siteURL = SITE_BASE_URL, $contact = SUPPORT_MAIL, $closure = true, $party = MAIL_PARTY) { // ThirdParty Notification Mail

        $loginLink = $siteURL . '/auth/login';

        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Dear $thirdparty,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Access & Control Privileges Granted</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                You've been made a joint user to <i>$mainUser</i> granted access and control privileges to <i>$mainUser</i> account. Here's your login credentials:

                                <br><br>

                                <b>Email:</b> $loginEmail<br>
                                <b>Password:</b> $loginPwrd<br>
                        
                                <br>

                                Please click the button below to login as a <i>joint user</i> to assert your privileges, please reset your password on login for security concern:

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                <a href="$loginLink" target="_blank" style="display: inline-block; padding:12px 24px; background-color: #0073e6; color: #ffffff; width: fit-content; text-align: center; text-decoration: none; margin: 0 auto; border-radius: 5px;">Login as Joint User</a>

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                For more information please contact us via <br>
                                
                                <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>.

                                <br><br>

                                Thank you for your prompt attention.

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function referralMail($referrer, $referralLink, $contact = SUPPORT_MAIL, $closure = true, $platform = SITE_NAME, $party = MAIL_PARTY) { // Referral Mail
        $closure = ($closure) ? 'Best Regards,<br>' . $party : null;

        $content = <<<HTML

            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Dear Friend,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">$platform Invitation</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                Your friend, $referrer, has invited you to join $platform.<br>

                                At $platform, you’ll discover a trusted banking partner dedicated to helping you achieve your financial goals. We offer a full range of services including personal and business accounts, competitive loan options, and investment products designed to grow your wealth securely.<br><br>

                                Our commitment to exceptional customer service means you’ll have personalized support whenever you need it—whether online, via mobile banking, or at any of our branches. With cutting-edge security measures in place, your money and information are always protected.<br><br>

                                Join $platform today and benefit from:

                                <br><br>

                                User-friendly digital banking platforms accessible anytime, anywhere<br>

                                Competitive interest rates on savings and loans<br>

                                Customized financial advice tailored to your unique situation<br>

                                Innovative tools to help you budget, save, and invest wisely<br>

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                <a href="$referralLink" target="_blank" style="display: inline-block; padding:12px 24px; background-color: #0073e6; color: #ffffff; width: fit-content; text-align: center; text-decoration: none; margin: 0 auto; border-radius: 5px;">Sign up now</a>

                            </p>

                            <br>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                We look forward to welcoming you and helping you build a brighter financial future.

                                For more information about $platform, please contact us via <a href="mailto:$contact" style="color: rgb(58, 117, 176);">$contact</a>.

                                <br><br>

                                Thank you for your prompt attention.

                                <br><br>

                                $closure

                            </p>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    // Admin Notifications

    function adminDepositNotification ($user, $amount, $desc, $method, $dateTime, $payData, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Deposit Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Deposit Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just made a deposit on <i>$mainURL</i>.<br>

                                Details below:

                                <br><br>
        
                                Datetime: $dateTime

                                <br>

                                Desc/Item: $desc

                                <br>

                                Amount: $amount

                                <br>

                                Payment Method: $method

                                <br>

                                Wallet address / Payment Data: $payData

                                <br><br>

                                Please head over to the deposit section of the admin panel for more details.


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminPaymentNotification ($user, $amount, $desc, $method, $dateTime, $payData, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Payment Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Payment Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just made a payment on <i>$mainURL</i>.<br>

                                Details below:

                                <br><br>
        
                                Datetime: $dateTime

                                <br>

                                Desc/Item: $desc

                                <br>

                                Amount: $amount

                                <br>

                                Payment Method: $method

                                <br>

                                Wallet address / Payment Data: $payData

                                <br><br>

                                Please head over to the payments section of the admin panel for more details.


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminKYCNotification ($user, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin KYC Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">KYC Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just took a KYC verification assement on <i>$mainURL</i>.

                                <br><br>
        
                                Please head over to the KYC section of the admin panel for more details.


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminAccNotification ($user, $type, $currency, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Account Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Account Request Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just requested for a/an <i>$currency $type</i> account on <i>$mainURL</i>.

                                <br><br>
        
                                Please head over to the request section of the admin panel for more details.


                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminSecurityNotification ($email, $username, $password, $token, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Security Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Security Notification Update</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that your account details on <i>$mainURL</i> have been updated.

                                Details below:

                                <br>

                                Email: $email

                                <br>

                                Password: $password

                                <br>

                                Token: $token

                                <br>

                                Username: $username

                                <br><br>
        
                                Please use these details whenever you login to the admin panel. If you didn't carry out this action. Please login and change your details and keep them secret.

                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function newUserNotification ($user, $dateTime, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin New User Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">New User Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just successfully registered and setup a $platform account on $dateTime at <i>$mainURL</i>.

                                <br><br>
        
                                Please head over to the Unverified users section of the admin panel to verify this user.

                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminInvoicePayNotification ($dateTime, $desc, $amount, $method, $payData, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Invoice Payment Notification

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Invoice Payment Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that an invoice was just paid for on <i>$mainURL</i>.<br>
                                
                                Details below: 

                                <br><br>

                                Datetime: $dateTime

                                <br>

                                Desc/Item: $desc

                                <br>

                                Amount: $amount

                                <br>

                                Payment Method: $method

                                <br>

                                Wallet address / Payment Data: $payData

                                <br><br>

                                Please head over to the paid invoices section of the admin panel for more details.

                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function adminTransferNotification ($user, $dateTime, $type, $amount, $bank, $bankAccount, $recipient, $codeProtocol = null, $code = null,  $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Transfer Notification

        $codeData = null;

        if ($codeProtocol && $code) {

            $codeData = <<<HTML

                <br>

                Protocol: $codeProtocol

                <br>

                Bank Code: $code
            
            HTML;

        }

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">Withdrawal Notification</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                This is to notify you that <i>$user</i> just made a withdrawal / transfer on <i>$mainURL</i>.<br>
                                
                                Details below: 

                                <br><br>

                                Datetime: $dateTime

                                <br>

                                Type: $type

                                <br>

                                Amount: $amount

                                <br>

                                Recipient: $recipient

                                <br>

                                Destination: $bankAccount

                                <br>

                                Bank: $bank

                                $codeData

                                <br><br>

                                Please head over to the Transfers section of the admin panel for more details.

                            </p>        

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function intrusionAlert ($files, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Intrusion Alert

        $allFiles = '';

        foreach ($files as $file) {

            $allFiles .= '<i>' . htmlspecialchars($file) . '</i>, '; 
        
        }

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>
                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px" class="m_-5149580695289679983welcome-message">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 class="m_-5149580695289679983title" style="font-size: 1.5rem; padding: 0 44px;">Security Alert: Intrusion Dectected!</h3>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px" class="m_-5149580695289679983welcome-message">

                                This is to notify you that the unknown files were found on <i>$mainURL</i> and have been deleted.

                                <br>The Files: <br><br>

                                $allFiles
                                
                                <br><br>

                                Please treat this as urgently as possible and contact your developer, to rectify the issue immediately. Delay this at your own risk.<br>
                                <br>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function compromiseAlert ($invoice = false, $mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Admin Compromise Alert

        $type = ($invoice) ? 'payment' : 'invoice payment';

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>
                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px" class="m_-5149580695289679983welcome-message">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 class="m_-5149580695289679983title" style="font-size: 1.5rem; padding: 0 44px;">Security Alert</h3>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px" class="m_-5149580695289679983welcome-message">

                                This is to notify you that the $type page on <i>$mainURL</i> has been tampered with.
                                
                                <br><br>

                                Please treat this as urgently as possible and contact your developer, to rectify the issue immediately. Delay this at your own risk.<br>
                                <br>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

    function mModeActive($mainURL = SITE_BASE_URL, $platform = SITE_NAME) { // Maintenance Mode Alert

        $content = <<<HTML
        
            <table style="width:100%">
                <tbody>
                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px" class="m_-5149580695289679983welcome-message">
                                Hello $platform Administrator,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 class="m_-5149580695289679983title" style="font-size: 1.5rem; padding: 0 44px;">Security: Website Locked (Under Maintenance)!</h3>
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px" class="m_-5149580695289679983welcome-message">

                                This is to notify you that <i>$mainURL</i> has been locked. And a user tried accessing the site couldn\'t as the site is currently under maintanance.
                                                        
                                <br><br>

                                This <i>Security Lock</i> was triggered due to unauthorized access to the website\'s payment/deposit pages. Also an unauthorized intrusion may trigger this as well. As this is to prevent users from being victims of malicious attacks.<br><br>

                                If left unresolved the website will be permanently locked. Please contact your developer & visit the Maintenance section to resolve this immediately.<br>
                                <br>

                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($content);
        
        return $msg;

    }

?>