<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $email = filter_var($_REQUEST['email'], FILTER_SANITIZE_EMAIL);

        // Find User

        $found = false; // Flag

        // $stmt = mysqli_prepare($conn, "SELECT * FROM `users` WHERE `email` = CAST(? AS BINARY)");
        
        $stmt = mysqli_prepare($conn, "SELECT DISTINCT `A`.`acc_status` AS `main_status`, 'USER' AS `user_type` FROM `users` AS `A` WHERE `A`.`email` = CAST(? AS BINARY) UNION ALL SELECT `U`.`acc_status` AS `main_status`, 'THIRD PARTY' AS `user_type` FROM `third_party` AS `TP` INNER JOIN `users` AS `U` ON `TP`.`user_id` = `U`.`user_id` WHERE `TP`.`email` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $email, $email); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $status = $row['main_status'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement


        $access = false; // Flag

        if ($found) {

            if ($status !== 'BANNED' && $status !== 'BLOCKED') {

                $access = true; // Update Flag

            }

            // if ($ipStatus === 'ALLOWED' && $cookieStatus === 'ALLOWED') {

            //     $access = true; // Update Flag

            // } else if (is_null($ipStatus) && is_null($cookieStatus)) {

            //     $access = true;

            // }

        }

        if ($access) {

            $_SESSION = [];

            session_destroy();

        } else {

            $_SESSION['NO-ACCESS'] = true;

        }

        $location = !is_null(HOME_PAGE) ? SITE_BASE_URL . '/auth/login' : HOME_PAGE; // Redirect Location

        echo json_encode(['access' => $access, 'dest' => $location]); // Encode JSON Response

    }

?>