<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Establish Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-TYPE']) || !isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-ID']) || !isset($_SESSION['B-CODE'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }
        
        $mainUser = $_SESSION['USER-ID']; // Account Owner

        $user = $_SESSION['CURRENT-USER']; // Logged User 

        $userType = $_SESSION['USER-TYPE']; // Get User Type

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $user, $userType); // Set Timezone

        $userData = userData($mainUser, $conn); // Get Main User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $codeTrack = isset($_SESSION['CODE-TRACK']) ? $_SESSION['CODE-TRACK'] : 0;

        $codeCount = bcodeCount($user, $conn);

        $codeData = currentBcode($user, $conn, $codeTrack);

        // Sanitize Field

        $code = filter_var($_REQUEST['code'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Check Code & Validate Code Status
        
        if ($code == $codeData['PIN'] && $codeData['PIN-status'] == 'PAID') {

            $_SESSION['CODE-TRACK'] = $codeTrack + 1; // Update Code Tracking

            if ($codeCount > $_SESSION['CODE-TRACK']) {

                echo json_encode(['codeNext' => true]); // Encode JSON Response

                exit(); // End Run

            } else {

                // Recall Sessions

                // $user = $_SESSION['USER-ID'];

                $amount = $_SESSION['SUBJECT-AMOUNT'];

                $scope = $_SESSION['TRANSFER-SCOPE'];

                $type = $_SESSION['TRANSFER-TYPE'];

                $descr = $_SESSION['TRANSFER-DESCR'];

                $balance = $_SESSION['TRANSFER-SRC-BAL'];

                $currency = $_SESSION['SUBJECT-CURR'];

                $accNum = $_SESSION['TRANSFER-SOURCE'];

                $name = $_SESSION['TRANSFER-RECPT'];

                $dest = $_SESSION['TRANSFER-DEST'];

                $bank = $_SESSION['RECPT-BANK'];

                $sourceiD = $_SESSION['TRANSFER-SRC-ID'];

                $status = $_SESSION['TRANSFER-STATUS'];

                $code = $_SESSION['TRANSFER-BANK-CODE'] ?? null;

                $codeType = $_SESSION['TRANSFER-BANK-CODE-TYPE'] ?? null;

                $newBal = $balance - $amount;

                $id = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

                $uetr = (!is_null($code) && !is_null($codeType)) ? uetrConvert($id) : null; // UETR (Wire Transfer Only)

                if ($userType != 'THIRD PARTY') {

                    $auth = $userData['auth']; // 2FA Status

                    $tPIN = true; // Transaction PIN

                    if ($auth === 'ENABLED') { // 2FA ENABLED

                        $code = generateOTP($mainUser, $conn); // Generate OTP

                        // Send Email

                        $subject = 'Authenticate Transfer #' . mt_rand(10000000, 99999999);

                        $mail = transferOTP($userData['firstname'], $code);

                        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                        if (!$deliver) {

                            @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                        }

                        echo json_encode(['auth' => true]); // Encode JSON Response

                        exit; // End Run

                    } else if ($tPIN) { // Transaction PIN

                        echo json_encode(['tPIN' => true]); // Encode JSON Response

                        exit; // End Run

                    }

                } 

                $thirdParty = thirdPartyData($user, $conn); // Get Third Party Data

                if (!$thirdParty) { // Invalid Third Party User

                    echo json_encode(['refresh' => true]); // Encode JSON Response

                    exit; // End Run

                }

                // Insert Into Database

                $approval = TRANSF_PREF;

                $created = false; // Flag

                $createTrans = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `uetr`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `recpt_acc`, `recpt_name`, `recpt_bank`, `banking_codetype`, `banking_code`, `status`, `approval_flag`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                mysqli_stmt_bind_param($createTrans, "ssssssssiddissssss", $user, $id, $uetr, $type, $scope, $descr, $currency, $sourceiD, $accNum, $amount, $balance, $dest, $name, $bank, $codeType, $code, $status, $approval); // Bind Parameters

                if (mysqli_stmt_execute($createTrans)) { // Execute Statement

                    $created = true; // Update Flag

                    if (TRANSF_PREF === 'AUTOMATIC') {

                        // Update Account Balance

                        $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ?"); // Prepare Statement

                        mysqli_stmt_bind_param($stmt, "ss", $amount, $sourceiD); // Bind Parameter(s)

                        mysqli_stmt_execute($stmt); // Execute Statement

                        mysqli_stmt_close($stmt); // Close Statement
                        
                    }

                    // if ($userType == 'THIRD PARTY') {

                        updateJointUserTransCount($user, $conn); // Update Transc Count

                    // }

                    // Unset Sessions

                    $sessions = [

                        'SUBJECT-AMOUNT',
                        'TRANSFER-SCOPE',
                        'TRANSFER-TYPE',
                        'TRANSFER-DESCR',
                        'TRANSFER-SRC-BAL',
                        'SUBJECT-CURR',
                        'TRANSFER-SOURCE',
                        'TRANSFER-RECPT',
                        'TRANSFER-DEST',
                        'RECPT-BANK',
                        'TRANSFER-SRC-ID',
                        'TRANSFER-STATUS',
                        'B-CODE',
                        'CODE-TRACK',
                        'TRANSFER-BANK-CODE',
                        'TRANSFER-BANK-CODE-TYPE',
                    ];

                    foreach ($sessions as $session) {

                        if (isset($_SESSION[$session])) {

                            unset($_SESSION[$session]);

                        }    

                    }

                    $_SESSION['TRANSF-ID'] = $id;

                    $dateTime = timeGMT('l M d, Y (H:i) [T]');

                    $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

                    // Handle Notifications & Mail (Notify Initiator / Account Owner / Admin) 

                    $notf = 'A transfer of ' . $money . ' was just initiated by ' . join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]) . ' (JOINT USER) through your ' . $currency . ' account on  ' . $dateTime;

                    createNotification($conn, $mainUser, 'Transfer Notification', $notf); // Notify Account Owner

                    $notfB = 'You just initiated a transfer of ' . $money . ' was through ' . join(' ', [$userData['firstname'], $userData['lastname']]) . '\'s ' . $currency . ' account on  ' . $dateTime;

                    createNotification($conn, $user, 'Transfer Notification', $notfB); // Notify Initiator

                    $subjectAdmin = 'New Transfer Alert #' . mt_rand(10000000, 99999999);

                    $subject = 'Transfer/Withdrawal Notification #' . mt_rand(10000000, 99999999);

                    // Notify Admin
                    
                    $adminMail = adminTransferNotification(join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]), $dateTime, $scope, $money, $bank, $dest, $name, $codeType, $code); // Admin Message

                    $mail = transferNotification($thirdParty['firstname'], $money, $dateTime, $currency, $dest . '(' . $name . ')'); // Initiator Message

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $thirdParty['email'], join('', [$thirdParty['firstname'], $thirdParty['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                    $deliverAdmin = @deliverByPHPMailer($subjectAdmin, $adminMail, makePlain($adminMail), ADMIN_MAIL, ADMIN_NAME);

                    if (!$deliverAdmin) {

                        @deliverByPHPMail(ADMIN_MAIL, $subjectAdmin, $adminMail); // Fallback

                    }

                }

                mysqli_stmt_close($createTrans); // Close Statement

                echo json_encode(['transfer' => $created]); // Encode JSON Response

                exit; // End Run

            }

        } else {

            echo json_encode(['codeError' => true]); // Encode JSON Response

            exit(); // End Run

        }

    }

?>