<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['beneficiary-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Determine Action

        if ($action == 'EDIT') {

            $content = null;

            // Commence Data Fetch For Editing

            $found = false; // Flag

            $stmt = mysqli_prepare($conn, "SELECT * FROM `beneficiaries` WHERE `id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

            if (mysqli_num_rows($result) === 1) {

                $found = true; // Update Flag

                while ($row = mysqli_fetch_assoc($result)) { // Iterate Through Data
                    
                    $name = $row['name'];

                    $account = $row['account'];

                    $bank = $row['bank'];

                    $codetype = $row['banking_codetype'];

                    $code = $row['banking_code'];

                    $type = $row['type'];

                }

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            $body = null; // Holds HTML Structure
            
            if ($found) { // Consider Flag

                $body = <<<HTML
                
                    <form id="edit-beneficiaryForm" method="post">

                        <div class="form_item">

                            <input name="beneficiary-id" type="hidden" value="$id">

                            <label for="beneficiary-name">Name</label>

                            <input class="form_field" type="text" name="beneficiary-name" value="$name" required>

                        </div>

                        <div class="form_item">

                            <label for="transfer-type">Transfer Type</label>

                            <input class="form_field" type="text" name="transfer-type" value="$type" readonly>

                        </div>

                        <div class="form_item db">

                            <div class="form_item">

                                <label for="beneficiary-account">Account</label>

                                <input class="form_field" type="text" name="beneficiary-account" value="$account" required>

                            </div>

                            <div class="form_item">

                                <label for="beneficiary-bank">Bank</label>

                                <input class="form_field" type="text" name="beneficiary-bank" value="$bank" required>

                            </div>

                        </div>

                        $content

                        <div class="form_item">

                            <button class="form_btn" id="edit-beneficiary">Proceed</button>

                        </div>

                    </form>

                HTML;

            } 

            echo json_encode(['found' => $found, 'body' => $body]); // Encode JSON Response

        } else if ($action == 'DELETE') {

            // Commence Deletion

            $deleted = false; // Flag

            $stmt = mysqli_prepare($conn, "DELETE FROM `beneficiaries` WHERE `id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $deleted = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

        }

    }

?>