<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup
    
    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS); // Main User (Account Holder)
        
        $accounts = userAccounts($user, $conn); // Get Accounts

        if (!$accounts) {

            echo json_encode(['accError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Field

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $thirdParty = thirdPartyData($id, $conn); // Get Third Party Data

        if (!$thirdParty) {

            echo json_encode(['holderError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Normalize Data

        // $middlename = $thirdParty['middlename'] ?? '';

        // $title = $thirdParty['title'] ?? '';

        $barred = is_null($thirdParty['no-access']) ? '' : array_map('trim', explode(',', $thirdParty['no-access'])); // Convert To Array

        $data = [

            'personal' => [

                'id' => $id,

                'firstname' => $thirdParty['firstname'],

                'middlename' => $thirdParty['middlename'] ?? '',

                'lastname' => $thirdParty['lastname'],

                'email' => $thirdParty['email'],

                'gender' => $thirdParty['gender'],

                'title' => $thirdParty['title'] ?? '',

            ],

            'banking' => [

                'status' => $thirdParty['account-status'],

                'wthLimit' => $thirdParty['wth-limit'] ?? 0.00,

                'transLimit' => $thirdParty['trans-limit'] ?? 0.00,

                'barred' => $barred,

                'transCount' => $thirdParty['trans-count'] ?? 0,

            ]

        ];

        echo json_encode(['strt' => $data], JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT); // Encode JSON Response

    }

?>