<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['CURRENT-USER'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['CURRENT-USER'];

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Fetch Conversations

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `messages` WHERE `ticket_id` = ? ORDER BY `created_at`"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) > 0) {

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Collect Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            $messages = '';

            foreach ($data as $row):

                $message = $row['message_text'];

                $date = date('D, M d, Y h:i a', strtotime($row['created_at'])) . ' [UTC]';

                $sender = $row['sender'];

                $class = ($user == $sender) ? 'sent' : 'reply';

                $messages .= <<<EOD

                    <div class="chat-box $class">

                        <div class="conversation-box">

                            <p>$message</p>

                        </div>

                        <p class="temporal">$date</p>

                    </div>

                EOD;    

            endforeach;

            $body[] = <<<EOD

                <div class="chat-window">

                    <div class="chat-con">

                        $messages

                    </div>

                    <div class="chat-field">

                        <input type="hidden" id="conv-id" value="$id">

                        <textarea placeholder="Type your message..." id="chat-msg"></textarea>

                        <button id="send-msg">

                            <svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="_GoIcon_ne5xz_109">
                                <title>Send Message</title>
                                <g id="homepage" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g id="homepage-dark-mode" transform="translate(-840, -648)" stroke="#E8E8E8" stroke-width="2">
                                        <g id="keyboard-arrow-right" transform="translate(840, 648)">
                                            <circle id="Oval" cx="16" cy="16" r="15"></circle>
                                            <polyline id="Path" stroke-linecap="round" stroke-linejoin="round" points="16 10 22 16 16 22"></polyline>
                                            <line x1="22" y1="16" x2="10" y2="16" id="Path" stroke-linecap="round" stroke-linejoin="round"></line>
                                        </g>
                                    </g>
                                </g>
                            </svg>

                        </button>

                    </div>

                </div>
            
            EOD;

        } else {

            $body[] = <<<EOD

                <div class="unavailable">

                    <div class="icon">

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-lg shrink-0">
                            <path d="M13 12C13 11.4477 12.5523 11 12 11C11.4477 11 11 11.4477 11 12V16C11 16.5523 11.4477 17 12 17C12.5523 17 13 16.5523 13 16V12Z" fill="currentColor"></path>
                            <path d="M12 9.5C12.6904 9.5 13.25 8.94036 13.25 8.25C13.25 7.55964 12.6904 7 12 7C11.3096 7 10.75 7.55964 10.75 8.25C10.75 8.94036 11.3096 9.5 12 9.5Z" fill="currentColor"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2ZM4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12Z" fill="currentColor"></path>
                        </svg>

                    </div>

                    <p>Error! Conversations not found!.</p>

                </div>

            EOD;

        }

        echo json_encode(['conversations' => implode('', $body)]);

    }

?>