<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Sanitize Field(s)

        $name = filter_var($_REQUEST['customer-name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var($_REQUEST['email'], FILTER_SANITIZE_SPECIAL_CHARS);

        $street = filter_var($_REQUEST['street'], FILTER_SANITIZE_SPECIAL_CHARS);

        $city = filter_var($_REQUEST['city'], FILTER_SANITIZE_SPECIAL_CHARS);

        $state = filter_var($_REQUEST['state'], FILTER_SANITIZE_SPECIAL_CHARS);

        $zip = filter_var($_REQUEST['zip-code'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var($_REQUEST['country'], FILTER_SANITIZE_SPECIAL_CHARS);

        $emailTaken = checkCustomerEmail($email, $conn); // Validate Customer's Email

        if ($emailTaken) {

            echo json_encode(['emailTaken' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Creation

        $created = false; // Flag

        $id = generateUniqueID($conn, 'customers', 'CUS'); // Generate ID

        $addedOn = sanitizeDate(time()); // Creation Date

        $stmt = mysqli_prepare($conn, "INSERT INTO `customers` (`customer_id`, `user_id`, `email`, `name`, `address`, `city`, `state`, `country`, `zip`, `added_on`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssssssss", $id, $user, $email, $name, $street, $city, $state, $country, $zip, $addedOn); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['created' => $created]); // Encode JSON Response

    }    

?>