<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Field(s)

        $customer = filter_var($_REQUEST['inv-recipient'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $rawDue = $_REQUEST['due'];

        $due = sanitizeDate($_REQUEST['due']);

        $discount = !empty($_REQUEST['discount']) ? filter_var($_REQUEST['discount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;

        $dicountType = ($discount) ? filter_var($_REQUEST['discount-type'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $tax = !empty($_REQUEST['tax']) ? filter_var($_REQUEST['tax'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;

        $taxType = ($tax) ? filter_var($_REQUEST['tax-type'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $itemList = array_map('htmlspecialchars', $_REQUEST['item-desc']);

        $itemList = implode(', ', $itemList); // Join Into Comma-Separated String

        $priceList = array_map('htmlspecialchars', $_REQUEST['item-price']);

        $priceList = implode(', ', $priceList); // Join Into Comma-Separated String

        $qtyList = array_map('htmlspecialchars', $_REQUEST['item-qty']);

        $qtyList = implode(', ', $qtyList); // Join Into Comma-Separated String

        $credit = !empty($_REQUEST['credit']) ? filter_var($_REQUEST['credit'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;

        $title = !empty($_REQUEST['inv-title']) ? filter_var($_REQUEST['inv-title'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $descr = !empty($_REQUEST['descr']) ? filter_var($_REQUEST['descr'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $taxSubtotal = isset($_REQUEST['tax-first']) ? true : false;

        $taxFirst = $taxSubtotal ? 'YES' : 'NO';

        // Validate Customer

        $customerData = customerData($customer, $conn); // Get Customer Data

        if (!$customerData) { // Invalid Customer

            echo json_encode(['customerError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $createdOn = date('Y-m-d', time()); // Creation Date

        if ($createdOn > $due) {

            echo json_encode(['dateError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $payable = invoiceTotal($qtyList, $priceList, $credit, $discount, $dicountType, $tax, $taxType, $taxSubtotal); // Calculate Total

        // Commence Invoice Creation

        $created = false; // Flag

        $id = generateUniqueID($conn, 'invoices', 'INV'); // Generate ID

        $num = mt_rand(1000, mt_getrandmax());

        $stmt = mysqli_prepare($conn, "INSERT INTO `invoices` (`invoice_id`, `inv_num`, `user_id`, `customer_id`, `title`, `descr`, `qty`, `items`, `prices`, `currency`, `credit`, `discount`, `discount_type`, `tax`, `tax_type`, `tax_first`, `payable_amount`, `created`, `due`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssssssssddsdssdss", $id, $num, $user, $customer, $title, $descr, $qtyList, $itemList, $priceList, $currency, $credit, $discount, $dicountType, $tax, $taxType, $taxFirst, $payable, $createdOn, $due); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        $sent = false; // Email Delivery Flag

        if ($created) { // Send Email

            $subject = 'Invoice Notification | Payment Due #' . $num;

            $created = date('l, M d Y', time());

            $dueDate = date('l, M d Y', strtotime($rawDue));

            $link = SITE_BASE_URL . '/invoice/?accessKey=' . urlencode(encrypt($id));

            $total = $currSymbol[$currency] . number_format($payable, 2) . ' ' . $currency;

            $mail = invoiceMail($customerData['name'], $total, $num, $created, $dueDate, join(' ', [$userData['firstname'], $userData['lastname']]), $userData['email'], $link);

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $customerData['email'], $customerData['name']);

            if (!$deliver) {

                $deliver = @deliverByPHPMail($customerData['email'], $subject, $mail); // Fallback

            }

            $sent = $deliver;

        }

        echo json_encode(['created' => $created, 'mail' => $sent]); // Encode JSON Response 

    }

?>