<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['CURRENT-USER'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // Terminate

        }

        $user = $_SESSION['CURRENT-USER'];

        // Sanitize Fields

        $title = !empty($_REQUEST['title']) ? filter_var(trim($_REQUEST['title']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $message = filter_var(trim($_REQUEST['msg']), FILTER_SANITIZE_SPECIAL_CHARS);

        // $date = timeGMT(time()); // GMT Equivalent

        $date = date('Y-m-d H:i:s', time());

        // Validate Fields

        if (strlen($message) < 6) {

            echo json_encode(['msgShort' => true]); // Encode JSON Response

            exit; // Terminate

        }

        // Initiate Data Drop

        $created = false; // Flag

        $id = generateUniqueID($conn, 'support_tickets', 'STK'); // Generate ID

        $stmt = mysqli_prepare($conn, "INSERT INTO `support_tickets` (`ticket_id`, `user_id`, `title`, `created_at`) VALUES(?, ?, ?, ?)"); // Prepare Statement (Ticket Creation)

        mysqli_stmt_bind_param($stmt, "ssss", $id, $user, $title, $date); // Bind Parameter(s)

        $stmt2 = mysqli_prepare($conn, "INSERT INTO `messages` (`ticket_id`, `message_text`, `sender`, `created_at`) VALUES(?, ?, ?, ?)"); // Prepare Statement (Record Message)

        mysqli_stmt_bind_param($stmt2, "ssss", $id, $message, $user, $date); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statements

            $created = true; // Update Flag

        }

        // Close Statements

        mysqli_stmt_close($stmt);

        mysqli_stmt_close($stmt2);

        echo json_encode(['created' => $created]); // Encode JSON Response

    }

?>