<?php

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); //  Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Deletion

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `support_tickets` WHERE `ticket_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id);
        
        $stmt2 = mysqli_prepare($conn, "DELETE FROM `messages` WHERE `ticket_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt2, "s", $id);

        if (mysqli_stmt_execute($stmt2) && mysqli_stmt_execute($stmt)) {

            $deleted = true; // Update Flag

        }

        // Close Statements

        mysqli_stmt_close($stmt);

        mysqli_stmt_close($stmt2);

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    }

?>