<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Establish Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Custom Functions

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])  || !isset($_SESSION['USER-TYPE']) || !isset($_SESSION['CURRENT-USER'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $mainUser = $_SESSION['USER-ID'];

        $userType = $_SESSION['USER-TYPE'];

        $user = $_SESSION['CURRENT-USER'];

        // Sanitize Fields

        $accId = filter_var($_REQUEST['account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        if ($amount <= 0) {

            echo json_encode(['amtError' => true]);

            exit;

        }

        $accountData = accountData($accId, $mainUser, $conn); // Get Account Data
        
        if (!$accountData) {

            echo json_encode(['accError' => true]);

            exit;

        }

        $currency = $accountData['currency'];

        $accNum = $accountData['acc-number'];

        $userData = userData($mainUser, $conn); // Get Main User Details

        if (!$userData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $thirdParty = false;

        if ($userType == 'THIRD PARTY') {

            $thirdParty = true;

        }

        $thirdPartyData = false;

        if ($thirdParty) {

            $thirdPartyData = thirdPartyData($user, $conn);

        }

        if (!$thirdPartyData && $thirdParty) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        // Set Payment Essentials

        $_SESSION['PAY'] = $currency . ' Account (DEPOSIT)';

        $_SESSION['PAY-AMOUNT'] = $amount;

        $_SESSION['PAY-DESC'] = $accId . '/' . $accNum;

        $_SESSION['SUBJECT-CURR'] = $currency;

        echo json_encode(['deposit' => true]);

        // Send Emails

        $time = timeGMT('l, M d Y, (H:i) [T]'); // GMT

        // Normalize Main User Data

        $mail = depositNotification($userData['firstname'], $currency, $time, $currSymbol[$currency] . number_format($amount, 2)); // Main User Message

        $subject = ($thirdParty ? 'Deposit Notification (Third Party) ' : 'Deposit Notification ') . '#' . mt_rand(10000000, 99999999);

        if ($thirdParty) {

            $name = join(' ', [$thirdPartyData['firstname'], $thirdPartyData['lastname']]);

            $mail = thirdPartyDepositNotification($userData['firstname'], $name, $currency, $time, $currSymbol[$currency] . number_format($amount, 2)); // Main User Message

            $notf = $name . ' just initiated a deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into your ' . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ')' . ' on ' . $time . '.';

            $notfB = 'You just initiated a deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into ' . join(' ', [$userData['firstname'], $userData['lastname']]) . ' ' . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ')' . ' on ' . $time . '.';

            createNotification($conn, $mainUser, 'Third Party Deposit Notification', $notf); // Notify Main User

            createNotification($conn, $user, 'Deposit Notification', $notfB); // Notify Current User

        } else {

            $notf = 'You just initiated a deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into your ' . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ')' . ' on ' . $time . '.';

            createNotification($conn, $mainUser, 'Deposit Notification', $notf); // Notify Main User

        }

        $recipientName = join(' ', [$userData['firstname'], $userData['lastname']]);

        $recipient = $userData['email'];

        $plain = makePlain($mail);

        $deliver = @deliverByPHPMailer($subject, $mail, $plain, $recipient, $recipientName);

        if (!$deliver) {

            @deliverByPHPMail($recipient, $subject, $mail); // Fallback

        }

    }

?>