<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initialize Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // User-defined Functions

    header('Content-Type: application/json'); // Communication Protocol

    $userData = userData($_SESSION['USER-ID'], $conn); // Get User Info

    // Request Processor
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Transaction Details

        $detailsFound = false; // Flag

        $details = mysqli_prepare($conn, "SELECT `A`.*, `B`.`due` AS `next_pay` FROM `loans` AS `A` LEFT JOIN `repayments_schedule` AS `B` ON `A`.`loan_id` = `B`.`loan_id` WHERE `A`.`loan_id` = ? AND `B`.`due` > ? ORDER BY `B`.`due` LIMIT 1"); // Prepare Statement

        $date = date('Y-m-d', time());

        mysqli_stmt_bind_param($details, "ss", $id, $date); // Bind Parameter(s)

        mysqli_stmt_execute($details); // Execute Statement

        $result = mysqli_stmt_get_result($details); // Get Result

        if (mysqli_num_rows($result) === 1) { // Get & Compare Result's Mass 

            $detailsFound = true; // Update Flag

            // Iterate Through Result

            while ($row = mysqli_fetch_assoc($result)) {

                $type = $row['type'];

                $status = $row['status'];
                
                $start = date('l jS, F, Y', strtotime($row['start']));

                $due = date('l jS, F, Y', strtotime($row['due']));

                $interest = $row['interest'];

                $frequency = $row['frequency'];

                $term = $row['term'];

                $currency = $row['currency'];

                $symbol = $currSymbol[$currency];

                $amount = number_format($row['amount'], 2);

                $repay = number_format($row['repay'], 2);

                $paid = number_format($row['paid'], 2);

                $next = date('l jS, F, Y', strtotime($row['next_pay']));

                $progress = 0;

                if ($repay > 0) {

                    // $progress = round($paid / (100 * $repay), 2);

                    $progress = round($paid * 100) / $repay;

                }

                $progress = round($progress, 2);

            }

        }

        mysqli_free_result($result); // Free Result
        
        mysqli_stmt_close($details); // Close Statement

        // Check Flag

        if ($detailsFound) {

            $response[] = <<<HTML
            
                <div class="loan_details">

                    <div class="flx col">

                        <div class="flx jSpaceBtw wFull">
                            
                            <p>Payment Progress</p>

                            <p>$progress%</p>

                        </div>

                        <div class="progress">

                            <div class="progress-track" style="width: $progress%"></div>

                        </div>

                    </div>

                    <br>

                    <div class="detailGrid">

                        <div class="detailGrid_box">

                            <p class="title">Loan Info</p>

                            <div class="detail_grid">

                                <div class="font-sm">Amount: $symbol$amount ($currency)</div>

                                <div class="font-sm">Type: $type</div>

                                <div class="font-sm">Interest: $interest%</div>

                                <div class="font-sm">Term: $term days</div>

                                <div class="font-sm">From: $start</div>

                                <div class="font-sm">Due: $due</div>

                            </div>

                        </div>

                        <div class="detailGrid_box">

                            <p class="title">Repayments</p>

                            <div class="detail_grid">

                                <div class="font-sm">Frequency: $frequency</div>
                                
                                <div class="font-sm">Repay: $symbol$repay ($currency)</div>

                                <div class="font-sm">Paid: $symbol$paid ($currency)</div>

                                <div class="font-sm">Next Payment due: $next</div>

                            </div>

                        </div>

                    </div>

                </div>
                
            HTML;

            echo json_encode(['status' => true, 'html' => implode('', $response)]); // Encode JSON Response

        } else {

            echo json_encode(['status' => false, 'message' => '<i>An error occurred!</i>']); // Encode JSON Response

        }

        exit; // End Run

    }

?>