<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Sesssions

    require('../../controls/config/config.php'); // Configuration File

    require('../../controls/engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user = $_SESSION['USER-ID'];

        // Sanitize Fields

        $base = filter_var($_REQUEST['base'], FILTER_SANITIZE_SPECIAL_CHARS);

        $alt = filter_var($_REQUEST['alt'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['volume'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        // Validation Checks

        if ($base == 0 || $alt == 0) {

            echo json_encode(['invalidCurr' => true]); // Encode JSON Response

            exit;

        }

        if ($base == $alt) {

            echo json_encode(['currError' => true]); // Encode JSON Response

            exit;

        }

        if ($amount <= 0) {

            echo json_encode(['amtError' => true]);

            exit;

        }

        $baseData = accountData($base, $user, $conn); // Get Base Account Data

        $altData = accountData($alt, $user, $conn); // Get Alt Account Data

        if (!$baseData || !$altData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        // Accounts Info

        $baseAcc = $baseData['acc-number'];

        $baseBal = $baseData['balance'];

        $baseCurr = $baseData['currency'];

        $altAcc = $altData['acc-number'];

        $altBal = $altData['balance'];

        $altCurr = $altData['currency'];

        // Check Balance 

        if ($amount > $baseBal) {

            echo json_encode(['fundError' => true]);

            exit;

        }

        $equiv = fiatSwap($baseCurr, $altCurr, $amount); // Convert

        if (!$equiv) {

            echo json_encode(['convError' => true]); // Encode JSON Response

            exit; // Terminate

        }

        $fee = (SWAP_RATE / 100) * $equiv; // Calculate Fee

        $receive = $equiv - $fee; // User Receives
        
        $swapped =  false; // Flag

        // Update Balance(s) & Record Transaction(s)

        $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = CASE WHEN `acc_id` = CAST(? AS BINARY) THEN `balance` - ? WHEN `acc_id` = CAST(? AS BINARY) THEN `balance` + ? ELSE `balance` END WHERE `acc_id` IN (CAST(? AS BINARY), CAST(? AS BINARY))"); // Prepare Statement (Accounts Balance Update)

        mysqli_stmt_bind_param($stmt, "sdsdss", $base, $amount, $alt, $receive, $base, $alt); // Bind Parameter(s)

        $stmt2 = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (For Transactions)

        // $stmt2 Parameter(s)

        $transId = generateUniqueID($conn, 'transactions', 'TRN');

        $transId2 = generateUniqueID($conn, 'transactions', 'TRN');

        $transType = 'DEBIT';

        $transType2 = 'CREDIT';

        $action = 'SWAP';

        $descr = $baseCurr . ' / ' . $altCurr . ' (SWAP)';

        $newBaseBal = $baseBal - $amount;

        $newAltBal = $altBal + $receive;

        $transStatus = 'COMPLETED';
 
        mysqli_stmt_bind_param($stmt2, "sssssssiddssssssssidds", $user, $transId, $transType, $action, $descr, $baseCurr, $base, $baseAcc, $amount, $newBaseBal, $transStatus, $user, $transId2, $transType2, $action, $descr, $altCurr, $alt, $altAcc, $receive, $newAltBal, $transStatus); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) {

            $swapped = true; // Update Flag

        }
        
        // Close Statements

        mysqli_stmt_close($stmt);

        mysqli_stmt_close($stmt2);

        echo json_encode(['swapped' => $swapped]);

    }

?>