<?php

    session_name('USERSESSID');

    session_start(); // Intiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // User-defined Functions

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response
            
            exit;

        }

        $user = $_SESSION['USER-ID'];

        $userData = userData($user, $conn); // Get User Info 

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        // Check KYC

        if ($userData['kyc-status'] == 'PROCESSING') {

            echo json_encode(['kycPending' => true]);

            exit;

        }
        
        if ($userData['kyc-status'] != 'VERIFIED') {

            echo json_encode(['kycError' => true]);

            exit;

        }

        $bankAddress = nl2br(break_commas($bankAddress));

        // Sanitize Fields

        $account = filter_var($_REQUEST['account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $start = sanitizeDate($_REQUEST['start']);

        $end = sanitizeDate($_REQUEST['end']);

        $format = filter_var($_REQUEST['format'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accData = accountData($account, $user, $conn); // Get Account Data

        if (!$accData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $currency = $accData['currency'];

        $accNum = $accData['acc-number'];

        // $balance = $accData['balance'];

        $bankCode = $accData['code'];

        $codeType = $accData['code-type'];

        $symbol = $currSymbol[$currency];

        $records = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `acc_id` = ? AND `date` >= ? AND `date` <= ?"); // Prepare Statement (Fetch Transactions)

        mysqli_stmt_bind_param($stmt, "sss", $account, $start, $end); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $records = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Collect Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        $balance = 0;

        $stmt = mysqli_prepare($conn, "SELECT COALESCE(SUM(CASE WHEN `type` = 'CREDIT' THEN `amount` ELSE 0 END), 0) AS `total_credit`, COALESCE(SUM(CASE WHEN `type` = 'DEBIT' THEN `amount` ELSE 0 END), 0) AS `total_debit`, COALESCE(SUM(CASE WHEN `type` = 'CREDIT' THEN `amount` ELSE 0 END), 0) - COALESCE(SUM(CASE WHEN type = 'DEBIT' THEN `amount` ELSE 0 END), 0) AS `balance` FROM `transactions` WHERE `acc_id` = ? AND `status` = ? AND `date` <= ?"); // Prepare Statement (Get Balance)

        $status = 'COMPLETED';

        mysqli_stmt_bind_param($stmt, "sss", $account, $status, $end); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        while ($row = mysqli_fetch_assoc($result)) {

            $balance = number_format($row['balance'], 2); // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($records) {

            $client = join(' ', [$userData['firstname'], $userData['lastname']]);

            $clientStreet = $userData['street'];

            $clientCity = $userData['city'];

            $clientState = $userData['state'];

            $clientCntry = $userData['country'];

            $clientZip = $userData['zip'];

            $from = strtoupper(date('F d, Y', strtotime($start)));

            $to = strtoupper(date('F d, Y', strtotime($end)));

            if ($format == 'PDF') {

                $tableData = '';

                foreach ($data as $row) {

                    $date = date('d/M/Y', strtotime($row['date']));

                    $descr = $row['descr'];

                    $class = 'red';

                    $sign = '-';

                    $type = $row['type'];

                    if ($type == 'CREDIT') {

                        $sign = '+';

                        $class = 'green';

                    }

                    $scope = $row['action'];

                    $amount = $sign . $symbol . number_format($row['amount'], 2);

                    // $ref = $row['trans_id'];

                    $status = $row['status'];

                    $tableData .= <<<HTML

                        <tr>

                            <td>$date</td>

                            <td>$descr</td>

                            <td class="$class">$amount</td>

                            <td>$scope</td>

                            <td>$status</td>

                        </tr>
                    
                    HTML;

                }

                $body[] = <<<HTML

                    <div class="bank_statement">

                        <div class="bankStmt_item header">

                            <div class="bank_data">

                                <div class="logo">

                                    <img src="$siteLogo" alt="">

                                </div>

                                <div class="address">

                                    <p>
                                        $bankName,<br>

                                        $bankAddress<br>
                                            
                                        $contactMail<br>

                                        $phone
                                
                                    </p>

                                </div>

                            </div>

                            <div class="bank_badge">

                                <svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>

                            </div>

                        </div>

                        <div class="bankStmt_item">

                            <p class="title">$currency STATEMENT OF ACCOUNT</p>

                            <p>$from to $to</p>
                        
                        </div>

                        <div class="bankStmt_item box_con">

                            <div class="box blue">

                                <div class="sub_box">

                                    <p class="title">$client</p>

                                    <p>

                                        $clientStreet,<br>

                                        $clientCity,<br>

                                        $clientState, $clientCntry.<br>

                                        $clientZip

                                    </p>

                                </div>

                            </div>

                            <div class="box">

                                <div class="sub_box">

                                    <p class="title">Account Number</p>

                                    <p>$accNum</p>

                                </div>

                            </div>

                            <div class="box">

                                <div class="sub_box">

                                    <p class="title">$codeType</p>

                                    <p>$bankCode</p>

                                </div>

                            </div>

                        </div>

                        <div class="bankStmt_item row jSpaceBtw">

                            <p class="title">$currency BALANCE AT $to</p>

                            <p class="title">$symbol $balance</p>

                        </div>

                        <div class="bankStmt_item table">

                            <table>

                                <thead>

                                    <tr>

                                        <th>Date</th>

                                        <th>Description</th>

                                        <th>Amount</th>

                                        <th>Type</th>

                                        <th>Status</th>

                                    </tr>

                                </thead>

                                <tbody>

                                    $tableData

                                </tbody>

                            </table>

                        </div>

                    </div>

                HTML;

                echo json_encode(['generated' => true, 'data' => implode('', $body)]);

                exit;

            } else if ($format == 'CSV') {

                ob_start(); // Output Buffering To Capture fputcsv() Output

                $output = fopen('php://output', 'w');

                // Add account details at the top
                fputcsv($output, ['Bank Statement']);
                fputcsv($output, ['Account Holder:', $client]);
                fputcsv($output, ['Account Number:', $accNum]);
                fputcsv($output, ['Bank Name:', SITE_NAME]);
                fputcsv($output, ['Statement Period:', $from . ' to ' . $to]);
                fputcsv($output, []); // Empty row for spacing
                fputcsv($output, [$currency . ' BALANCE AT ' . $to . ':', $symbol . $balance]);
                fputcsv($output, []); // Empty row for spacing

                fputcsv($output, ['Date', 'Description', 'Amount', 'Type', 'Reference', 'Status']);
                fputcsv($output, []); // Empty row for spacing
            
                foreach ($data as $row) {
                    fputcsv($output, [
                        date('d/M/Y', strtotime($row['date'])),
                        $row['descr'],
                        ($row['type'] == 'CREDIT' ? '+' : '-') . $symbol . number_format($row['amount'], 2),
                        $row['action'],
                        $row['trans_id'],
                        $row['status']
                    ]);

                    fputcsv($output, []); // Empty row for spacing
                }
            
                fclose($output);

                $body = ob_get_clean(); // Get Entire CSV Output
            
                echo json_encode(['generated' => true, 'data' => $body]);

                exit;

            }

            echo json_encode(['generated' => false]);

        } else {

            echo json_encode(['noTrans' => true]); // Encode JSON Response

        }

    }

?>