<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initialize Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // User-defined Functions

    header('Content-Type: application/json'); // Communication Protocol

    $userData = userData($_SESSION['USER-ID'], $conn); // Get User Info

    // Request Processor
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Transaction Details

        $detailsFound = false; // Flag

        $details = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `trans_id` = ?"); // Prpepare Statement

        mysqli_stmt_bind_param($details, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($details); // Execute Statement

        $result = mysqli_stmt_get_result($details); // Get Result

        if (mysqli_num_rows($result) === 1) { // Get & Compare Result's Mass 

            $detailsFound = true; // Update Flag

            // Iterate Through Result

            while ($row = mysqli_fetch_assoc($result)) {

                $status = $row['status'];
                
                $date = date('l jS, F, Y H:i', strtotime($row['date']));

                $currency = $row['currency'];

                $symbol = $currSymbol[$currency];

                $amount = number_format($row['amount'], 2);

                $source = $row['acc_num'];

                $dest = $row['recpt_acc'];

                $recipient = $row['recpt_name'];

                $type = $row['type'];

                $scope = $row['action'];

                $bank = $row['recpt_bank'];

                $code = $row['banking_code'];

                $codeType = $row['banking_codetype'];

                $desc = $row['descr'];

                $ref = $row['trans_id'];

                $descriptor = $type == 'CREDIT' ? 'Benefactor' : 'Sender';

                if ($scope == 'LOCAL TRANSFER') {

                    $body = '<div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Source</p>

                            <p class="desc">' . $source . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Destination</p>

                            <p class="desc">' . $dest . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Amount</p>

                            <p class="desc">' . $symbol . $amount . $currency . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Recipient</p>

                            <p class="desc">' . $recipient . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Bank</p>

                            <p class="desc">' . $bank . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Reference Number</p>

                            <p class="desc" variant="special">' . $ref . '</p>

                        </div>

                    </div>';

                } else if ($scope == 'CROSS-BORDER TRANSFER') {

                    $body = '<div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Source</p>

                            <p class="desc">' . $source . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Destination</p>

                            <p class="desc">' . $dest . '</p>

                        </div>

                    </div>

                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Code Type</p>

                            <p class="desc">' . $codeType . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Code</p>

                            <p class="desc">' . $code . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Amount</p>

                            <p class="desc">' . $symbol . $amount . $currency . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Recipient</p>

                            <p class="desc">' . $recipient . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Bank</p>

                            <p class="desc">' . $bank . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Reference Number</p>

                            <p class="desc" variant="special">' . $ref . '</p>

                        </div>

                    </div>';

                } else if ($scope == 'DEPOSIT') {

                    $body = '<div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Amount</p>

                            <p class="desc">' . $symbol . $amount . $currency . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Destination</p>

                            <p class="desc">' . $source . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Recipient</p>

                            <p class="desc">' . join(' ', [$userData['firstname'], $userData['lastname']]) . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Reference Number</p>

                            <p class="desc" variant="special">' . $ref . '</p>

                        </div>

                    </div>';

                } else {

                    $body = '<div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Amount</p>

                            <p class="desc">' . $symbol . $amount . $currency . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Destination</p>

                            <p class="desc">' . $source . '</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Recipient</p>

                            <p class="desc">' . join(' ', [$userData['firstname'], $userData['lastname']]) . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Reference Number</p>

                            <p class="desc" variant="special">' . $ref . '</p>

                        </div>

                    </div>';

                }

            }

        }

        mysqli_free_result($result); // Free Result
        
        mysqli_stmt_close($details); // Close Statement

        // Check Flag

        if ($detailsFound) {

            $response[] = '<div class="receipt">

                <div class="receipt_header">

                    <div class="logo">

                        <img src="' . SITE_LOGO . '" alt="' . SITE_NAME . '">

                    </div>

                    <p class="title">Transaction Summary</p>

                    <p class="title">Status: ' . $status . '</p>

                </div>

                <div class="receipt_main">

                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">Date/Time</p>

                            <p class="desc">' . $date . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Scope / Type</p>

                            <p class="desc">' . $scope . ' (' . $type . ')</p>

                        </div>

                    </div>
                    
                    <div class="receipt_box">

                        <div class="receipt_item">

                            <p class="title">' . $descriptor . '</p>

                            <p class="desc">' . join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) . '</p>

                        </div>

                        <div class="receipt_item">

                            <p class="title">Description</p>

                            <p class="desc">' . $desc . '</p>

                        </div>

                    </div>'. $body .'

                </div>

                <div class="receipt_footer">

                    <p>Did you know that you can manage your payments online? Make an extra payment, pay off your loan, or change your due date right from your account. Simply log in to your account or contact us for additional support.</p>

                </div>

            </div>';

            echo json_encode(['status' => true, 'html' => implode('', $response)]); // Encode JSON Response

        } else {

            echo json_encode(['status' => false, 'html' => '<i>An error occurred!</i>']); // Encode JSON Response

        }

        exit; // End Run

    }

?>