<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['inv-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $invoiceData = invoiceData($id, $conn); // Fetch Invoice Data

        if (!$invoiceData) {

            echo json_encode(['invoiceError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $sent = false; // Flag

        $currency = $invoiceData['currency'];

        $payable = $invoiceData['total'];

        $subject = 'Invoice Notification | Payment Due #' . $invoiceData['invoice-number'];

        $created = date('l, M d Y', strtotime($invoiceData['created']));

        $dueDate = date('l, M d Y', strtotime($invoiceData['due']));

        $link = SITE_BASE_URL . '/invoice/?accessKey=' . urlencode(encrypt($id));

        $total = $currSymbol[$currency] . number_format($payable, 2) . ' ' . $currency;

        $mail = invoiceMail($invoiceData['customer'], $total, $invoiceData['invoice-number'], $created, $dueDate, $invoiceData['user'], $invoiceData['user-email'], $link);

        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $invoiceData['customer-email'], $invoiceData['customer']);

        if (!$deliver) {

            $deliver = @deliverByPHPMail($invoiceData['customer-email'], $subject, $mail); // Fallback

        }

        echo json_encode(['sent' => $deliver]); // Encode JSON Response

    

    }

?>