<?php

    session_name('USERSESSID');

session_start(); // Initiatwe Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $account = filter_var($_REQUEST['loan-curr'], FILTER_SANITIZE_SPECIAL_CHARS);

        $income = filter_var($_REQUEST['user-income'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        $user_id = $_SESSION['USER-ID'];

        $userData = userData($user_id, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        // Check KYC

        if ($userData['kyc-status'] == 'PROCESSING') {

            echo json_encode(['kycPending' => true]);

            exit;

        }
        
        if ($userData['kyc-status'] != 'VERIFIED') {

            echo json_encode(['kycError' => true]);

            exit;

        }

        $accData = accountData($account, $user_id, $conn); // Get Account Data

        if (!$accData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        $creditScore = $userData['credit-score']; // Get Credit Score

        if ($creditScore < 0) {

            // echo json_encode(['noLoan' => true]);

            $response[] = '<div class="flx col">

                <img src="' . SITE_BASE_URL . '/assets/images/fly-dollar.svg" alt="" style="width: 5em;">

                <h3>Sorry, no loans available!</h3>

                <p class="txt_center">Sorry, you aren\'t eligible for loans, at the moment!</p>

            </div>';

            echo json_encode(['eligiblity' => true, 'html' => implode('', $response)]);

        } else {

            $maxLoan = loanEligibility($creditScore, $income); // Get Max Loan

            $rate = loanRate($creditScore); // Get Loan Rate

            $currency = $accData['currency'];

            $symbol = $currSymbol[$currency];

            // Get Unpaid Loans

            $owed = 0; // Flag

            $stmt = mysqli_prepare($conn, "SELECT SUM(`repay`) AS `total_owed` FROM `loans` WHERE `user_id` = ?");

            mysqli_stmt_bind_param($stmt, "s", $user_id);

            mysqli_stmt_execute($stmt);

            $result = mysqli_stmt_get_result($stmt);

            if (mysqli_num_rows($result) > 0) {

                $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                foreach ($data as $row):
                
                    $owed = $row['total_owed'];

                endforeach;

            }

            mysqli_free_result($result);

            mysqli_stmt_close($stmt);

            $maxLoan = $maxLoan - $owed;

            if ($maxLoan > 0) {
            
                $response[] = '<div>

                    <p class="form_info">You\'re eligible for loan of up to ' . $symbol . number_format($maxLoan, 2) . ' (' . $currency . ') at a rate of ' . $rate . '%</p>

                    <div class="form_item">

                        <input type="hidden" id="loan-rate" value="' . $rate . '">

                        <label for="loan-amount">Loan: ' . $symbol . '<span class="iQ_rangeValue"> </span></label>

                        <input id="loan-amount" class="form_field iQ_range" type="range" min="0" max="' . $maxLoan . '" value="0">

                    </div>

                    <div class="form_item">

                        <button class="form_btn" id="getLoan">Proceed &rarr;</button>

                    </div>

                </div>';

            } else {

                $response[] = '<div class="flx col">

                    <img src="' . SITE_BASE_URL . '/assets/media/icons/fly-dollar.svg" alt="" style="width: 5em;">

                    <h3>Sorry, no loans available!</h3>

                    <p class="txt_center">Sorry, you aren\'t eligible for loans, at the moment!</p>

                </div>';

            } 

            echo json_encode(['eligiblity' => true, 'html' => implode('', $response)]);

        }

    }

?>