<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $loanId = filter_var($_REQUEST['loan-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Locate Loan

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `loans` WHERE `loan_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $loanId); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $currency = $row['currency'];

                $type = $row['type'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

        // Get Repayment Schedule

        $valid = false; // Flag

        if ($found) {

            $stmt = mysqli_prepare($conn, "SELECT SUM(CASE WHEN `status` = ? AND `due` = ? THEN `amount` ELSE 0 END) AS `current`, SUM(CASE WHEN `status` = ? AND `due` < ? THEN `amount` ELSE 0 END) AS `owed` FROM `repayments_schedule` WHERE `loan_id` = ?"); // Prepare Statement (Get Due Payments [Missed & Current])

            $date = date('Y-m-d', time());

            $status = 'PENDING';

            mysqli_stmt_bind_param($stmt, "sssss", $status, $date, $status, $date, $loanId);

            mysqli_stmt_execute($stmt);

            $result = mysqli_stmt_get_result($stmt);

            if (mysqli_num_rows($result) > 0) {

                $valid = true; // Update Flag

                while ($row = mysqli_fetch_assoc($result)) {

                    $current = $row['current'];

                    $missed = $row['owed'];

                }

                $pay = $current + $missed;

                $pay = round($pay, 2); // Amount to be paid
                
                if ($pay <= 0) {

                    $valid = false; // Update Flag

                } else {

                    // Prepare Payment (Assign Sessions)

                    $_SESSION['PAY'] = $type . ' (LOAN)';

                    $_SESSION['PAY-AMOUNT'] = $pay;

                    $_SESSION['PAY-DESC'] = $loanId;

                    $_SESSION['SUBJECT-CURR'] = $currency;

                }

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

        }

        $checks = ($found && $valid) ? true : false;

        echo json_encode(['proceed' => $checks]); // Encode JSON Response

    }

?>