<?php

    session_name('USERSESSID');

    session_start(); // Initiate Sessions 

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $amount = filter_var($_REQUEST['loan'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $type = filter_var($_REQUEST['loan-purpose'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accId = filter_var($_REQUEST['loan-curr'], FILTER_SANITIZE_SPECIAL_CHARS);

        $job = filter_var($_REQUEST['user-job'], FILTER_SANITIZE_SPECIAL_CHARS);

        $income = filter_var($_REQUEST['user-income'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $term = filter_var($_REQUEST['loan-term'], FILTER_SANITIZE_SPECIAL_CHARS);

        $frequency = filter_var($_REQUEST['loan-freq'], FILTER_SANITIZE_SPECIAL_CHARS);

        $rate = filter_var($_REQUEST['rate'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        $user_id = $_SESSION['USER-ID'];

        $userData = userData($user_id, $conn); // Get User Data

        $accData = accountData($accId, $user_id, $conn); // Get Account Data

        if (!$accData || !$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        $balance = $accData['balance'];

        $currency = $accData['currency'];

        $accNum = $accData['acc-number'];

        // Check Approval Preference

        if (LOAN_PREF == 'MANUAL') {

            $id = generateUniqueID($conn, 'loan_requests', 'LRQ'); // Generate ID

            $recorded = false; // Flag

            // Insert Request

            $stmt = mysqli_prepare($conn, "INSERT INTO `loan_requests` (`req_id`, `user_id`, `amount`, `currency`, `account`, `rate`, `term`, `reason`, `employment`, `income`, `frequency`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement 

            mysqli_stmt_bind_param($stmt, "ssdssssssss", $id, $user_id, $amount, $currency, $accId, $rate, $term, $type, $job, $income, $frequency); // Prepare Statement

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $recorded = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            if ($recorded) {

                // Create Notification & Message

                $dateTime = timeGMT('l, M d Y, (H:i) [T]'); // GMT Time

                $symbol = $currSymbol[$currency];

                $notf = 'Your request for ' . $currency . ' loan of ' . $symbol . number_format($amount, 2) . 'for ' . $term . ' days (' . $term / 30 . ' Months) on ' . $dateTime . ' is under review.';

                createNotification($conn, $user_id, 'Loan Request Notification', $notf);
                

            }
            
            echo json_encode(['request' => $recorded]); // Enconde JSON Response

        } else {

            $id = generateUniqueID($conn, 'loans', 'LN'); // Generate ID

            $granted = false; // Flag

            // Create Loan

            $stmt = mysqli_prepare($conn, "INSERT INTO `loans` (`loan_id`, `user_id`, `amount`, `repay`, `currency`, `acc_id`, `type`,  `interest`, `frequency`, `term`, `due`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (Record Loan)

            $due = ($term * 24 * 60 * 60); // Convert to Seconds

            $due = time() + $due;

            $dueDate = date('Y-m-d', $due); // Format Date

            $repay = ($amount * ($rate / 100) * ($term / 365)) + $amount;  // Simple interest

            mysqli_stmt_bind_param($stmt, "ssddsssssss", $id, $user_id, $amount, $repay, $currency, $accId, $type, $rate, $frequency, $term, $dueDate); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` + ? WHERE `acc_id` = ? AND `user_id` = ?"); // Update Account Balance

            mysqli_stmt_bind_param($stmt2, "dss", $amount, $accId, $user_id); //Bind Parameter(s)

            $stmt3 = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Create Transaction

            // Param(s)

            $transID = generateUniqueID($conn, 'transactions', 'TRN');

            $transType = 'CREDIT';

            $action = 'LOAN';

            $descr = "LOAN ($currency)";

            $nBal = $balance + $amount;

            $transStatus = 'COMPLETED';

            mysqli_stmt_bind_param($stmt3, "sssssssidds", $user_id, $transID, $transType, $action, $descr, $currency, $accId, $accNum, $nBal, $amount, $transStatus); //

            if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2) && mysqli_stmt_execute($stmt3)) { // Execute Statement

                $repayments = generateRepaymentSchedule($amount, $rate, $term, $frequency); // Generate Repayments

                // Record Repayments Scheldule

                $stmt4 = mysqli_prepare($conn, "INSERT INTO `repayments_schedule` (`loan_id`, `user_id`, `amount`, `due`) VALUES (?, ?, ?, ?)");

                $records = null; // Stores Repayment Records

                foreach ($repayments['paymentDates'] as $index => $dueDate) {

                    // Bind parameters for each repayment
                    mysqli_stmt_bind_param($stmt4, 'ssds', $id, $user_id, $repayments['paymentAmount'], $dueDate);

                    $formattedAmount = $currSymbol[$currency] . number_format($payments['paymentAmount'], 2) . $currency;

                        $formattedDate = date('d/M/Y', strtotime($dueDate));

                        $records .= <<<HTML

                            <tr style="height:33px">

                                <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                    
                                    <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$formattedDate</p>
                                    
                                </td>
                                
                                <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                    
                                    <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$formattedAmount</p>
                                    
                                </td>

                            <tr> 
                        
                        HTML;
                        
                    // Execute the insert for this repayment
                    if (!mysqli_stmt_execute($stmt4)) {
                        // Handle error if any repayment insertion fails
                        error_log("Error inserting repayment schedule: " . mysqli_stmt_error($stmt4));
                        break;
                    }

                }

                $granted = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            if ($granted) {

                // Create Notifications & Emails

                $symbol = $currSymbol[$currency];

                $notf = 'Your request for ' . $currency . ' loan of ' . $symbol . number_format($amount, 2) . ' has been approved. Note this loan will last for ' . $term . ' days (' . $term / 30 . ' Months) and will be due on ' . date('l M d, Y', $due) . '.';

                createNotification($conn, $user_id, 'Loan Approved', $notf);

                $subject = 'Loan Granted #' . mt_rand(10000000, 99999999);

                $requested = date('l, M d Y', strtotime($date));

                $mail = loanConfirmation($userData['firstname'], $currency, $symbol . number_format($amount, 2), $type, $requested, $term, $frequency, $records);

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                if (!$deliver) {

                    @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                }

            }
            
            echo json_encode(['granted' => $granted]); // Enconde JSON Response

        }

    }

?>