<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-TYPE']) || !isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $mainUser = $_SESSION['USER-ID']; // Account Owner

        $currentUser = $_SESSION['CURRENT-USER']; // Logged User 

        $userType = $_SESSION['USER-TYPE']; // Get User Type

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $currentUser, $userType); // Set Timezone

        $userData = userData($mainUser, $conn); // Get Main User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Check User's KYC

        if ($userType === 'USER') {

            $kycState = $userData['kyc-status'] ?? 'UNVERIFIED';

            if ($kycState == 'UNVERIFIED' || $kycState == 'REJECTED') {

                echo json_encode(['kycError' => true]); // Encode JSON Response

                exit; // End Run

            } else if ($kycState == 'PROCESSING') {

                echo json_encode(['kycPending' => true]); // Encode JSON Response

                exit; // End Run

            }

        }

        $bcodeCount = bcodeCount($currentUser, $conn); // Get Total Billing Code (Of Current User)

        // Sanitize Fields

        $name = filter_var($_REQUEST['name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $dest = filter_var($_REQUEST['account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bank = filter_var($_REQUEST['bank'], FILTER_SANITIZE_SPECIAL_CHARS);

        $sourceiD = filter_var($_REQUEST['source'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $descr = !empty($_REQUEST['desc']) ? filter_var($_REQUEST['desc'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $save = filter_var($_REQUEST['beneficiary'], FILTER_SANITIZE_SPECIAL_CHARS);

        $save = $save == 'yes' ? true : null;

        $type = 'DEBIT';

        $scope = 'LOCAL TRANSFER';

        $status = (TRANSF_PREF == 'AUTOMATIC') ? 'COMPLETED' : 'PENDING';

        $approval = TRANSF_PREF;

        $source = accountData($sourceiD, $mainUser, $conn); // Locate Source (Main User Account) 

        if (!$source) {

            echo json_encode(['accError' => true]); // Encode JSON Response
            
            exit; // End Run

        }

        // Normalize Account (Source) Data

        $currency = $source['currency'];

        $balance = $source['balance'];

        $accNum = $source['acc-number'];

        $wLimit = $source['wth-limit'];

        $wCount = $source['wth-count'] ?? 0;

        $maxCount = $source['wth-max-count'];
       
        // Perform Checks

        $bcodes = $userData['bcode-status']; // Billing Code Status

        $auth = $userData['auth']; // 2FA Status

        $tPIN = true; // Transaction PIN

        if ($userType == 'THIRD PARTY') { // Third Party User Check

            $auth = 'DISABLED';

            $tPIN = false;

            $thirdParty = thirdPartyData($currentUser, $conn);

            if (!$thirdParty) { // Invalid Third Party User

                echo json_encode(['refresh' => true]); // Encode JSON Response

                exit; // End Run

            }

            $bcodes = $thirdParty['bcode-status']; // Billing Code Status

            // Perform Checkes

            $wLimit = $thirdParty['wth-limit']; // Withdrawal Limit (Currency Amount)

            $tCount = $thirdParty['trans-count']; // Transaction Count

            $tLimit = $thirdParty['trans-limit']; // Transaction Limit

            if ($tCount >= $tLimit) {

                echo json_encode(['maxTransc' => true]); // Encode JSON Response

                exit; // End Run

            }

            if ($amount > $wLimit) {

               echo json_encode(['wthLimit' => true]); // Encode JSON Response

                exit; // End Run 

            }

            $barred = $thirdParty['no-access']; // Accounts Third Party Can't Access

            if (!is_null($barred)) {

                $barredList = array_map('trim', explode(',', $barred)); // Convert to an array

                if (in_array($currency, $barredList)) { // Check Access State

                    echo json_encode(['noAccess' => true, 'currency' => $currency]); // Encode JSON Response

                    exit; // End Run

                }

            }    

        } else {

            if (!is_null($wLimit) && $amount > $wLimit) { // Check Limit Amount

                $limit = $currSymbol[$currency] . number_format($wLimit) . ' (' . $currency . ')';

                echo json_encode(['wLimit' => true]); // Encode JSON Response
        
                exit; // End Run

            } else if (!is_null($maxCount) && $wCount >= $maxCount) {

                echo json_encode(['maxWth' => true]); // Encode JSON Response
        
                exit; // End Run

            }

        }
         
        if ($balance < $amount) {

            echo json_encode(['fundError' => true]); // Encode JSON Response
        
            exit; // End Run

        }

        if ($save) { // Save as Beneficiary

            // Look for Beneficiary

            $new = true; // Flag

            $benefic = mysqli_prepare($conn, "SELECT * FROM `beneficiaries` WHERE `user_id` = ? AND `account` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($benefic, "ss", $mainUser, $dest); // Bind Parameter(s)

            mysqli_stmt_execute($benefic); // Execute Statement

            $result = mysqli_stmt_get_result($benefic); // Get Statement Result

            if (mysqli_num_rows($result) === 1) {

                $new = false; // Update Flag

            }
            
            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($benefic); // Close Statement

            if ($new) {

                $createBeneficiary = mysqli_prepare($conn, "INSERT INTO `beneficiaries` (`user_id`, `name`, `account`, `currency`, `bank`, `type`) VALUES(?, ?, ?, ?, ?, ?)"); // Prepare Statement

                mysqli_stmt_bind_param($createBeneficiary, "ssssss", $mainUser, $name, $dest, $currency, $bank, $scope); // Bind Statement Parameter(s)

                mysqli_stmt_execute($createBeneficiary); // Execute Statement

            }

        }

        $codeTrack = $_SESSION['CODE-TRACK'] ?? 0; // Check if codes have been entered

        // Search For Billing Code

        if ($bcodes == 'ACTIVE' && $bcodeCount > 0 && $codeTrack != $bcodeCount) {

            // Prep for Billing Code

            $_SESSION['B-CODE'] = true;

            $_SESSION['SUBJECT-AMOUNT'] = $amount;

            $_SESSION['TRANSFER-SCOPE'] = $scope;

            $_SESSION['TRANSFER-TYPE'] = $type;

            $_SESSION['TRANSFER-DESCR'] = $descr;

            $_SESSION['TRANSFER-SRC-BAL'] = $balance;

            $_SESSION['SUBJECT-CURR'] = $currency;

            $_SESSION['TRANSFER-SOURCE'] = $accNum;

            $_SESSION['TRANSFER-RECPT'] = $name;

            $_SESSION['TRANSFER-DEST'] = $dest;

            $_SESSION['RECPT-BANK'] = $bank;

            $_SESSION['TRANSFER-SRC-ID'] = $sourceiD;

            $_SESSION['TRANSFER-STATUS'] = $status;

            echo json_encode(['bCode' => true]); // Encode JSON Response
    
            exit; // End Run

        } else {

            if ($userType != 'THIRD PARTY') {

                // Set Neccessary Sessions

                $_SESSION['SUBJECT-AMOUNT'] = $amount;

                $_SESSION['TRANSFER-SCOPE'] = $scope;

                $_SESSION['TRANSFER-TYPE'] = $type;

                $_SESSION['TRANSFER-DESCR'] = $descr;

                $_SESSION['TRANSFER-SRC-BAL'] = $balance;

                $_SESSION['SUBJECT-CURR'] = $currency;

                $_SESSION['TRANSFER-SOURCE'] = $accNum;

                $_SESSION['TRANSFER-RECPT'] = $name;

                $_SESSION['TRANSFER-DEST'] = $dest;

                $_SESSION['RECPT-BANK'] = $bank;

                $_SESSION['TRANSFER-SRC-ID'] = $sourceiD;

                $_SESSION['TRANSFER-STATUS'] = $status;

                if ($auth === 'ENABLED') { // 2FA ENABLED

                    $code = generateOTP($mainUser, $conn); // Generate OTP
                    
                    // Send Email

                    $subject = 'Authenticate Transfer #' . mt_rand(10000000, 99999999);

                    $mail = transferOTP($userData['firstname'], $code);

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                    echo json_encode(['auth' => true]); // Encode JSON Response

                    exit; // End Run

                } else if ($tPIN) { // Transaction PIN

                    echo json_encode(['tPIN' => true]); // Encode JSON Response

                    exit; // End Run

                }

            }    

            $id = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

            $newBal = $balance - $amount;

            // Insert Into Database

            $created = false; // Flag

            $createTrans = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `recpt_acc`, `recpt_name`, `recpt_bank`, `status`, `approval_flag`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

            mysqli_stmt_bind_param($createTrans, "sssssssiddsssss", $currentUser, $id, $type, $scope, $descr, $currency, $sourceiD, $accNum, $amount, $newBal, $dest, $name, $bank, $status, $approval); // Bind Parameters

            if (mysqli_stmt_execute($createTrans)) { // Execute Statement

                $created = true; // Update Flag

                if (TRANSF_PREF === 'AUTOMATIC') {

                    // Update Account Balance

                    $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ?"); // Prepare Statement

                    mysqli_stmt_bind_param($stmt, "ss", $amount, $sourceiD); // Bind Parameter(s)

                    mysqli_stmt_execute($stmt); // Execute Statement

                    mysqli_stmt_close($stmt); // Close Statement
                    
                }

                if ($userType == 'THIRD PARTY') {

                    updateJointUserTransCount($currentUser, $conn); // Update Transc Count

                }

                $_SESSION['TRANSF-ID'] = $id;

                $dateTime = timeGMT('l M d, Y (H:i) [T]');

                $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

                // Handle Notifications & Mail (Notify Initiator / Account Owner / Admin) 

                $notf = 'A transfer of ' . $money . ' was just initiated by ' . join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]) . ' (JOINT USER) through your ' . $currency . ' account on  ' . $dateTime;

                createNotification($conn, $mainUser, 'Transfer Notification', $notf); // Notify Account Owner

                $notfB = 'You just initiated a transfer of ' . $money . '  through ' . join(' ', [$userData['firstname'], $userData['lastname']]) . '\'s ' . $currency . ' account on  ' . $dateTime;

                createNotification($conn, $currentUser, 'Transfer Notification', $notfB); // Notify Initiator

                $subjectAdmin = 'New Transfer Alert #' . mt_rand(10000000, 99999999);

                $subject = 'Transfer/Withdrawal Notification #' . mt_rand(10000000, 99999999);

                // Notify Admin
                
                $adminMail = adminTransferNotification(join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]), $dateTime, $scope, $money, $bank, $dest, $name); // Admin Message

                $mail = transferNotification($thirdParty['firstname'], $money, $dateTime, $currency, $dest . '(' . $name . ')'); // Initiator Message

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $thirdParty['email'], join('', [$thirdParty['firstname'], $thirdParty['lastname']]));

                if (!$deliver) {

                    @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                }

                $deliverAdmin = @deliverByPHPMailer($subjectAdmin, $adminMail, makePlain($adminMail), ADMIN_MAIL, ADMIN_NAME);

                if (!$deliverAdmin) {

                    @deliverByPHPMail(ADMIN_MAIL, $subjectAdmin, $adminMail); // Fallback

                }

            }

            mysqli_stmt_close($createTrans); // Close Statement

            echo json_encode(['transfer' => $created]); // Encode JSON Response

            exit; // End Run

        }

        
    }

?>