<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // HTTP Content Type

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $digit1 = filter_var($_POST['digit_1'], FILTER_SANITIZE_SPECIAL_CHARS);
    
        $digit2 = filter_var($_POST['digit_2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit3 = filter_var($_POST['digit_3'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit4 = filter_var($_POST['digit_4'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit5 = filter_var($_POST['digit_5'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit6 = filter_var($_POST['digit_6'], FILTER_SANITIZE_SPECIAL_CHARS);

        $input = join('', [$digit1, $digit2, $digit3, $digit4, $digit5, $digit6]); // Concatnate Fields

        $browser = !empty($_REQUEST['browser']) ? filter_var($_REQUEST['browser'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $browserVersion = !empty($_REQUEST['browser-version']) ? filter_var($_REQUEST['browser-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $os = !empty($_REQUEST['os']) ? filter_var($_REQUEST['os'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $osVersion = !empty($_REQUEST['os-version']) ? filter_var($_REQUEST['os-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $device = !empty($_REQUEST['device']) ? filter_var(ucwords($_REQUEST['device']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        if (!isset($_SESSION['MFA']) || !isset($_SESSION['MFA-TYPE'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['MFA']; // Recall Session

        $userType = (isset($_SESSION['USER-TYPE'])) ? $_SESSION['USER-TYPE'] : 'USER';

        if ($userType == 'USER') {

            $userData = userData($user, $conn); // Locate User

        } else {

            $userData = thirdPartyData($user, $conn); // Locate Third Party User

        }
        
        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Normalize User Data

        $code = $userData['code'];

        $expires = $userData['code-expires'];

        // Validate Input

        if ((int)$input !== (int)$code) {

            echo json_encode(['codeInvalid' => true]); // Encode JSON Response

            exit; // Terminate Run

        }

        if (date('Y-m-d H:i:s', time()) >= $expires) {

            echo json_encode(['codeExpired' => true]); // Encode JSON Response

            exit; // Terminate Run

        }

        $pwrdReset = false; // Pwrd Reset Flag

        if ($_SESSION['MFA-TYPE'] == 'LOGIN') {

            $ip = getIP(); //'172.177.213.10';//'154.113.118.142'; //getIP(); // Get User's IP

            $ipData = @retrieveIPData($ip); // Get User's IP

            @date_default_timezone_set($ipData['timezone']); // Set Time Zone

            $token = randomString(30) . @join('/', [$device, $ipData['city'], $ipData['region'], $ipData['country'], $ipData['latitude'], $ipData['latitude']]);

            $token = encrypt($token); // Encrypt Token

            @activityLog($conn, $user, $device, $browser, $browserVersion, $os, $osVersion, $token, $ip, $ipData['timezone'], $ipData['city'], $ipData['region'], $ipData['country'], $ipData['country-code'], $ipData['latitude'], $ipData['longitude']); // Create User Log

            $encryptID = encrypt($user); // Encrypt Current User

            setcookie('USER-iD', $encryptID, time() + (86400 * 30), '/'); // Set Cookie (Validity: 30days)

            setcookie('ACCESS-iD', $token, time() + 86400, '/'); // Set Cookie (Validity: 1day, 24Hrs)

            $dateTime = timeGMT('l, M d Y, (H:i) [T]'); // GMT Time

            $msg = join(' ', [$userData['firstname'], $userData['lastname']]) . ' your account and dashboard was just accessed with your login credentials on ' . $dateTime .  '.';

            createNotification($conn, $user, 'Login Detected', $msg); // Notify Main User

            // Grant Dashboard Access

            $_SESSION['ACCESS'] = true;

            $_SESSION['USER-ID'] = $user;

            $_SESSION['USER-TYPE'] = 'USER';

            $_SESSION['CURRENT-USER'] = $user;

            if ($userData['login-alerts'] === 'ENABLED') {

                $dateTime = timeGMT('l, M d Y, (H:i) [T]'); // GMT Time

                $subject = 'Login Detected #' . mt_rand(10000000, 99999999);

                $city = $ipData['city'];

                $region = $ipData['region'];

                $country = $ipData['country'];

                $logs = [

                    'ip-address' => $ipData['ip'],

                    'device' => $device,

                    'location' => implode(', ', array_filter([$city, $region, $country], fn($part) => !is_null($part) && $part !== '')),

                    'browser' => $browser,

                ];

                $mail = loginAlert($userData['firstname'], $dateTime, $logs);

                $plain = makePlain($mail);

                $recipient = $userData['email'];

                $recipientName = join(' ', [$userData['firstname'], $userData['lastname']]);

                $_SESSION ['MAIL'] = $mail;

                $_SESSION['SUBJECT'] = $subject;

                $_SESSION['RECIPIENT'] = $recipientName;

                $_SESSION['MAIL-DEST'] = $recipient;

                // $deliver = @deliverByPHPMailer($subject, $mail, $plain, $recipient, $recipientName);

                // if (!$deliver) {

                //     @deliverByPHPMail($recipient, $subject, $mail); // Fallback

                // }

            }

        } else if ($_SESSION['MFA-TYPE'] == 'PWRD RESET') {

            $pwrdReset = true; // Update Flag

            $_SESSION['PWRD-RESET'] = $user;

            $_SESSION['USER-TYPE'] = $userType;

        }

        // Destroy Sessions

        unset($_SESSION['MFA']);

        unset($_SESSION['MFA-TYPE']);
        
        echo json_encode(['codeValid' => true, 'pwrdReset' => $pwrdReset]); // Encode JSON Response

    }

?>