<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definitions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID']) || !isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-TYPE'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['account-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn);

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $userType = $_SESSION['USER-TYPE'];

        $inactive = null;

        $label = null;

        if ($userType == 'THIRD PARTY') {

            $thirdParty = thirdPartyData($_SESSION['CURRENT-USER'], $conn);

            if (!$thirdParty) {

                echo json_encode(['refresh' => true]); // Encode JSON Response

                exit; // End Run

            }

            $userStatus = $thirdParty['account-status'];            

        } else {

            $userStatus = $userData['account-status'];

        }

        if ($userStatus == 'INACTIVE') {

            $inactive = 'no-access';

            $label = '<sup class="label pos-abs" style="margin: 0.3em 0; right: 0.7em; bottom: 0.5em; font-size: 0.525rem;">INACTIVE</sup>';

        }

        $accountData = accountData($id, $user, $conn); // Fetch Account Data

        if (!$accountData) {

            echo json_encode(['accError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Account Info

        $currency = $accountData['currency'];

        $currencyName = ucwords($currCodeNames[$currency]);

        $countryCode = $currCountryCodes[$currency];

        $balance = number_format($accountData['balance'], 2);

        $symbol = $currSymbol[$currency];

        $flag = 'https://flagcdn.com/' . strtolower($countryCode) . '.svg';

        $class = $accountData['class'];

        $icon = null;

        if ($class == 'PRIMARY') {

            $icon = '<div class="icon" style="min-width: 1.5rem; color: var(--OmenXBlue);">

                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M4 6.5 6 8l3-3 3 3 2-1.5V10H4V6.5ZM14 13v-2H4v2h10Z" fill="currentColor"></path></svg>

            </div>';

        }

        $content = <<<HTML
        
            <div iQ-target="#iQ_accDetails" class="pos-abs $inactive" style="right: 1em; top: 1em; width: 1.2em">

                <input type="hidden" value="$id">

                <svg viewBox="0 0 13 13" aria-hidden="true"><path fill="currentColor" d="M6.5.5c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6m0 1c2.757 0 5 2.243 5 5s-2.243 5-5 5-5-2.243-5-5 2.243-5 5-5"></path> <path fill="currentColor" d="M7.75 3.8501c0 .2-.05.35-.2.5-.15.15-.3.2-.5.2s-.35-.05-.5-.2c-.15-.15-.2-.3-.2-.5s.05-.35.2-.5c.15-.15.3-.2.5-.2s.35.05.5.2c.1.15.2.3.2.5M7 7.5001h.45c-.4 1.45-.9 1.85-1.55 1.85-.25 0-.5-.05-.6-.15-.1-.1-.2-.3-.2-.5 0-.15.05-.35.15-.7l.55-1.5c.05-.1.05-.2-.3-.25v-.1c.35-.05.3 0 .25 0-.15 0-.35.2-.55.35h-.45c.4-.6.9-1.05 1.6-1.05.25 0 .45.05.55.2.1.15.2.3.2.5 0 .15-.05.4-.2.75l-.5 1.4c-.05.2-.1.3-.1.35 0 .05 0 .05.05.05s.05.05.1.05c.1 0 .15-.05.3-.2.15-.15.2-.25.25-1.05"></path></svg>

            </div> 

            $label

            <div class="acc-info">

                <img class="flag-icon" src="$flag" alt="">

                <div class="text-box">

                    $icon

                    <p class="text-min">$currencyName</p>

                    <p class="balance" id="sensiq">$symbol$balance ($currency)</p>

                </div>

            </div>

        HTML; // HTML Content

        echo json_encode(['accData' => $content]); // Encode JSON Response

    }

?>