<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['notf-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($action == 'READ') { // Mark As Read

            $read = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `notifications` SET `status` = ? WHERE `notf_id` = ?"); // Prepare Statement

            // Parameter(s)

            $param = 'READ';

            mysqli_stmt_bind_param($stmt, "ss", $param, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $read = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['updated' => $read]); // Encode JSON Response

        } else if ($action == 'DELETE') {

            $deleted = false; // Flag

            // Commence Deletion

            $stmt = mysqli_prepare($conn, "DELETE FROM `notifications` WHERE `notf_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $deleted = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response


        } 

    }

?>