<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package(s) File 

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    // Payment Proof Form Processor

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID']) || !isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-TYPE']) || !isset($_SESSION['PAY'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $currentUser = $_SESSION['CURRENT-USER'];

        $userType = $_SESSION['USER-TYPE'];

        $mainUser = $_SESSION['USER-ID'];

        $userData = userData($currentUser, $conn); // Get User Data

        if ($userType == 'THIRD PARTY') {

            $userData = thirdPartyData($currentUser, $conn); // Get User Data

        } 

        if (!$userData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        if (isset($_FILES['proof']) && $_FILES['proof']['error'] === 0) {

            $proof = $_FILES['proof']; // Uploaded File

            // Directory To Store File

            $directory = '../../vault/proof-payments/';

            $uploadProof = fileUpload($proof, $directory, 'payment-', null, true, false, true); // Upload File

            if ($uploadProof['status']) {

                $proof = $uploadProof['vault']; 

            } else {

                if ($uploadProof['error'] == 'Extension Error') {

                    echo json_encode(['extensionError' => true]);

                } else if ($uploadProof['error'] == 'MIME Error') {

                    echo json_encode(['mimeError' => true]);

                } else {

                    echo json_encode(['uploadError' => true]);

                }
                
                exit();

            }

            // Recall Sessions

            $payItem = $_SESSION['PAY'];

            $amount = $_SESSION['PAY-AMOUNT'];

            $itemDesc = $_SESSION['PAY-DESC'] ?? null;

            // $equiv = $_SESSION['SUBJECT-AMOUNT'];

            $currency = $_SESSION['SUBJECT-CURR'];
            
            $equiv = null;

            if ($currency != 'USD') { // Convert To USD

                $equiv = convertToUSD($amount, $currency);

            } 

            $payAsset = null;

            $assetEquiv = isset($_SESSION['ASSET-EQUIV']) ? $_SESSION['ASSET-EQUIV'] : null;

            if ($assetEquiv !== null) {

                $assetEquiv = round((float) $assetEquiv, 8);

            }

            // Fetch Resource Data

            $resourceId = $_SESSION['RESOURCE-ID'];

            $resourceData = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `id` = ?");

            mysqli_stmt_bind_param($resourceData, "s", $resourceId);

            mysqli_stmt_execute($resourceData);

            $rDataResults = mysqli_stmt_get_result($resourceData);

            if (mysqli_num_rows($rDataResults) === 1) {

                while ($getResourceData = mysqli_fetch_assoc($rDataResults)) {

                    $resourceVendor = $getResourceData['vendor_name'];

                    $resourceAttr = $getResourceData['resource_attr'];

                    if ($resourceAttr === null) {

                        $resourceAttr = $getResourceData['resource_qrcode'];

                    }

                    $resourceType = $getResourceData['type'];

                    if ($resourceType === 'BANK') {

                        $payChannel = 'BANK TRANSFER';

                        $resourceVendor = $getResourceData['bank_name'];

                    } else if ($resourceType === 'CRYPTO') {

                        $payChannel = 'CRYPTO';

                        $payAsset = $getResourceData['resource_symbol'];

                        if ($getResourceData['network_type'] != null) {

                            $payAsset = $payAsset . '[' . $getResourceData['network_type'] . ']';

                        }

                    } else {

                        $payChannel = $resourceType;

                    }

                }

            }

            // Free Result & Close Statement

            mysqli_free_result($rDataResults);

            mysqli_stmt_close($resourceData);

            $datetime = timeGMT(); // Get Current Datetime

            // $type = 'INVESTMENT';

            $type = $payItem; 
            
            if (str_contains($payItem, '(BC)')) {

                $type = 'SERVICE FEE';

            } else if (str_contains($payItem, 'Account (DEPOSIT)')) {

                $type = 'DEPOSIT';

            } else if (str_contains($payItem, '(INVESTMENT)')) {

                $type = 'INVESTMENT';

            }

            $transID = null;

            $datetime = timeGMT('l, M d Y, (H:i) [T]');

            // Intiate Data Drop

            $drop = false; // Data Drop Flag

            // Separate Deposits / Pour Data Into Database

            if ($type == 'DEPOSIT') {

                // Generate IDs

                $transID = generateUniqueID($conn, 'transactions', 'TRN');

                $depID = generateUniqueID($conn, 'deposits', 'DEP');

                // Get Account Details

                $itemDesc = explode('/', $itemDesc);

                $accNum = trim($itemDesc[1]);

                $accId = trim($itemDesc[0]);
                
                // Record Deposit

                $recordDeposit = mysqli_prepare($conn, "INSERT INTO `deposits` (`dep_id`, `user_id`, `amount`, `currency`, `account`, `acc_id`, `related_transc`, `dep_channel`, `dep_asset`, `identifier`, `vendor`, `channel_attr`, `dep_proof`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                mysqli_stmt_bind_param($recordDeposit, 'ssdsissssssss', $depID, $currentUser, $amount, $currency, $accNum, $accId, $transID, $payChannel, $payAsset, $resourceId, $resourceVendor, $resourceAttr, $proof); // Bind Parameter(s)

                // Create Transaction For Deposits

                $createTrans = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `amount`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                // Parameter(s)

                $descr = "$type ($currency)";

                $action = 'CREDIT';

                mysqli_stmt_bind_param($createTrans, "sssssssid", $currentUser, $transID, $action, $type, $descr, $currency, $accId, $accNum, $amount); // Bind Parameters

                if (mysqli_stmt_execute($createTrans) && mysqli_stmt_execute($recordDeposit)) { // Execute Statement

                    $drop = true;

                    $_SESSION['TRANSF-ID'] = $transID;
    
                }

                // Close Statements

                mysqli_stmt_close($recordDeposit);

                mysqli_stmt_close($createTrans);

                // Email Messages

                $mail = payGateway($datetime, $payItem, $currency . '(DEPOSIT)', 'PROCESSING (Awaiting Verification)', $currSymbol[$currency] . number_format($amount, 2) . $currency, $depID);

                $adminMsg = adminDepositNotification(join(' ', [$userData['firstname'], $userData['lastname']]),  $currSymbol[$currency] . number_format($amount, 2) . $currency, $currency . '(DEPOSIT)', $resourceType, $datetime, $depID);

               
            } else {

                // $type = 'SUBSCRIPTION';

                // if (str_contains($payItem, '(BC)')) {

                //     $type = 'SERVICE FEE';

                // }

                $payID = generateUniqueID($conn, 'payments', 'PAY'); // Generate ID
                
                // Record Payment

                $recordPayment = mysqli_prepare($conn, "INSERT INTO `payments` (`pay_id`, `user_id`, `amount`, `currency`, `equiv_USD`, `item`, `item_desc`, `related_transc`, `pay_channel`, `pay_asset`, `identifier`, `vendor`, `channel_attr`, `pay_proof`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                mysqli_stmt_bind_param($recordPayment, 'ssdsdsssssssss', $payID, $currentUser, $amount, $currency, $equiv, $payItem, $itemDesc, $transID, $payChannel, $payAsset, $resourceId, $resourceVendor, $resourceAttr, $proof); // Bind Parameter(s)

                if (mysqli_stmt_execute($recordPayment)) {

                    $drop = true;
    
                }

                // Close Statement

                mysqli_stmt_close($recordPayment);

                $mail = payGateway($datetime, $type, $payItem, 'PROCESSING (Awaiting Verification)', $currSymbol[$currency] . number_format($amount, 2) . $currency, $payID);

                $adminMsg = adminPaymentNotification(join(' ', [$userData['firstname'], $userData['lastname']]), $currSymbol[$currency] . number_format($amount, 2) . $currency, $itemDesc . '/' .  $payItem, $resourceType, $datetime, $payID);
               
            }

            // Check Flag

            if ($drop) {

                // Send Emails

                $subjectAdmin = (($type == 'DEPOSIT') ? 'Deposit ' : 'Payment ') . 'Notification #' . mt_rand(10000000, 99999999);

                $deliverAdmin = @deliverByPHPMailer($subjectAdmin, $adminMsg, makePlain($adminMsg), ADMIN_MAIL, ADMIN_NAME);

                if (!$deliverAdmin) {

                    @deliverByPHPMail(ADMIN_MAIL, $subjectAdmin, $adminMsg); // Fallback

                }

                // Initiator Mail

                $subject = (($type == 'DEPOSIT') ? 'Deposit ' : 'Payment ') . 'Confirmation #' . mt_rand(10000000, 99999999);

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                if (!$deliver) {

                    @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                }

            }

            if (!$transID && $drop) {

                $_SESSION['FEEDBACK'] = true;

                $_SESSION['PAY-GO'] = true;


            } else {

                $sessions = [

                    'PAY',
                    'PAY-AMOUNT',
                    'PAY-DESC',
                    'SUBJECT-CURR',
                    'SUBJECT-AMOUNT',
                    'ASSET-EQUIV',
                    'RESOURCE-ID',
                    'PAYMENT-EXPIRES'

                ];

                foreach ($sessions as $session) {

                    if (isset($_SESSION[$session])) {

                        unset($_SESSION[$session]);

                    }

                }

            }

            echo json_encode(['insertProof' => $drop, 'id' => $transID]); // Encode JSON Response
           
        }

    }

?>

