<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Process Request

        $user = filter_var($_SESSION['REG-ID'], FILTER_SANITIZE_EMAIL); // Get Email Address
        
        $userFound = false; // Account Location Flag

        $userData = userData($user, $conn);// Locate Account

        if (!$userData) {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit(); // End Run

        }

        $code = generateOTP($user, $conn); // Generate OTP

        $delivered = true; // Mail Delivery Flag

        $msg = reOTP($userData['firstname'], $code); // Msg

        $deliver = @deliverByPHPMailer('Verification Code Request #' . mt_rand(10000000, 99999999), $msg, makePlain($msg), join('
        ', [$userData['firstname'], $userData['lastname']]), $name);

        if (!$deliver) {

            $deliver = @deliverByPHPMail($userData['email'], 'Verification Code Request #' . mt_rand(10000000, 99999999), $msg); // Fallback

        }

        $delivered = $deliver;

        echo json_encode(['codeDelivered' => $delivered]); // Encode JSON Response

    }

?>