<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Functions

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // HTTP Content Type

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $digit1 = filter_var($_POST['digit_1'], FILTER_SANITIZE_SPECIAL_CHARS);
    
        $digit2 = filter_var($_POST['digit_2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit3 = filter_var($_POST['digit_3'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit4 = filter_var($_POST['digit_4'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit5 = filter_var($_POST['digit_5'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit6 = filter_var($_POST['digit_6'], FILTER_SANITIZE_SPECIAL_CHARS);

        $input = $digit1 . $digit2 . $digit3 . $digit4 . $digit5 . $digit6; // Concatnate Fields

        $browser = !empty($_REQUEST['browser']) ? filter_var($_REQUEST['browser'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $browserVersion = !empty($_REQUEST['browser-version']) ? filter_var($_REQUEST['browser-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $os = !empty($_REQUEST['os']) ? filter_var($_REQUEST['os'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $osVersion = !empty($_REQUEST['os-version']) ? filter_var($_REQUEST['os-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $device = !empty($_REQUEST['device']) ? filter_var(ucwords($_REQUEST['device']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $user = $_SESSION['REG-ID']; // Recall Session

        $accountFound = false; // Account Detection Flag

        $userData = userData($user, $conn); // Locate User's Account

        if (!$userData) {

            $_SESSION = [];

            session_destroy(); // Kill Sessions

            echo json_encode(['invalidUser' => true]); // Encode JSON Response

            exit(); // Terminate Run

        } 

        $code = $userData['code'];

        $expires = $userData['code-expires'];

        // Validate Input

        if ((int)$input !== (int)$code) {

            echo json_encode(['codeInvalid' => true]); // Encode JSON Response

            exit(); // Terminate Run

        }

        if (date('Y-m-d H:i:s', time()) >= $expires) { // Check Validity

            echo json_encode(['codeExpired' => true]); // Encode JSON Response

            exit(); // Terminate Run

        }

        // Check Registration Preference

        $cleared = true; // Flag

        $subject = 'Welcome Aboard ' . SITE_NAME; // Mail Subject

        $mail = welcomeAboard($userData['firstname']); // Default Mail

        if (REG_PREF == 'MANUAL') {

            $subject = 'Registration Application Under Review!'; // Mail Subject

            $mail = regUncleared($userData['firstname']);

            $cleared = false; // Update Flag

            $stmt = mysqli_prepare($conn, "UPDATE `users` SET `reg_clearance` = ? WHERE `user_id` = ?"); // Prepare Staement

            $param = 'PENDING'; // Parameter

            mysqli_stmt_bind_param($stmt, "ss", $param, $user); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $details = join(' ', [$userData['firstname'], $userData['lastname']]) . '(' . $userData['email'] . ')';

            $dateTime = timeGMT('l, M d Y, (H:i) [T]');

            $mailAdmin = newUserNotification($details, $dateTime); // Message Admin

        }

        unset($_SESSION['REG-ID']);

        if ($cleared) {

            // Collect Device & IP Info

            $ip = getIP(); //'172.177.213.10';//'154.113.118.142'; //getIP(); // Get User's IP

            $ipData = @retrieveIPData($ip); // Get User's IP

            @date_default_timezone_set($ipData['timezone']); // Set Time Zone

            $token = randomString(30) . @join('/', [$device, $ipData['city'], $ipData['region'], $ipData['country'], $ipData['latitude'], $ipData['latitude']]);

            $token = encrypt($token); // Encrypt Token

            @activityLog($conn, $user, $device, $browser, $browserVersion, $os, $osVersion, $token, $ip, $ipData['timezone'], $ipData['city'], $ipData['region'], $ipData['country'], $ipData['country-code'], $ipData['latitude'], $ipData['longitude']); // Create User Log

            $encryptID = encrypt($user); // Encrypt Current User

            setcookie('USER-iD', $encryptID, time() + (86400 * 30), '/'); // Set Cookie (Validity: 30days)

            setcookie('ACCESS-iD', $token, time() + 86400, '/'); // Set Cookie (Validity: 1day, 24Hrs)

            // Set Sessions For Dashboard Access (Redirect to Security)

            $_SESSION['NEW-BIRD'] = $userData['firstname'];

            $_SESSION['ACCESS'] = true;

            $_SESSION['USER-ID'] = $user;

            $_SESSION['USER-TYPE'] = 'USER';

            $_SESSION['CURRENT-USER'] = $user;

            // Welcome Aboard Notification

            $msg = 'Welcome to ' . SITE_NAME . ', where innovation meets personalized banking! Enjoy secure, 24/7 access to your accounts through our cutting-edge digital platform, backed by dedicated customer support and tailored financial solutions designed to help you achieve your goals. With fast, convenient transactions and top-notch security, ' . SITE_NAME . ' is here to make your banking experience seamless and stress-free. Welcome aboard the future of banking, we\'re excited to have you on board!';

            createNotification($conn, $user, 'Welcome Abroad to ' . SITE_NAME, $msg);

        }

        // Send Welcome Mail (For Cleared) / Welcome Mail Stating uncleared

        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

        if (!$deliver) {

            @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

        }

        if (isset($mailAdmin)) {

            $subject = 'New User Notification #' . mt_rand(10000000, 99999999);

            $plain = makePlain($mailAdmin);

            $deliverAdmin = @deliverByPHPMailer($subject, $mailAdmin, $plain, ADMIN_MAIL, SITE_NAME . ' Admin');

            if (!$deliverAdmin) {

                deliverByPHPMail($userData['email'], $subject, $mailAdmin);

            }

        }

        echo json_encode(['codeValid' => true, 'cleared' => $cleared]); // Encode JSON Response

        exit(); // End Run

    }

?>