<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $residence = filter_var($_REQUEST['residence'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var(trim($_REQUEST['user_fname']), FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['user_mname']) ? filter_var(trim($_REQUEST['user_mname']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var(trim($_REQUEST['user_lname']), FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['user_email'])), FILTER_SANITIZE_EMAIL);

        $gender = filter_var($_REQUEST['user_gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $phone = filter_var($_REQUEST['phone-number'], FILTER_SANITIZE_SPECIAL_CHARS);

        $password = $_REQUEST['user_key'];

        $key = md5($password); // Encrypt Password

        $question1 = filter_var($_REQUEST['sq1'], FILTER_SANITIZE_SPECIAL_CHARS);

        $answer1 = filter_var(trim($_REQUEST['a_sq1']), FILTER_SANITIZE_SPECIAL_CHARS);

        $question2 = filter_var($_REQUEST['sq2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $answer2 = filter_var(trim($_REQUEST['a_sq2']), FILTER_SANITIZE_SPECIAL_CHARS);

        $tPin = $_REQUEST['t-digit_1'] . $_REQUEST['t-digit_2'] . $_REQUEST['t-digit_3'] . $_REQUEST['t-digit_4'] . $_REQUEST['t-digit_5'] . $_REQUEST['t-digit_6'];

        $tPin = filter_var($tPin, FILTER_SANITIZE_SPECIAL_CHARS);;

        $user = generateUniqueID($conn, 'users', 'USR'); // Generate User ID

        if (!$user) {

            // Send Response

            echo json_encode(['idError' => true]); // Enconde JSON Response

            exit(); // End Run

        }

        $registered = false; // Registration Flag

        // Create User

        $createUser = mysqli_prepare($conn, "INSERT INTO `users` (`user_id`, `fname`, `mname`, `lname`, `email`, `password`, `pre_hash`, `gender`, `resident_country`, `telephone`, `trans_pin`, `question_1`, `answer_1`, `question_2`, `answer_2`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($createUser, "sssssssssssssss", $user, $fname, $mname, $lname, $email, $key, $password, $gender, $residence, $phone, $tPin, $question1, $answer1, $question2, $answer2); // Bind Parameter(s)

        // Execute Statement

        if (mysqli_stmt_execute($createUser)) {

            $registered = true; // Update Flag

        }

        // Close Statements

        mysqli_stmt_close($createUser);

        // mysqli_stmt_close($createAccounts);

        // Check Flag

        if ($registered) {

            // Set Session(s) For Advancement

            $_SESSION['REG-ID'] = $user; // Needed For Identification

            // Update Invite & Record Referral

            if (isset($_SESSION['REF-LINK']) && isset($_SESSION['REFERRER'])) {

                $refCode = $_SESSION['REF-LINK'];

                $referrer = $_SESSION['REFERRER'];

                $status = 'EXPIRED';

                $stmt = mysqli_prepare($conn, "UPDATE `invites` SET `validity` = ? WHERE `ref_code` = ? AND `referrer` = ?"); // Prepare Statement (Update Invite Status)

                mysqli_stmt_bind_param($stmt, "sss", $status, $refCode, $referrer); // Bind Parameter(s)

                mysqli_stmt_execute($stmt); // Execute Statement

                $stmtB = mysqli_prepare($conn, "INSERT INTO `referrals` (`referrer`, `referred`, `ref_code`) VALUES(?, ?, ?)"); // Prepare Statement (Record Referral)

                mysqli_stmt_bind_param($stmtB, "sss", $referrer, $user, $refCode); // Bind Parameter(s)

                mysqli_stmt_execute($stmtB); // Execute Statement

            }

        }

        // Send Response

        echo json_encode(['regStatus' => $registered]); // Enconde JSON Response

        exit(); // End Run

    }

?>