<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Functions Definitions

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $email = filter_var(strtolower(trim($_REQUEST['identifier'])), FILTER_SANITIZE_EMAIL);
        
        // Look For User

        $userFound = false;

        $stmt = mysqli_prepare($conn, "SELECT `fname`, `lname`, `user_id` AS `identifier`, 'USER' AS `user_type` FROM `users` WHERE `email` = CAST(? AS BINARY) UNION SELECT `fname`, `lname`, `tp_id` AS `identifier`, 'THIRD PARTY' AS `user_type` FROM `third_party` WHERE `email` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $email, $email); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $userFound = true;

            while ($row = mysqli_fetch_assoc($result)) {

                $id = $row['identifier'];

                $userType = $row['user_type'];

                $firstname = $row['fname'];

                $lastname = $row['lname'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$userFound) {

            echo json_encode(['userError' => true]);

            exit;

        }

        $recipientName = join(' ', [$firstname, $lastname]);

        $code = generateOTP($id, $conn, $userType); // Generate OTP

        $mail = pwrdResetOTP($firstname, $code); // Mail

        $subject = 'Reset Your Password #' . mt_rand(10000000, 99999999);

        // $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $email, $recipientName);

        // if (!$deliver) {

        //     $deliver = @deliverByPHPMail($email, $subject, $mail); //  Fallback

        // }

        $_SESSION ['MAIL'] = $mail;

        $_SESSION['SUBJECT'] = $subject;

        $_SESSION['RECIPIENT'] = $recipientName;

        $_SESSION['MAIL-DEST'] = $email;

        // Send OTP

        $_SESSION['MFA'] = $id;

        $_SESSION['MFA-TYPE'] = 'PWRD RESET';

        $_SESSION['USER-TYPE'] = $userType;

        echo json_encode(['mfa' => true]); // Encode JSON Response

    }

?>