<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        // Sanitize Field(s)

        $conv = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $msg = filter_var(trim($_REQUEST['msg']), FILTER_SANITIZE_SPECIAL_CHARS);

        // Dump Message

        $date = timeGMT(); // UTC Equivalent Time

        $sent = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `messages` (`ticket_id`, `message_text`, `sender`, `created_at`) VALUES(?, ?, ?, ?)"); // Prepare Statement
    
        mysqli_stmt_bind_param($stmt, "ssss", $conv, $msg, $user, $date); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
            
            $sent = true; // Update Flag 

        }

        mysqli_stmt_close($stmt); // Close Statement


        echo json_encode(['sent' => $sent]); // Encode JSON Response

    }

?>