<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-TYPE']) || !isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $mainUser = $_SESSION['USER-ID']; // Account Owner

        $currentUser = $_SESSION['CURRENT-USER']; // Logged User 

        $userType = $_SESSION['USER-TYPE']; // Get User Type

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $currentUser, $userType); // Set Timezone

        // Sanitize Field(s)

        $acc = filter_var($_REQUEST['account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $accFound = false; // Flag

        if ($amount < 0) {

            echo json_encode(['invalidAmt' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Get User Info

        $recipientData = mysqli_prepare($conn, "SELECT `A`.*, `B`.`email`, `B`.`username`, `B`.`fname`, `B`.`mname`, `B`.`lname` FROM `accounts` AS `A` JOIN `users` AS `B` ON CAST(`A`.`user_id` AS BINARY) =  CAST(`B`.`user_id` AS BINARY) WHERE `A`.`acc_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($recipientData, "s", $acc); // Bind Parameters

        mysqli_stmt_execute($recipientData); // Execute Statement

        $result = mysqli_stmt_get_result($recipientData); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Get Result's Mass

            $accFound = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $currency = $row['currency'];

                $rAccNum = $row['acc_num'];

                $rAccBal = $row['balance'];

                $rEmail = $row['email'];

                $rTag = $row['username'];

                $rFname = $row['fname'];

                $recipient = join(' ', [$rFname, $row['mname'], $row['lname']]);

                $rID = $row['user_id'];

                $rAccID = $row['acc_id'];

            }

        }

        mysqli_free_result($result); // Fre Result

        mysqli_stmt_close($recipientData); // Close Statement

        // Check Flag

        if (!$accFound) {

            echo json_encode(['recipientError' => true]); // Encode JSON Response

            exit; // End Run

        }

    
        $sourceFound = false; // Flag
        
        // Look For Source

        $sourceData = mysqli_prepare($conn, "SELECT * FROM `accounts` WHERE `user_id` = CAST(? AS BINARY) AND `currency` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($sourceData, "ss", $mainUser, $currency); // Bind Parameter(s)

        mysqli_stmt_execute($sourceData); // Execute Statement

        $result = mysqli_stmt_get_result($sourceData); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Get Result's Mass

            $sourceFound = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $sourceNum = $row['acc_num'];

                $sourceBal = $row['balance'];

                $sourceID = $row['acc_id'];

                $wLimit = $row['wth_limit'];

                $wCount = $row['wth_count'] ?? 0;

                $maxCount = $row['wth_max'];

            }

        }

        mysqli_free_result($result); // Fre Result

        mysqli_stmt_close($sourceData); // Close Statement

        // Check Flag

        if (!$sourceFound) {

            echo json_encode(['sourceError' => true, 'currency' => $currency]); // Encode JSON Response

            exit; // End Run

        }

        // $tPIN = true; // Transaction PIN

        if ($userType == 'THIRD PARTY') { // Third Party User Check

            $tPIN = false;

            $thirdParty = thirdPartyData($currentUser, $conn);

            if (!$thirdParty) { // Invalid Third Party User

                echo json_encode(['refresh' => true]); // Encode JSON Response

                exit; // End Run

            }

            // Perform Checks

            $wLimit = $thirdParty['wth-limit']; // Withdrawal Limit (Currency Amount)

            $tCount = $thirdParty['trans-count']; // Transaction Count

            $tLimit = $thirdParty['trans-limit']; // Transaction Limit

            if ($tCount >= $tLimit) {

                echo json_encode(['maxTransc' => true]); // Encode JSON Response

                exit; // End Run

            }

            if ($amount > $wLimit) {

               echo json_encode(['wthLimit' => true]); // Encode JSON Response

                exit; // End Run 

            }

            $barred = $thirdParty['no-access']; // Accounts Third Party Can't Access

            if (!is_null($barred)) { 

                $barredList = array_map('trim', explode(',', $barred)); // Convert to an array

                if (in_array($currency, $barredList)) { // Check Access State

                    echo json_encode(['noAccess' => true, 'currency' => $currency]); // Encode JSON Response

                    exit; // End Run

                }

            }

        } else {

            if (!is_null($wLimit) && $amount > $wLimit) { // Check Limit Amount

                $limit = $currSymbol[$currency] . number_format($wLimit) . ' (' . $currency . ')';

                echo json_encode(['wLimit' => true]); // Encode JSON Response
        
                exit; // End Run

            } else if (!is_null($maxCount) && $wCount >= $maxCount) {

                echo json_encode(['maxWth' => true]); // Encode JSON Response
        
                exit; // End Run

            }

        }

        // Check Source Balance

        if ($amount > $sourceBal) {

            echo json_encode(['fundError' => true]); // Encode JSON Response

            exit; // End Run

        } else {

            $senderData = userData($mainUser, $conn); // Get Sender's Info

            // Calculate Balances
            
            $newRBal = $amount + $rAccBal;

            $newSrcBal = $sourceBal - $amount;

            $status = "COMPLETED";

            $scope = "TAG TRANSFER";

            // Update Balance

            $balances = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = CASE WHEN `acc_id` = CAST(? AS BINARY) THEN `balance` + ? WHEN `acc_id` = CAST(? AS BINARY) THEN `balance` - ? ELSE `balance` END WHERE `acc_id` IN (CAST(? AS BINARY), CAST(? AS BINARY))"); // Prepare Statement

            mysqli_stmt_bind_param($balances, "sdsdss", $rAccID, $amount, $sourceID, $amount, $rAccID, $sourceID);

            // Create Transactions

            $srcTransc = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `recpt_acc`, `recpt_name`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

            // Parameter(s)

            $srcTrID = generateUniqueID($conn, 'transactions', 'TRN');

            $type = 'DEBIT';

            mysqli_stmt_bind_param($srcTransc, "ssssssiddsss", $mainUser, $srcTrID, $type, $scope, $currency, $sourceID, $sourceNum, $amount, $newSrcBal, $rAccNum, $recipient, $status); // Bind Parameter(s)

            $rTransc = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `type`, `action`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

            // Parameter(s)

            $rTrID = generateUniqueID($conn, 'transactions', 'TRN');

            $rtype = 'CREDIT';

            mysqli_stmt_bind_param($rTransc, "ssssssidds", $rID, $rTrID, $rtype, $scope, $currency, $rAccID, $rAccNum, $amount, $newRBal, $status); // Bind Parameters

            // Execute Statements

            if (mysqli_stmt_execute($balances) && mysqli_stmt_execute($srcTransc) && mysqli_stmt_execute($rTransc)) {

                $recipient = $recipient . ' (' . ((is_null($rTag)) ? $rEmail : '@' . $rTag) . ')';

                $sender = join(' ', [$senderData['firstname'], $senderData['lastname']]) . ' (' . ((is_null($senderData['tag'])) ? $senderData['email'] : '@' . $senderData['tag']) . ')';

                $dateTime = timeGMT('l M d, Y (H:i) [T]');

                $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

                // Notify Parties

                if ($userType == 'THIRD PARTY') {

                    // Notify Initiator & Account Owner

                    $notf = 'You just successfully initiated a transfer of ' . $money . '  through ' . join(' ', [$senderData['firstname'], $senderData['lastname']]) . '\'s ' . $currency . ' account to ' . $recipient . ' on  ' . $dateTime;

                    createNotification($conn, $currentUser, 'Transfer Notification', $notf); // Notify Initiator

                    $notfB = 'A transfer of ' . $money . ' was just successfully initiated by ' . join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]) . ' (JOINT USER) through your ' . $currency . ' account to ' . $recipient . ' on  ' . $dateTime;


                } else {

                    // Notify Initiator

                    $notfB = 'You just successfully initiated a transfer of ' . $money . ' to ' . $recipient . ' ' . $currency . ' account on  ' . $dateTime;

                }

                createNotification($conn, $mainUser, 'Transfer Notification', $notfB); // Notify Account Owner

                // Notify Receiver
            
                $notfC = 'You just received the sum of ' . $money . '  through TAG TRANSFER from ' . $sender . ' on  ' . $dateTime;

                createNotification($conn, $rID, 'Transfer Notification', $notfC); // Notify Recipient

                $_SESSION['TRANSF-ID'] = $srcTrID;

                echo json_encode(['transfer' => true]); // Encode JSON Response

            } else {

                echo json_encode(['transfer' => false]); // Encode JSON Response

            }

            // Close Statements

            mysqli_stmt_close($balances);

            mysqli_stmt_close($srcTransc);

            mysqli_stmt_close($rTransc);

        }

    }

?>