<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s) 

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $digit1 = filter_var($_POST['digit_1'], FILTER_SANITIZE_SPECIAL_CHARS);
    
        $digit2 = filter_var($_POST['digit_2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit3 = filter_var($_POST['digit_3'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit4 = filter_var($_POST['digit_4'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit5 = filter_var($_POST['digit_5'], FILTER_SANITIZE_SPECIAL_CHARS);

        $digit6 = filter_var($_POST['digit_6'], FILTER_SANITIZE_SPECIAL_CHARS);

        $input = join('', [$digit1, $digit2, $digit3, $digit4, $digit5, $digit6]); // Concatnate Fields

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        $token = $_COOKIE['ACCESS-iD'] ?? null;

        setTimezone($conn, $token, $user, 'USER');

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $code = $userData['code'];

        $expires = $userData['code-expires'];

        // Perform Checks

        if ((int)$input !== (int)$code) { // Validate Input

            echo json_encode(['codeInvalid' => true]); // Encode JSON Response

            exit; // Terminate Run

        } else if (date('Y-m-d H:i:s', time()) >= $expires) { // Check Validity

            echo json_encode(['codeExpired' => true]); // Encode JSON Response

            exit; // Terminate Run

        }

        echo json_encode(['tPIN' => true]); // Encode JSON Response

    }

?>